/*
 * Copyright 2001-2022 Artima, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.scalatestplus.play

import play.api.Application

/**
 * Trait that provides method that creates a new instance of `Application` to the functional test suite mixins.
 *
 * The `GuiceFakeApplicationFactory` provides a `FakeApplicationFactory` that uses `GuiceApplicationBuilder`
 * to build an Application for test suites.
 */
trait FakeApplicationFactory {

  def fakeApplication(): Application

}
