/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scalatest.events.Event;
import org.scalatest.events.SuiteAborted;
import org.scalatest.events.TestCanceled;
import org.scalatest.events.TestFailed;
import org.scalatest.tools.Memento;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;

public final class Memento$
implements Serializable {
    public static final Memento$ MODULE$;
    private final Pattern SomeNonePat;

    static {
        new Memento$();
    }

    public Memento apply(Event event) {
        Tuple4 tuple4;
        Event event2 = event;
        if (event2 instanceof TestFailed) {
            TestFailed testFailed = (TestFailed)event2;
            tuple4 = new Tuple4((Object)"TestFailed", testFailed.rerunner(), (Object)testFailed.suiteId(), (Object)new Some((Object)testFailed.testName()));
        } else if (event2 instanceof TestCanceled) {
            TestCanceled testCanceled = (TestCanceled)event2;
            tuple4 = new Tuple4((Object)"TestCanceled", testCanceled.rerunner(), (Object)testCanceled.suiteId(), (Object)new Some((Object)testCanceled.testName()));
        } else if (event2 instanceof SuiteAborted) {
            SuiteAborted suiteAborted = (SuiteAborted)event2;
            tuple4 = new Tuple4((Object)"SuiteAborted", suiteAborted.rerunner(), (Object)suiteAborted.suiteId(), (Object)None$.MODULE$);
        } else {
            tuple4 = new Tuple4((Object)"unexpected", (Object)None$.MODULE$, (Object)event2.toString(), (Object)None$.MODULE$);
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 != null) {
            String eventName = (String)tuple42._1();
            Option className = (Option)tuple42._2();
            String suiteId = (String)tuple42._3();
            Option testName = (Option)tuple42._4();
            if (eventName != null) {
                String string = eventName;
                if (className != null) {
                    Option option = className;
                    if (suiteId != null) {
                        String string2 = suiteId;
                        if (testName != null) {
                            Tuple4 tuple43;
                            Option option2 = testName;
                            Tuple4 tuple44 = tuple43 = new Tuple4((Object)string, (Object)option, (Object)string2, (Object)option2);
                            String eventName2 = (String)tuple44._1();
                            Option className2 = (Option)tuple44._2();
                            String suiteId2 = (String)tuple44._3();
                            Option testName2 = (Option)tuple44._4();
                            return new Memento(eventName2, (Option<String>)className2, suiteId2, (Option<String>)testName2);
                        }
                    }
                }
            }
        }
        throw new MatchError((Object)tuple42);
    }

    public List<Memento> readFromFile(String fileName) {
        BufferedSource source = Source$.MODULE$.fromFile(fileName, Codec$.MODULE$.fallbackSystemCodec());
        try {
            return (List)source.getLines().toList().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Memento apply(String line) {
                    return Memento$.MODULE$.fromString(line);
                }
            }, List$.MODULE$.canBuildFrom());
        }
        finally {
            source.close();
        }
    }

    public void writeToFile(String fileName, Set<Memento> mementos) {
        PrintWriter out = new PrintWriter(fileName, "UTF-8");
        try {
            List lines = (List)((TraversableOnce)mementos.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Memento x$3) {
                    return x$3.singleLine();
                }
            }, Set$.MODULE$.canBuildFrom())).toList().sortWith((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$4, String x$5) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$4)).$less((Object)x$5);
                }
            });
            lines.foreach((Function1)new Serializable(out){
                public static final long serialVersionUID = 0L;
                private final PrintWriter out$1;

                public final void apply(String x$1) {
                    this.out$1.println(x$1);
                }
                {
                    this.out$1 = out$1;
                }
            });
            return;
        }
        finally {
            out.close();
        }
    }

    public Memento fromString(String str) {
        String[] splits = str.split(" ");
        if (splits.length != 4) {
            throw new Exception(new StringBuilder().append((Object)"bad line format [").append((Object)str).append((Object)"]").toString());
        }
        String eventName = splits[0];
        Option<String> className = this.optionFromString(splits[1]);
        String suiteId = this.decode(splits[2]);
        Option<String> testName = this.optionFromString(this.decode(splits[3]));
        return new Memento(eventName, className, suiteId, testName);
    }

    public Pattern SomeNonePat() {
        return this.SomeNonePat;
    }

    public Option<String> optionFromString(String str) {
        block2: {
            block5: {
                Some some;
                block4: {
                    String string;
                    block3: {
                        Matcher matcher = this.SomeNonePat().matcher(str);
                        if (!matcher.find()) break block2;
                        String string2 = string = matcher.group(1);
                        if ("Some(" != null ? !"Some(".equals(string2) : string2 != null) break block3;
                        some = new Some((Object)matcher.group(2));
                        break block4;
                    }
                    String string3 = string;
                    if ("None" != null ? !"None".equals(string3) : string3 != null) break block5;
                    some = None$.MODULE$;
                }
                return some;
            }
            throw new Exception(new StringBuilder().append((Object)"bad Option format [").append((Object)str).append((Object)"]").toString());
        }
        throw new Exception(new StringBuilder().append((Object)"bad option string [").append((Object)str).append((Object)"]").toString());
    }

    public String encode(String text) {
        return text.replaceAll("\\\\", "\\\\5c").replaceAll("\n", "\\\\1f").replaceAll("_", "\\\\5f").replaceAll(" ", "_");
    }

    public String decode(String text) {
        return text.replaceAll("_", " ").replaceAll("\\\\5f", "_").replaceAll("\\\\1f", "\n").replaceAll("\\\\5c", "\\\\");
    }

    public Memento apply(String eventName, Option<String> className, String suiteId, Option<String> testName) {
        return new Memento(eventName, className, suiteId, testName);
    }

    public Option<Tuple4<String, Option<String>, String, Option<String>>> unapply(Memento x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.eventName(), x$0.className(), (Object)x$0.suiteId(), x$0.testName()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Memento$() {
        MODULE$ = this;
        this.SomeNonePat = Pattern.compile("^(Some\\(|None)(.*?)\\)?$");
    }
}

