/*
 * Decompiled with CFR 0.152.
 */
package nak.liblinear;

import java.util.HashMap;
import java.util.Map;

public enum SolverType {
    L2R_LR(0, true, false),
    L2R_L2LOSS_SVC_DUAL(1, false, false),
    L2R_L2LOSS_SVC(2, false, false),
    L2R_L1LOSS_SVC_DUAL(3, false, false),
    MCSVM_CS(4, false, false),
    L1R_L2LOSS_SVC(5, false, false),
    L1R_LR(6, true, false),
    L2R_LR_DUAL(7, true, false),
    L2R_L2LOSS_SVR(11, false, true),
    L2R_L2LOSS_SVR_DUAL(12, false, true),
    L2R_L1LOSS_SVR_DUAL(13, false, true);

    private final boolean logisticRegressionSolver;
    private final boolean supportVectorRegression;
    private final int id;
    private static Map<Integer, SolverType> SOLVERS_BY_ID;

    private SolverType(int n2, boolean bl, boolean bl2) {
        this.id = n2;
        this.logisticRegressionSolver = bl;
        this.supportVectorRegression = bl2;
    }

    public int getId() {
        return this.id;
    }

    public static SolverType getById(int n) {
        SolverType solverType = SOLVERS_BY_ID.get(n);
        if (solverType == null) {
            throw new RuntimeException("found no solvertype for id " + n);
        }
        return solverType;
    }

    public boolean isLogisticRegressionSolver() {
        return this.logisticRegressionSolver;
    }

    public boolean isSupportVectorRegression() {
        return this.supportVectorRegression;
    }

    static {
        SOLVERS_BY_ID = new HashMap<Integer, SolverType>();
        for (SolverType solverType : SolverType.values()) {
            SolverType solverType2 = SOLVERS_BY_ID.put(solverType.getId(), solverType);
            if (solverType2 == null) continue;
            throw new Error("duplicate solver type ID: " + solverType.getId());
        }
    }
}

