/*
 * Decompiled with CFR 0.152.
 */
package nak.liblinear;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import nak.liblinear.Linear;
import nak.liblinear.SolverType;

public final class Model
implements Serializable {
    private static final long serialVersionUID = -6456047576741854834L;
    double bias;
    int[] label;
    int nr_class;
    int nr_feature;
    SolverType solverType;
    double[] w;

    public Model() {
    }

    public Model(SolverType solverType, int n, int[] nArray, int n2, double d, double[] dArray) {
        this.solverType = solverType;
        this.nr_class = n;
        this.label = nArray;
        this.nr_feature = n2;
        this.bias = d;
        this.w = dArray;
    }

    public SolverType getSolverType() {
        return this.solverType;
    }

    public int getNrClass() {
        return this.nr_class;
    }

    public int getNrFeature() {
        return this.nr_feature;
    }

    public int[] getLabels() {
        return Linear.copyOf(this.label, this.nr_class);
    }

    public double[] getFeatureWeights() {
        return Linear.copyOf(this.w, this.w.length);
    }

    public boolean isProbabilityModel() {
        return this.solverType.isLogisticRegressionSolver();
    }

    public double getBias() {
        return this.bias;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Model");
        stringBuilder.append(" bias=").append(this.bias);
        stringBuilder.append(" nr_class=").append(this.nr_class);
        stringBuilder.append(" nr_feature=").append(this.nr_feature);
        stringBuilder.append(" solverType=").append((Object)this.solverType);
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.bias);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + Arrays.hashCode(this.label);
        n = 31 * n + this.nr_class;
        n = 31 * n + this.nr_feature;
        n = 31 * n + (this.solverType == null ? 0 : this.solverType.hashCode());
        n = 31 * n + Arrays.hashCode(this.w);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Model model = (Model)object;
        if (Double.doubleToLongBits(this.bias) != Double.doubleToLongBits(model.bias)) {
            return false;
        }
        if (!Arrays.equals(this.label, model.label)) {
            return false;
        }
        if (this.nr_class != model.nr_class) {
            return false;
        }
        if (this.nr_feature != model.nr_feature) {
            return false;
        }
        if (this.solverType == null ? model.solverType != null : !this.solverType.equals((Object)model.solverType)) {
            return false;
        }
        return Model.equals(this.w, model.w);
    }

    protected static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray == null || dArray2 == null) {
            return false;
        }
        int n = dArray.length;
        if (dArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == dArray2[i]) continue;
            return false;
        }
        return true;
    }

    public void save(File file) throws IOException {
        Linear.saveModel(file, this);
    }

    public void save(Writer writer) throws IOException {
        Linear.saveModel(writer, this);
    }

    public static Model load(File file) throws IOException {
        return Linear.loadModel(file);
    }

    public static Model load(Reader reader) throws IOException {
        return Linear.loadModel(reader);
    }
}

