/*
 * Decompiled with CFR 0.152.
 */
package nak.liblinear;

import nak.liblinear.Feature;

public class FeatureNode
implements Feature {
    public final int index;
    public double value;

    public FeatureNode(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("index must be >= 0");
        }
        this.index = n;
        this.value = d;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double d) {
        this.value = d;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.index;
        long l = Double.doubleToLongBits(this.value);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FeatureNode featureNode = (FeatureNode)object;
        if (this.index != featureNode.index) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(featureNode.value);
    }

    public String toString() {
        return "FeatureNode(idx=" + this.index + ", value=" + this.value + ")";
    }
}

