/*
 * Decompiled with CFR 0.152.
 */
package nak;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import nak.NakContext$;
import nak.core.Classifier;
import nak.core.Classifier$;
import nak.core.FeaturizedClassifier;
import nak.core.IndexedClassifier;
import nak.data.BinomialExampleIndexer;
import nak.data.BinomialExampleIndexer$;
import nak.data.Example;
import nak.data.Example$;
import nak.data.ExampleIndexer;
import nak.data.ExampleIndexer$;
import nak.data.FeatureObservation;
import nak.data.FeatureObservation$;
import nak.data.Featurizer;
import nak.data.HashedExampleIndexer;
import nak.data.HashedFeatureMap;
import nak.liblinear.Feature;
import nak.liblinear.LiblinearConfig;
import nak.liblinear.LiblinearTrainer;
import nak.liblinear.LiblinearTrainerBinomial;
import nak.liblinear.LiblinearUtil$;
import nak.liblinear.Model;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.Map;
import scala.collection.mutable.WrappedArray;
import scala.io.BufferedSource;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class NakContext$ {
    public static final NakContext$ MODULE$;

    static {
        new NakContext$();
    }

    public Iterator<Example<String, Seq<FeatureObservation<String>>>> fromCsvFile(String filename) {
        return Source$.MODULE$.fromFile(filename, Codec$.MODULE$.fallbackSystemCodec()).getLines().map((Function1)new Serializable(){

            public final Example<String, WrappedArray<FeatureObservation<String>>> apply(String line) {
                String[] items = line.split(",");
                FeatureObservation[] features = (FeatureObservation[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])items).dropRight(1)).map((Function1)new Serializable(this){

                    public final FeatureObservation<String> apply(String descr) {
                        return new FeatureObservation<String>(descr, FeatureObservation$.MODULE$.apply$default$2());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FeatureObservation.class)));
                String label = (String)Predef$.MODULE$.refArrayOps((Object[])items).last();
                return Example$.MODULE$.apply(label, Predef$.MODULE$.wrapRefArray((Object[])features), Example$.MODULE$.apply$default$3());
            }
        });
    }

    public Iterator<Example<String, String>> fromLabeledDirs(File topdir, Codec codec) {
        return Predef$.MODULE$.refArrayOps((Object[])topdir.listFiles()).toIterator().filter((Function1)new Serializable(){

            public final boolean apply(File x$1) {
                return x$1.isDirectory();
            }
        }).map((Function1)new Serializable(){

            public final Tuple2<File, String> apply(File dir) {
                String label = dir.getName();
                return new Tuple2((Object)dir, (Object)label);
            }
        }).flatMap((Function1)new Serializable(codec){
            public final Codec codec$1;

            public final GenTraversableOnce<Example<String, String>> apply(Tuple2<File, String> x$2) {
                Tuple2<File, String> tuple2 = x$2;
                if (tuple2 != null) {
                    File dir = (File)tuple2._1();
                    String label = (String)tuple2._2();
                    Iterator iterator = Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).toIterator().map((Function1)new Serializable(this, label){
                        private final /* synthetic */ anonfun.fromLabeledDirs.3 $outer;
                        private final String label$1;

                        public final Example<String, String> apply(File file) {
                            BufferedSource fileSource = Source$.MODULE$.fromFile(file, this.$outer.codec$1);
                            String text = fileSource.mkString();
                            fileSource.close();
                            return Example$.MODULE$.apply(this.label$1, text, file.getName());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.label$1 = label$1;
                        }
                    });
                    return iterator;
                }
                throw new MatchError(tuple2);
            }
            {
                this.codec$1 = codec$1;
            }
        });
    }

    public <I> IndexedClassifier<String> trainClassifier(LiblinearConfig config, Featurizer<I, String> featurizer, Seq<Example<String, I>> rawExamples) {
        ExampleIndexer indexer = new ExampleIndexer(ExampleIndexer$.MODULE$.$lessinit$greater$default$1());
        Seq examples = (Seq)((TraversableLike)rawExamples.map((Function1)new Serializable(featurizer){
            private final Featurizer featurizer$1;

            public final Example<String, Seq<FeatureObservation<String>>> apply(Example<String, I> x$3) {
                return x$3.map(this.featurizer$1);
            }
            {
                this.featurizer$1 = featurizer$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)indexer, Seq$.MODULE$.canBuildFrom());
        Tuple2<Map<String, Object>, Map<String, Object>> tuple2 = indexer.getMaps();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Map lmap = (Map)tuple2._1();
            Map fmap2 = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)lmap, (Object)fmap2);
            Map lmap2 = (Map)tuple23._1();
            Map fmap3 = (Map)tuple23._2();
            Model model = this.trainModel(config, (TraversableOnce<Example<Object, Seq<FeatureObservation<Object>>>>)examples, fmap3.size());
            return (FeaturizedClassifier)((Object)Classifier$.MODULE$.apply(model, lmap2, fmap3, featurizer));
        }
        throw new MatchError(tuple2);
    }

    public <I> IndexedClassifier<String> trainBinomialClassifier(LiblinearConfig config, Featurizer<I, String> featurizer, Seq<Example<Tuple2<Object, Object>, I>> rawExamples) {
        BinomialExampleIndexer indexer = new BinomialExampleIndexer(BinomialExampleIndexer$.MODULE$.$lessinit$greater$default$1(), BinomialExampleIndexer$.MODULE$.$lessinit$greater$default$2(), BinomialExampleIndexer$.MODULE$.$lessinit$greater$default$3());
        Seq examples = (Seq)((TraversableLike)rawExamples.map((Function1)new Serializable(featurizer){
            private final Featurizer featurizer$2;

            public final Example<Tuple2<Object, Object>, Seq<FeatureObservation<String>>> apply(Example<Tuple2<Object, Object>, I> x$5) {
                return x$5.map(this.featurizer$2);
            }
            {
                this.featurizer$2 = featurizer$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)indexer, Seq$.MODULE$.canBuildFrom());
        Tuple2<Map<String, Object>, Map<String, Object>> tuple2 = indexer.getMaps();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Map lmap = (Map)tuple2._1();
            Map fmap2 = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)lmap, (Object)fmap2);
            Map lmap2 = (Map)tuple23._1();
            Map fmap3 = (Map)tuple23._2();
            Model model = this.trainBinomialModel(config, (TraversableOnce<Example<Tuple2<Object, Object>, Seq<FeatureObservation<Object>>>>)examples, fmap3.size());
            return (FeaturizedClassifier)((Object)Classifier$.MODULE$.apply(model, lmap2, fmap3, featurizer));
        }
        throw new MatchError(tuple2);
    }

    public <I> IndexedClassifier<String> trainClassifierHashed(LiblinearConfig config, Featurizer<I, String> featurizer, Seq<Example<String, I>> rawExamples, int maxNumberOfFeatures) {
        HashedExampleIndexer indexer = new HashedExampleIndexer(maxNumberOfFeatures);
        int primeNumberOfFeatures = indexer.highestFeatureIndex();
        Seq examples = (Seq)((TraversableLike)rawExamples.map((Function1)new Serializable(featurizer){
            private final Featurizer featurizer$3;

            public final Example<String, Seq<FeatureObservation<String>>> apply(Example<String, I> x$7) {
                return x$7.map(this.featurizer$3);
            }
            {
                this.featurizer$3 = featurizer$3;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)indexer, Seq$.MODULE$.canBuildFrom());
        Tuple2<Map<String, Object>, HashedFeatureMap> tuple2 = indexer.getMaps();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Map lmap = (Map)tuple2._1();
            HashedFeatureMap fmap2 = (HashedFeatureMap)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)lmap, (Object)fmap2);
            Map lmap2 = (Map)tuple23._1();
            HashedFeatureMap fmap3 = (HashedFeatureMap)tuple23._2();
            Predef$.MODULE$.println((Object)"Estimating model parameters...");
            Model model = this.trainModel(config, (TraversableOnce<Example<Object, Seq<FeatureObservation<Object>>>>)examples, primeNumberOfFeatures + 1);
            return (FeaturizedClassifier)((Object)Classifier$.MODULE$.apply(model, lmap2, fmap3, featurizer));
        }
        throw new MatchError(tuple2);
    }

    public IndexedClassifier<String> trainClassifier(LiblinearConfig config, TraversableOnce<Example<Object, Seq<FeatureObservation<Object>>>> examples, Map<String, Object> lmap, Map<String, Object> fmap2) {
        return Classifier$.MODULE$.apply(this.trainModel(config, examples, fmap2.size()), lmap, fmap2);
    }

    public <I> int trainClassifierHashed$default$4() {
        return 10000;
    }

    public void saveClassifier(Classifier classifier, String filename) {
        FileOutputStream stream = new FileOutputStream(filename);
        new ObjectOutputStream(stream).writeObject(classifier);
        stream.close();
    }

    /*
     * WARNING - void declaration
     */
    public <C extends Classifier> C loadClassifier(String filename) {
        void var3_3;
        FileInputStream stream = new FileInputStream(filename);
        Classifier classifier = (Classifier)new ObjectInputStream(stream).readObject();
        stream.close();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public <C extends Classifier> C loadClassifierFromResource(String resource) {
        void var3_3;
        ObjectInputStream stream = new ObjectInputStream(this.getClass().getResourceAsStream(resource));
        Classifier classifier = (Classifier)stream.readObject();
        stream.close();
        return var3_3;
    }

    public Model trainModel(LiblinearConfig config, TraversableOnce<Example<Object, Seq<FeatureObservation<Object>>>> examples, int numFeatures) {
        Tuple2 tuple2 = TraversableOnce$.MODULE$.MonadOps(examples).map((Function1)new anonfun.5()).toSeq().unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq responses = (Seq)tuple2._1();
            Seq observationsAsTuples = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responses, (Object)observationsAsTuples);
            Seq responses2 = (Seq)tuple23._1();
            Seq observationsAsTuples2 = (Seq)tuple23._2();
            Feature[][] observations = LiblinearUtil$.MODULE$.createLiblinearMatrix((Seq<Seq<Tuple2<Object, Object>>>)observationsAsTuples2);
            return new LiblinearTrainer(config).apply((double[])((TraversableOnce)responses2.map((Function1)new Serializable(){

                public final double apply(int x$11) {
                    return this.apply$mcDI$sp(x$11);
                }

                public double apply$mcDI$sp(int x$11) {
                    return x$11;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()), observations, numFeatures);
        }
        throw new MatchError((Object)tuple2);
    }

    public Model trainBinomialModel(LiblinearConfig config, TraversableOnce<Example<Tuple2<Object, Object>, Seq<FeatureObservation<Object>>>> examples, int numFeatures) {
        Tuple2 tuple2 = TraversableOnce$.MODULE$.MonadOps(examples).map((Function1)new anonfun.6()).toSeq().unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq responses = (Seq)tuple2._1();
            Seq observationsAsTuples = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responses, (Object)observationsAsTuples);
            Seq responses2 = (Seq)tuple23._1();
            Seq observationsAsTuples2 = (Seq)tuple23._2();
            Feature[][] observations = LiblinearUtil$.MODULE$.createLiblinearMatrix((Seq<Seq<Tuple2<Object, Object>>>)observationsAsTuples2);
            LiblinearTrainerBinomial qual$1 = new LiblinearTrainerBinomial(config);
            Tuple2[] x$20 = (Tuple2[])responses2.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
            Feature[][] x$21 = observations;
            int x$22 = numFeatures;
            Option<double[]> x$23 = qual$1.apply$default$4();
            return qual$1.apply(x$20, x$21, x$22, x$23);
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<FeatureObservation<Object>> condense(Seq<FeatureObservation<Object>> features) {
        return (Seq)((TraversableOnce)features.groupBy((Function1)new Serializable(){

            public final int apply(FeatureObservation<Object> x$14) {
                return BoxesRunTime.unboxToInt((Object)x$14.feature());
            }
        }).values().map((Function1)new Serializable(){

            public final FeatureObservation<Object> apply(Seq<FeatureObservation<Object>> x$15) {
                return (FeatureObservation)x$15.reduce((Function2)new Serializable(this){

                    public final FeatureObservation<Object> apply(FeatureObservation<Object> x$16, FeatureObservation<Object> x$17) {
                        return x$16.$plus(x$17);
                    }
                });
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1)new Serializable(){

            public final int apply(FeatureObservation<Object> x$18) {
                return BoxesRunTime.unboxToInt((Object)x$18.feature());
            }
        }, (Ordering)Ordering.Int$.MODULE$);
    }

    public String maxLabel(Seq<String> labels2, Seq<Object> scores2) {
        return (String)((Tuple2)((TraversableOnce)labels2.zip(scores2, Seq$.MODULE$.canBuildFrom())).maxBy((Function1)new Serializable(){

            public final double apply(Tuple2<String, Object> x$19) {
                return x$19._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$))._1();
    }

    private NakContext$() {
        MODULE$ = this;
    }
}

