/*
 * Decompiled with CFR 0.152.
 */
package nak.liblinear;

import nak.liblinear.Feature;
import nak.liblinear.Function;
import nak.liblinear.Problem;

class L2R_LrFunction
implements Function {
    private final double[] C;
    private final double[] z;
    private final double[] D;
    private final Problem prob;

    public L2R_LrFunction(Problem problem, double[] dArray) {
        int n = problem.l;
        this.prob = problem;
        this.z = new double[n];
        this.D = new double[n];
        this.C = dArray;
    }

    private void Xv(double[] dArray, double[] dArray2) {
        for (int i = 0; i < this.prob.l; ++i) {
            dArray2[i] = 0.0;
            for (Feature feature : this.prob.x[i]) {
                int n = i;
                dArray2[n] = dArray2[n] + dArray[feature.getIndex() - 1] * feature.getValue();
            }
        }
    }

    private void XTv(double[] dArray, double[] dArray2) {
        int n;
        int n2 = this.prob.l;
        int n3 = this.get_nr_variable();
        Feature[][] featureArray = this.prob.x;
        for (n = 0; n < n3; ++n) {
            dArray2[n] = 0.0;
        }
        for (n = 0; n < n2; ++n) {
            for (Feature feature : featureArray[n]) {
                int n4 = feature.getIndex() - 1;
                dArray2[n4] = dArray2[n4] + dArray[n] * feature.getValue();
            }
        }
    }

    @Override
    public double fun(double[] dArray) {
        int n;
        double d = 0.0;
        double[] dArray2 = this.prob.y;
        int n2 = this.prob.l;
        int n3 = this.get_nr_variable();
        this.Xv(dArray, this.z);
        for (n = 0; n < n3; ++n) {
            d += dArray[n] * dArray[n];
        }
        d /= 2.0;
        for (n = 0; n < n2; ++n) {
            double d2 = dArray2[n] * this.z[n];
            if (d2 >= 0.0) {
                d += this.C[n] * Math.log(1.0 + Math.exp(-d2));
                continue;
            }
            d += this.C[n] * (-d2 + Math.log(1.0 + Math.exp(d2)));
        }
        return d;
    }

    @Override
    public void grad(double[] dArray, double[] dArray2) {
        int n;
        double[] dArray3 = this.prob.y;
        int n2 = this.prob.l;
        int n3 = this.get_nr_variable();
        for (n = 0; n < n2; ++n) {
            this.z[n] = 1.0 / (1.0 + Math.exp(-dArray3[n] * this.z[n]));
            this.D[n] = this.z[n] * (1.0 - this.z[n]);
            this.z[n] = this.C[n] * (this.z[n] - 1.0) * dArray3[n];
        }
        this.XTv(this.z, dArray2);
        for (n = 0; n < n3; ++n) {
            dArray2[n] = dArray[n] + dArray2[n];
        }
    }

    @Override
    public void Hv(double[] dArray, double[] dArray2) {
        int n;
        int n2 = this.prob.l;
        int n3 = this.get_nr_variable();
        double[] dArray3 = new double[n2];
        this.Xv(dArray, dArray3);
        for (n = 0; n < n2; ++n) {
            dArray3[n] = this.C[n] * this.D[n] * dArray3[n];
        }
        this.XTv(dArray3, dArray2);
        for (n = 0; n < n3; ++n) {
            dArray2[n] = dArray[n] + dArray2[n];
        }
    }

    @Override
    public int get_nr_variable() {
        return this.prob.n;
    }
}

