/*
 * Decompiled with CFR 0.152.
 */
package epic.parser;

import breeze.linalg.Counter2;
import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.Logger;
import epic.lexicon.Lexicon;
import epic.lexicon.SimpleTagScorer;
import epic.parser.GenerativeParser$;
import epic.parser.GenerativeTrainer;
import epic.parser.Grammar$;
import epic.parser.MaxRuleProductDecoder;
import epic.parser.ParseEval;
import epic.parser.Parser;
import epic.parser.Parser$;
import epic.parser.ParserParams;
import epic.parser.ParserPipeline;
import epic.parser.ParserPipeline$class;
import epic.parser.RuleTopology;
import epic.parser.RuleTopology$;
import epic.parser.SimpleGrammar;
import epic.parser.ViterbiDecoder;
import epic.parser.projections.GrammarRefinements;
import epic.parser.projections.GrammarRefinements$;
import epic.trees.AnnotatedLabel;
import epic.trees.AnnotatedLabel$;
import epic.trees.Debinarizer$AnnotatedLabelDebinarizer$;
import epic.trees.ProcessedTreebank;
import epic.trees.TreeInstance;
import epic.trees.annotations.TreeAnnotator;
import java.io.BufferedWriter;
import java.io.FileWriter;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.generic.CanBuildFrom;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParSeq$;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class GenerativeTrainer$
implements ParserPipeline {
    public static final GenerativeTrainer$ MODULE$;
    private final Manifest<GenerativeTrainer.Params> paramManifest;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GenerativeTrainer$();
    }

    @Override
    public Iterator<Tuple2<String, Parser<AnnotatedLabel, String>>> trainParser(ProcessedTreebank treebank, Object params) {
        return ParserPipeline$class.trainParser(this, treebank, params);
    }

    @Override
    public void main(String[] args) {
        ParserPipeline$class.main(this, args);
    }

    @Override
    public ParseEval.Statistics evalParser(IndexedSeq<TreeInstance<AnnotatedLabel, String>> testTrees, Parser<AnnotatedLabel, String> parser, String name) {
        return ParserPipeline$class.evalParser(this, testTrees, parser, name);
    }

    private Logger logger$lzycompute() {
        GenerativeTrainer$ generativeTrainer$ = this;
        synchronized (generativeTrainer$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Manifest<GenerativeTrainer.Params> paramManifest() {
        return this.paramManifest;
    }

    public Iterator<Tuple2<String, Parser<AnnotatedLabel, String>>> trainParser(IndexedSeq<TreeInstance<AnnotatedLabel, String>> trainTrees2, Function1<Parser<AnnotatedLabel, String>, ParseEval.Statistics> validate2, GenerativeTrainer.Params params) {
        TreeAnnotator<AnnotatedLabel, String, AnnotatedLabel> annotator = params.annotator();
        ParserParams.XbarGrammar baseParser = params.baseParser();
        Tuple2<RuleTopology<AnnotatedLabel>, Lexicon<AnnotatedLabel, String>> tuple2 = baseParser.xbarGrammar(trainTrees2);
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            RuleTopology xbar = (RuleTopology)tuple22._1();
            Lexicon xbarLexicon = (Lexicon)tuple22._2();
            scala.collection.immutable.IndexedSeq transformed = ((ParIterableLike)((ParIterableLike)trainTrees2.par()).map((Function1)new Serializable(annotator){
                public static final long serialVersionUID = 0L;
                private final TreeAnnotator annotator$2;

                public final TreeInstance<AnnotatedLabel, String> apply(TreeInstance<AnnotatedLabel, String> ti) {
                    return this.annotator$2.apply(ti);
                }
                {
                    this.annotator$2 = annotator$2;
                }
            }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).seq().toIndexedSeq();
            Tuple3 tuple3 = GenerativeParser$.MODULE$.extractCounts(transformed);
            if (tuple3 != null) {
                Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
                Counter2 wordCounts = (Counter2)tuple32._1();
                Counter2 binaryCounts = (Counter2)tuple32._2();
                Counter2 initUnaries = (Counter2)tuple32._3();
                RuleTopology<AnnotatedLabel> refGrammar = RuleTopology$.MODULE$.apply(AnnotatedLabel$.MODULE$.TOP(), binaryCounts, initUnaries);
                GrammarRefinements indexedRefinements = GrammarRefinements$.MODULE$.apply(xbar, refGrammar, new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final AnnotatedLabel apply(AnnotatedLabel x$14) {
                        return x$14.baseAnnotatedLabel();
                    }
                }, GrammarRefinements$.MODULE$.apply$default$4());
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)"Num coarse rules:").append((Object)BoxesRunTime.boxToInteger((int)xbar.index().size())).toString());
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)"Num coarse symbols:").append((Object)BoxesRunTime.boxToInteger((int)xbar.labelIndex().size())).toString());
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)"Num refined rules:").append((Object)BoxesRunTime.boxToInteger((int)refGrammar.index().size())).toString());
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)"Num refined symbols:").append((Object)BoxesRunTime.boxToInteger((int)refGrammar.labelIndex().size())).toString());
                }
                SimpleTagScorer scorer2 = new SimpleTagScorer(wordCounts);
                SimpleGrammar refinedGrammar = Grammar$.MODULE$.generative(xbar, xbarLexicon, indexedRefinements, binaryCounts, initUnaries, scorer2);
                if (params.grammarDumpPath() != null) {
                    BufferedWriter out = new BufferedWriter(new FileWriter(params.grammarDumpPath()));
                    refinedGrammar.prettyPrint(out);
                    out.close();
                }
                Product decoder = params.maxRule() ? new MaxRuleProductDecoder() : new ViterbiDecoder();
                Parser parser = Parser$.MODULE$.apply(refinedGrammar, decoder, Debinarizer$AnnotatedLabelDebinarizer$.MODULE$);
                return package$.MODULE$.Iterator().single((Object)new Tuple2((Object)"Gen", parser));
            }
            throw new MatchError(tuple3);
        }
        throw new MatchError(tuple2);
    }

    private GenerativeTrainer$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        ParserPipeline$class.$init$(this);
        this.paramManifest = Predef$.MODULE$.manifest(ManifestFactory$.MODULE$.classType(GenerativeTrainer.Params.class));
    }
}

