/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.scalameta.collections.package$;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.meta.internal.io.InputStreamIO$;
import scala.meta.internal.io.ListFiles;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scalapb.GeneratedMessage;

public final class PlatformFileIO$ {
    public static final PlatformFileIO$ MODULE$ = new PlatformFileIO$();

    public byte[] readAllBytes(URI uri) {
        byte[] byArray;
        try (InputStream is = uri.toURL().openStream();){
            byArray = InputStreamIO$.MODULE$.readBytes(is);
        }
        return byArray;
    }

    public byte[] readAllBytes(AbsolutePath path) {
        return Files.readAllBytes(path.toNIO());
    }

    public Seq<TextDocument> readAllDocuments(AbsolutePath path) {
        Seq seq;
        try (InputStream stream = Files.newInputStream(path.toNIO(), new OpenOption[0]);){
            seq = ((TextDocuments)TextDocuments$.MODULE$.parseFrom(stream)).documents();
        }
        return seq;
    }

    public void write(AbsolutePath path, GeneratedMessage proto, Seq<OpenOption> openOptions) {
        Files.createDirectories(path.toNIO().getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path.toNIO(), (OpenOption[])openOptions.toArray(ClassTag$.MODULE$.apply(OpenOption.class)));){
            proto.writeTo(os);
        }
    }

    public String slurp(AbsolutePath path, Charset charset) {
        return new String(Files.readAllBytes(path.toNIO()), charset);
    }

    public ListFiles listFiles(AbsolutePath path2) {
        return new ListFiles(path2, (List<RelativePath>)((List)Option$.MODULE$.apply((Object)path2.toFile().list()).toList().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs))).map((Function1 & Serializable)path -> RelativePath$.MODULE$.apply((String)path)));
    }

    public boolean isFile(AbsolutePath path) {
        return Files.isRegularFile(path.toNIO(), new LinkOption[0]);
    }

    public boolean isDirectory(AbsolutePath path) {
        return Files.isDirectory(path.toNIO(), new LinkOption[0]);
    }

    public ListFiles listAllFilesRecursively(AbsolutePath root) {
        List relativeFiles = package$.MODULE$.XtensionJavaList(Files.walk(root.toNIO(), new FileVisitOption[0]).collect(Collectors.toList())).toScala().collect((PartialFunction)new Serializable(root){
            private static final long serialVersionUID = 0L;
            private final AbsolutePath root$1;

            public final <A1 extends Path, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (Files.isRegularFile(A1, new LinkOption[0])) {
                    return (B1)RelativePath$.MODULE$.apply(this.root$1.toNIO().relativize(A1));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Path x1) {
                Path path = x1;
                return Files.isRegularFile(path, new LinkOption[0]);
            }
            {
                this.root$1 = root$1;
            }
        });
        return new ListFiles(root, (List<RelativePath>)relativeFiles);
    }

    public AbsolutePath jarRootPath(AbsolutePath jarFile, boolean create) {
        FileSystem fs = this.newJarFileSystem(jarFile, create);
        return AbsolutePath$.MODULE$.apply(fs.getPath("/", new String[0]), AbsolutePath$.MODULE$.workingDirectory());
    }

    public boolean jarRootPath$default$2() {
        return false;
    }

    public <T> T withJarFileSystem(AbsolutePath path, boolean create, boolean close, Function1<AbsolutePath, T> f) {
        FileSystem fs = this.newJarFileSystem(path, create);
        AbsolutePath root = AbsolutePath$.MODULE$.apply(fs.getPath("/", new String[0]), AbsolutePath$.MODULE$.workingDirectory());
        if (create || close) {
            Object object;
            try {
                object = f.apply((Object)root);
            }
            finally {
                fs.close();
            }
            return (T)object;
        }
        return (T)f.apply((Object)root);
    }

    public <T> boolean withJarFileSystem$default$3() {
        return false;
    }

    public FileSystem newJarFileSystem(AbsolutePath path, boolean create) {
        Object object = create && !Files.exists(path.toNIO().getParent(), new LinkOption[0]) ? Files.createDirectories(path.toNIO().getParent(), new FileAttribute[0]) : BoxedUnit.UNIT;
        HashMap<String, String> map = new HashMap<String, String>();
        Object object2 = create ? map.put("create", "true") : BoxedUnit.UNIT;
        URI uri = URI.create(new StringBuilder(4).append("jar:").append(path.toNIO().toUri().toString()).toString());
        return this.newFileSystem(uri, map);
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> map) {
        FileSystem fileSystem;
        try {
            fileSystem = FileSystems.newFileSystem(uri, map);
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            fileSystem = FileSystems.getFileSystem(uri);
        }
        return fileSystem;
    }

    public Map<String, ?> newFileSystem$default$2() {
        return new HashMap();
    }

    private PlatformFileIO$() {
    }
}

