/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scalapb.TextFormatException;
import scalapb.textformat.Position;
import scalapb.textformat.TArray;
import scalapb.textformat.TBytes;
import scalapb.textformat.TField;
import scalapb.textformat.TIntLiteral;
import scalapb.textformat.TLiteral;
import scalapb.textformat.TMessage;
import scalapb.textformat.TPrimitive;
import scalapb.textformat.TValue;
import scalapb.textformat.Tokenizer;
import scalapb.textformat.Tokenizer$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006g\u0001!\t\u0001\u000e\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u0019i\u0004\u0001)A\u0005u!)a\b\u0001C\u0003\u007f!)!\f\u0001C\u00037\")a\u000f\u0001C\u0001o\")A\u0010\u0001C\u0001o\")Q\u0010\u0001C\u0001}\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!a\u0012\u0001\t\u0003\tI\u0005C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0004bBA:\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!!&\u0001\t\u0003\t9\nC\u0004\u0002&\u0002!\t!a*\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0002\u0007!\u0006\u00148/\u001a:\u000b\u0005qi\u0012A\u0003;fqR4wN]7bi*\ta$A\u0004tG\u0006d\u0017\r\u001d2\u0004\u0001M\u0011\u0001!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0002\tQ,\u0007\u0010\u001e\t\u0003SAr!A\u000b\u0018\u0011\u0005-\u001aS\"\u0001\u0017\u000b\u00055z\u0012A\u0002\u001fs_>$h(\u0003\u00020G\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\ty3%\u0001\u0004=S:LGO\u0010\u000b\u0003k]\u0002\"A\u000e\u0001\u000e\u0003mAQa\n\u0002A\u0002!\n!!\u001b;\u0016\u0003i\u0002\"AN\u001e\n\u0005qZ\"!\u0003+pW\u0016t\u0017N_3s\u0003\rIG\u000fI\u0001\u0012a\u0006\u00148/Z&fsZ\u000bG.^3MSN$Hc\u0001!M#B\u0019\u0011IR%\u000f\u0005\t#eBA\u0016D\u0013\u0005!\u0013BA#$\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0012%\u0003\u0007M+\u0017O\u0003\u0002FGA\u0011aGS\u0005\u0003\u0017n\u0011a\u0001\u0016$jK2$\u0007\"B'\u0006\u0001\u0004q\u0015AB2m_N,'\u000fE\u0002#\u001f\"J!\u0001U\u0012\u0003\r=\u0003H/[8o\u0011\u0015\u0011V\u00011\u0001A\u0003\r\t7m\u0019\u0015\u0003\u000bQ\u0003\"!\u0016-\u000e\u0003YS!aV\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002Z-\n9A/Y5me\u0016\u001c\u0017a\u0001:faV\u0011A\f\u0019\u000b\u0005;&Tw\u000eE\u0002B\rz\u0003\"a\u00181\r\u0001\u0011)\u0011M\u0002b\u0001E\n\tA+\u0005\u0002dMB\u0011!\u0005Z\u0005\u0003K\u000e\u0012qAT8uQ&tw\r\u0005\u0002#O&\u0011\u0001n\t\u0002\u0004\u0003:L\b\"\u0002*\u0007\u0001\u0004i\u0006\"B6\u0007\u0001\u0004a\u0017\u0001\u0004:fC\u0012Lhi\u001c:OKb$\bC\u0001\u0012n\u0013\tq7EA\u0004C_>dW-\u00198\t\u000bA4\u0001\u0019A9\u0002\u000bA\f'o]3\u0011\t\t\u0012\b\u0006^\u0005\u0003g\u000e\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007\tze\f\u000b\u0002\u0007)\u0006aQ.Z:tC\u001e,\u0017I\u001d:bsV\t\u0001\u0010E\u0002B\rf\u0004\"A\u000e>\n\u0005m\\\"A\u0002+WC2,X-\u0001\u0006wC2,X-\u0011:sCf\fq\u0002\u001e:z\u001b\u0016\u001c8/Y4f\u0003J\u0014\u0018-\u001f\u000b\u0004\u007f\u0006\u001d\u0001\u0003\u0002\u0012P\u0003\u0003\u00012ANA\u0002\u0013\r\t)a\u0007\u0002\u0007)\u0006\u0013(/Y=\t\r\u0005%\u0011\u00021\u0001)\u0003\u0011Ig.\u001b;\u0002\u001bQ\u0014\u0018PV1mk\u0016\f%O]1z)\ry\u0018q\u0002\u0005\u0007\u0003\u0013Q\u0001\u0019\u0001\u0015\u0002\u0015Q\u0014\u00180T3tg\u0006<W\r\u0006\u0003\u0002\u0016\u0005u\u0001\u0003\u0002\u0012P\u0003/\u00012ANA\r\u0013\r\tYb\u0007\u0002\t)6+7o]1hK\"1\u0011\u0011B\u0006A\u0002!\na\u0002\u001e:z\u0011\u0016D\u0018J\u001c;fOJ\fG\u000e\u0006\u0005\u0002$\u0005-\u0012qFA\u001d!\u0011\u0011s*!\n\u0011\u0007\u0005\u000b9#C\u0002\u0002*!\u0013aAQ5h\u0013:$\bBBA\u0017\u0019\u0001\u0007\u0001&A\u0003u_.,g\u000eC\u0004\u000221\u0001\r!a\r\u0002\u000b%tG-\u001a=\u0011\u0007\t\n)$C\u0002\u00028\r\u00121!\u00138u\u0011\u001d\tY\u0004\u0004a\u0001\u0003g\tAa]5h]\u0006qAO]=PGRLe\u000e^3he\u0006dG\u0003CA\u0012\u0003\u0003\n\u0019%!\u0012\t\r\u00055R\u00021\u0001)\u0011\u001d\t\t$\u0004a\u0001\u0003gAq!a\u000f\u000e\u0001\u0004\t\u0019$\u0001\u0006uef$UmY5nC2$\u0002\"a\t\u0002L\u00055\u0013q\n\u0005\u0007\u0003[q\u0001\u0019\u0001\u0015\t\u000f\u0005Eb\u00021\u0001\u00024!9\u00111\b\bA\u0002\u0005M\u0012!\u0003;ss\nKw-\u00138u)\u0011\t\u0019#!\u0016\t\r\u00055r\u00021\u0001)\u0003A!(/\u001f\"jO&sG\u000fT5uKJ\fG\u000e\u0006\u0003\u0002\\\u0005\r\u0004\u0003\u0002\u0012P\u0003;\u00022ANA0\u0013\r\t\tg\u0007\u0002\f)&sG\u000fT5uKJ\fG\u000e\u0003\u0004\u0002.A\u0001\r\u0001K\u0001\u000biJLH*\u001b;fe\u0006dG\u0003BA5\u0003c\u0002BAI(\u0002lA\u0019a'!\u001c\n\u0007\u0005=4D\u0001\u0005U\u0019&$XM]1m\u0011\u0019\ti#\u0005a\u0001Q\u0005iAO]=Ge\u0006\u001cG/[8oC2$B!!\u001b\u0002x!1\u0011Q\u0006\nA\u0002!\n\u0011\u0003\u001e:z!JLW.\u001b;jm\u00164\u0016\r\\;f)\u0011\ti(!\"\u0011\t\tz\u0015q\u0010\t\u0004m\u0005\u0005\u0015bAAB7\tQA\u000b\u0015:j[&$\u0018N^3\t\r\u000552\u00031\u0001)\u0003=!(/\u001f\"zi\u0016\u001cH*\u001b;fe\u0006dG\u0003BAF\u0003'\u0003BAI(\u0002\u000eB\u0019a'a$\n\u0007\u0005E5D\u0001\u0004U\u0005f$Xm\u001d\u0005\u0007\u0003[!\u0002\u0019\u0001\u0015\u0002+Q\u0014\u0018PQ=uKNd\u0015\u000e^3sC2\u001c\u0016N\\4mKR)A.!'\u0002\u001c\"1\u0011QF\u000bA\u0002!Bq!!(\u0016\u0001\u0004\ty*\u0001\u0002tEB\u0019\u0011)!)\n\u0007\u0005\r\u0006JA\u0007TiJLgn\u001a\"vS2$WM]\u0001\u000eiJL8i\u001c7p]Z\u000bG.^3\u0015\t\u0005%\u00161\u0016\t\u0004E=K\bBBA\u0005-\u0001\u0007\u0001&\u0001\u0006qCJ\u001cXMV1mk\u0016$2!_AY\u0011\u0019\tIa\u0006a\u0001Q\u0005a\u0001/\u0019:tK6+7o]1hKV\u0011\u0011qC\u0001\u000fa\u0006\u00148/Z#yG\u0016\u0004H/[8o)\u0011\tY,a1\u0011\t\u0005u\u0016qX\u0007\u0002;%\u0019\u0011\u0011Y\u000f\u0003'Q+\u0007\u0010\u001e$pe6\fG/\u0012=dKB$\u0018n\u001c8\t\r\u0005\u0015\u0017\u00041\u0001)\u0003\ri7o\u001a")
public class Parser {
    private final Tokenizer it;

    public Tokenizer it() {
        return this.it;
    }

    public final Seq<TField> parseKeyValueList(Option<String> closer, Seq<TField> acc) {
        Seq seq;
        block7: {
            while (true) {
                if (!this.it().hasNext()) {
                    Option<String> option = closer;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String cl = (String)some.value();
                        throw this.parseException(new StringBuilder(35).append("Expected ").append(cl).append(" but reached end of stream").toString());
                    }
                    if (!None$.MODULE$.equals(option)) {
                        throw new MatchError(option);
                    }
                    Seq seq2 = acc;
                    seq = seq2;
                    break block7;
                }
                String token = this.it().next();
                Position pos = this.it().lastPosition();
                Option<String> option = closer;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String cl = (String)some.value();
                    String string = token;
                    String string2 = cl;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) break;
                }
                if (!Tokenizer$.MODULE$.isIdentifier(token)) {
                    throw this.parseException(new StringBuilder(25).append("Expected identifier, got ").append(token).toString());
                }
                if (!this.it().hasNext()) {
                    throw this.parseException("Expected value after identifier");
                }
                TValue value = this.parseValue(this.it().next());
                acc = (Seq)acc.$colon$plus((Object)new TField(pos, token, value));
            }
            Seq seq3 = acc;
            seq = seq3;
        }
        return seq;
    }

    public final <T> Seq<T> rep(Seq<T> acc, boolean readyForNext, Function1<String, Option<T>> parse) {
        block7: {
            Option option;
            while (true) {
                String token;
                if (!this.it().hasNext()) {
                    throw this.parseException("Unclosed list of messages.");
                }
                String string = token = this.it().next();
                String string2 = "]";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (acc.nonEmpty() && readyForNext) {
                        throw this.parseException("Expected value, found ']' (trailing commas not allowed)");
                    }
                    break block7;
                }
                String string3 = token;
                String string4 = ",";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    if (readyForNext) {
                        throw this.parseException("Unexpected comma");
                    }
                    readyForNext = true;
                    continue;
                }
                option = (Option)parse.apply((Object)token);
                if (None$.MODULE$.equals(option)) {
                    throw this.parseException("Expected value");
                }
                if (!(option instanceof Some)) break;
                Some some = (Some)option;
                Object msg = some.value();
                readyForNext = false;
                acc = (Seq)acc.$colon$plus(msg);
            }
            throw new MatchError((Object)option);
        }
        return acc;
    }

    public Seq<TValue> messageArray() {
        return this.rep((Seq)package$.MODULE$.Nil(), true, (Function1)(Function1 & Serializable)init -> this.tryMessage((String)init));
    }

    public Seq<TValue> valueArray() {
        return this.rep((Seq)package$.MODULE$.Nil(), true, (Function1)(Function1 & Serializable)m -> this.tryMessage((String)m).orElse((Function0 & Serializable)() -> this.tryPrimitiveValue((String)m)));
    }

    public Option<TArray> tryMessageArray(String init) {
        String string = init;
        String string2 = "[";
        return !(string != null ? !string.equals(string2) : string2 != null) ? new Some((Object)new TArray(this.it().lastPosition(), this.messageArray())) : None$.MODULE$;
    }

    public Option<TArray> tryValueArray(String init) {
        String string = init;
        String string2 = "[";
        return !(string != null ? !string.equals(string2) : string2 != null) ? new Some((Object)new TArray(this.it().lastPosition(), this.valueArray())) : None$.MODULE$;
    }

    public Option<TMessage> tryMessage(String init) {
        None$ none$;
        block4: {
            String string = init;
            switch (string == null ? 0 : string.hashCode()) {
                case 60: {
                    if (!"<".equals(string)) break;
                    none$ = new Some((Object)new TMessage(this.it().lastPosition(), this.parseKeyValueList((Option<String>)new Some((Object)">"), (Seq<TField>)package$.MODULE$.Nil())));
                    break block4;
                }
                case 123: {
                    if (!"{".equals(string)) break;
                    none$ = new Some((Object)new TMessage(this.it().lastPosition(), this.parseKeyValueList((Option<String>)new Some((Object)"}"), (Seq<TField>)package$.MODULE$.Nil())));
                    break block4;
                }
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<BigInt> tryHexIntegral(String token, int index, int sign) {
        None$ none$;
        boolean hexPrefix;
        boolean bl = hexPrefix = index + 1 < token.length() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(token), index) == '0' && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(token), index + 1) == 'x';
        if (!hexPrefix) {
            none$ = None$.MODULE$;
        } else {
            String s = token.substring(index + 2);
            if (!StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)ch -> BoxesRunTime.boxToBoolean((boolean)Parser.$anonfun$tryHexIntegral$1(BoxesRunTime.unboxToChar((Object)ch))))) {
                throw this.parseException(new StringBuilder(21).append("Invalid hex literal: ").append(token).toString());
            }
            none$ = new Some((Object)package$.MODULE$.BigInt().apply(s, 16).$times(BigInt$.MODULE$.int2bigInt(sign)));
        }
        return none$;
    }

    public Option<BigInt> tryOctIntegral(String token, int index, int sign) {
        None$ none$;
        boolean octPrefix;
        boolean bl = octPrefix = index < token.length() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(token), index) == '0';
        if (!octPrefix) {
            none$ = None$.MODULE$;
        } else {
            String s = token.substring(index);
            if (!StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)ch -> BoxesRunTime.boxToBoolean((boolean)Parser.$anonfun$tryOctIntegral$1(BoxesRunTime.unboxToChar((Object)ch))))) {
                throw this.parseException(new StringBuilder(23).append("Invalid octal literal: ").append(token).toString());
            }
            none$ = new Some((Object)package$.MODULE$.BigInt().apply(s, 8).$times(BigInt$.MODULE$.int2bigInt(sign)));
        }
        return none$;
    }

    public Option<BigInt> tryDecimal(String token, int index, int sign) {
        String s = token.substring(index);
        return !StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)ch -> BoxesRunTime.boxToBoolean((boolean)Parser.$anonfun$tryDecimal$1(BoxesRunTime.unboxToChar((Object)ch)))) ? None$.MODULE$ : new Some((Object)package$.MODULE$.BigInt().apply(s, 10).$times(BigInt$.MODULE$.int2bigInt(sign)));
    }

    public Option<BigInt> tryBigInt(String token) {
        None$ none$;
        if (token.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            Tuple2.mcII.sp sp2;
            Tuple2.mcII.sp sp3 = token.startsWith("-") ? new Tuple2.mcII.sp(-1, 1) : (sp2 = token.startsWith("+") ? new Tuple2.mcII.sp(1, 1) : new Tuple2.mcII.sp(1, 0));
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int sign = sp2._1$mcI$sp();
            int index = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(sign, index);
            Tuple2.mcII.sp sp5 = sp4;
            int sign2 = sp5._1$mcI$sp();
            int index2 = sp5._2$mcI$sp();
            none$ = this.tryHexIntegral(token, index2, sign2).orElse((Function0 & Serializable)() -> this.tryOctIntegral(token, index2, sign2)).orElse((Function0 & Serializable)() -> this.tryDecimal(token, index2, sign2));
        }
        return none$;
    }

    public Option<TIntLiteral> tryBigIntLiteral(String token) {
        Position pos = this.it().lastPosition();
        return this.tryBigInt(token).map((Function1 & Serializable)x$2 -> new TIntLiteral(pos, (BigInt)x$2));
    }

    public Option<TLiteral> tryLiteral(String token) {
        return StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(token), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)Parser.$anonfun$tryLiteral$1(BoxesRunTime.unboxToChar((Object)c)))) ? new Some((Object)new TLiteral(this.it().lastPosition(), token)) : None$.MODULE$;
    }

    public Option<TLiteral> tryFractional(String token) {
        Position pos = this.it().lastPosition();
        return Tokenizer$.MODULE$.FRACTIONAL().matcher(token).matches() ? new Some((Object)new TLiteral(pos, token)) : None$.MODULE$;
    }

    public Option<TPrimitive> tryPrimitiveValue(String token) {
        return this.tryFractional(token).orElse((Function0 & Serializable)() -> this.tryBigIntLiteral(token)).orElse((Function0 & Serializable)() -> this.tryBytesLiteral(token)).orElse((Function0 & Serializable)() -> this.tryLiteral(token));
    }

    public Option<TBytes> tryBytesLiteral(String token) {
        None$ none$;
        Position pos = this.it().lastPosition();
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        if (!this.tryBytesLiteralSingle(token, sb)) {
            none$ = None$.MODULE$;
        } else {
            while (this.tryBytesLiteralSingle(this.it().currentToken(), sb)) {
                this.it().nextToken();
            }
            none$ = new Some((Object)new TBytes(pos, sb.result()));
        }
        return none$;
    }

    public boolean tryBytesLiteralSingle(String token, scala.collection.mutable.StringBuilder sb) {
        boolean bl;
        char quote;
        char c = quote = token.isEmpty() ? (char)' ' : (char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(token), 0);
        if (quote != '\"' && quote != '\'') {
            bl = false;
        } else {
            if (token.length() < 2 || StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(token)) != quote) {
                throw this.parseException("String missing ending quote");
            }
            sb.$plus$plus$eq(token.substring(1, token.length() - 1));
            bl = true;
        }
        return bl;
    }

    public Option<TValue> tryColonValue(String init) {
        None$ none$;
        String string = init;
        String string2 = ":";
        if (string == null ? string2 != null : !string.equals(string2)) {
            none$ = None$.MODULE$;
        } else {
            if (!this.it().hasNext()) {
                throw this.parseException("Expected value");
            }
            String token = this.it().next();
            none$ = this.tryMessage(token).orElse((Function0 & Serializable)() -> this.tryValueArray(token)).orElse((Function0 & Serializable)() -> this.tryPrimitiveValue(token));
        }
        return none$;
    }

    public TValue parseValue(String init) {
        return (TValue)this.tryMessage(init).orElse((Function0 & Serializable)() -> this.tryMessageArray(init)).orElse((Function0 & Serializable)() -> this.tryColonValue(init)).getOrElse((Function0 & Serializable)() -> {
            throw this.parseException(new StringBuilder(38).append("Expected ':', '{', '<', or '[', got '").append(init).append("'").toString());
        });
    }

    public TMessage parseMessage() {
        return new TMessage(this.it().lastPosition(), this.parseKeyValueList((Option<String>)None$.MODULE$, (Seq<TField>)package$.MODULE$.Nil()));
    }

    public TextFormatException parseException(String msg) {
        throw new TextFormatException(new StringBuilder(17).append(msg).append(" (line ").append(this.it().lastPosition().line() + 1).append(", column ").append(this.it().lastPosition().col() + 1).append(")").toString());
    }

    public static final /* synthetic */ boolean $anonfun$tryHexIntegral$1(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    public static final /* synthetic */ boolean $anonfun$tryOctIntegral$1(char ch) {
        return ch >= '0' && ch <= '7';
    }

    public static final /* synthetic */ boolean $anonfun$tryDecimal$1(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static final /* synthetic */ boolean $anonfun$tryLiteral$1(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-';
    }

    public Parser(String text) {
        this.it = new Tokenizer(text);
    }
}

