/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.scalafmt.CompatCollections$;
import org.scalafmt.Error;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.ExitCode;
import org.scalafmt.cli.ExitCode$;
import org.scalafmt.cli.InputMethod;
import org.scalafmt.cli.ScalafmtCliReporter;
import org.scalafmt.cli.ScalafmtDynamicRunner;
import org.scalafmt.cli.ScalafmtRunner;
import org.scalafmt.cli.TermDisplay;
import org.scalafmt.dynamic.ScalafmtDynamicError;
import org.scalafmt.interfaces.Scalafmt;
import org.scalafmt.interfaces.ScalafmtReporter;
import org.scalafmt.interfaces.ScalafmtSession;
import org.scalafmt.interfaces.ScalafmtSessionFactory;
import org.scalafmt.util.AbsoluteFile;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.parallel.CollectionConverters;
import scala.meta.internal.tokenizers.PlatformTokenizerCache$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

public final class ScalafmtDynamicRunner$
implements ScalafmtRunner {
    public static final ScalafmtDynamicRunner$ MODULE$ = new ScalafmtDynamicRunner$();

    static {
        ScalafmtRunner.$init$(MODULE$);
    }

    @Override
    public TermDisplay newTermDisplay(CliOptions options, Seq<InputMethod> inputMethods, String msg) {
        return ScalafmtRunner.newTermDisplay$(this, options, inputMethods, msg);
    }

    @Override
    public Seq<InputMethod> getInputMethods(CliOptions options, Function1<AbsoluteFile, Object> filter) {
        return ScalafmtRunner.getInputMethods$(this, options, filter);
    }

    @Override
    public ExitCode run(CliOptions options, String termDisplayMessage) {
        Function1 & Serializable intersect;
        ScalafmtDynamicRunner.MyInstanceSession myInstanceSession;
        ScalafmtCliReporter reporter = new ScalafmtCliReporter(options);
        Scalafmt scalafmtInstance = Scalafmt.create((ClassLoader)this.getClass().getClassLoader()).withReporter((ScalafmtReporter)reporter).withRespectProjectFilters(false);
        try {
            ScalafmtDynamicRunner.MyInstanceSession myInstanceSession2;
            Scalafmt scalafmt = scalafmtInstance;
            if (scalafmt instanceof ScalafmtSessionFactory) {
                Scalafmt scalafmt2 = scalafmt;
                myInstanceSession2 = ((ScalafmtSessionFactory)scalafmt2).createSession(options.configPath());
            } else {
                myInstanceSession2 = new ScalafmtDynamicRunner.MyInstanceSession(options, scalafmtInstance);
            }
            myInstanceSession = myInstanceSession2;
        }
        catch (ScalafmtDynamicError.ConfigError configError) {
            return reporter.getExitCode();
        }
        ScalafmtDynamicRunner.MyInstanceSession session = myInstanceSession;
        if (options.customFiles().isEmpty()) {
            intersect = (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamicRunner$.sessionMatcher$1(x, session));
        } else {
            Function1<AbsoluteFile, Object> customMatcher = this.getFileMatcher(options.customFiles());
            intersect = (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamicRunner$.$anonfun$run$2(customMatcher, session, x));
        }
        Function1 & Serializable filterMatcher = intersect;
        Seq<InputMethod> inputMethods = this.getInputMethods(options, (Function1<AbsoluteFile, Object>)filterMatcher);
        if (inputMethods.isEmpty() && options.mode().isEmpty() && !options.stdIn()) {
            throw Error.NoMatchingFiles$.MODULE$;
        }
        AtomicInteger counter = new AtomicInteger();
        TermDisplay termDisplay = this.newTermDisplay(options, inputMethods, termDisplayMessage);
        AtomicReference<ExitCode> exitCode = new AtomicReference<ExitCode>(ExitCode$.MODULE$.Ok());
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> CollectionConverters.ImmutableSeqIsParallelizable$.MODULE$.par$extension(CompatCollections$.MODULE$.ParConverters().ImmutableSeqIsParallelizable(inputMethods)).foreach((Function1 & Serializable)inputMethod -> {
            ScalafmtDynamicRunner$.$anonfun$run$4(session, options, exitCode, reporter, termDisplay, termDisplayMessage, counter, inputMethod);
            return BoxedUnit.UNIT;
        }));
        ExitCode exit = ExitCode$.MODULE$.merge(exitCode.get(), reporter.getExitCode());
        termDisplay.completedTask(termDisplayMessage, exit.isOk());
        termDisplay.stop();
        return exit;
    }

    private ExitCode handleFile(InputMethod inputMethod, ScalafmtSession session, CliOptions options) {
        String input = inputMethod.readInput(options);
        String formatResult = session.format(Paths.get(inputMethod.filename(), new String[0]), input);
        return inputMethod.write(formatResult, input, options);
    }

    private Function1<AbsoluteFile, Object> getFileMatcher(Seq<AbsoluteFile> paths) {
        Predef$.MODULE$.require(paths.nonEmpty());
        Tuple2 tuple2 = paths.partition((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamicRunner$.$anonfun$getFileMatcher$1(x$3)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq files = (Seq)tuple2._1();
        Seq dirs = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)files, (Object)dirs);
        Tuple2 tuple23 = tuple22;
        Seq files2 = (Seq)tuple23._1();
        Seq dirs2 = (Seq)tuple23._2();
        return (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamicRunner$.$anonfun$getFileMatcher$2(files2, dirs2, x));
    }

    private static final boolean sessionMatcher$1(AbsoluteFile x, ScalafmtSession session$1) {
        return session$1.matchesProjectFilters(x.jfile().toPath());
    }

    public static final /* synthetic */ boolean $anonfun$run$2(Function1 customMatcher$1, ScalafmtSession session$1, AbsoluteFile x) {
        return BoxesRunTime.unboxToBoolean((Object)customMatcher$1.apply((Object)x)) && ScalafmtDynamicRunner$.sessionMatcher$1(x, session$1);
    }

    public static final /* synthetic */ void $anonfun$run$4(ScalafmtSession session$1, CliOptions options$1, AtomicReference exitCode$1, ScalafmtCliReporter reporter$1, TermDisplay termDisplay$1, String termDisplayMessage$1, AtomicInteger counter$1, InputMethod inputMethod) {
        ExitCode exitCode;
        try {
            ExitCode code = MODULE$.handleFile(inputMethod, session$1, options$1);
            exitCode = exitCode$1.getAndUpdate(new UnaryOperator<ExitCode>(code){
                private final ExitCode code$1;

                public ExitCode apply(ExitCode t) {
                    return ExitCode$.MODULE$.merge(this.code$1, t);
                }
                {
                    this.code$1 = code$1;
                }
            });
        }
        catch (Error.MisformattedFile e) {
            reporter$1.error(e.file().toPath(), e);
            if (options$1.check()) {
                throw Breaks$.MODULE$.break();
            }
            exitCode = BoxedUnit.UNIT;
        }
        PlatformTokenizerCache$.MODULE$.megaCache().clear();
        termDisplay$1.taskProgress(termDisplayMessage$1, counter$1.incrementAndGet());
    }

    public static final /* synthetic */ boolean $anonfun$getFileMatcher$1(AbsoluteFile x$3) {
        return x$3.jfile().isFile();
    }

    public static final /* synthetic */ boolean $anonfun$getFileMatcher$3(String filename$1, AbsoluteFile dir) {
        String dirname = dir.path();
        return filename$1.startsWith(dirname) && (filename$1.length() == dirname.length() || filename$1.charAt(dirname.length()) == File.separatorChar);
    }

    public static final /* synthetic */ boolean $anonfun$getFileMatcher$2(Seq files$1, Seq dirs$1, AbsoluteFile x) {
        String filename;
        return files$1.contains((Object)x) || dirs$1.exists(arg_0 -> ScalafmtDynamicRunner$.$anonfun$getFileMatcher$3$adapted(filename = x.path(), arg_0));
    }

    private ScalafmtDynamicRunner$() {
    }

    public static final /* synthetic */ Object $anonfun$getFileMatcher$3$adapted(String filename$1, AbsoluteFile dir) {
        return BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamicRunner$.$anonfun$getFileMatcher$3(filename$1, dir));
    }
}

