/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.binary.converters;

import java.io.Serializable;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import sbt.internal.inc.APIs;
import sbt.internal.inc.APIs$;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.Analysis$;
import sbt.internal.inc.Compilation;
import sbt.internal.inc.Compilations;
import sbt.internal.inc.Compilations$;
import sbt.internal.inc.CompileOutput$;
import sbt.internal.inc.DiagnosticsUtil$;
import sbt.internal.inc.EmptyStamp$;
import sbt.internal.inc.ExternalDependencies;
import sbt.internal.inc.FarmHash$;
import sbt.internal.inc.Hash$;
import sbt.internal.inc.InternalDependencies;
import sbt.internal.inc.LastModified;
import sbt.internal.inc.RelationBuilder;
import sbt.internal.inc.Relations;
import sbt.internal.inc.Relations$;
import sbt.internal.inc.Schema;
import sbt.internal.inc.SourceInfos;
import sbt.internal.inc.SourceInfos$;
import sbt.internal.inc.Stamps;
import sbt.internal.inc.Stamps$;
import sbt.internal.inc.UsedNames;
import sbt.internal.inc.UsedNames$;
import sbt.internal.inc.binary.converters.InternalApiProxy$Modifiers$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$EmptyLazyCompanions$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$Feedback$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$Feedback$Readers$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$ReadersConstants$;
import sbt.internal.util.Relation;
import sbt.util.InterfaceUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import xsbti.Action;
import xsbti.DiagnosticCode;
import xsbti.DiagnosticRelatedInformation;
import xsbti.Position;
import xsbti.Problem;
import xsbti.Severity;
import xsbti.T2;
import xsbti.TextEdit;
import xsbti.UseScope;
import xsbti.VirtualFileRef;
import xsbti.WorkspaceEdit;
import xsbti.api.Access;
import xsbti.api.AnalyzedClass;
import xsbti.api.Annotated;
import xsbti.api.Annotation;
import xsbti.api.AnnotationArgument;
import xsbti.api.ClassDefinition;
import xsbti.api.ClassLike;
import xsbti.api.ClassLikeDef;
import xsbti.api.Companions;
import xsbti.api.Constant;
import xsbti.api.Def;
import xsbti.api.DefinitionType;
import xsbti.api.DependencyContext;
import xsbti.api.Existential;
import xsbti.api.Id;
import xsbti.api.IdQualifier;
import xsbti.api.Lazy;
import xsbti.api.MethodParameter;
import xsbti.api.Modifiers;
import xsbti.api.NameHash;
import xsbti.api.ParameterList;
import xsbti.api.ParameterModifier;
import xsbti.api.ParameterRef;
import xsbti.api.Parameterized;
import xsbti.api.Path;
import xsbti.api.PathComponent;
import xsbti.api.Polymorphic;
import xsbti.api.Private;
import xsbti.api.Projection;
import xsbti.api.Protected;
import xsbti.api.Qualifier;
import xsbti.api.SafeLazyProxy$;
import xsbti.api.Singleton;
import xsbti.api.Structure;
import xsbti.api.Super;
import xsbti.api.Type;
import xsbti.api.TypeAlias;
import xsbti.api.TypeDeclaration;
import xsbti.api.TypeParameter;
import xsbti.api.Val;
import xsbti.api.Var;
import xsbti.api.Variance;
import xsbti.compile.CompileOrder;
import xsbti.compile.FileHash;
import xsbti.compile.MiniOptions;
import xsbti.compile.MiniSetup;
import xsbti.compile.Output;
import xsbti.compile.OutputGroup;
import xsbti.compile.analysis.ReadMapper;
import xsbti.compile.analysis.SourceInfo;
import xsbti.compile.analysis.Stamp;

@ScalaSignature(bytes="\u0006\u0001\u0015]a\u0001\u0002$H\u0005IC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\tI\u0002\u0011\t\u0011)A\u0005K\")Q\u000e\u0001C\u0001]\")1\u000f\u0001C\u0001i\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!!\u001b\u0001\t\u0003\tY\u0007C\u0004\u0002~\u0001!\t!a \t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003\u0013\u0004A\u0011BAf\u0011\u001d\t9\u000e\u0001C\u0005\u00033Dq!a;\u0001\t\u0013\ti\u000fC\u0004\u0002~\u0002!I!a@\t\u000f\t=\u0001\u0001\"\u0003\u0003\u0012!9!\u0011\u0005\u0001\u0005\n\t\r\u0002b\u0002B\u001a\u0001\u0011%!Q\u0007\u0005\b\u0005\u0007\u0002A\u0011\u0001B#\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005/BqAa\u001a\u0001\t\u0003\u0011I\u0007C\u0004\u0003z\u0001!\tAa\u001f\t\u000f\t-\u0005\u0001\"\u0001\u0003\u000e\"9!Q\u0014\u0001\u0005\u0002\t}\u0005b\u0002BY\u0001\u0011\u0005!1\u0017\u0005\b\u0005\u000b\u0004A\u0011\u0001Bd\u0011\u001d\u0011\u0019\u000e\u0001C\u0001\u0005+4aA!8\u0001\u0003\t}\u0007B\u0003Br=\t\u0005\t\u0015!\u0003\u0003f\"1QN\bC\u0001\u0007\u000fAqaa\u0004\u001f\t\u0003\u0019\t\u0002C\u0005\u0004@\u0001\t\t\u0011b\u0001\u0004B\u001911q\n\u0001\u0002\u0007#B!b!\u0016$\u0005\u0003\u0005\u000b\u0011BB,\u0011\u0019i7\u0005\"\u0001\u0004^!911M\u0012\u0005\u0002\r\u0015\u0004\"CB?\u0001\u0005\u0005I1AB@\u0011\u001d\u0019i\t\u0001C\u0001\u0007\u001fCqa!)\u0001\t\u0003\u0019\u0019\u000bC\u0004\u00044\u0002!\ta!.\t\u000f\r5\u0007\u0001\"\u0001\u0004P\"91q\u001c\u0001\u0005\u0002\r\u0005\bbBBy\u0001\u0011\u000511\u001f\u0005\b\t\u0007\u0001A\u0011\u0001C\u0003\u0011\u001d!)\u0002\u0001C\u0001\t/Aq\u0001b\n\u0001\t\u0003!I\u0003C\u0004\u0005:\u0001!\t\u0001b\u000f\t\u000f\u0011-\u0003\u0001\"\u0001\u0005N!9Aq\f\u0001\u0005\u0002\u0011\u0005\u0004\"\u0003CO\u0001\t\u0007IQ\u0002CP\u0011!!\u0019\u000b\u0001Q\u0001\u000e\u0011\u0005\u0006\"\u0003CS\u0001\t\u0007IQ\u0002CT\u0011!!Y\u000b\u0001Q\u0001\u000e\u0011%\u0006\"\u0003CW\u0001\t\u0007IQ\u0002CT\u0011!!y\u000b\u0001Q\u0001\u000e\u0011%\u0006\"\u0003CY\u0001\t\u0007IQ\u0002CT\u0011!!\u0019\f\u0001Q\u0001\u000e\u0011%\u0006b\u0002C[\u0001\u0011\u0005Aq\u0017\u0005\b\t\u000f\u0004A\u0011\u0001Ce\u0011\u001d!i\u000e\u0001C\u0001\t?Dq\u0001b=\u0001\t\u0003!)\u0010C\u0004\u0006\u0004\u0001!\t!\"\u0002\u0007\r\u0011\r\u0005\u0001\u0002CC\u0011\u0019i\u0017\t\"\u0001\u0005\b\"IA\u0011R!C\u0002\u0013%A1\u0012\u0005\t\t'\u000b\u0005\u0015!\u0003\u0005\u000e\"9AQS!\u0005\u0002\u0011]%a\u0004)s_R|'-\u001e4SK\u0006$WM]:\u000b\u0005!K\u0015AC2p]Z,'\u000f^3sg*\u0011!jS\u0001\u0007E&t\u0017M]=\u000b\u00051k\u0015aA5oG*\u0011ajT\u0001\tS:$XM\u001d8bY*\t\u0001+A\u0002tER\u001c\u0001a\u0005\u0002\u0001'B\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n1\u0011I\\=SK\u001a\fa!\\1qa\u0016\u0014\bCA.c\u001b\u0005a&BA/_\u0003!\tg.\u00197zg&\u001c(BA0a\u0003\u001d\u0019w.\u001c9jY\u0016T\u0011!Y\u0001\u0006qN\u0014G/[\u0005\u0003Gr\u0013!BU3bI6\u000b\u0007\u000f]3s\u00039\u0019WO\u001d:f]R4VM]:j_:\u0004\"A\u001a6\u000f\u0005\u001dDW\"A&\n\u0005%\\\u0015AB*dQ\u0016l\u0017-\u0003\u0002lY\n9a+\u001a:tS>t'BA5L\u0003\u0019a\u0014N\\5u}Q\u0019q.\u001d:\u0011\u0005A\u0004Q\"A$\t\u000be\u001b\u0001\u0019\u0001.\t\u000b\u0011\u001c\u0001\u0019A3\u0002\u001d\u0019\u0014x.\u001c)bi\"\u001cFO]5oOR\u0011Qo \t\u0003mvl\u0011a\u001e\u0006\u0003qf\fAAZ5mK*\u0011!p_\u0001\u0004]&|'\"\u0001?\u0002\t)\fg/Y\u0005\u0003}^\u0014A\u0001U1uQ\"9\u0011\u0011\u0001\u0003A\u0002\u0005\r\u0011\u0001\u00029bi\"\u0004B!!\u0002\u0002\u00149!\u0011qAA\b!\r\tI!V\u0007\u0003\u0003\u0017Q1!!\u0004R\u0003\u0019a$o\\8u}%\u0019\u0011\u0011C+\u0002\rA\u0013X\rZ3g\u0013\u0011\t)\"a\u0006\u0003\rM#(/\u001b8h\u0015\r\t\t\"V\u0001\u0010MJ|W\u000eU1uQN#(/\u001b8h-R!\u0011QDA\u0013!\u0011\ty\"!\t\u000e\u0003\u0001L1!a\ta\u000591\u0016N\u001d;vC24\u0015\u000e\\3SK\u001aDq!!\u0001\u0006\u0001\u0004\t\u0019!A\u0007ge>l7\u000b^1naRK\b/\u001a\u000b\u0005\u0003W\t\t\u0004E\u0002\\\u0003[I1!a\f]\u0005\u0015\u0019F/Y7q\u0011\u001d\t\u0019D\u0002a\u0001\u0003k\t\u0011b\u001d;b[B$\u0016\u0010]3\u0011\t\u0005]\u0012Q\b\b\u0004M\u0006e\u0012bAA\u001eY\u000611\u000b^1naNLA!a\u0010\u0002B\tI1\u000b^1naRK\b/\u001a\u0006\u0004\u0003wa\u0017A\u00034s_6\u001cF/Y7qgR!\u0011qIA'!\r9\u0017\u0011J\u0005\u0004\u0003\u0017Z%AB*uC6\u00048\u000fC\u0004\u0002P\u001d\u0001\r!!\u0015\u0002\rM$\u0018-\u001c9t!\r1\u00171K\u0005\u0004\u0003\u0017b\u0017a\u00044s_6|U\u000f\u001e9vi\u001e\u0013x.\u001e9\u0015\t\u0005e\u0013\u0011\r\t\u0005\u00037\ni&D\u0001_\u0013\r\tyF\u0018\u0002\f\u001fV$\b/\u001e;He>,\b\u000fC\u0004\u0002d!\u0001\r!!\u001a\u0002\u0017=,H\u000f];u\u000fJ|W\u000f\u001d\t\u0004M\u0006\u001d\u0014bAA0Y\u0006)bM]8n\u0007>l\u0007/\u001b7bi&|gnT;uaV$H\u0003BA7\u0003g\u0002B!a\u0017\u0002p%\u0019\u0011\u0011\u000f0\u0003\r=+H\u000f];u\u0011\u001d\t)(\u0003a\u0001\u0003o\n\u0011a\u0019\t\u0004M\u0006e\u0014bAA>Y\nY1i\\7qS2\fG/[8o\u0003=1'o\\7D_6\u0004\u0018\u000e\\1uS>tG\u0003BAA\u0003\u000b\u00032aWAB\u0013\r\tY\b\u0018\u0005\b\u0003\u000fS\u0001\u0019AA<\u0003-\u0019w.\u001c9jY\u0006$\u0018n\u001c8\u0002!\u0019\u0014x.\\\"p[BLG.\u0019;j_:\u001cH\u0003BAG\u0003'\u00032aZAH\u0013\r\t\tj\u0013\u0002\r\u0007>l\u0007/\u001b7bi&|gn\u001d\u0005\b\u0003+[\u0001\u0019AAL\u00035\u0019w.\u001c9jY\u0006$\u0018n\u001c8taA\u0019a-!'\n\u0007\u0005EE.\u0001\u0007ge>l\u0007k\\:ji&|g\u000e\u0006\u0003\u0002 \u0006\u0015\u0006\u0003BA\u0010\u0003CK1!a)a\u0005!\u0001vn]5uS>t\u0007bBAT\u0019\u0001\u0007\u0011\u0011V\u0001\ta>\u001c\u0018\u000e^5p]B\u0019a-a+\n\u0007\u0005\rF.\u0001\u0007ge>l7+\u001a<fe&$\u0018\u0010\u0006\u0004\u00022\u0006]\u0016q\u0018\t\u0005\u0003?\t\u0019,C\u0002\u00026\u0002\u0014\u0001bU3wKJLG/\u001f\u0005\b\u0003sk\u0001\u0019AA^\u0003!\u0019XM^3sSRL\bc\u00014\u0002>&\u0019\u0011Q\u00177\t\u000f\u0005\u0005W\u00021\u0001\u0002D\u0006\u0011\u0011\u000e\u001a\t\u0004)\u0006\u0015\u0017bAAd+\n\u0019\u0011J\u001c;\u0002\u0015\u0019\u0014x.\\*ue&tw\r\u0006\u0003\u0002N\u0006M\u0007#\u0002+\u0002P\u0006\r\u0011bAAi+\n1q\n\u001d;j_:Dq!!6\u000f\u0001\u0004\t\u0019!A\u0003wC2,X-A\u0004ge>l\u0017J\u001c;\u0015\t\u0005m\u0017\u0011\u001e\t\u0006)\u0006=\u0017Q\u001c\t\u0005\u0003?\f)/\u0004\u0002\u0002b*\u0019\u00111]>\u0002\t1\fgnZ\u0005\u0005\u0003O\f\tOA\u0004J]R,w-\u001a:\t\u000f\u0005Uw\u00021\u0001\u0002D\u0006\u0011bM]8n\t&\fwM\\8ti&\u001c7i\u001c3f)\u0011\ty/!>\u0011\t\u0005}\u0011\u0011_\u0005\u0004\u0003g\u0004'A\u0004#jC\u001etwn\u001d;jG\u000e{G-\u001a\u0005\b\u0003o\u0004\u0002\u0019AA}\u00039!\u0017.Y4o_N$\u0018nY\"pI\u0016\u00042AZA~\u0013\r\t\u0019\u0010\\\u0001!MJ|W\u000eR5bO:|7\u000f^5d%\u0016d\u0017\r^3e\u0013:4wN]7bi&|g\u000e\u0006\u0003\u0003\u0002\t\u001d\u0001\u0003BA\u0010\u0005\u0007I1A!\u0002a\u0005q!\u0015.Y4o_N$\u0018n\u0019*fY\u0006$X\rZ%oM>\u0014X.\u0019;j_:DqA!\u0003\u0012\u0001\u0004\u0011Y!\u0001\u0003j]\u001a|\u0007c\u00014\u0003\u000e%\u0019!Q\u00017\u0002\u0015\u0019\u0014x.\\!di&|g\u000e\u0006\u0003\u0003\u0014\te\u0001\u0003BA\u0010\u0005+I1Aa\u0006a\u0005\u0019\t5\r^5p]\"9!1\u0004\nA\u0002\tu\u0011AB1di&|g\u000eE\u0002g\u0005?I1Aa\u0006m\u0003E1'o\\7X_J\\7\u000f]1dK\u0016#\u0017\u000e\u001e\u000b\u0005\u0005K\u0011Y\u0003\u0005\u0003\u0002 \t\u001d\u0012b\u0001B\u0015A\niqk\u001c:lgB\f7-Z#eSRDqA!\f\u0014\u0001\u0004\u0011y#\u0001\u0003fI&$\bc\u00014\u00032%\u0019!\u0011\u00067\u0002\u0019\u0019\u0014x.\u001c+fqR,E-\u001b;\u0015\t\t]\"Q\b\t\u0005\u0003?\u0011I$C\u0002\u0003<\u0001\u0014\u0001\u0002V3yi\u0016#\u0017\u000e\u001e\u0005\b\u0005[!\u0002\u0019\u0001B !\r1'\u0011I\u0005\u0004\u0005wa\u0017a\u00034s_6\u0004&o\u001c2mK6$BAa\u0012\u0003NA!\u0011q\u0004B%\u0013\r\u0011Y\u0005\u0019\u0002\b!J|'\r\\3n\u0011\u001d\u0011y%\u0006a\u0001\u0005#\nq\u0001\u001d:pE2,W\u000eE\u0002g\u0005'J1Aa\u0013m\u000391'o\\7T_V\u00148-Z%oM>$BA!\u0017\u0003`A\u00191La\u0017\n\u0007\tuCL\u0001\u0006T_V\u00148-Z%oM>DqA!\u0019\u0017\u0001\u0004\u0011\u0019'\u0001\u0006t_V\u00148-Z%oM>\u00042A\u001aB3\u0013\r\u0011i\u0006\\\u0001\u0010MJ|WnU8ve\u000e,\u0017J\u001c4pgR!!1\u000eB9!\r9'QN\u0005\u0004\u0005_Z%aC*pkJ\u001cW-\u00138g_NDqAa\u001d\u0018\u0001\u0004\u0011)(\u0001\u0007t_V\u00148-Z%oM>\u001c\b\u0007E\u0002g\u0005oJ1Aa\u001cm\u0003U1'o\\7DY\u0006\u001c8\u000f]1uQ\u001aKG.\u001a%bg\"$BA! \u0003\u0004B!\u00111\fB@\u0013\r\u0011\tI\u0018\u0002\t\r&dW\rS1tQ\"9!Q\u0011\rA\u0002\t\u001d\u0015\u0001\u00034jY\u0016D\u0015m\u001d5\u0011\u0007\u0019\u0014I)C\u0002\u0003\u00022\fqB\u001a:p[6Kg.[(qi&|gn\u001d\u000b\u0005\u0005\u001f\u0013)\n\u0005\u0003\u0002\\\tE\u0015b\u0001BJ=\nYQ*\u001b8j\u001fB$\u0018n\u001c8t\u0011\u001d\u00119*\u0007a\u0001\u00053\u000b1\"\\5oS>\u0003H/[8ogB\u0019aMa'\n\u0007\tME.\u0001\tge>l7i\\7qS2,wJ\u001d3feR1!\u0011\u0015BT\u0005_\u0003B!a\u0017\u0003$&\u0019!Q\u00150\u0003\u0019\r{W\u000e]5mK>\u0013H-\u001a:\t\u000f\t%&\u00041\u0001\u0003,\u0006a1m\\7qS2,wJ\u001d3feB\u0019aM!,\n\u0007\t\u0015F\u000eC\u0004\u0002Bj\u0001\r!a1\u0002\u001f\u0019\u0014x.\\*ue&tw\rV;qY\u0016$BA!.\u0003<BA\u0011q\u0004B\\\u0003\u0007\t\u0019!C\u0002\u0003:\u0002\u0014!\u0001\u0016\u001a\t\u000f\tu6\u00041\u0001\u0003@\u0006)A/\u001e9mKB\u0019aM!1\n\u0007\t\rGNA\u0003UkBdW-A\nge>lW*\u001b8j'\u0016$X\u000f](viB,H\u000f\u0006\u0003\u0002n\t%\u0007b\u0002Bf9\u0001\u0007!QZ\u0001\n[&t\u0017nU3ukB\u00042A\u001aBh\u0013\r\u0011\t\u000e\u001c\u0002\n\u001b&t\u0017nU3ukB\fQB\u001a:p[6Kg.[*fiV\u0004H\u0003\u0002Bl\u00057\u0004B!a\u0017\u0003Z&\u0019!\u0011\u001b0\t\u000f\t-W\u00041\u0001\u0003N\n\tRI\u001a4jG&,g\u000e\u001e+sCZ,'o]3\u0016\t\t\u0005(Q_\n\u0003=M\u000b1a]3r!\u0019\u00119O!<\u0003r6\u0011!\u0011\u001e\u0006\u0004\u0005W\\\u0018\u0001B;uS2LAAa<\u0003j\n!A*[:u!\u0011\u0011\u0019P!>\r\u0001\u00119!q\u001f\u0010C\u0002\te(!\u0001+\u0012\t\tm8\u0011\u0001\t\u0004)\nu\u0018b\u0001B\u0000+\n9aj\u001c;iS:<\u0007c\u0001+\u0004\u0004%\u00191QA+\u0003\u0007\u0005s\u0017\u0010\u0006\u0003\u0004\n\r5\u0001#BB\u0006=\tEX\"\u0001\u0001\t\u000f\t\r\b\u00051\u0001\u0003f\u0006YAo\u001c.j]\u000e\f%O]1z+\u0011\u0019\u0019ba\b\u0015\t\rU1Q\u0007\u000b\u0005\u0007/\u0019)\u0003E\u0003U\u00073\u0019i\"C\u0002\u0004\u001cU\u0013Q!\u0011:sCf\u0004BAa=\u0004 \u001191\u0011E\u0011C\u0002\r\r\"!\u0001*\u0012\u0007\tm8\u000bC\u0005\u0004(\u0005\n\t\u0011q\u0001\u0004*\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\r\r-2\u0011GB\u000f\u001b\t\u0019iCC\u0002\u00040U\u000bqA]3gY\u0016\u001cG/\u0003\u0003\u00044\r5\"\u0001C\"mCN\u001cH+Y4\t\u000f\r]\u0012\u00051\u0001\u0004:\u0005\ta\rE\u0004U\u0007w\u0011\tp!\b\n\u0007\ruRKA\u0005Gk:\u001cG/[8oc\u0005\tRI\u001a4jG&,g\u000e\u001e+sCZ,'o]3\u0016\t\r\r3\u0011\n\u000b\u0005\u0007\u000b\u001aY\u0005E\u0003\u0004\fy\u00199\u0005\u0005\u0003\u0003t\u000e%Ca\u0002B|E\t\u0007!\u0011 \u0005\b\u0005G\u0014\u0003\u0019AB'!\u0019\u00119O!<\u0004H\taq\n\u001d;j_:\u0014V-\u00193feV!11KB.'\t\u00193+\u0001\u0004paRLwN\u001c\t\u0006)\u0006=7\u0011\f\t\u0005\u0005g\u001cY\u0006B\u0004\u0003x\u000e\u0012\rA!?\u0015\t\r}3\u0011\r\t\u0006\u0007\u0017\u00193\u0011\f\u0005\b\u0007+*\u0003\u0019AB,\u0003\u0011\u0011X-\u00193\u0016\t\r\u001d41\u000e\u000b\u0007\u0007S\u001aiga\u001d\u0011\t\tM81\u000e\u0003\b\u0007C1#\u0019\u0001B}\u0011\u001d\u0019yG\na\u0001\u0007c\nAA\u001a:p[B9Aka\u000f\u0004Z\r%\u0004\u0002CB;M\u0011\u0005\raa\u001e\u0002\u0019\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3\u0011\u000bQ\u001bI(a\u0001\n\u0007\rmTK\u0001\u0005=Eft\u0017-\\3?\u00031y\u0005\u000f^5p]J+\u0017\rZ3s+\u0011\u0019\tia\"\u0015\t\r\r5\u0011\u0012\t\u0006\u0007\u0017\u00193Q\u0011\t\u0005\u0005g\u001c9\tB\u0004\u0003x\u001e\u0012\rA!?\t\u000f\rUs\u00051\u0001\u0004\fB)A+a4\u0004\u0006\u0006AaM]8n!\u0006$\b\u000e\u0006\u0003\u0004\u0012\u000em\u0005\u0003BBJ\u00073k!a!&\u000b\u0007\r]\u0005-A\u0002ba&L1A`BK\u0011\u001d\t\t\u0001\u000ba\u0001\u0007;\u00032AZBP\u0013\tqH.\u0001\bge>l\u0017I\u001c8pi\u0006$\u0018n\u001c8\u0015\t\r\u001561\u0016\t\u0005\u0007'\u001b9+\u0003\u0003\u0004*\u000eU%AC!o]>$\u0018\r^5p]\"91QV\u0015A\u0002\r=\u0016AC1o]>$\u0018\r^5p]B\u0019am!-\n\u0007\r%F.A\u0007ge>l7\u000b\u001e:vGR,(/\u001a\u000b\u0005\u0007o\u001bi\f\u0005\u0003\u0004\u0014\u000ee\u0016\u0002BB^\u0007+\u0013\u0011b\u0015;sk\u000e$XO]3\t\u000f\r}&\u00061\u0001\u0004B\u0006\u0019A\u000f]3\u0011\t\r\r7\u0011\u001a\b\u0004M\u000e\u0015\u0017bABdY\u0006!A+\u001f9f\u0013\u0011\u0019Yla3\u000b\u0007\r\u001dG.\u0001\u0005ge>lG+\u001f9f)\u0011\u0019\tna6\u0011\t\rM51[\u0005\u0005\u0007+\u001c)J\u0001\u0003UsB,\u0007bBBmW\u0001\u000711\\\u0001\u0005if\u0004X\rE\u0002g\u0007;L1a!6m\u000351'o\\7N_\u0012Lg-[3sgR!11]Bu!\u0011\u0019\u0019j!:\n\t\r\u001d8Q\u0013\u0002\n\u001b>$\u0017NZ5feNDqaa;-\u0001\u0004\u0019i/A\u0005n_\u0012Lg-[3sgB\u0019ama<\n\u0007\r\u001dH.\u0001\u0006ge>l\u0017iY2fgN$Ba!>\u0004|B!11SB|\u0013\u0011\u0019Ip!&\u0003\r\u0005\u001b7-Z:t\u0011\u001d\u0019i0\fa\u0001\u0007\u007f\fa!Y2dKN\u001c\bc\u00014\u0005\u0002%\u00191\u0011 7\u0002%\u0019\u0014x.\u001c#fM&t\u0017\u000e^5p]RK\b/\u001a\u000b\u0005\t\u000f!i\u0001\u0005\u0003\u0004\u0014\u0012%\u0011\u0002\u0002C\u0006\u0007+\u0013a\u0002R3gS:LG/[8o)f\u0004X\rC\u0004\u0005\u00109\u0002\r\u0001\"\u0005\u0002\u001d\u0011,g-\u001b8ji&|g\u000eV=qKB\u0019a\rb\u0005\n\u0007\u0011-A.A\nge>l7\t\\1tg\u0012+g-\u001b8ji&|g\u000e\u0006\u0003\u0005\u001a\u0011}\u0001\u0003BBJ\t7IA\u0001\"\b\u0004\u0016\ny1\t\\1tg\u0012+g-\u001b8ji&|g\u000eC\u0004\u0005\"=\u0002\r\u0001b\t\u0002\u001f\rd\u0017m]:EK\u001aLg.\u001b;j_:\u00042A\u001aC\u0013\u0013\r!i\u0002\\\u0001\u0012MJ|W\u000eV=qKB\u000b'/Y7fi\u0016\u0014H\u0003\u0002C\u0016\tc\u0001Baa%\u0005.%!AqFBK\u00055!\u0016\u0010]3QCJ\fW.\u001a;fe\"9A1\u0007\u0019A\u0002\u0011U\u0012!\u0004;za\u0016\u0004\u0016M]1nKR,'\u000fE\u0002g\toI1\u0001b\fm\u000351'o\\7DY\u0006\u001c8\u000fT5lKR!AQ\bC\"!\u0011\u0019\u0019\nb\u0010\n\t\u0011\u00053Q\u0013\u0002\n\u00072\f7o\u001d'jW\u0016Dq\u0001\"\u00122\u0001\u0004!9%A\u0005dY\u0006\u001c8\u000fT5lKB\u0019a\r\"\u0013\n\u0007\u0011\u0005C.\u0001\u0007ge>lWk]3TG>\u0004X\r\u0006\u0004\u0005P\u0011UCQ\f\t\u0005\u0003?!\t&C\u0002\u0005T\u0001\u0014\u0001\"V:f'\u000e|\u0007/\u001a\u0005\b\t/\u0012\u0004\u0019\u0001C-\u0003!)8/Z*d_B,\u0007c\u00014\u0005\\%\u0019A1\u000b7\t\u000f\u0005\u0005'\u00071\u0001\u0002D\u0006\tbM]8n\u0003:\fG.\u001f>fI\u000ec\u0017m]:\u0015\r\u0011\rD1\u000fC?)\u0011!)\u0007b\u001b\u0011\t\rMEqM\u0005\u0005\tS\u001a)JA\u0007B]\u0006d\u0017P_3e\u00072\f7o\u001d\u0005\b\t[\u001a\u0004\u0019\u0001C8\u00035\tg.\u00197zu\u0016$7\t\\1tgB\u0019a\r\"\u001d\n\u0007\u0011%D\u000eC\u0004\u0005vM\u0002\r\u0001b\u001e\u0002\u001fMDw.\u001e7e'R|'/Z!qSN\u00042\u0001\u0016C=\u0013\r!Y(\u0016\u0002\b\u0005>|G.Z1o\u0011\u001d!yh\ra\u0001\t\u0003\u000b1b\u001d;sS:<G+\u00192mKB\u001911B!\u0003\u0017M#(/\u001b8h)\u0006\u0014G.Z\n\u0003\u0003N#\"\u0001\"!\u0002\u000fM$(/\u001b8hgV\u0011AQ\u0012\t\t\u0005O$y)a\u0001\u0002\u0004%!A\u0011\u0013Bu\u0005\u001dA\u0015m\u001d5NCB\f\u0001b\u001d;sS:<7\u000fI\u0001\u000eY>|7.\u001e9Pe\u0016sG/\u001a:\u0015\t\u0005\rA\u0011\u0014\u0005\b\t7+\u0005\u0019AA\u0002\u0003\u0019\u0019HO]5oO\u0006A1\u000f\u001e:j]\u001eLE-\u0006\u0002\u0005\"B9Aka\u000f\u0002\u0004\u0005\r\u0011!C:ue&tw-\u00133!\u00039\u0019HO]5oOR{7k\\;sG\u0016,\"\u0001\"+\u0011\u000fQ\u001bY$a\u0001\u0002\u001e\u0005y1\u000f\u001e:j]\u001e$vnU8ve\u000e,\u0007%A\btiJLgn\u001a+p\u0019&\u0014'/\u0019:z\u0003A\u0019HO]5oOR{G*\u001b2sCJL\b%\u0001\u0007tiJLgn\u001a+p!J|G-A\u0007tiJLgn\u001a+p!J|G\rI\u0001\u000eMJ|WNU3mCRLwN\\:\u0015\t\u0011eFq\u0018\t\u0004O\u0012m\u0016b\u0001C_\u0017\nI!+\u001a7bi&|gn\u001d\u0005\b\t\u0003d\u0004\u0019\u0001Cb\u0003%\u0011X\r\\1uS>t7\u000fE\u0002g\t\u000bL1\u0001\"0m\u0003!1'o\\7Ba&\u001cH\u0003\u0002Cf\t7$B\u0001\"4\u0005TB\u0019q\rb4\n\u0007\u0011E7J\u0001\u0003B!&\u001b\bb\u0002Ck{\u0001\u0007Aq[\u0001\u0005CBL7\u000fE\u0002g\t3L1\u0001\"5m\u0011\u001d!)(\u0010a\u0001\to\nAB\u001a:p[\u0006\u0003\u0018n\u001d$jY\u0016$b\u0001\"9\u0005h\u0012E\bC\u0002+\u0005d\u00125W-C\u0002\u0005fV\u0013a\u0001V;qY\u0016\u0014\u0004b\u0002Cu}\u0001\u0007A1^\u0001\tCBL7OR5mKB\u0019a\r\"<\n\u0007\u0011=HN\u0001\u0005B!&\u001bh)\u001b7f\u0011\u001d!)H\u0010a\u0001\to\nAB\u001a:p[\u0006s\u0017\r\\=tSN$B\u0001b>\u0005~B\u0019q\r\"?\n\u0007\u0011m8J\u0001\u0005B]\u0006d\u0017p]5t\u0011\u0019iv\b1\u0001\u0005\u0000B\u0019a-\"\u0001\n\u0007\u0011mH.\u0001\tge>l\u0017I\\1msNL7OR5mKR!QqAC\u0007!!!V\u0011\u0002C|\u0005/,\u0017bAC\u0006+\n1A+\u001e9mKNBq!b\u0004A\u0001\u0004)\t\"\u0001\u0007b]\u0006d\u0017p]5t\r&dW\rE\u0002g\u000b'I1!\"\u0006m\u00051\te.\u00197zg&\u001ch)\u001b7f\u0001")
public final class ProtobufReaders {
    private final ReadMapper mapper;
    private final Schema.Version currentVersion;
    private final Function1<String, String> stringId;
    private final Function1<String, VirtualFileRef> stringToSource;
    private final Function1<String, VirtualFileRef> stringToLibrary;
    private final Function1<String, VirtualFileRef> stringToProd;

    public java.nio.file.Path fromPathString(String path) {
        return Paths.get(path, new String[0]);
    }

    public VirtualFileRef fromPathStringV(String path) {
        return VirtualFileRef.of((String)path);
    }

    public Stamp fromStampType(Schema.Stamps.StampType stampType) {
        Schema.Stamps.StampType.TypeCase typeCase = stampType.getTypeCase();
        if (Schema.Stamps.StampType.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
            return EmptyStamp$.MODULE$;
        }
        if (Schema.Stamps.StampType.TypeCase.FARMHASH.equals(typeCase)) {
            return FarmHash$.MODULE$.fromLong(stampType.getFarmHash().getHash());
        }
        if (Schema.Stamps.StampType.TypeCase.HASH.equals(typeCase)) {
            return Hash$.MODULE$.unsafeFromString(stampType.getHash().getHash());
        }
        if (Schema.Stamps.StampType.TypeCase.LASTMODIFIED.equals(typeCase)) {
            return new LastModified(stampType.getLastModified().getMillis());
        }
        throw new MatchError((Object)typeCase);
    }

    public Stamps fromStamps(Schema.Stamps stamps) {
        scala.collection.immutable.Map libraries = this.fromBinarySchemaMap$1(stamps.getBinaryStampsMap());
        scala.collection.immutable.Map sources = this.fromSourceSchemaMap$1(stamps.getSourceStampsMap());
        scala.collection.immutable.Map products = this.fromProductSchemaMap$1(stamps.getProductStampsMap());
        return Stamps$.MODULE$.apply(products, sources, libraries);
    }

    public OutputGroup fromOutputGroup(Schema.OutputGroup outputGroup) {
        java.nio.file.Path sourcePath = this.fromPathString(outputGroup.getSourcePath());
        java.nio.file.Path sourceDir = this.mapper.mapSourceDir(sourcePath);
        java.nio.file.Path targetPath = this.fromPathString(outputGroup.getTargetPath());
        java.nio.file.Path targetDir = this.mapper.mapOutputDir(targetPath);
        return CompileOutput$.MODULE$.outputGroup(sourceDir, targetDir);
    }

    public Output fromCompilationOutput(Schema.Compilation c) {
        Schema.Compilation.OutputCase outputCase = c.getOutputCase();
        if (Schema.Compilation.OutputCase.SINGLEOUTPUT.equals(outputCase)) {
            java.nio.file.Path target;
            Schema.SingleOutput single = c.getSingleOutput();
            java.nio.file.Path path = target = this.fromPathString(single.getTarget());
            java.nio.file.Path path2 = Analysis$.MODULE$.dummyOutputPath();
            if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                return CompileOutput$.MODULE$.empty();
            }
            java.nio.file.Path outputDir = this.mapper.mapOutputDir(target);
            return CompileOutput$.MODULE$.apply(outputDir);
        }
        if (Schema.Compilation.OutputCase.MULTIPLEOUTPUT.equals(outputCase)) {
            Schema.MultipleOutput multiple = c.getMultipleOutput();
            OutputGroup[] groups = (OutputGroup[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(multiple.getOutputGroupsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)outputGroup -> this.fromOutputGroup((Schema.OutputGroup)outputGroup)).toArray(ClassTag$.MODULE$.apply(OutputGroup.class));
            return CompileOutput$.MODULE$.apply(groups);
        }
        if (Schema.Compilation.OutputCase.OUTPUT_NOT_SET.equals(outputCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedOutputInCompilationOutput()).$bang$bang();
        }
        throw new MatchError((Object)outputCase);
    }

    public xsbti.compile.analysis.Compilation fromCompilation(Schema.Compilation compilation) {
        Output output = this.fromCompilationOutput(compilation);
        return new Compilation(compilation.getStartTimeMillis(), output);
    }

    public Compilations fromCompilations(Schema.Compilations compilations0) {
        Iterator compilations = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(compilations0.getCompilationsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)compilation -> this.fromCompilation((Schema.Compilation)compilation));
        Seq castedCompilations = compilations.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            xsbti.compile.analysis.Compilation compilation = x0$1;
            if (compilation instanceof Compilation) {
                Compilation compilation2 = (Compilation)compilation;
                return compilation2;
            }
            throw new MatchError((Object)compilation);
        }).toSeq();
        return Compilations$.MODULE$.of(castedCompilations);
    }

    public Position fromPosition(Schema.Position position) {
        return InterfaceUtil$.MODULE$.position(this.fromInt(position.getLine()), position.getLineContent(), this.fromInt(position.getOffset()), this.fromInt(position.getPointer()), this.fromString(position.getPointerSpace()), this.fromString(position.getSourcePath()), this.fromString(position.getSourceFilepath()).map((Function1 & Serializable & scala.Serializable)path -> this.fromPathString((String)path)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toFile()), this.fromInt(position.getStartOffset()), this.fromInt(position.getEndOffset()), this.fromInt(position.getStartLine()), this.fromInt(position.getStartColumn()), this.fromInt(position.getEndLine()), this.fromInt(position.getEndColumn()));
    }

    public Severity fromSeverity(Schema.Severity severity, int id) {
        Schema.Severity severity2 = severity;
        if (Schema.Severity.INFO.equals(severity2)) {
            return Severity.Info;
        }
        if (Schema.Severity.WARN.equals(severity2)) {
            return Severity.Warn;
        }
        if (Schema.Severity.ERROR.equals(severity2)) {
            return Severity.Error;
        }
        if (Schema.Severity.UNRECOGNIZED.equals(severity2)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedSeverity(id)).$bang$bang();
        }
        throw new MatchError((Object)severity2);
    }

    private Option<String> fromString(String value) {
        String string = value;
        String string2 = ProtobufDefaults$.MODULE$.MissingString();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return None$.MODULE$;
        }
        return new Some((Object)value);
    }

    private Option<Integer> fromInt(int value) {
        if (value == ProtobufDefaults$.MODULE$.MissingInt()) {
            return None$.MODULE$;
        }
        return new Some((Object)Predef$.MODULE$.int2Integer(value));
    }

    private DiagnosticCode fromDiagnosticCode(Schema.DiagnosticCode diagnosticCode) {
        return DiagnosticsUtil$.MODULE$.diagnosticCode(diagnosticCode.getCode(), this.fromString(diagnosticCode.getExplanation()));
    }

    private DiagnosticRelatedInformation fromDiagnosticRelatedInformation(Schema.DiagnosticRelatedInformation info) {
        return DiagnosticsUtil$.MODULE$.diagnosticRelatedInformation(this.fromPosition(info.getPosition()), info.getMessage());
    }

    private Action fromAction(Schema.Action action) {
        return InterfaceUtil$.MODULE$.action(action.getTitle(), this.fromString(action.getDescription()), this.fromWorkspaceEdit(action.getEdit()));
    }

    private WorkspaceEdit fromWorkspaceEdit(Schema.WorkspaceEdit edit2) {
        return InterfaceUtil$.MODULE$.workspaceEdit(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(edit2.getChangesList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)edit -> this.fromTextEdit((Schema.TextEdit)edit)).toList());
    }

    private TextEdit fromTextEdit(Schema.TextEdit edit) {
        return InterfaceUtil$.MODULE$.textEdit(this.fromPosition(edit.getPosition()), edit.getNewText());
    }

    public Problem fromProblem(Schema.Problem problem) {
        String category = problem.getCategory();
        String message = problem.getMessage();
        Severity severity = this.fromSeverity(problem.getSeverity(), problem.getSeverityValue());
        if (!problem.hasPosition()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPositionInProblem()).$bang$bang();
        }
        Position position = this.fromPosition(problem.getPosition());
        Option<String> rendered = this.fromString(problem.getRendered());
        None$ diagnosticCode = problem.hasDiagnosticCode() ? new Some((Object)this.fromDiagnosticCode(problem.getDiagnosticCode())) : None$.MODULE$;
        List infos = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(problem.getDiagnosticRelatedInformationList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)info -> this.fromDiagnosticRelatedInformation((Schema.DiagnosticRelatedInformation)info)).toList();
        List actions = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(problem.getActionsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)action -> this.fromAction((Schema.Action)action)).toList();
        return InterfaceUtil$.MODULE$.problem(category, position, message, severity, rendered, (Option)diagnosticCode, infos, actions);
    }

    public SourceInfo fromSourceInfo(Schema.SourceInfo sourceInfo) {
        Seq mainClasses = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)sourceInfo.getMainClassesList()).asScala()).toSeq();
        Seq reportedProblems = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sourceInfo.getReportedProblemsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)problem -> this.fromProblem((Schema.Problem)problem)).toSeq();
        Seq unreportedProblems = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sourceInfo.getUnreportedProblemsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)problem -> this.fromProblem((Schema.Problem)problem)).toSeq();
        return SourceInfos$.MODULE$.makeInfo(reportedProblems, unreportedProblems, mainClasses);
    }

    public SourceInfos fromSourceInfos(Schema.SourceInfos sourceInfos0) {
        Iterator sourceInfos = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sourceInfos0.getSourceInfosMap()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String path = (String)tuple2._1();
                Schema.SourceInfo value = (Schema.SourceInfo)tuple2._2();
                VirtualFileRef file = $this.mapper.mapSourceFile(this.fromPathStringV(path));
                SourceInfo sourceInfo = this.fromSourceInfo(value);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), (Object)sourceInfo);
            }
            throw new MatchError((Object)tuple2);
        });
        return SourceInfos$.MODULE$.of(sourceInfos.toMap(Predef$.MODULE$.$conforms()));
    }

    public FileHash fromClasspathFileHash(Schema.FileHash fileHash) {
        int hash = fileHash.getHash();
        java.nio.file.Path classpathEntry = this.fromPathString(fileHash.getPath());
        java.nio.file.Path newClasspathEntry = this.mapper.mapClasspathEntry(classpathEntry);
        return FileHash.of((java.nio.file.Path)newClasspathEntry, (int)hash);
    }

    public MiniOptions fromMiniOptions(Schema.MiniOptions miniOptions) {
        FileHash[] classpathHash = (FileHash[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(miniOptions.getClasspathHashList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)fileHash -> this.fromClasspathFileHash((Schema.FileHash)fileHash)).toArray(ClassTag$.MODULE$.apply(FileHash.class));
        String[] javacOptions = (String[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)miniOptions.getJavacOptionsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)javacOption -> $this.mapper.mapJavacOption((String)javacOption)).toArray(ClassTag$.MODULE$.apply(String.class));
        String[] scalacOptions = (String[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)miniOptions.getScalacOptionsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)scalacOption -> $this.mapper.mapScalacOption((String)scalacOption)).toArray(ClassTag$.MODULE$.apply(String.class));
        return MiniOptions.of((FileHash[])classpathHash, (String[])scalacOptions, (String[])javacOptions);
    }

    public CompileOrder fromCompileOrder(Schema.CompileOrder compileOrder, int id) {
        Schema.CompileOrder compileOrder2 = compileOrder;
        if (Schema.CompileOrder.MIXED.equals(compileOrder2)) {
            return CompileOrder.Mixed;
        }
        if (Schema.CompileOrder.JAVATHENSCALA.equals(compileOrder2)) {
            return CompileOrder.JavaThenScala;
        }
        if (Schema.CompileOrder.SCALATHENJAVA.equals(compileOrder2)) {
            return CompileOrder.ScalaThenJava;
        }
        if (Schema.CompileOrder.UNRECOGNIZED.equals(compileOrder2)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedOrder(id)).$bang$bang();
        }
        throw new MatchError((Object)compileOrder2);
    }

    public T2<String, String> fromStringTuple(Schema.Tuple tuple) {
        return InterfaceUtil$.MODULE$.t2(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tuple.getFirst()), (Object)tuple.getSecond()));
    }

    public Output fromMiniSetupOutput(Schema.MiniSetup miniSetup) {
        Schema.MiniSetup.OutputCase outputCase = miniSetup.getOutputCase();
        if (Schema.MiniSetup.OutputCase.SINGLEOUTPUT.equals(outputCase)) {
            java.nio.file.Path target;
            Schema.SingleOutput single = miniSetup.getSingleOutput();
            java.nio.file.Path path = target = this.fromPathString(single.getTarget());
            java.nio.file.Path path2 = Analysis$.MODULE$.dummyOutputPath();
            if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                return CompileOutput$.MODULE$.empty();
            }
            java.nio.file.Path outputDir = this.mapper.mapOutputDir(target);
            return CompileOutput$.MODULE$.apply(outputDir);
        }
        if (Schema.MiniSetup.OutputCase.MULTIPLEOUTPUT.equals(outputCase)) {
            Schema.MultipleOutput multiple = miniSetup.getMultipleOutput();
            OutputGroup[] groups = (OutputGroup[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(multiple.getOutputGroupsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)outputGroup -> this.fromOutputGroup((Schema.OutputGroup)outputGroup)).toArray(ClassTag$.MODULE$.apply(OutputGroup.class));
            return CompileOutput$.MODULE$.apply(groups);
        }
        if (Schema.MiniSetup.OutputCase.OUTPUT_NOT_SET.equals(outputCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedOutputInCompilationOutput()).$bang$bang();
        }
        throw new MatchError((Object)outputCase);
    }

    public MiniSetup fromMiniSetup(Schema.MiniSetup miniSetup) {
        Output output = this.fromMiniSetupOutput(miniSetup);
        if (!miniSetup.hasMiniOptions()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedMiniOptionsInSetup()).$bang$bang();
        }
        MiniOptions miniOptions = this.fromMiniOptions(miniSetup.getMiniOptions());
        String compilerVersion = miniSetup.getCompilerVersion();
        CompileOrder compileOrder = this.fromCompileOrder(miniSetup.getCompileOrder(), miniSetup.getCompileOrderValue());
        boolean storeApis = miniSetup.getStoreApis();
        T2[] extra = (T2[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(miniSetup.getExtraList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)tuple -> this.fromStringTuple((Schema.Tuple)tuple)).toArray(ClassTag$.MODULE$.apply(T2.class));
        MiniSetup original = MiniSetup.of((Output)output, (MiniOptions)miniOptions, (String)compilerVersion, (CompileOrder)compileOrder, (boolean)storeApis, (T2[])extra);
        return this.mapper.mapMiniSetup(original);
    }

    public <T> EfficientTraverse<T> EfficientTraverse(java.util.List<T> seq) {
        return new EfficientTraverse<T>(this, seq);
    }

    public <T> OptionReader<T> OptionReader(Option<T> option) {
        return new OptionReader<T>(this, option);
    }

    public Path fromPath(Schema.Path path) {
        PathComponent[] components = (PathComponent[])this.EfficientTraverse(path.getComponentsList()).toZincArray((Function1 & Serializable & scala.Serializable)pathComponent -> this.fromPathComponent$1((Schema.Path.PathComponent)pathComponent), ClassTag$.MODULE$.apply(PathComponent.class));
        return Path.of((PathComponent[])components);
    }

    public Annotation fromAnnotation(Schema.Annotation annotation) {
        AnnotationArgument[] arguments = (AnnotationArgument[])this.EfficientTraverse(annotation.getArgumentsList()).toZincArray((Function1 & Serializable & scala.Serializable)argument -> ProtobufReaders.fromAnnotationArgument$1(argument), ClassTag$.MODULE$.apply(AnnotationArgument.class));
        None$ b = annotation.hasBase() ? new Some((Object)annotation.getBase()) : None$.MODULE$;
        Type base = (Type)this.OptionReader((Option)b).read((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Annotation.class));
        return Annotation.of((Type)base, (AnnotationArgument[])arguments);
    }

    public Structure fromStructure(Schema.Type.Structure tpe) {
        Lazy parents = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getParentsList()).toZincArray((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class)));
        Lazy declared = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getDeclaredList()).toZincArray((Function1 & Serializable & scala.Serializable)classDefinition -> this.fromClassDefinition((Schema.ClassDefinition)classDefinition), ClassTag$.MODULE$.apply(ClassDefinition.class)));
        Lazy inherited = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getInheritedList()).toZincArray((Function1 & Serializable & scala.Serializable)classDefinition -> this.fromClassDefinition((Schema.ClassDefinition)classDefinition), ClassTag$.MODULE$.apply(ClassDefinition.class)));
        return Structure.of((Lazy)parents, (Lazy)declared, (Lazy)inherited);
    }

    public Type fromType(Schema.Type type) {
        Schema.Type.ValueCase valueCase = type.getValueCase();
        if (Schema.Type.ValueCase.PARAMETERREF.equals(valueCase)) {
            return ProtobufReaders.fromParameterRef$1(type.getParameterRef());
        }
        if (Schema.Type.ValueCase.PARAMETERIZED.equals(valueCase)) {
            return this.fromParameterized$1(type.getParameterized());
        }
        if (Schema.Type.ValueCase.STRUCTURE.equals(valueCase)) {
            return this.fromStructure(type.getStructure());
        }
        if (Schema.Type.ValueCase.POLYMORPHIC.equals(valueCase)) {
            return this.fromPolymorphic$1(type.getPolymorphic());
        }
        if (Schema.Type.ValueCase.CONSTANT.equals(valueCase)) {
            return this.fromConstant$1(type.getConstant());
        }
        if (Schema.Type.ValueCase.EXISTENTIAL.equals(valueCase)) {
            return this.fromExistential$1(type.getExistential());
        }
        if (Schema.Type.ValueCase.SINGLETON.equals(valueCase)) {
            return this.fromSingleton$1(type.getSingleton());
        }
        if (Schema.Type.ValueCase.PROJECTION.equals(valueCase)) {
            return this.fromProjection$1(type.getProjection());
        }
        if (Schema.Type.ValueCase.ANNOTATED.equals(valueCase)) {
            return this.fromAnnotated$1(type.getAnnotated());
        }
        if (Schema.Type.ValueCase.EMPTYTYPE.equals(valueCase)) {
            return ProtobufDefaults$ReadersConstants$.MODULE$.EmptyType();
        }
        if (Schema.Type.ValueCase.VALUE_NOT_SET.equals(valueCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyType()).$bang$bang();
        }
        throw new MatchError((Object)valueCase);
    }

    public Modifiers fromModifiers(Schema.Modifiers modifiers) {
        return InternalApiProxy$Modifiers$.MODULE$.apply(modifiers.getFlags());
    }

    public Access fromAccess(Schema.Access access) {
        Schema.Access.TypeCase typeCase = access.getTypeCase();
        if (Schema.Access.TypeCase.PUBLIC.equals(typeCase)) {
            return ProtobufDefaults$ReadersConstants$.MODULE$.Public();
        }
        if (Schema.Access.TypeCase.PROTECTED.equals(typeCase)) {
            Schema.Protected a = access.getProtected();
            return Protected.of((Qualifier)this.readQualifier$1((Option)(a.hasQualifier() ? new Some((Object)a.getQualifier()) : None$.MODULE$)));
        }
        if (Schema.Access.TypeCase.PRIVATE.equals(typeCase)) {
            Schema.Private a = access.getPrivate();
            return Private.of((Qualifier)this.readQualifier$1((Option)(a.hasQualifier() ? new Some((Object)a.getQualifier()) : None$.MODULE$)));
        }
        if (Schema.Access.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedValidAccessType()).$bang$bang();
        }
        throw new MatchError((Object)typeCase);
    }

    public DefinitionType fromDefinitionType(Schema.DefinitionType definitionType) {
        Schema.DefinitionType definitionType2 = definitionType;
        if (Schema.DefinitionType.CLASSDEF.equals(definitionType2)) {
            return DefinitionType.ClassDef;
        }
        if (Schema.DefinitionType.MODULE.equals(definitionType2)) {
            return DefinitionType.Module;
        }
        if (Schema.DefinitionType.TRAIT.equals(definitionType2)) {
            return DefinitionType.Trait;
        }
        if (Schema.DefinitionType.PACKAGEMODULE.equals(definitionType2)) {
            return DefinitionType.PackageModule;
        }
        if (Schema.DefinitionType.UNRECOGNIZED.equals(definitionType2)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedDefinitionType()).$bang$bang();
        }
        throw new MatchError((Object)definitionType2);
    }

    public ClassDefinition fromClassDefinition(Schema.ClassDefinition classDefinition) {
        String name = classDefinition.getName().intern();
        if (!classDefinition.hasAccess()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.MissingAccessInDef()).$bang$bang();
        }
        Access access = this.fromAccess(classDefinition.getAccess());
        if (!classDefinition.hasModifiers()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.MissingModifiersInDef()).$bang$bang();
        }
        Modifiers modifiers = this.fromModifiers(classDefinition.getModifiers());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(classDefinition.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        Schema.ClassDefinition.ExtraCase extraCase = classDefinition.getExtraCase();
        if (Schema.ClassDefinition.ExtraCase.CLASSLIKEDEF.equals(extraCase)) {
            return this.fromClassLikeDef$1(classDefinition.getClassLikeDef(), name, access, modifiers, annotations);
        }
        if (Schema.ClassDefinition.ExtraCase.DEFDEF.equals(extraCase)) {
            return this.fromDefDef$1(classDefinition.getDefDef(), name, access, modifiers, annotations);
        }
        if (Schema.ClassDefinition.ExtraCase.VALDEF.equals(extraCase)) {
            return this.fromValDef$1(classDefinition.getValDef(), name, access, modifiers, annotations);
        }
        if (Schema.ClassDefinition.ExtraCase.VARDEF.equals(extraCase)) {
            return this.fromVarDef$1(classDefinition.getVarDef(), name, access, modifiers, annotations);
        }
        if (Schema.ClassDefinition.ExtraCase.TYPEALIAS.equals(extraCase)) {
            return this.fromTypeAlias$1(classDefinition.getTypeAlias(), name, access, modifiers, annotations);
        }
        if (Schema.ClassDefinition.ExtraCase.TYPEDECLARATION.equals(extraCase)) {
            return this.fromTypeDeclaration$1(classDefinition.getTypeDeclaration(), name, access, modifiers, annotations);
        }
        if (Schema.ClassDefinition.ExtraCase.EXTRA_NOT_SET.equals(extraCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyDefType()).$bang$bang();
        }
        throw new MatchError((Object)extraCase);
    }

    public TypeParameter fromTypeParameter(Schema.TypeParameter typeParameter2) {
        String id = typeParameter2.getId();
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(typeParameter2.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(typeParameter2.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        Variance variance = ProtobufReaders.fromVariance$1(typeParameter2.getVariance());
        if (!typeParameter2.hasLowerBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedLowerBoundInTypeParameter()).$bang$bang();
        }
        Type lowerBound = this.fromType(typeParameter2.getLowerBound());
        if (!typeParameter2.hasUpperBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedUpperBoundInTypeParameter()).$bang$bang();
        }
        Type upperBound = this.fromType(typeParameter2.getUpperBound());
        return TypeParameter.of((String)id, (Annotation[])annotations, (TypeParameter[])typeParameters, (Variance)variance, (Type)lowerBound, (Type)upperBound);
    }

    public ClassLike fromClassLike(Schema.ClassLike classLike) {
        String name = classLike.getName().intern();
        if (!classLike.hasAccess()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Access.class)).$bang$bang();
        }
        Access access = this.fromAccess(classLike.getAccess());
        if (!classLike.hasModifiers()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Modifiers.class)).$bang$bang();
        }
        Modifiers modifiers = this.fromModifiers(classLike.getModifiers());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(classLike.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        DefinitionType definitionType = this.fromDefinitionType(classLike.getDefinitionType());
        if (!classLike.hasSelfType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expectedMsg$1("self type")).$bang$bang();
        }
        Lazy selfType = SafeLazyProxy$.MODULE$.strict((Object)this.fromType(classLike.getSelfType()));
        if (!classLike.hasStructure()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Type.Structure.class)).$bang$bang();
        }
        Lazy structure = SafeLazyProxy$.MODULE$.strict((Object)this.fromStructure(classLike.getStructure()));
        String[] savedAnnotations = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)classLike.getSavedAnnotationsList()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        Type[] childrenOfSealedClass = (Type[])this.EfficientTraverse(classLike.getChildrenOfSealedClassList()).toZincArray((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class));
        boolean topLevel = classLike.getTopLevel();
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(classLike.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return ClassLike.of((String)name, (Access)access, (Modifiers)modifiers, (Annotation[])annotations, (DefinitionType)definitionType, (Lazy)selfType, (Lazy)structure, (String[])savedAnnotations, (Type[])childrenOfSealedClass, (boolean)topLevel, (TypeParameter[])typeParameters);
    }

    public UseScope fromUseScope(Schema.UseScope useScope, int id) {
        Schema.UseScope useScope2 = useScope;
        if (Schema.UseScope.DEFAULT.equals(useScope2)) {
            return UseScope.Default;
        }
        if (Schema.UseScope.IMPLICIT.equals(useScope2)) {
            return UseScope.Implicit;
        }
        if (Schema.UseScope.PATMAT.equals(useScope2)) {
            return UseScope.PatMatTarget;
        }
        if (Schema.UseScope.UNRECOGNIZED.equals(useScope2)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedUseScope(id)).$bang$bang();
        }
        throw new MatchError((Object)useScope2);
    }

    public AnalyzedClass fromAnalyzedClass(boolean shouldStoreApis, StringTable stringTable, Schema.AnalyzedClass analyzedClass) {
        ProtobufDefaults$EmptyLazyCompanions$ protobufDefaults$EmptyLazyCompanions$;
        long compilationTs = analyzedClass.getCompilationTimestamp();
        String name = analyzedClass.getName().intern();
        if (!shouldStoreApis) {
            protobufDefaults$EmptyLazyCompanions$ = ProtobufDefaults$EmptyLazyCompanions$.MODULE$;
        } else {
            if (!analyzedClass.hasApi()) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedCompanionsInAnalyzedClass()).$bang$bang();
            }
            protobufDefaults$EmptyLazyCompanions$ = SafeLazyProxy$.MODULE$.strict((Object)this.fromCompanions$1(analyzedClass.getApi()));
        }
        ProtobufDefaults$EmptyLazyCompanions$ api = protobufDefaults$EmptyLazyCompanions$;
        int apiHash = analyzedClass.getApiHash();
        Schema.Version version = this.currentVersion;
        Schema.Version version2 = Schema.Version.V1;
        int extraHash = !(version != null ? !version.equals(version2) : version2 != null) ? 0 : analyzedClass.getExtraHash();
        NameHash[] nameHashes = (NameHash[])this.EfficientTraverse(analyzedClass.getNameHashesList()).toZincArray((Function1 & Serializable & scala.Serializable)nameHash -> this.fromNameHash$1((Schema.NameHash)nameHash, stringTable), ClassTag$.MODULE$.apply(NameHash.class));
        boolean hasMacro = analyzedClass.getHasMacro();
        String provenance = analyzedClass.getProvenance().intern();
        return AnalyzedClass.of((long)compilationTs, (String)name, (Lazy)api, (int)apiHash, (NameHash[])nameHashes, (boolean)hasMacro, (int)extraHash, (String)provenance);
    }

    private final Function1<String, String> stringId() {
        return this.stringId;
    }

    private final Function1<String, VirtualFileRef> stringToSource() {
        return this.stringToSource;
    }

    private final Function1<String, VirtualFileRef> stringToLibrary() {
        return this.stringToLibrary;
    }

    private final Function1<String, VirtualFileRef> stringToProd() {
        return this.stringToProd;
    }

    public Relations fromRelations(Schema.Relations relations) {
        Relation srcProd = ProtobufReaders.fromMap$1(relations.getSrcProdMap(), this.stringToSource(), this.stringToProd());
        Relation libraryDep = ProtobufReaders.fromMap$1(relations.getLibraryDepMap(), this.stringToSource(), this.stringToLibrary());
        Relation libraryClassName = ProtobufReaders.fromMap$1(relations.getLibraryClassNameMap(), this.stringToLibrary(), this.stringId());
        if (!relations.hasMemberRef()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("member refs")).$bang$bang();
        }
        Relations.ClassDependencies memberRef = this.fromClassDependencies$1(relations.getMemberRef());
        if (!relations.hasInheritance()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("inheritance")).$bang$bang();
        }
        Relations.ClassDependencies inheritance = this.fromClassDependencies$1(relations.getInheritance());
        if (!relations.hasLocalInheritance()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("local inheritance")).$bang$bang();
        }
        Relations.ClassDependencies localInheritance = this.fromClassDependencies$1(relations.getLocalInheritance());
        Relation classes = ProtobufReaders.fromMap$1(relations.getClassesMap(), this.stringToSource(), this.stringId());
        Relation productClassName = ProtobufReaders.fromMap$1(relations.getProductClassNameMap(), this.stringId(), this.stringId());
        UsedNames.JavaUsedNames names = UsedNames$.MODULE$.fromJavaMap(relations.getNamesMap());
        InternalDependencies internal = new InternalDependencies((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByMemberRef), (Object)memberRef.internal()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByInheritance), (Object)inheritance.internal()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.LocalDependencyByInheritance), (Object)localInheritance.internal())})));
        ExternalDependencies external = new ExternalDependencies((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByMemberRef), (Object)memberRef.external()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByInheritance), (Object)inheritance.external()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.LocalDependencyByInheritance), (Object)localInheritance.external())})));
        return Relations$.MODULE$.make(srcProd, libraryDep, libraryClassName, internal, external, classes, (UsedNames)names, productClassName);
    }

    public APIs fromApis(boolean shouldStoreApis, Schema.APIs apis) {
        StringTable stringTable = new StringTable();
        scala.collection.immutable.Map internal = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(apis.getInternalMap()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Schema.AnalyzedClass v = (Schema.AnalyzedClass)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)this.fromAnalyzedClass(shouldStoreApis, stringTable, v));
            }
            throw new MatchError((Object)tuple2);
        }).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map external = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(apis.getExternalMap()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Schema.AnalyzedClass v = (Schema.AnalyzedClass)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)this.fromAnalyzedClass(shouldStoreApis, stringTable, v));
            }
            throw new MatchError((Object)tuple2);
        }).toMap(Predef$.MODULE$.$conforms());
        return APIs$.MODULE$.apply(internal, external);
    }

    public Tuple2<APIs, Schema.Version> fromApisFile(Schema.APIsFile apisFile, boolean shouldStoreApis) {
        if (!apisFile.hasApis()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedApisInApisFile()).$bang$bang();
        }
        APIs apis = this.fromApis(shouldStoreApis, apisFile.getApis());
        Schema.Version version = apisFile.getVersion();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)apis), (Object)version);
    }

    public Analysis fromAnalysis(Schema.Analysis analysis) {
        if (!analysis.hasStamps()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Stamps.class)).$bang$bang();
        }
        Stamps stamps = this.fromStamps(analysis.getStamps());
        if (!analysis.hasRelations()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Relations.class)).$bang$bang();
        }
        Relations relations = this.fromRelations(analysis.getRelations());
        if (!analysis.hasSourceInfos()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.SourceInfos.class)).$bang$bang();
        }
        SourceInfos sourceInfos = this.fromSourceInfos(analysis.getSourceInfos());
        if (!analysis.hasCompilations()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Compilations.class)).$bang$bang();
        }
        Compilations compilations = this.fromCompilations(analysis.getCompilations());
        Stamps x$1 = stamps;
        Relations x$2 = relations;
        SourceInfos x$3 = sourceInfos;
        Compilations x$4 = compilations;
        APIs x$5 = Analysis$.MODULE$.Empty().copy$default$2();
        return Analysis$.MODULE$.Empty().copy(x$1, x$5, x$2, x$3, x$4);
    }

    public Tuple3<Analysis, MiniSetup, Schema.Version> fromAnalysisFile(Schema.AnalysisFile analysisFile) {
        Schema.Version version = analysisFile.getVersion();
        if (!analysisFile.hasAnalysis()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(new StringBuilder(49).append("The analysis file from format ").append(version).append(" could not be read.").toString()).$bang$bang();
        }
        Analysis analysis = this.fromAnalysis(analysisFile.getAnalysis());
        if (!analysisFile.hasMiniSetup()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(new StringBuilder(46).append("The mini setup from format ").append(version).append(" could not be read.").toString()).$bang$bang();
        }
        MiniSetup miniSetup = this.fromMiniSetup(analysisFile.getMiniSetup());
        return new Tuple3((Object)analysis, (Object)miniSetup, (Object)version);
    }

    private final scala.collection.immutable.Map fromBinarySchemaMap$1(Map stamps) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String path = (String)tuple2._1();
                Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
                VirtualFileRef file = this.fromPathStringV(path);
                VirtualFileRef newFile = $this.mapper.mapBinaryFile(file);
                Stamp stamp = this.fromStampType(schemaStamp);
                Stamp newStamp = $this.mapper.mapBinaryStamp(newFile, stamp);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            }
            throw new MatchError((Object)tuple2);
        }).toMap(Predef$.MODULE$.$conforms());
    }

    private final scala.collection.immutable.Map fromSourceSchemaMap$1(Map stamps) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String path = (String)tuple2._1();
                Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
                VirtualFileRef file = this.fromPathStringV(path);
                VirtualFileRef newFile = $this.mapper.mapSourceFile(file);
                Stamp stamp = this.fromStampType(schemaStamp);
                Stamp newStamp = $this.mapper.mapSourceStamp(newFile, stamp);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            }
            throw new MatchError((Object)tuple2);
        }).toMap(Predef$.MODULE$.$conforms());
    }

    private final scala.collection.immutable.Map fromProductSchemaMap$1(Map stamps) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String path = (String)tuple2._1();
                Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
                VirtualFileRef file = this.fromPathStringV(path);
                VirtualFileRef newFile = $this.mapper.mapProductFile(file);
                Stamp stamp = this.fromStampType(schemaStamp);
                Stamp newStamp = $this.mapper.mapProductStamp(newFile, stamp);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            }
            throw new MatchError((Object)tuple2);
        }).toMap(Predef$.MODULE$.$conforms());
    }

    private final PathComponent fromPathComponent$1(Schema.Path.PathComponent pathComponent) {
        Schema.Path.PathComponent.ComponentCase componentCase = pathComponent.getComponentCase();
        if (Schema.Path.PathComponent.ComponentCase.ID.equals(componentCase)) {
            Schema.Id c = pathComponent.getId();
            return Id.of((String)c.getId());
        }
        if (Schema.Path.PathComponent.ComponentCase.SUPER.equals(componentCase)) {
            Schema.Super c = pathComponent.getSuper();
            if (!c.hasQualifier()) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPathInSuper()).$bang$bang();
            }
            Path q = this.fromPath(c.getQualifier());
            return Super.of((Path)q);
        }
        if (Schema.Path.PathComponent.ComponentCase.THIS.equals(componentCase)) {
            return ProtobufDefaults$ReadersConstants$.MODULE$.This();
        }
        if (Schema.Path.PathComponent.ComponentCase.COMPONENT_NOT_SET.equals(componentCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expected(Schema.Path.PathComponent.ComponentCase.class, Schema.Path.PathComponent.class)).$bang$bang();
        }
        throw new MatchError((Object)componentCase);
    }

    private static final AnnotationArgument fromAnnotationArgument$1(Schema.AnnotationArgument argument) {
        String name = argument.getName().intern();
        String value = argument.getValue();
        return AnnotationArgument.of((String)name, (String)value);
    }

    private static final Lazy lazy$1(Object value) {
        return SafeLazyProxy$.MODULE$.strict(value);
    }

    private static final ParameterRef fromParameterRef$1(Schema.Type.ParameterRef tpe) {
        return ParameterRef.of((String)tpe.getId());
    }

    private final Parameterized fromParameterized$1(Schema.Type.Parameterized tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Parameterized.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        Type[] typeArguments = (Type[])this.EfficientTraverse(tpe.getTypeArgumentsList()).toZincArray((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class));
        return Parameterized.of((Type)baseType, (Type[])typeArguments);
    }

    private final Polymorphic fromPolymorphic$1(Schema.Type.Polymorphic tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Polymorphic.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(tpe.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return Polymorphic.of((Type)baseType, (TypeParameter[])typeParameters);
    }

    private final Constant fromConstant$1(Schema.Type.Constant tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Constant.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        String value = tpe.getValue();
        return Constant.of((Type)baseType, (String)value);
    }

    private final Existential fromExistential$1(Schema.Type.Existential tpe) {
        None$ b = tpe.hasBaseType() ? new Some((Object)tpe.getBaseType()) : None$.MODULE$;
        Type baseType = (Type)this.OptionReader((Option)b).read((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Existential.class));
        TypeParameter[] clause = (TypeParameter[])this.EfficientTraverse(tpe.getClauseList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return Existential.of((Type)baseType, (TypeParameter[])clause);
    }

    private final Singleton fromSingleton$1(Schema.Type.Singleton tpe) {
        if (!tpe.hasPath()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPathInSingleton()).$bang$bang();
        }
        Path path = this.fromPath(tpe.getPath());
        return Singleton.of((Path)path);
    }

    private final Projection fromProjection$1(Schema.Type.Projection tpe) {
        String id = tpe.getId();
        if (!tpe.hasPrefix()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPrefixInProjection()).$bang$bang();
        }
        Type prefix = this.fromType(tpe.getPrefix());
        return Projection.of((Type)prefix, (String)id);
    }

    private final Annotated fromAnnotated$1(Schema.Type.Annotated tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Annotated.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(tpe.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        return Annotated.of((Type)baseType, (Annotation[])annotations);
    }

    private static final Qualifier fromQualifier$1(Schema.Qualifier qualifier) {
        Schema.Qualifier.TypeCase typeCase = qualifier.getTypeCase();
        if (Schema.Qualifier.TypeCase.IDQUALIFIER.equals(typeCase)) {
            Schema.IdQualifier q = qualifier.getIdQualifier();
            return IdQualifier.of((String)q.getValue());
        }
        if (Schema.Qualifier.TypeCase.THISQUALIFIER.equals(typeCase)) {
            return ProtobufDefaults$ReadersConstants$.MODULE$.ThisQualifier();
        }
        if (Schema.Qualifier.TypeCase.UNQUALIFIED.equals(typeCase)) {
            return ProtobufDefaults$ReadersConstants$.MODULE$.Unqualified();
        }
        if (Schema.Qualifier.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyQualifier()).$bang$bang();
        }
        throw new MatchError((Object)typeCase);
    }

    private final Qualifier readQualifier$1(Option qualifier2) {
        return (Qualifier)this.OptionReader(qualifier2).read((Function1 & Serializable & scala.Serializable)qualifier -> ProtobufReaders.fromQualifier$1(qualifier), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedQualifierInAccess());
    }

    private static final ParameterModifier fromParameterModifier$1(Schema.ParameterModifier modifier) {
        Schema.ParameterModifier parameterModifier = modifier;
        if (Schema.ParameterModifier.PLAIN.equals(parameterModifier)) {
            return ParameterModifier.Plain;
        }
        if (Schema.ParameterModifier.BYNAME.equals(parameterModifier)) {
            return ParameterModifier.ByName;
        }
        if (Schema.ParameterModifier.REPEATED.equals(parameterModifier)) {
            return ParameterModifier.Repeated;
        }
        if (Schema.ParameterModifier.UNRECOGNIZED.equals(parameterModifier)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedParamModifier()).$bang$bang();
        }
        throw new MatchError((Object)parameterModifier);
    }

    private final MethodParameter fromMethodParameter$1(Schema.MethodParameter methodParameter) {
        String name = methodParameter.getName().intern();
        boolean hasDefault = methodParameter.getHasDefault();
        if (!methodParameter.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.MethodParameter.class)).$bang$bang();
        }
        Type type = this.fromType(methodParameter.getType());
        ParameterModifier modifier = ProtobufReaders.fromParameterModifier$1(methodParameter.getModifier());
        return MethodParameter.of((String)name, (Type)type, (boolean)hasDefault, (ParameterModifier)modifier);
    }

    private final ParameterList fromParameterList$1(Schema.ParameterList parameterList) {
        boolean isImplicit = parameterList.getIsImplicit();
        MethodParameter[] parameters = (MethodParameter[])this.EfficientTraverse(parameterList.getParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)methodParameter -> this.fromMethodParameter$1((Schema.MethodParameter)methodParameter), ClassTag$.MODULE$.apply(MethodParameter.class));
        return ParameterList.of((MethodParameter[])parameters, (boolean)isImplicit);
    }

    private final ClassLikeDef fromClassLikeDef$1(Schema.ClassDefinition.ClassLikeDef defDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        DefinitionType definitionType = this.fromDefinitionType(defDef.getDefinitionType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(defDef.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return ClassLikeDef.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (DefinitionType)definitionType);
    }

    private final Def fromDefDef$1(Schema.ClassDefinition.Def defDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!defDef.hasReturnType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedReturnTypeInDef()).$bang$bang();
        }
        Type returnType = this.fromType(defDef.getReturnType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(defDef.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        ParameterList[] valueParameters = (ParameterList[])this.EfficientTraverse(defDef.getValueParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)parameterList -> this.fromParameterList$1((Schema.ParameterList)parameterList), ClassTag$.MODULE$.apply(ParameterList.class));
        return Def.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (ParameterList[])valueParameters, (Type)returnType);
    }

    private final Val fromValDef$1(Schema.ClassDefinition.Val valDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!valDef.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.Val.class)).$bang$bang();
        }
        Type tpe = this.fromType(valDef.getType());
        return Val.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (Type)tpe);
    }

    private final Var fromVarDef$1(Schema.ClassDefinition.Var varDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!varDef.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.Var.class)).$bang$bang();
        }
        Type tpe = this.fromType(varDef.getType());
        return Var.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (Type)tpe);
    }

    private final TypeAlias fromTypeAlias$1(Schema.ClassDefinition.TypeAlias typeAlias, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!typeAlias.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.TypeAlias.class)).$bang$bang();
        }
        Type tpe = this.fromType(typeAlias.getType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(typeAlias.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return TypeAlias.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (Type)tpe);
    }

    private final TypeDeclaration fromTypeDeclaration$1(Schema.ClassDefinition.TypeDeclaration decl, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!decl.hasLowerBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedLowerBoundInTypeDeclaration()).$bang$bang();
        }
        Type lowerBound = this.fromType(decl.getLowerBound());
        if (!decl.hasUpperBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedUpperBoundInTypeDeclaration()).$bang$bang();
        }
        Type upperBound = this.fromType(decl.getUpperBound());
        TypeParameter[] typeParams = (TypeParameter[])this.EfficientTraverse(decl.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return TypeDeclaration.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParams, (Type)lowerBound, (Type)upperBound);
    }

    private static final Variance fromVariance$1(Schema.Variance variance) {
        Schema.Variance variance2 = variance;
        if (Schema.Variance.INVARIANT.equals(variance2)) {
            return Variance.Invariant;
        }
        if (Schema.Variance.COVARIANT.equals(variance2)) {
            return Variance.Covariant;
        }
        if (Schema.Variance.CONTRAVARIANT.equals(variance2)) {
            return Variance.Contravariant;
        }
        if (Schema.Variance.UNRECOGNIZED.equals(variance2)) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedVariance()).$bang$bang();
        }
        throw new MatchError((Object)variance2);
    }

    private static final String expectedMsg$1(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.ClassLike.class);
    }

    private static final String expected$1(Class clazz) {
        return ProtobufReaders.expectedMsg$1(clazz.getName());
    }

    private static final String expected$2(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.Companions.class);
    }

    private final Companions fromCompanions$1(Schema.Companions companions) {
        if (!companions.hasClassApi()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$2("class api")).$bang$bang();
        }
        ClassLike classApi = this.fromClassLike(companions.getClassApi());
        if (!companions.hasObjectApi()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$2("object api")).$bang$bang();
        }
        ClassLike objectApi = this.fromClassLike(companions.getObjectApi());
        return Companions.of((ClassLike)classApi, (ClassLike)objectApi);
    }

    private final NameHash fromNameHash$1(Schema.NameHash nameHash, StringTable stringTable$1) {
        String name = stringTable$1.lookupOrEnter(nameHash.getName());
        int hash = nameHash.getHash();
        UseScope scope = this.fromUseScope(nameHash.getScope(), nameHash.getScopeValue());
        return NameHash.of((String)name, (UseScope)scope, (int)hash);
    }

    public static final /* synthetic */ boolean $anonfun$fromRelations$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$fromRelations$2(Function1 fk$1, RelationBuilder builder$1, Function1 fv$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            String kString = (String)tuple2._1();
            Schema.Values vs = (Schema.Values)tuple2._2();
            if (!vs.getValuesList().isEmpty()) {
                Object k = fk$1.apply((Object)kString);
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)vs.getValuesList()).asScala()).foreach((Function1 & Serializable & scala.Serializable)vString -> {
                    builder$1.update(k, fv$1.apply((Object)vString));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Relation fromMap$1(Map map, Function1 fk, Function1 fv) {
        RelationBuilder builder = new RelationBuilder();
        ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ProtobufReaders.$anonfun$fromRelations$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            ProtobufReaders.$anonfun$fromRelations$2(fk, builder, fv, x$3);
            return BoxedUnit.UNIT;
        });
        return builder.result();
    }

    private final Relations.ClassDependencies fromClassDependencies$1(Schema.ClassDependencies classDependencies) {
        Relation internal = ProtobufReaders.fromMap$1(classDependencies.getInternalMap(), this.stringId(), this.stringId());
        Relation external = ProtobufReaders.fromMap$1(classDependencies.getExternalMap(), this.stringId(), this.stringId());
        return new Relations.ClassDependencies(internal, external);
    }

    private static final String expected$3(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.Relations.class);
    }

    private static final String expected$4(Class clazz) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(clazz, Schema.Analysis.class);
    }

    public ProtobufReaders(ReadMapper mapper, Schema.Version currentVersion) {
        this.mapper = mapper;
        this.currentVersion = currentVersion;
        this.stringId = (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x);
        this.stringToSource = (Function1 & Serializable & scala.Serializable)path -> $this.mapper.mapSourceFile(this.fromPathStringV((String)path));
        this.stringToLibrary = (Function1 & Serializable & scala.Serializable)path -> $this.mapper.mapBinaryFile(this.fromPathStringV((String)path));
        this.stringToProd = (Function1 & Serializable & scala.Serializable)path -> $this.mapper.mapProductFile(this.fromPathStringV((String)path));
    }

    public class EfficientTraverse<T> {
        private final java.util.List<T> seq;
        public final /* synthetic */ ProtobufReaders $outer;

        public <R> R[] toZincArray(Function1<T, R> f, ClassTag<R> evidence$1) {
            return this.seq.stream().map(x -> f.apply(x)).toArray(x$2 -> (Object[])evidence$1.newArray(x$2));
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$EfficientTraverse$$$outer() {
            return this.$outer;
        }

        public EfficientTraverse(ProtobufReaders $outer, java.util.List<T> seq) {
            this.seq = seq;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class OptionReader<T> {
        private final Option<T> option;
        public final /* synthetic */ ProtobufReaders $outer;

        public <R> R read(Function1<T, R> from, Function0<String> errorMessage) {
            return (R)this.option.fold((Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$.MODULE$.StringToException((String)errorMessage.apply()).$bang$bang(), from);
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$OptionReader$$$outer() {
            return this.$outer;
        }

        public OptionReader(ProtobufReaders $outer, Option<T> option) {
            this.option = option;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class StringTable {
        private final HashMap<String, String> strings;

        private HashMap<String, String> strings() {
            return this.strings;
        }

        public String lookupOrEnter(String string) {
            String string2 = this.strings().putIfAbsent(string, string);
            if (string2 == null) {
                return string;
            }
            return string2;
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$StringTable$$$outer() {
            return ProtobufReaders.this;
        }

        public StringTable() {
            if (ProtobufReaders.this == null) {
                throw null;
            }
            this.strings = new HashMap();
        }
    }
}

