/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.cached;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.FileAnalysisStore$;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.Stamper$;
import sbt.internal.inc.Stamps;
import sbt.internal.inc.Stamps$;
import sbt.internal.inc.cached.CleanClasses$;
import sbt.internal.inc.cached.CleanOutput$;
import sbt.internal.inc.cached.CleanOutputMode;
import sbt.internal.inc.cached.CompilationCache;
import sbt.internal.inc.cached.ExportableCache$;
import sbt.internal.inc.cached.FailOnNonEmpty$;
import sbt.io.FileFilter;
import sbt.io.FileFilter$;
import sbt.io.IO$;
import sbt.io.NameFilter;
import sbt.io.PathFinder;
import sbt.io.PathFinder$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Traversable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.MiniSetup;
import xsbti.compile.Output;
import xsbti.compile.SingleOutput;
import xsbti.compile.analysis.ReadWriteMappers;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001\u0002\u000b\u0016\u0001yA\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tk\u0001\u0011\t\u0011)A\u0005W!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003;\u0001\u0011\u00051\bC\u0004@\u0001\t\u0007I\u0011\u0001\u0016\t\r\u0001\u0003\u0001\u0015!\u0003,\u0011\u001d\t\u0005A1A\u0005\u0002)BaA\u0011\u0001!\u0002\u0013Y\u0003\"B\"\u0001\t#!\u0005\"B+\u0001\t\u00032\u0006\"\u00022\u0001\t\u0013\u0019\u0007\"B<\u0001\t\u0003A\bbBA\u0004\u0001\u0011E\u0011\u0011\u0002\u0005\b\u0003\u001f\u0001A\u0011CA\t\u0011\u001d\tY\u0002\u0001C\t\u0003;9\u0011\"a\n\u0016\u0003\u0003E\t!!\u000b\u0007\u0011Q)\u0012\u0011!E\u0001\u0003WAaAO\t\u0005\u0002\u00055\u0002\"CA\u0018#E\u0005I\u0011AA\u0019\u0005=)\u0005\u0010]8si\u0006\u0014G.Z\"bG\",'B\u0001\f\u0018\u0003\u0019\u0019\u0017m\u00195fI*\u0011\u0001$G\u0001\u0004S:\u001c'B\u0001\u000e\u001c\u0003!Ig\u000e^3s]\u0006d'\"\u0001\u000f\u0002\u0007M\u0014Go\u0001\u0001\u0014\u0007\u0001yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M\u001dj\u0011!F\u0005\u0003QU\u0011\u0001cQ8na&d\u0017\r^5p]\u000e\u000b7\r[3\u0002\u001b\r\f7\r[3M_\u000e\fG/[8o+\u0005Y\u0003C\u0001\u00174\u001b\u0005i#B\u0001\u00180\u0003\u00111\u0017\u000e\\3\u000b\u0005A\n\u0014a\u00018j_*\t!'\u0001\u0003kCZ\f\u0017B\u0001\u001b.\u0005\u0011\u0001\u0016\r\u001e5\u0002\u001d\r\f7\r[3M_\u000e\fG/[8oA\u0005y1\r\\3b]>+H\u000f];u\u001b>$W\r\u0005\u0002'q%\u0011\u0011(\u0006\u0002\u0010\u00072,\u0017M\\(viB,H/T8eK\u00061A(\u001b8jiz\"2\u0001P\u001f?!\t1\u0003\u0001C\u0003*\t\u0001\u00071\u0006C\u00047\tA\u0005\t\u0019A\u001c\u0002\u0019\u0005t\u0017\r\\=tSN4\u0015\u000e\\3\u0002\u001b\u0005t\u0017\r\\=tSN4\u0015\u000e\\3!\u00039\u0019G.Y:tKNT\u0016\u000e\u001d$jY\u0016\fqb\u00197bgN,7OW5q\r&dW\rI\u0001\r_V$\b/\u001e;ESJ4uN\u001d\u000b\u0003\u000b.\u0003\"AR%\u000e\u0003\u001dS!\u0001S\u0019\u0002\u0005%|\u0017B\u0001&H\u0005\u00111\u0015\u000e\\3\t\u000b1K\u0001\u0019A'\u0002\u000bM,G/\u001e9\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016aB2p[BLG.\u001a\u0006\u0002%\u0006)\u0001p\u001d2uS&\u0011Ak\u0014\u0002\n\u001b&t\u0017nU3ukB\f\u0011\u0002\\8bI\u000e\u000b7\r[3\u0015\u0005]\u0003\u0007c\u0001\u0011Y5&\u0011\u0011,\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0001ZV,T\u0005\u00039\u0006\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001(_\u0013\tyvJA\bD_6\u0004\u0018\u000e\\3B]\u0006d\u0017p]5t\u0011\u0015\t'\u00021\u0001F\u0003=\u0001(o\u001c6fGRdunY1uS>t\u0017aH;qI\u0006$Xm\u0015;b[B\u001chi\u001c:J[B|'\u000f^3e!J|G-^2ugR\u0019A\r\u001b6\u0011\u0005\u00154W\"A\f\n\u0005\u001d<\"\u0001C!oC2L8/[:\t\u000b%\\\u0001\u0019\u00013\u0002\u0011\u0005t\u0017\r\\=tSNDQa[\u0006A\u00021\fQ\"[7q_J$X\r\u001a$jY\u0016\u001c\bcA7u\u000b:\u0011aN\u001d\t\u0003_\u0006j\u0011\u0001\u001d\u0006\u0003cv\ta\u0001\u0010:p_Rt\u0014BA:\"\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0004'\u0016$(BA:\"\u0003-)\u0007\u0010]8si\u000e\u000b7\r[3\u0015\u0007elh\u0010E\u0002!1j\u0004\"\u0001I>\n\u0005q\f#\u0001B+oSRDQ!\u0019\u0007A\u0002\u0015Caa \u0007A\u0002\u0005\u0005\u0011\u0001F2veJ,g\u000e^!oC2L8/[:Ti>\u0014X\rE\u0002O\u0003\u0007I1!!\u0002P\u00055\te.\u00197zg&\u001c8\u000b^8sK\u0006Y1\r\\3b]>+H\u000f];u)\rQ\u00181\u0002\u0005\u0007\u0003\u001bi\u0001\u0019A#\u0002\r=,H\u000f];u\u0003EIW\u000e]8si\nKg.\u0019:z\u0007\u0006\u001c\u0007.\u001a\u000b\u0006Y\u0006M\u0011q\u0003\u0005\u0007\u0003+q\u0001\u0019\u00013\u0002\u00179,w/\u00118bYf\u001c\u0018n\u001d\u0005\u0007\u00033q\u0001\u0019A'\u0002\u00119,woU3ukB\f\u0011#\u001a=q_J$()\u001b8bef\u001c\u0015m\u00195f)\u0015Q\u0018qDA\u0012\u0011\u0019\t\tc\u0004a\u0001I\u0006y1-\u001e:sK:$\u0018I\\1msNL7\u000f\u0003\u0004\u0002&=\u0001\r!T\u0001\rGV\u0014(/\u001a8u'\u0016$X\u000f]\u0001\u0010\u000bb\u0004xN\u001d;bE2,7)Y2iKB\u0011a%E\n\u0003#}!\"!!\u000b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019DK\u00028\u0003kY#!a\u000e\u0011\t\u0005e\u00121I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003\n\u0013AC1o]>$\u0018\r^5p]&!\u0011QIA\u001e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ExportableCache
implements CompilationCache {
    private final Path cacheLocation;
    private final CleanOutputMode cleanOutputMode;
    private final Path analysisFile;
    private final Path classesZipFile;

    public static CleanOutputMode $lessinit$greater$default$2() {
        return ExportableCache$.MODULE$.$lessinit$greater$default$2();
    }

    public Path cacheLocation() {
        return this.cacheLocation;
    }

    public Path analysisFile() {
        return this.analysisFile;
    }

    public Path classesZipFile() {
        return this.classesZipFile;
    }

    public File outputDirFor(MiniSetup setup) {
        Output output = setup.output();
        if (!(output instanceof SingleOutput)) {
            throw new RuntimeException("Only single output is supported");
        }
        SingleOutput singleOutput = (SingleOutput)output;
        File file = singleOutput.getOutputDirectory();
        return file;
    }

    @Override
    public Option<Tuple2<CompileAnalysis, MiniSetup>> loadCache(File projectLocation) {
        ReadWriteMappers mappers = ReadWriteMappers.getMachineIndependentMappers(projectLocation.toPath());
        AnalysisStore store = FileAnalysisStore$.MODULE$.binary(this.analysisFile().toFile(), mappers);
        return JavaInterfaceUtil$.MODULE$.EnrichOptional(store.get()).toOption().map((Function1 & Serializable & scala.Serializable)analysisContents -> {
            Analysis newAnalysis = (Analysis)analysisContents.getAnalysis();
            MiniSetup newSetup = analysisContents.getMiniSetup();
            Set<File> importedClassFiles = this.importBinaryCache(newAnalysis, newSetup);
            Analysis analysisForLocalProducts = this.updateStampsForImportedProducts(newAnalysis, importedClassFiles);
            return new Tuple2((Object)analysisForLocalProducts, (Object)newSetup);
        });
    }

    private Analysis updateStampsForImportedProducts(Analysis analysis, Set<File> importedFiles) {
        Stamps oldStamps = analysis.stamps();
        Map updatedProducts = (Map)oldStamps.products().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            File file;
            Tuple2 tuple2 = x0$1;
            Tuple2 tuple22 = tuple2 != null && importedFiles.contains((Object)(file = (File)tuple2._1())) ? new Tuple2((Object)file, Stamper$.MODULE$.forLastModified().apply((Object)file)) : tuple2;
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Stamps newStamps = Stamps$.MODULE$.apply(updatedProducts, oldStamps.sources(), oldStamps.binaries());
        return analysis.copy(newStamps, analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5());
    }

    public Option<BoxedUnit> exportCache(File projectLocation, AnalysisStore currentAnalysisStore) {
        return JavaInterfaceUtil$.MODULE$.EnrichOptional(currentAnalysisStore.get()).toOption().map((Function1 & Serializable & scala.Serializable)analysisContents -> {
            ExportableCache.$anonfun$exportCache$1(this, projectLocation, analysisContents);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cleanOutput(File output) {
        if (!output.exists()) return;
        if (!output.isDirectory()) throw new IllegalStateException(new StringBuilder(32).append("Output file: ").append(output).append(" is not a directory").toString());
        CleanOutputMode cleanOutputMode = this.cleanOutputMode;
        if (CleanOutput$.MODULE$.equals(cleanOutputMode)) {
            BoxedUnit boxedUnit;
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output.list())).nonEmpty()) {
                IO$.MODULE$.delete(output);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        } else if (FailOnNonEmpty$.MODULE$.equals(cleanOutputMode)) {
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output.list())).nonEmpty()) {
                throw new IllegalStateException(new StringBuilder(56).append("Output directory: ").append(output).append(" is not empty and cleanOutput is false").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            if (!CleanClasses$.MODULE$.equals(cleanOutputMode)) throw new MatchError((Object)cleanOutputMode);
            PathFinder classFiles = PathFinder$.MODULE$.apply(output).$times$times((FileFilter)FileFilter$.MODULE$.globFilter("*.class"));
            IO$.MODULE$.delete((Iterable)classFiles.get());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Set<File> importBinaryCache(Analysis newAnalysis, MiniSetup newSetup) {
        File output = this.outputDirFor(newSetup);
        this.cleanOutput(output);
        File x$1 = this.classesZipFile().toFile();
        File x$2 = output;
        boolean x$3 = true;
        NameFilter x$4 = IO$.MODULE$.unzip$default$3();
        return IO$.MODULE$.unzip(x$1, x$2, x$4, x$3);
    }

    public void exportBinaryCache(Analysis currentAnalysis, MiniSetup currentSetup) {
        Path out = this.outputDirFor(currentSetup).toPath();
        List entries = (List)ExportableCache.files$1(out.toFile()).map((Function1 & Serializable & scala.Serializable)classFile -> {
            String mapping = ((Object)out.relativize(classFile.toPath())).toString();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(classFile), (Object)mapping);
        }, List$.MODULE$.canBuildFrom());
        IO$.MODULE$.zip((Traversable)entries, this.classesZipFile().toFile());
    }

    public static final /* synthetic */ void $anonfun$exportCache$1(ExportableCache $this, File projectLocation$1, AnalysisContents analysisContents) {
        Analysis currentAnalysis = (Analysis)analysisContents.getAnalysis();
        MiniSetup currentSetup = analysisContents.getMiniSetup();
        ReadWriteMappers mappers = ReadWriteMappers.getMachineIndependentMappers(projectLocation$1.toPath());
        AnalysisStore remoteStore = FileAnalysisStore$.MODULE$.binary($this.analysisFile().toFile(), mappers);
        $this.exportBinaryCache(currentAnalysis, currentSetup);
        AnalysisContents contents = AnalysisContents.create((CompileAnalysis)currentAnalysis, (MiniSetup)currentSetup);
        remoteStore.set(contents);
    }

    private static final List files$1(File f2) {
        File file = f2;
        return ((List)(f2.isDirectory() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])IO$.MODULE$.listFiles(f2))).toList().flatMap((Function1 & Serializable & scala.Serializable)f -> ExportableCache.files$1(f), List$.MODULE$.canBuildFrom()) : Nil$.MODULE$)).$colon$colon((Object)file);
    }

    public ExportableCache(Path cacheLocation, CleanOutputMode cleanOutputMode) {
        this.cacheLocation = cacheLocation;
        this.cleanOutputMode = cleanOutputMode;
        this.analysisFile = cacheLocation.resolve("analysis.zip");
        this.classesZipFile = cacheLocation.resolve("classes.zip");
    }
}

