/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classpath;

import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.Enumeration;
import sbt.internal.inc.classpath.ClasspathUtil$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\b\u0010\u0005aA\u0001\"\t\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\tE\u0001\u0011\t\u0011)A\u00053!A\u0001\u0003\u0001B\u0001B\u0003%1\u0005C\u00039\u0001\u0011\u0005\u0011\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003F\u0001\u0011\u0005c\t\u0003\u0004K\u0001\u0001\u0006Ia\u0013\u0005\u0006)\u0002!\t%\u0016\u0005\u0007Y\u0002\u0001K\u0011B7\t\rU\u0004\u0001\u0015\"\u0003w\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u0011q\u0001\u0001\u0005B\u0005%\u0001\u0002CA\r\u0001\u0001&I!a\u0007\u0003\u001f\rc\u0017m]:qCRDg)\u001b7uKJT!\u0001E\t\u0002\u0013\rd\u0017m]:qCRD'B\u0001\n\u0014\u0003\rIgn\u0019\u0006\u0003)U\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002-\u0005\u00191O\u0019;\u0004\u0001M\u0011\u0001!\u0007\t\u00035}i\u0011a\u0007\u0006\u00039u\tA\u0001\\1oO*\ta$\u0001\u0003kCZ\f\u0017B\u0001\u0011\u001c\u0005-\u0019E.Y:t\u0019>\fG-\u001a:\u0002\rA\f'/\u001a8u\u0003\u0011\u0011xn\u001c;\u0011\u0007\u0011j\u0003G\u0004\u0002&WA\u0011a%K\u0007\u0002O)\u0011\u0001fF\u0001\u0007yI|w\u000e\u001e \u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0002\rA\u0013X\rZ3g\u0013\tqsFA\u0002TKRT!\u0001L\u0015\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014\u0001\u00024jY\u0016T!!N\u000f\u0002\u00079Lw.\u0003\u00028e\t!\u0001+\u0019;i\u0003\u0019a\u0014N\\5u}Q!!\bP\u001f?!\tY\u0004!D\u0001\u0010\u0011\u0015\tC\u00011\u0001\u001a\u0011\u0015\u0011C\u00011\u0001\u001a\u0011\u0015\u0001B\u00011\u0001$\u0003\u0015\u0019Gn\\:f)\u0005\t\u0005C\u0001\"D\u001b\u0005I\u0013B\u0001#*\u0005\u0011)f.\u001b;\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0012\t\u0003I!K!!S\u0018\u0003\rM#(/\u001b8h\u0003-!\u0017N]3di>\u0014\u0018.Z:\u0011\u00071\u000b\u0006G\u0004\u0002N\u001f:\u0011aET\u0005\u0002U%\u0011\u0001+K\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00116KA\u0002TKFT!\u0001U\u0015\u0002\u00131|\u0017\rZ\"mCN\u001cHc\u0001,fOB\u0012q\u000b\u0018\t\u0004IaS\u0016BA-0\u0005\u0015\u0019E.Y:t!\tYF\f\u0004\u0001\u0005\u0013uC\u0011\u0011!A\u0001\u0006\u0003q&aA0%kE\u0011qL\u0019\t\u0003\u0005\u0002L!!Y\u0015\u0003\u000f9{G\u000f[5oOB\u0011!iY\u0005\u0003I&\u00121!\u00118z\u0011\u00151\u0007\u00021\u0001H\u0003%\u0019G.Y:t\u001d\u0006lW\rC\u0003i\u0011\u0001\u0007\u0011.A\u0004sKN|GN^3\u0011\u0005\tS\u0017BA6*\u0005\u001d\u0011un\u001c7fC:\fQB\u001a:p[\u000ec\u0017m]:qCRDGCA5o\u0011\u0015y\u0017\u00021\u0001q\u0003\u0005\u0019\u0007GA9t!\r!\u0003L\u001d\t\u00037N$\u0011\u0002\u001e8\u0002\u0002\u0003\u0005)\u0011\u00010\u0003\u0007}#c'A\u0006p]\u000ec\u0017m]:qCRDGCA5x\u0011\u0015A(\u00021\u0001z\u0003\r\u0019(o\u0019\t\u0003uvl\u0011a\u001f\u0006\u0003yv\t1A\\3u\u0013\tq8PA\u0002V%2\u000b1bZ3u%\u0016\u001cx.\u001e:dKR\u0019\u00110a\u0001\t\r\u0005\u00151\u00021\u0001H\u0003\u0011q\u0017-\\3\u0002\u0019\u001d,GOU3t_V\u00148-Z:\u0015\t\u0005-\u0011q\u0003\t\u0006\u0003\u001b\t\u0019\"_\u0007\u0003\u0003\u001fQ1!!\u0005\u001e\u0003\u0011)H/\u001b7\n\t\u0005U\u0011q\u0002\u0002\f\u000b:,X.\u001a:bi&|g\u000e\u0003\u0004\u0002\u00061\u0001\raR\u0001\u000eS:\u001cG.\u001e3f\u0019>\fG-\u001a:\u0015\u000b%\fi\"a\b\t\u000b=l\u0001\u0019A\r\t\r\u0005\u0005R\u00021\u0001\u001a\u0003\u0011\u0011\u0017m]3)\u00075\t)\u0003\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tY#K\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0018\u0003S\u0011q\u0001^1jYJ,7\r")
public final class ClasspathFilter
extends ClassLoader {
    private final ClassLoader parent;
    private final ClassLoader root;
    private final Set<Path> classpath;
    private final Seq<Path> directories;

    public void close() {
        ClassLoader classLoader = this.parent;
        if (classLoader instanceof URLClassLoader) {
            ((URLClassLoader)classLoader).close();
            return;
        }
    }

    public String toString() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(85).append("|ClasspathFilter(\n        |  parent = ").append(this.parent).append("\n        |  root = ").append(this.root).append("\n        |  cp = ").append(this.classpath).append("\n        |)").toString()));
    }

    @Override
    public Class<?> loadClass(String className, boolean resolve) {
        Class<?> c = super.loadClass(className, resolve);
        if (this.includeLoader(c.getClassLoader(), this.root) || this.fromClasspath(c)) {
            return c;
        }
        throw new ClassNotFoundException(className);
    }

    private boolean fromClasspath(Class<?> c) {
        CodeSource codeSource = c.getProtectionDomain().getCodeSource();
        return codeSource == null || this.onClasspath(codeSource.getLocation());
    }

    private boolean onClasspath(URL src) {
        block8: {
            block7: {
                boolean bl;
                if (src == null) break block7;
                Option option = ClasspathUtil$.MODULE$.asFile(src).headOption();
                if (option instanceof Some) {
                    Path f = (Path)((Some)option).value();
                    bl = this.classpath.apply((Object)f) || this.directories.exists((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)ClasspathFilter.$anonfun$onClasspath$1(f, dir)));
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError((Object)option);
                }
                if (!bl) break block8;
            }
            return true;
        }
        return false;
    }

    @Override
    public URL getResource(String name) {
        URL u = super.getResource(name);
        if (this.onClasspath(u)) {
            return u;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        Enumeration<URL> us = super.getResources(name);
        if (us != null) {
            return JavaConverters$.MODULE$.asJavaEnumerationConverter(((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(us).asScala()).filter((Function1 & Serializable)src -> BoxesRunTime.boxToBoolean((boolean)this.onClasspath(src)))).asJavaEnumeration();
        }
        return null;
    }

    private boolean includeLoader(ClassLoader c, ClassLoader base) {
        while (base != null && c != null) {
            if (c != base) {
                c = c.getParent();
                continue;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$directories$1(Path p) {
        return !((Object)p).toString().endsWith(".jar") && Files.isDirectory(p, new LinkOption[0]);
    }

    public static final /* synthetic */ boolean $anonfun$onClasspath$1(Path f$1, Path dir) {
        return ClasspathUtil$.MODULE$.relativize(dir, f$1).isDefined();
    }

    public ClasspathFilter(ClassLoader parent, ClassLoader root, Set<Path> classpath) {
        this.parent = parent;
        this.root = root;
        this.classpath = classpath;
        super(parent);
        this.directories = (Seq)classpath.toSeq().filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ClasspathFilter.$anonfun$directories$1(p)));
    }
}

