/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Properties;
import sbt.internal.inc.InvalidScalaInstance;
import sbt.internal.inc.InvalidScalaProvider;
import sbt.internal.inc.ScalaInstance;
import sbt.internal.inc.classpath.ClasspathUtil$;
import sbt.io.IO$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;
import xsbti.Launcher;
import xsbti.ScalaProvider;

public final class ScalaInstance$ {
    public static ScalaInstance$ MODULE$;
    private final String ScalaOrg;
    private final String VersionPrefix;
    private final Set<String> excludeList;

    static {
        new ScalaInstance$();
    }

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("loaderLibraryOnly", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public String ScalaOrg() {
        return this.ScalaOrg;
    }

    public String VersionPrefix() {
        return this.VersionPrefix;
    }

    public boolean isDotty(String version) {
        return version.startsWith("0.") || version.startsWith("3.");
    }

    public ScalaInstance apply(String org, String version, Launcher launcher) {
        String string = org;
        String string2 = this.ScalaOrg();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.apply(version, launcher);
        }
        try {
            return this.apply(version, launcher.getScala(version, "", org));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            String message = new StringOps(Predef$.MODULE$.augmentString("Incompatible version of the `xsbti.Launcher` interface.\n              |Use an sbt 0.12+ launcher instead.\n            ")).stripMargin();
            throw scala.sys.package$.MODULE$.error(message);
        }
    }

    public ScalaInstance apply(String version, Launcher launcher) {
        return this.apply(version, launcher.getScala(version));
    }

    /*
     * WARNING - void declaration
     */
    public ScalaInstance apply(String version, ScalaProvider provider) {
        void var7_7;
        void var6_6;
        File[] jars = provider.jars();
        File libraryJar = ScalaInstance$.findOrCrash$1(jars, "scala-library.jar");
        Tuple2 tuple2 = (Tuple2)ScalaInstance$.liftedTree1$1(provider).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fallbackClassLoaders$1(libraryJar, jars));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ClassLoader loader = (ClassLoader)tuple2._1();
        ClassLoader loaderLibraryOnly = (ClassLoader)tuple2._2();
        void loader2 = var6_6;
        void loaderLibraryOnly2 = var7_7;
        return new ScalaInstance(version, (ClassLoader)loader2, (ClassLoader)loader2, (ClassLoader)loaderLibraryOnly2, (File[])((Object[])new File[]{libraryJar}), jars, jars, (Option<String>)None$.MODULE$);
    }

    public ScalaInstance apply(File scalaHome, Launcher launcher) {
        return this.apply(scalaHome, this.scalaLibraryLoader(launcher));
    }

    public ScalaInstance apply(File scalaHome, Function1<List<File>, ClassLoader> classLoader) {
        File[] all = (File[])this.allJars(scalaHome).toArray(ClassTag$.MODULE$.apply(File.class));
        File library = this.libraryJar(scalaHome);
        ClassLoader loaderLibraryOnly = (ClassLoader)classLoader.apply((Object)new .colon.colon((Object)library, (List)Nil$.MODULE$));
        ClassLoader loader = (ClassLoader)this.scalaLoader(loaderLibraryOnly).apply(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])all)).toVector().filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ScalaInstance$.$anonfun$apply$5(library, x$4))));
        String version = this.sbt$internal$inc$ScalaInstance$$actualVersion(loader, new StringBuilder(16).append(" (library jar  ").append(library.getAbsolutePath()).append(")").toString());
        return new ScalaInstance(version, loader, loader, loaderLibraryOnly, (File[])((Object[])new File[]{library}), all, all, (Option<String>)None$.MODULE$);
    }

    public ScalaInstance apply(String version, File scalaHome, Launcher launcher) {
        File[] all = (File[])this.allJars(scalaHome).toArray(ClassTag$.MODULE$.apply(File.class));
        File library = this.libraryJar(scalaHome);
        ClassLoader loaderLibraryOnly = (ClassLoader)this.scalaLibraryLoader(launcher).apply((Object)new .colon.colon((Object)library, (List)Nil$.MODULE$));
        ClassLoader loader = (ClassLoader)this.scalaLoader(loaderLibraryOnly).apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])all)).toVector());
        return new ScalaInstance(version, loader, loader, loaderLibraryOnly, (File[])((Object[])new File[]{library}), all, all, (Option<String>)None$.MODULE$);
    }

    public Seq<File> allJars(File scalaHome) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])IO$.MODULE$.listFiles(this.scalaLib(scalaHome)))).toIndexedSeq().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ScalaInstance$.$anonfun$allJars$1(f)));
    }

    private File scalaLib(File scalaHome) {
        return new File(scalaHome, "lib");
    }

    public File scalaJar(File scalaHome, String name) {
        return new File(this.scalaLib(scalaHome), name);
    }

    private File libraryJar(File scalaHome) {
        return this.scalaJar(scalaHome, "scala-library.jar");
    }

    public String sbt$internal$inc$ScalaInstance$$actualVersion(ClassLoader scalaLoader, String label) {
        try {
            return this.fastActualVersion(scalaLoader);
        }
        catch (Exception exception) {
            return this.slowActualVersion(scalaLoader, label);
        }
    }

    private String slowActualVersion(ClassLoader scalaLoader, String label) {
        String string;
        try {
            string = Class.forName("scala.tools.nsc.Properties", true, scalaLoader).getMethod("versionString", new Class[0]).invoke(null, new Object[0]).toString();
        }
        catch (Exception cause) {
            String msg = new StringBuilder(44).append("Scala instance doesn't exist or is invalid: ").append(label).toString();
            throw new InvalidScalaInstance(msg, cause);
        }
        String scalaVersion = string;
        if (scalaVersion.startsWith(this.VersionPrefix())) {
            return scalaVersion.substring(this.VersionPrefix().length());
        }
        return scalaVersion;
    }

    private String fastActualVersion(ClassLoader scalaLoader) {
        String string;
        try (InputStream stream = scalaLoader.getResourceAsStream("compiler.properties");){
            Properties props = new Properties();
            props.load(stream);
            string = props.getProperty("version.number");
        }
        return string;
    }

    private Function1<Seq<File>, ClassLoader> scalaLibraryLoader(Launcher launcher) {
        return (Function1 & Serializable & scala.Serializable)jars -> ClasspathUtil$.MODULE$.toLoader((Seq<Path>)((Seq)jars.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toPath(), Seq$.MODULE$.canBuildFrom())), launcher.topLoader());
    }

    private Function1<Seq<File>, ClassLoader> scalaLoader(ClassLoader parent) {
        return (Function1 & Serializable & scala.Serializable)jars -> ClasspathUtil$.MODULE$.toLoader((Seq<Path>)((Seq)jars.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toPath(), Seq$.MODULE$.canBuildFrom())), parent);
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(String jarName$1, File x$1) {
        String string = x$1.getName();
        return !(string != null ? !string.equals(jarName$1) : jarName$1 != null);
    }

    private static final File findOrCrash$1(File[] jars, String jarName) {
        return (File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jars)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScalaInstance$.$anonfun$apply$1(jarName, x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new InvalidScalaProvider(new StringBuilder(16).append("Couldn't find '").append(jarName).append("'").toString());
        });
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(File libraryJar$1, File x$2) {
        File file = x$2;
        return !(file != null ? !((Object)file).equals(libraryJar$1) : libraryJar$1 != null);
    }

    private final Tuple2 fallbackClassLoaders$1(File libraryJar$1, File[] jars$1) {
        ClassLoader l = ClasspathUtil$.MODULE$.toLoader((Seq<Path>)((Seq)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{libraryJar$1.toPath()}))));
        ClassLoader c = (ClassLoader)this.scalaLoader(l).apply(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jars$1)).toVector().filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ScalaInstance$.$anonfun$apply$3(libraryJar$1, x$2))));
        return new Tuple2((Object)c, (Object)l);
    }

    private static final /* synthetic */ Option liftedTree1$1(ScalaProvider provider$1) {
        None$ none$;
        try {
            Object object;
            if (provider$1 instanceof Object) {
                try {
                    object = ScalaInstance$.reflMethod$Method1(provider$1.getClass()).invoke((Object)provider$1, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
            } else {
                throw new MatchError((Object)provider$1);
            }
            none$ = Option$.MODULE$.apply((Object)new Tuple2((Object)provider$1.loader(), (Object)((ClassLoader)object)));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(File library$1, File x$4) {
        File file = x$4;
        return !(file != null ? !((Object)file).equals(library$1) : library$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$allJars$1(File f) {
        return !ScalaInstance$.MODULE$.excludeList.apply((Object)f.getName());
    }

    private ScalaInstance$() {
        MODULE$ = this;
        this.ScalaOrg = "org.scala-lang";
        this.VersionPrefix = "version ";
        this.excludeList = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scala-actors.jar", "scalacheck.jar", "scala-partest.jar", "scala-partest-javaagent.jar", "scalap.jar", "scala-swing.jar"}));
    }
}

