/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classpath;

import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.Enumeration;
import sbt.internal.inc.classpath.ClasspathUtil$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001\u0002\b\u0010\u0005aA\u0001\"\t\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\tE\u0001\u0011\t\u0011)A\u00053!A\u0001\u0003\u0001B\u0001B\u0003%1\u0005C\u00039\u0001\u0011\u0005\u0011\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003F\u0001\u0011\u0005c\t\u0003\u0004K\u0001\u0001\u0006Ia\u0013\u0005\u0006)\u0002!\t%\u0016\u0005\u0007Y\u0002\u0001K\u0011B7\t\rU\u0004\u0001\u0015\"\u0003w\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u0011q\u0001\u0001\u0005B\u0005%\u0001\u0002CA\r\u0001\u0001&I!a\u0007\u0003\u001f\rc\u0017m]:qCRDg)\u001b7uKJT!\u0001E\t\u0002\u0013\rd\u0017m]:qCRD'B\u0001\n\u0014\u0003\rIgn\u0019\u0006\u0003)U\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002-\u0005\u00191O\u0019;\u0004\u0001M\u0011\u0001!\u0007\t\u00035}i\u0011a\u0007\u0006\u00039u\tA\u0001\\1oO*\ta$\u0001\u0003kCZ\f\u0017B\u0001\u0011\u001c\u0005-\u0019E.Y:t\u0019>\fG-\u001a:\u0002\rA\f'/\u001a8u\u0003\u0011\u0011xn\u001c;\u0011\u0007\u0011j\u0003G\u0004\u0002&WA\u0011a%K\u0007\u0002O)\u0011\u0001fF\u0001\u0007yI|w\u000e\u001e \u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0002\rA\u0013X\rZ3g\u0013\tqsFA\u0002TKRT!\u0001L\u0015\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014\u0001\u00024jY\u0016T!!N\u000f\u0002\u00079Lw.\u0003\u00028e\t!\u0001+\u0019;i\u0003\u0019a\u0014N\\5u}Q!!\bP\u001f?!\tY\u0004!D\u0001\u0010\u0011\u0015\tC\u00011\u0001\u001a\u0011\u0015\u0011C\u00011\u0001\u001a\u0011\u0015\u0001B\u00011\u0001$\u0003\u0015\u0019Gn\\:f)\u0005\t\u0005C\u0001\"D\u001b\u0005I\u0013B\u0001#*\u0005\u0011)f.\u001b;\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0012\t\u0003I!K!!S\u0018\u0003\rM#(/\u001b8h\u0003-!\u0017N]3di>\u0014\u0018.Z:\u0011\u00071\u000b\u0006G\u0004\u0002N\u001f:\u0011aET\u0005\u0002U%\u0011\u0001+K\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00116KA\u0002TKFT!\u0001U\u0015\u0002\u00131|\u0017\rZ\"mCN\u001cHc\u0001,fOB\u0012q\u000b\u0018\t\u0004IaS\u0016BA-0\u0005\u0015\u0019E.Y:t!\tYF\f\u0004\u0001\u0005\u0013uC\u0011\u0011!A\u0001\u0006\u0003q&\u0001\u0003\u0013r[\u0006\u00148\u000eJ\u001b\u0012\u0005}\u0013\u0007C\u0001\"a\u0013\t\t\u0017FA\u0004O_RD\u0017N\\4\u0011\u0005\t\u001b\u0017B\u00013*\u0005\r\te.\u001f\u0005\u0006M\"\u0001\raR\u0001\nG2\f7o\u001d(b[\u0016DQ\u0001\u001b\u0005A\u0002%\fqA]3t_24X\r\u0005\u0002CU&\u00111.\u000b\u0002\b\u0005>|G.Z1o\u000351'o\\7DY\u0006\u001c8\u000f]1uQR\u0011\u0011N\u001c\u0005\u0006_&\u0001\r\u0001]\u0001\u0002GB\u0012\u0011o\u001d\t\u0004Ia\u0013\bCA.t\t%!h.!A\u0001\u0002\u000b\u0005aL\u0001\u0005%c6\f'o\u001b\u00137\u0003-ygn\u00117bgN\u0004\u0018\r\u001e5\u0015\u0005%<\b\"\u0002=\u000b\u0001\u0004I\u0018aA:sGB\u0011!0`\u0007\u0002w*\u0011A0H\u0001\u0004]\u0016$\u0018B\u0001@|\u0005\r)&\u000bT\u0001\fO\u0016$(+Z:pkJ\u001cW\rF\u0002z\u0003\u0007Aa!!\u0002\f\u0001\u00049\u0015\u0001\u00028b[\u0016\fAbZ3u%\u0016\u001cx.\u001e:dKN$B!a\u0003\u0002\u0018A)\u0011QBA\ns6\u0011\u0011q\u0002\u0006\u0004\u0003#i\u0012\u0001B;uS2LA!!\u0006\u0002\u0010\tYQI\\;nKJ\fG/[8o\u0011\u0019\t)\u0001\u0004a\u0001\u000f\u0006i\u0011N\\2mk\u0012,Gj\\1eKJ$R![A\u000f\u0003?AQa\\\u0007A\u0002eAa!!\t\u000e\u0001\u0004I\u0012\u0001\u00022bg\u0016D3!DA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016S\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0012\u0011\u0006\u0002\bi\u0006LGN]3d\u0001")
public final class ClasspathFilter
extends ClassLoader {
    private final ClassLoader parent;
    private final ClassLoader root;
    private final Set<Path> classpath;
    private final Seq<Path> directories;

    public void close() {
        ClassLoader classLoader = this.parent;
        if (classLoader instanceof URLClassLoader) {
            ((URLClassLoader)classLoader).close();
            return;
        }
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(85).append("|ClasspathFilter(\n        |  parent = ").append(this.parent).append("\n        |  root = ").append(this.root).append("\n        |  cp = ").append(this.classpath).append("\n        |)").toString())).stripMargin();
    }

    @Override
    public Class<?> loadClass(String className, boolean resolve) {
        Class<?> c = super.loadClass(className, resolve);
        if (this.includeLoader(c.getClassLoader(), this.root) || this.fromClasspath(c)) {
            return c;
        }
        throw new ClassNotFoundException(className);
    }

    private boolean fromClasspath(Class<?> c) {
        CodeSource codeSource = c.getProtectionDomain().getCodeSource();
        return codeSource == null || this.onClasspath(codeSource.getLocation());
    }

    private boolean onClasspath(URL src) {
        block8: {
            block7: {
                boolean bl;
                if (src == null) break block7;
                Option option = ClasspathUtil$.MODULE$.asFile(src).headOption();
                if (option instanceof Some) {
                    Path f = (Path)((Some)option).value();
                    bl = this.classpath.apply((Object)f) || this.directories.exists((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)ClasspathFilter.$anonfun$onClasspath$1(f, dir)));
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError((Object)option);
                }
                if (!bl) break block8;
            }
            return true;
        }
        return false;
    }

    @Override
    public URL getResource(String name) {
        URL u = super.getResource(name);
        if (this.onClasspath(u)) {
            return u;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        Enumeration<URL> us = super.getResources(name);
        if (us != null) {
            return JavaConverters$.MODULE$.asJavaEnumerationConverter(((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(us).asScala()).filter((Function1 & Serializable & scala.Serializable)src -> BoxesRunTime.boxToBoolean((boolean)this.onClasspath(src)))).asJavaEnumeration();
        }
        return null;
    }

    private boolean includeLoader(ClassLoader c, ClassLoader base) {
        while (base != null && c != null) {
            if (c != base) {
                c = c.getParent();
                continue;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$directories$1(Path p) {
        return !((Object)p).toString().endsWith(".jar") && Files.isDirectory(p, new LinkOption[0]);
    }

    public static final /* synthetic */ boolean $anonfun$onClasspath$1(Path f$1, Path dir) {
        return ClasspathUtil$.MODULE$.relativize(dir, f$1).isDefined();
    }

    public ClasspathFilter(ClassLoader parent, ClassLoader root, Set<Path> classpath) {
        this.parent = parent;
        this.root = root;
        this.classpath = classpath;
        super(parent);
        this.directories = (Seq)classpath.toSeq().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ClasspathFilter.$anonfun$directories$1(p)));
    }
}

