/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classfile;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import sbt.internal.inc.classfile.AttributeInfo;
import sbt.internal.inc.classfile.ClassFile;
import sbt.internal.inc.classfile.Constant;
import sbt.internal.inc.classfile.FieldOrMethodInfo;
import sbt.internal.inc.classfile.Parser$;
import sbt.internal.io.ErrorHandling$;
import sbt.io.Using;
import sbt.io.Using$;
import sbt.util.Logger;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Right;

public final class Parser$ {
    public static final Parser$ MODULE$ = new Parser$();
    private static final Using<URL, BufferedInputStream> usingUrlInputStreamWithoutCaching = Using$.MODULE$.resource((Function1 & Serializable)u -> (BufferedInputStream)ErrorHandling$.MODULE$.translate((Function0 & Serializable)() -> new StringBuilder(16).append("Error opening ").append(u).append(": ").toString(), (Function0 & Serializable)() -> {
        URLConnection urlConnection = u.openConnection();
        urlConnection.setUseCaches(false);
        return new BufferedInputStream(urlConnection.getInputStream());
    }));

    public ClassFile apply(Path file, Logger log) {
        return (ClassFile)((Either)Using$.MODULE$.bufferedInputStream().apply((Object)Files.newInputStream(file, new OpenOption[0]), arg_0 -> Parser$.$anonfun$apply$1(((Object)file).toString(), log, arg_0))).toOption().get();
    }

    public ClassFile apply(File file, Logger log) {
        return (ClassFile)((Either)((Using)Using$.MODULE$.fileInputStream()).apply((Object)file, arg_0 -> Parser$.$anonfun$apply$2(file.toString(), log, arg_0))).toOption().get();
    }

    public ClassFile apply(URL url, Logger log) {
        return (ClassFile)((Either)this.usingUrlInputStreamWithoutCaching().apply((Object)url, arg_0 -> Parser$.$anonfun$apply$3(url.toString(), log, arg_0))).toOption().get();
    }

    private Using<URL, BufferedInputStream> usingUrlInputStreamWithoutCaching() {
        return usingUrlInputStreamWithoutCaching;
    }

    private Either<String, ClassFile> parse(String readableName, Logger log, InputStream is) {
        return new Right((Object)this.parseImpl(readableName, log, is));
    }

    private ClassFile parseImpl(String readableName, Logger log, InputStream is) {
        DataInputStream in = new DataInputStream(is);
        Predef$.MODULE$.assume(in.readInt() == -889275714, (Function0 & Serializable)() -> new StringBuilder(20).append("Invalid class file: ").append(readableName).toString());
        return new ClassFile(log, in, readableName){
            private Option<String> sourceFile;
            private final int minorVersion;
            private final int majorVersion;
            private final Constant[] constantPool;
            private final int accessFlags;
            private final String className;
            private final String superClassName;
            private final String[] interfaceNames;
            private final FieldOrMethodInfo[] fields;
            private final FieldOrMethodInfo[] methods;
            private final AttributeInfo[] attributes;
            private volatile boolean bitmap$0;
            private final DataInputStream in$1;
            private final Logger log$4;
            private final String readableName$1;

            public Option<Object> constantValue(String fieldName) {
                return ClassFile.constantValue$(this, fieldName);
            }

            public int minorVersion() {
                return this.minorVersion;
            }

            public int majorVersion() {
                return this.majorVersion;
            }

            public Constant[] constantPool() {
                return this.constantPool;
            }

            public int accessFlags() {
                return this.accessFlags;
            }

            public String className() {
                return this.className;
            }

            public String superClassName() {
                return this.superClassName;
            }

            public String[] interfaceNames() {
                return this.interfaceNames;
            }

            public FieldOrMethodInfo[] fields() {
                return this.fields;
            }

            public FieldOrMethodInfo[] methods() {
                return this.methods;
            }

            public AttributeInfo[] attributes() {
                return this.attributes;
            }

            private Option<String> sourceFile$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.sourceFile = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])this.attributes()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$sourceFile$1(x$1))).map((Function1 & Serializable)sourceFileAttribute -> this.toUTF8(Parser$.MODULE$.entryIndex((AttributeInfo)sourceFileAttribute)));
                        this.bitmap$0 = true;
                    }
                }
                return this.sourceFile;
            }

            public Option<String> sourceFile() {
                if (!this.bitmap$0) {
                    return this.sourceFile$lzycompute();
                }
                return this.sourceFile;
            }

            public String stringValue(AttributeInfo a) {
                return this.toUTF8(Parser$.MODULE$.entryIndex(a));
            }

            private FieldOrMethodInfo[] readFieldsOrMethods() {
                return (FieldOrMethodInfo[])Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$array(this.in$1.readUnsignedShort(), (Function0 & Serializable)() -> this.parseFieldOrMethodInfo(), ClassTag$.MODULE$.apply(FieldOrMethodInfo.class));
            }

            private String toUTF8(int entryIndex) {
                Constant entry = this.constantPool()[entryIndex];
                Predef$.MODULE$.assume(entry.tag() == 1, (Function0 & Serializable)() -> new StringBuilder(40).append("Constant pool entry is not a UTF8 type: ").append(entryIndex).toString());
                return (String)entry.value().get();
            }

            private String getClassConstantName(int entryIndex) {
                Constant entry = this.constantPool()[entryIndex];
                if (entry == null) {
                    return "";
                }
                return Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$slashesToDots(this.toUTF8(entry.nameIndex()));
            }

            private Option<String> toString(int index) {
                if (index <= 0) {
                    return None$.MODULE$;
                }
                return new Some((Object)this.toUTF8(index));
            }

            private FieldOrMethodInfo parseFieldOrMethodInfo() {
                return new FieldOrMethodInfo(this.in$1.readUnsignedShort(), this.toString(this.in$1.readUnsignedShort()), this.toString(this.in$1.readUnsignedShort()), (IndexedSeq<AttributeInfo>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$array(this.in$1.readUnsignedShort(), (Function0 & Serializable)() -> this.parseAttribute(), ClassTag$.MODULE$.apply(AttributeInfo.class)))));
            }

            private AttributeInfo parseAttribute() {
                int nameIndex = this.in$1.readUnsignedShort();
                None$ name = nameIndex == -1 ? None$.MODULE$ : new Some((Object)this.toUTF8(nameIndex));
                byte[] value = (byte[])Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$array(this.in$1.readInt(), (JFunction0.mcB.sp & Serializable)() -> $this.in$1.readByte(), ClassTag$.MODULE$.Byte());
                return new AttributeInfo((Option<String>)name, value);
            }

            public Set<String> types() {
                return ((IterableOnceOps)((IterableOps)((IterableOps)this.classConstantReferences().$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])this.fieldTypes()))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])this.methodTypes()))).$plus$plus((IterableOnce)this.annotationsReferencesCarefully$1())).toSet();
            }

            private String[] getTypes(FieldOrMethodInfo[] fieldsOrMethods) {
                return (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])fieldsOrMethods), (Function1 & Serializable)fieldOrMethod -> Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$descriptorToTypes(fieldOrMethod.descriptor()), ClassTag$.MODULE$.apply(String.class));
            }

            private String[] fieldTypes() {
                return this.getTypes(this.fields());
            }

            private String[] methodTypes() {
                return this.getTypes(this.methods());
            }

            private List<String> annotationsReferences() {
                Object[] allAttributes = (AttributeInfo[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.attributes()), ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.fields()), (Function1 & Serializable)x$2 -> x$2.attributes(), ClassTag$.MODULE$.apply(AttributeInfo.class)), ClassTag$.MODULE$.apply(AttributeInfo.class))), ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.methods()), (Function1 & Serializable)x$3 -> x$3.attributes(), ClassTag$.MODULE$.apply(AttributeInfo.class)), ClassTag$.MODULE$.apply(AttributeInfo.class));
                return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(allAttributes), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$annotationsReferences$3(x)))), (Function1 & Serializable)attr -> {
                    DataInputStream in = new DataInputStream(new ByteArrayInputStream(attr.value()));
                    int numAnnotations = in.readUnsignedShort();
                    ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numAnnotations).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> this.parseAnnotation$1(result, in));
                    return (ListBuffer)result.map((Function1 & Serializable)name -> StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(name), 1, name.length() - 1));
                }, ClassTag$.MODULE$.apply(String.class))).toList();
            }

            private List<String> classConstantReferences() {
                return this.constants().flatMap((Function1 & Serializable)constant -> {
                    switch (constant.tag()) {
                        case 7: {
                            String name = this.toUTF8(constant.nameIndex());
                            if (name.startsWith("[")) {
                                return Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$descriptorToTypes((Option<String>)new Some((Object)name));
                            }
                            String string = Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$slashesToDots(name);
                            return Nil$.MODULE$.$colon$colon((Object)string);
                        }
                    }
                    return Nil$.MODULE$;
                });
            }

            private List<Constant> constants() {
                return this.next$1(1, (List)Nil$.MODULE$);
            }

            public static final /* synthetic */ boolean $anonfun$sourceFile$1(AttributeInfo x$1) {
                return x$1.isSourceFile();
            }

            private final List annotationsReferencesCarefully$1() {
                try {
                    return this.annotationsReferences();
                }
                catch (RuntimeException re) {
                    this.log$4.warn((Function0 & Serializable)() -> new StringBuilder(33).append("couldn't parse annotations in ").append($this.readableName$1).append(" (").append(re).append(")").toString());
                    return Nil$.MODULE$;
                }
            }

            public static final /* synthetic */ boolean $anonfun$annotationsReferences$3(AttributeInfo x) {
                return x.isRuntimeVisibleAnnotations() || x.isRuntimeInvisibleAnnotations();
            }

            private final void parseElementValue$1(DataInputStream in$2, ListBuffer result$1) {
                char c = (char)in$2.readUnsignedByte();
                switch (c) {
                    case 'e': {
                        result$1.$plus$eq((Object)Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$slashesToDots(this.toUTF8(in$2.readUnsignedShort())));
                        in$2.readUnsignedShort();
                        return;
                    }
                    case 'c': {
                        result$1.$plus$eq((Object)Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$slashesToDots(this.toUTF8(in$2.readUnsignedShort())));
                        return;
                    }
                    case '@': {
                        this.parseAnnotation$1(result$1, in$2);
                        return;
                    }
                    case '[': {
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), in$2.readUnsignedShort()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> this.parseElementValue$1(in$2, result$1));
                        return;
                    }
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': 
                    case 's': {
                        in$2.readUnsignedShort();
                        return;
                    }
                }
                throw package$.MODULE$.error(new StringBuilder(32).append("unexpected tag in annotation: '").append(c).append("'").toString());
            }

            private final void parseAnnotation$1(ListBuffer result$1, DataInputStream in$2) {
                result$1.$plus$eq((Object)Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$slashesToDots(this.toUTF8(in$2.readUnsignedShort())));
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), in$2.readUnsignedShort()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {
                    in$2.readUnsignedShort();
                    this.parseElementValue$1(in$2, result$1);
                });
            }

            private final List next$1(int i, List list) {
                while (i < this.constantPool().length) {
                    Constant constant;
                    list = list.$colon$colon((Object)constant);
                    constant = this.constantPool()[i];
                    i = constant.wide() ? i + 2 : i + 1;
                }
                return list;
            }
            {
                this.in$1 = in$1;
                this.log$4 = log$4;
                this.readableName$1 = readableName$1;
                ClassFile.$init$(this);
                this.minorVersion = in$1.readUnsignedShort();
                this.majorVersion = in$1.readUnsignedShort();
                this.constantPool = Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$parseConstantPool(in$1);
                this.accessFlags = in$1.readUnsignedShort();
                this.className = this.getClassConstantName(in$1.readUnsignedShort());
                log$4.debug((Function0 & Serializable)() -> new StringBuilder(32).append("[zinc] classfile.Parser parsing ").append(this.className()).toString());
                this.superClassName = this.getClassConstantName(in$1.readUnsignedShort());
                this.interfaceNames = (String[])Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$array(in$1.readUnsignedShort(), (Function0 & Serializable)() -> this.getClassConstantName($this.in$1.readUnsignedShort()), ClassTag$.MODULE$.apply(String.class));
                this.fields = this.readFieldsOrMethods();
                this.methods = this.readFieldsOrMethods();
                this.attributes = (AttributeInfo[])Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$array(in$1.readUnsignedShort(), (Function0 & Serializable)() -> this.parseAttribute(), ClassTag$.MODULE$.apply(AttributeInfo.class));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$annotationsReferences$1(sbt.internal.inc.classfile.FieldOrMethodInfo ), $anonfun$annotationsReferences$2(sbt.internal.inc.classfile.FieldOrMethodInfo ), $anonfun$annotationsReferences$3$adapted(sbt.internal.inc.classfile.AttributeInfo ), $anonfun$annotationsReferences$4(sbt.internal.inc.classfile.Parser$$anon$1 sbt.internal.inc.classfile.AttributeInfo ), $anonfun$annotationsReferences$5(sbt.internal.inc.classfile.Parser$$anon$1 java.io.DataInputStream scala.collection.mutable.ListBuffer int ), $anonfun$annotationsReferences$6(sbt.internal.inc.classfile.Parser$$anon$1 java.io.DataInputStream scala.collection.mutable.ListBuffer int ), $anonfun$annotationsReferences$7(sbt.internal.inc.classfile.Parser$$anon$1 scala.collection.mutable.ListBuffer java.io.DataInputStream int ), $anonfun$annotationsReferences$8(java.lang.String ), $anonfun$attributes$1(sbt.internal.inc.classfile.Parser$$anon$1 ), $anonfun$classConstantReferences$1(sbt.internal.inc.classfile.Parser$$anon$1 sbt.internal.inc.classfile.Constant ), $anonfun$getTypes$1(sbt.internal.inc.classfile.FieldOrMethodInfo ), $anonfun$interfaceNames$1(sbt.internal.inc.classfile.Parser$$anon$1 ), $anonfun$new$1(sbt.internal.inc.classfile.Parser$$anon$1 ), $anonfun$parseAttribute$1(sbt.internal.inc.classfile.Parser$$anon$1 ), $anonfun$parseFieldOrMethodInfo$1(sbt.internal.inc.classfile.Parser$$anon$1 ), $anonfun$readFieldsOrMethods$1(sbt.internal.inc.classfile.Parser$$anon$1 ), $anonfun$sourceFile$1$adapted(sbt.internal.inc.classfile.AttributeInfo ), $anonfun$sourceFile$2(sbt.internal.inc.classfile.Parser$$anon$1 sbt.internal.inc.classfile.AttributeInfo ), $anonfun$toUTF8$1(int ), $anonfun$types$1(sbt.internal.inc.classfile.Parser$$anon$1 java.lang.RuntimeException )}, serializedLambda);
            }
        };
    }

    public <T> Object sbt$internal$inc$classfile$Parser$$array(int size, Function0<T> f, ClassTag<T> evidence$1) {
        return Array$.MODULE$.tabulate(size, (Function1 & Serializable)x$9 -> f.apply(), evidence$1);
    }

    public Constant[] sbt$internal$inc$classfile$Parser$$parseConstantPool(DataInputStream in) {
        int constantPoolSize = in.readUnsignedShort();
        Constant[] pool = new Constant[constantPoolSize];
        this.parse$1(1, constantPoolSize, in, pool);
        return pool;
    }

    private Constant getConstant(DataInputStream in) {
        byte tag = in.readByte();
        switch (tag) {
            case 7: 
            case 8: {
                return new Constant(tag, in.readUnsignedShort());
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return new Constant(tag, in.readUnsignedShort(), in.readUnsignedShort());
            }
            case 3: {
                return new Constant(tag, (Object)in.readInt());
            }
            case 4: {
                return new Constant(tag, Float.valueOf(in.readFloat()));
            }
            case 5: {
                return new Constant(tag, in.readLong());
            }
            case 6: {
                return new Constant(tag, in.readDouble());
            }
            case 1: {
                return new Constant(tag, in.readUTF());
            }
            case 15: {
                in.readByte();
                in.readUnsignedShort();
                return new Constant(tag, -1, -1, (Option<Object>)None$.MODULE$);
            }
            case 16: {
                in.readUnsignedShort();
                return new Constant(tag, -1, -1, (Option<Object>)None$.MODULE$);
            }
            case 18: {
                in.readUnsignedShort();
                in.readUnsignedShort();
                return new Constant(tag, -1, -1, (Option<Object>)None$.MODULE$);
            }
            case 19: {
                in.readUnsignedShort();
                return new Constant(tag, -1, -1, (Option<Object>)None$.MODULE$);
            }
            case 20: {
                in.readUnsignedShort();
                return new Constant(tag, -1, -1, (Option<Object>)None$.MODULE$);
            }
            case 17: {
                in.readUnsignedShort();
                in.readUnsignedShort();
                return new Constant(tag, -1, -1, (Option<Object>)None$.MODULE$);
            }
        }
        throw package$.MODULE$.error(new StringBuilder(18).append("Unknown constant: ").append(tag).toString());
    }

    private int toInt(byte v) {
        if (v < 0) {
            return v + 256;
        }
        return v;
    }

    private int u2(byte highByte, byte lowByte) {
        return this.toInt(highByte) * 256 + this.toInt(lowByte);
    }

    public int entryIndex(AttributeInfo a) {
        Object object;
        byte[] byArray = a.value();
        if (byArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)byArray))) {
            new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object));
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                byte v0 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                byte v1 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                return this.u2(v0, v1);
            }
        }
        throw package$.MODULE$.error(new StringBuilder(44).append("Expected two bytes for unsigned value; got: ").append(a.value().length).toString());
    }

    public String sbt$internal$inc$classfile$Parser$$slashesToDots(String s) {
        return s.replace('/', '.');
    }

    public List<String> sbt$internal$inc$classfile$Parser$$descriptorToTypes(Option<String> descriptor) {
        return this.toTypes$1((String)descriptor.getOrElse((Function0 & Serializable)() -> ""), (List)Nil$.MODULE$);
    }

    public static final /* synthetic */ Either $anonfun$apply$1(String eta$0$1$1, Logger log$1, InputStream is) {
        return MODULE$.parse(eta$0$1$1, log$1, is);
    }

    public static final /* synthetic */ Either $anonfun$apply$2(String eta$0$1$2, Logger log$2, InputStream is) {
        return MODULE$.parse(eta$0$1$2, log$2, is);
    }

    public static final /* synthetic */ Either $anonfun$apply$3(String eta$0$1$3, Logger log$3, InputStream is) {
        return MODULE$.parse(eta$0$1$3, log$3, is);
    }

    private final void parse$1(int i, int constantPoolSize$1, DataInputStream in$3, Constant[] pool$1) {
        while (i < constantPoolSize$1) {
            Constant constant;
            pool$1[i] = constant = this.getConstant(in$3);
            i = constant.wide() ? i + 2 : i + 1;
        }
    }

    private final List toTypes$1(String descriptor, List types) {
        int startIndex;
        while ((startIndex = descriptor.indexOf(76)) >= 0) {
            int endIndex = descriptor.indexOf(59, startIndex + 1);
            String tpe = this.sbt$internal$inc$classfile$Parser$$slashesToDots(descriptor.substring(startIndex + 1, endIndex));
            types = types.$colon$colon((Object)tpe);
            descriptor = descriptor.substring(endIndex);
        }
        return types;
    }

    private Parser$() {
    }
}

