/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sbt.internal.inc.IndexBasedZipFsOps$;
import sbt.internal.inc.IndexBasedZipOps;
import sbt.internal.inc.JarUtils;
import sbt.internal.inc.JarUtils$ClassInJar$;
import sbt.internal.inc.JarUtils$NoOutputJar$;
import sbt.internal.inc.zip.ZipCentralDir;
import sbt.io.IO$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import xsbti.compile.Output;
import xsbti.compile.SingleOutput;

public final class JarUtils$ {
    public static JarUtils$ MODULE$;
    private final Set<String> scalacOptions;
    private final Set<String> javacOptions;
    private Path tempDir;
    private final String prevJarPrefix;

    static {
        new JarUtils$();
    }

    public Set<String> scalacOptions() {
        return this.scalacOptions;
    }

    public Set<String> javacOptions() {
        return this.javacOptions;
    }

    public ZipCentralDir stashIndex(Path jar) {
        return (ZipCentralDir)IndexBasedZipFsOps$.MODULE$.readCentralDir(jar.toFile());
    }

    public void unstashIndex(Path jar, ZipCentralDir index) {
        IndexBasedZipFsOps$.MODULE$.writeCentralDir(jar.toFile(), index);
    }

    public void includeInJar(File jar, Seq<Tuple2<File, String>> files) {
        IndexBasedZipFsOps$.MODULE$.includeInArchive(jar, (scala.collection.immutable.Seq<Tuple2<File, String>>)files.toVector());
    }

    public void mergeJars(File into, File from) {
        IndexBasedZipFsOps$.MODULE$.mergeArchives(into, from);
    }

    public Seq<String> listClassFiles(File jar) {
        return (Seq)IndexBasedZipFsOps$.MODULE$.listEntries(jar).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.endsWith(".class")));
    }

    public Seq<String> listFiles(Path jar) {
        return IndexBasedZipFsOps$.MODULE$.listEntries(jar.toFile());
    }

    public void removeFromJar(Path jarFile, Iterable<String> classes) {
        if (Files.exists(jarFile, new LinkOption[0])) {
            IndexBasedZipFsOps$.MODULE$.removeEntries(jarFile.toFile(), classes);
        }
    }

    public Function1<Path, Object> readStamps(Path jar) {
        return arg_0 -> JarUtils$.$anonfun$readStamps$1$adapted(IndexBasedZipFsOps$.MODULE$.new IndexBasedZipOps.CachedStamps(jar), jar, arg_0);
    }

    public void withPreviousJar(Output output, Function1<Seq<Path>, BoxedUnit> compile) {
        Tuple2 tuple2;
        Option<Tuple2<File, File>> option = this.preparePreviousJar(output);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            File prevJar = (File)tuple2._1();
            File outputJar = (File)tuple2._2();
            try {
                compile.apply((Object)new .colon.colon((Object)prevJar.toPath(), (List)Nil$.MODULE$));
            }
            catch (Exception e) {
                IO$.MODULE$.move(prevJar, outputJar);
                throw e;
            }
            this.cleanupPreviousJar(prevJar, outputJar);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)compile.apply((Object)Nil$.MODULE$);
            return;
        }
        throw new MatchError(option);
    }

    public Option<Tuple2<File, File>> preparePreviousJar(Output output) {
        return this.getOutputJar(output).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JarUtils$.$anonfun$preparePreviousJar$1(x$2))).map((Function1 & Serializable & scala.Serializable)outputJar -> {
            File prevJar = MODULE$.createPrevJarPath();
            File out = outputJar.toFile();
            IO$.MODULE$.move(out, prevJar);
            return new Tuple2((Object)prevJar, (Object)out);
        });
    }

    public void cleanupPreviousJar(File prevJar, File outputJar) {
        if (outputJar.exists()) {
            this.mergeJars(prevJar, outputJar);
        }
        IO$.MODULE$.move(prevJar, outputJar);
    }

    private Path tempDir() {
        return this.tempDir;
    }

    private void tempDir_$eq(Path x$1) {
        this.tempDir = x$1;
    }

    public void setupTempClassesDir(Option<Path> temporaryClassesDirectory) {
        if (temporaryClassesDirectory instanceof Some) {
            Path dir = (Path)((Some)temporaryClassesDirectory).value();
            Files.createDirectories(dir, new FileAttribute[0]);
            this.tempDir_$eq(dir);
            return;
        }
        if (None$.MODULE$.equals(temporaryClassesDirectory)) {
            this.tempDir_$eq(new File(IO$.MODULE$.temporaryDirectory(), "zinc_temp_classes_dir").toPath());
            return;
        }
        throw new MatchError(temporaryClassesDirectory);
    }

    private File createPrevJarPath() {
        String prevJarName = new StringBuilder(5).append(this.prevJarPrefix()).append("-").append(UUID.randomUUID()).append(".jar").toString();
        return this.tempDir().resolve(prevJarName).toFile();
    }

    public String prevJarPrefix() {
        return this.prevJarPrefix;
    }

    public boolean isClassInJar(File file) {
        String[] stringArray = file.toString().split("!");
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        boolean bl = !option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0 ? ((String)((SeqLike)option.get()).apply(0)).endsWith(".jar") : false;
        return bl;
    }

    public Option<Path> getJarInClassInJar(Path path) {
        String jar;
        String[] stringArray = ((Object)path).toString().split("!");
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        Object object = !option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0 && (jar = (String)((SeqLike)option.get()).apply(0)).toString().endsWith(".jar") ? new Some((Object)Paths.get(jar, new String[0])) : None$.MODULE$;
        return object;
    }

    public boolean isCompilingToJar(Output output) {
        return this.getOutputJar(output).isDefined();
    }

    public Option<Path> getOutputJar(Output output) {
        None$ none$;
        if (output instanceof SingleOutput) {
            SingleOutput singleOutput = (SingleOutput)output;
            none$ = new Some((Object)singleOutput.getOutputDirectoryAsPath()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)JarUtils$.$anonfun$getOutputJar$1(x$3)));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Path javacTempOutput(Path outputJar) {
        String outJarName = ((Object)outputJar.getFileName()).toString();
        String outDirName = new StringBuilder(13).append(outJarName).append("-javac-output").toString();
        return outputJar.resolveSibling(outDirName);
    }

    public JarUtils.OutputJarContent createOutputJarContent(Output output) {
        JarUtils.OutputJarContent outputJarContent;
        Option<Path> option = this.getOutputJar(output);
        if (option instanceof Some) {
            Path jar = (Path)((Some)option).value();
            outputJarContent = new JarUtils.ValidOutputJarContent(jar);
        } else if (None$.MODULE$.equals(option)) {
            outputJarContent = JarUtils$NoOutputJar$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return outputJarContent;
    }

    public long readModifiedTime(String jc) {
        Tuple2<File, Option<String>> tuple2 = JarUtils$ClassInJar$.MODULE$.splitJarReference$extension(jc);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        File file = (File)tuple2._1();
        Option option = (Option)tuple2._2();
        File jar = file;
        Option cls = option;
        if (jar.exists()) {
            return BoxesRunTime.unboxToLong(this.withZipFile(jar, (Function1 & Serializable & scala.Serializable)zip -> BoxesRunTime.boxToLong((long)JarUtils$.$anonfun$readModifiedTime$1(cls, zip))));
        }
        return 0L;
    }

    public boolean exists(String jc) {
        Tuple2<File, Option<String>> tuple2 = JarUtils$ClassInJar$.MODULE$.splitJarReference$extension(jc);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        File file = (File)tuple2._1();
        Option option = (Option)tuple2._2();
        File jar = file;
        Option clsOpt = option;
        if (jar.exists()) {
            boolean bl;
            if (clsOpt instanceof Some) {
                String cls = (String)((Some)clsOpt).value();
                bl = BoxesRunTime.unboxToBoolean(this.withZipFile(jar, (Function1 & Serializable & scala.Serializable)zip -> BoxesRunTime.boxToBoolean((boolean)JarUtils$.$anonfun$exists$1(cls, zip))));
            } else {
                bl = true;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    private <A> A withZipFile(File zip, Function1<ZipFile, A> f) {
        Object object;
        try (ZipFile file = new ZipFile(zip);){
            object = f.apply((Object)file);
        }
        return (A)object;
    }

    public static final /* synthetic */ long $anonfun$readStamps$1(IndexBasedZipOps.CachedStamps stamps$1, Path jar$1, Path file) {
        URL u = file.toUri().toURL();
        return stamps$1.getStamp((String)JarUtils$ClassInJar$.MODULE$.toClassFilePath$extension0(JarUtils$ClassInJar$.MODULE$.fromURL(u, jar$1)).get());
    }

    public static final /* synthetic */ boolean $anonfun$preparePreviousJar$1(Path x$2) {
        return Files.exists(x$2, new LinkOption[0]);
    }

    public static final /* synthetic */ boolean $anonfun$getOutputJar$1(Path x$3) {
        return ((Object)x$3).toString().endsWith(".jar");
    }

    public static final /* synthetic */ long $anonfun$readModifiedTime$2(ZipEntry x$5) {
        return x$5.getLastModifiedTime().toMillis();
    }

    public static final /* synthetic */ long $anonfun$readModifiedTime$1(Option cls$1, ZipFile zip) {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)zip.getEntry((String)cls$1.get())).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)JarUtils$.$anonfun$readModifiedTime$2(x$5))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$exists$1(String cls$2, ZipFile zip) {
        return zip.getEntry(cls$2) != null;
    }

    private JarUtils$() {
        MODULE$ = this;
        this.scalacOptions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-YdisableFlatCpCaching"}));
        this.javacOptions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-XDuseOptimizedZip=false"}));
        this.prevJarPrefix = "prev-jar";
    }

    public static final /* synthetic */ Object $anonfun$readStamps$1$adapted(IndexBasedZipOps.CachedStamps stamps$1, Path jar$1, Path file) {
        return BoxesRunTime.boxToLong((long)JarUtils$.$anonfun$readStamps$1(stamps$1, jar$1, file));
    }
}

