/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classfile;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import sbt.internal.inc.JarUtils$;
import sbt.internal.inc.JarUtils$ClassInJar$;
import sbt.internal.inc.classfile.ClassFile;
import sbt.internal.inc.classfile.Parser$;
import sbt.io.IO$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import xsbti.AnalysisCallback;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;
import xsbti.api.DependencyContext;
import xsbti.compile.Output;

public final class JavaAnalyze$ {
    public static JavaAnalyze$ MODULE$;

    static {
        new JavaAnalyze$();
    }

    public <T> void apply(Seq<Path> newClasses, Seq<VirtualFile> sources, Logger log, Output output, Option<Path> finalJarOutput, AnalysisCallback analysis, ClassLoader loader, Function2<VirtualFileRef, Seq<Class<?>>, Set<Tuple2<String, String>>> readAPI) {
        Map sourceMap = sources.toSet().groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name());
        Path singleOutputOrNull = output.getSingleOutputAsPath().orElse(null);
        Path directOutputJarOrNull = (Path)JarUtils$.MODULE$.getOutputJar(output).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
        Path mappedOutputJarOrNull = (Path)finalJarOutput.getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
        HashMap sourceToClassFiles = (HashMap)HashMap$.MODULE$.apply((Seq)sources.map((Function1 & Serializable & scala.Serializable)vf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(vf), (Object)new ArrayBuffer()), Seq$.MODULE$.canBuildFrom()));
        HashMap binaryClassNameToLoadedClass = new HashMap();
        scala.collection.mutable.Map classfilesCache = Map$.MODULE$.empty();
        ((IterableLike)newClasses.map((Function1 & Serializable & scala.Serializable)newClass -> {
            ClassFile classFile = Parser$.MODULE$.apply((Path)newClass, log);
            return new Tuple2(newClass, (Object)classFile);
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            JavaAnalyze$.$anonfun$apply$8(this, sourceMap, log, binaryClassNameToLoadedClass, analysis, sourceToClassFiles, loader, directOutputJarOrNull, singleOutputOrNull, mappedOutputJarOrNull, x$3);
            return BoxedUnit.UNIT;
        });
        sourceToClassFiles.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JavaAnalyze$.$anonfun$apply$15(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            JavaAnalyze$.$anonfun$apply$16(this, analysis, binaryClassNameToLoadedClass, loader, log, finalJarOutput, classfilesCache, readAPI, directOutputJarOrNull, singleOutputOrNull, mappedOutputJarOrNull, x$8);
            return BoxedUnit.UNIT;
        });
    }

    private Path resolveFinalClassFile(Path realClassFile, Path outputDir, Path outputJar, Logger log) {
        Option option = IO$.MODULE$.relativize(JavaAnalyze$.toFile$1(outputDir), JavaAnalyze$.toFile$1(realClassFile));
        if (option instanceof Some) {
            String relativeClass = (String)((Some)option).value();
            return JarUtils$ClassInJar$.MODULE$.toPath$extension(JarUtils$ClassInJar$.MODULE$.apply(outputJar, relativeClass));
        }
        if (None$.MODULE$.equals(option)) {
            return realClassFile;
        }
        throw new MatchError((Object)option);
    }

    private Option<Path> urlAsFile(URL url, Logger log, Option<Path> finalJarOutput) {
        try {
            return this.urlAsFile(url, finalJarOutput);
        }
        catch (Exception e) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Could not convert URL '").append(url.toExternalForm()).append("' to File: ").append(e.toString()).toString());
            return None$.MODULE$;
        }
    }

    private Option<Path> urlAsFile(URL url, Option<Path> finalJarOutput) {
        return IO$.MODULE$.urlAsFile(url).map((Function1 & Serializable & scala.Serializable)file -> {
            Path p = file.toPath();
            if (finalJarOutput.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)JavaAnalyze$.$anonfun$urlAsFile$3(p, x$9)))) {
                return JarUtils$ClassInJar$.MODULE$.toPath$extension(JarUtils$ClassInJar$.MODULE$.fromURL(url, p));
            }
            return p;
        });
    }

    private void trapAndLog(Logger log, Function0<BoxedUnit> execute) {
        try {
            execute.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            log.trace((Function0 & Serializable & scala.Serializable)() -> e);
            log.error((Function0 & Serializable & scala.Serializable)() -> e.toString());
            return;
        }
    }

    private Some<String> guessSourceName(String name) {
        return new Some((Object)this.takeToDollar(this.trimClassExt(name)));
    }

    private String takeToDollar(String name) {
        int dollar = name.indexOf(36);
        if (dollar < 0) {
            return name;
        }
        return name.substring(0, dollar);
    }

    private final String ClassExt() {
        return ".class";
    }

    private String trimClassExt(String name) {
        if (name.endsWith(".class")) {
            return name.substring(0, name.length() - ".class".length());
        }
        return name;
    }

    private String classNameToClassFile(String name) {
        return new StringBuilder(6).append(name.replace('.', '/')).append(".class").toString();
    }

    private Option<String> binaryToSourceName(Class<?> loadedClass) {
        return Option$.MODULE$.apply((Object)loadedClass.getCanonicalName());
    }

    private Option<String> loadEnclosingClass(Class<?> clazz) {
        Option<String> option;
        while (None$.MODULE$.equals(option = this.binaryToSourceName(clazz)) && clazz.getEnclosingClass() != null) {
            clazz = clazz.getEnclosingClass();
        }
        return option;
    }

    private List<VirtualFile> guessSourcePath(Map<String, Set<VirtualFile>> sourceNameMap, ClassFile classFile, Logger log) {
        List list;
        String[] classNameParts = classFile.className().split("\\.");
        String[] pkg = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classNameParts)).init();
        String simpleClassName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classNameParts)).last();
        String sourceFileName = (String)classFile.sourceFile().getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(simpleClassName)).takeWhile((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JavaAnalyze$.$anonfun$guessSourcePath$2(BoxesRunTime.unboxToChar((Object)x$10)))))).mkString("", "", ".java"));
        List<VirtualFile> candidates = this.findSource(sourceNameMap, (List<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pkg)).toList(), sourceFileName);
        if (Nil$.MODULE$.equals(candidates)) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Could not determine source for class ").append(classFile.className()).toString());
        } else if (!(candidates instanceof .colon.colon) || !Nil$.MODULE$.equals(list = ((.colon.colon)candidates).tl$access$1())) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Multiple sources matched for class ").append(classFile.className()).append(": ").append(candidates.mkString(", ")).toString());
        }
        return candidates;
    }

    private List<VirtualFile> findSource(Map<String, Iterable<VirtualFile>> sourceNameMap, List<String> pkg, String sourceFileName) {
        return this.refine$1((List)((List)sourceNameMap.get((Object)sourceFileName).toList().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x.names())).toList().reverse().drop(1)), List$.MODULE$.canBuildFrom()), pkg.reverse());
    }

    private static final Option load$1(String tpe, Function0 errMsg, ClassLoader loader$1, Logger log$1) {
        if (tpe.endsWith("module-info")) {
            return None$.MODULE$;
        }
        try {
            return new Some(Class.forName(tpe, false, loader$1));
        }
        catch (Throwable e) {
            ((Option)errMsg.apply()).foreach((Function1 & Serializable & scala.Serializable)msg -> {
                log$1.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(3).append(msg).append(" : ").append(e$1.toString()).toString());
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
    }

    private final Path remapClassFile$1(Path classFile, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Logger log$1) {
        if (directOutputJarOrNull$1 != null) {
            String string = classFile.getFileSystem().provider().getScheme();
            String string2 = "jar";
            if (string != null && string.equals(string2)) {
                return JarUtils$ClassInJar$.MODULE$.toPath$extension(JarUtils$ClassInJar$.MODULE$.apply(directOutputJarOrNull$1, ((Object)classFile.getRoot().relativize(classFile)).toString()));
            }
        }
        if (singleOutputOrNull$1 != null && mappedOutputJarOrNull$1 != null) {
            return this.resolveFinalClassFile(classFile, singleOutputOrNull$1, mappedOutputJarOrNull$1, log$1);
        }
        return classFile;
    }

    public static final /* synthetic */ void $anonfun$apply$12(JavaAnalyze$ $this, HashMap binaryClassNameToLoadedClass$1, Path newClass$1, AnalysisCallback analysis$1, HashMap sourceToClassFiles$1, ClassFile classFile$1, ClassLoader loader$1, Logger log$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Tuple2 x$2) {
        if (x$2 != null) {
            VirtualFile source = (VirtualFile)x$2._1();
            String binaryClassName = (String)x$2._2();
            JavaAnalyze$.load$1(binaryClassName, (Function0 & Serializable & scala.Serializable)() -> new Some((Object)new StringBuilder(35).append("Error reading API from class file: ").append(binaryClassName).toString()), loader$1, log$1).foreach((Function1 & Serializable & scala.Serializable)loadedClass -> {
                binaryClassNameToLoadedClass$1.update((Object)binaryClassName, loadedClass);
                Option<String> srcClassName = MODULE$.loadEnclosingClass((Class<?>)loadedClass);
                Path finalClassFile = $this.remapClassFile$1(newClass$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, log$1);
                if (srcClassName instanceof Some) {
                    String className = (String)((Some)srcClassName).value();
                    analysis$1.generatedNonLocalClass((VirtualFileRef)source, finalClassFile, binaryClassName, className);
                } else if (None$.MODULE$.equals(srcClassName)) {
                    analysis$1.generatedLocalClass((VirtualFileRef)source, finalClassFile);
                } else {
                    throw new MatchError(srcClassName);
                }
                return ((BufferLike)sourceToClassFiles$1.apply((Object)source)).$plus$eq((Object)classFile$1);
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$apply$10(JavaAnalyze$ $this, Map sourceMap$1, ClassFile classFile$1, Logger log$1, HashMap binaryClassNameToLoadedClass$1, Path newClass$1, AnalysisCallback analysis$1, HashMap sourceToClassFiles$1, ClassLoader loader$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, String _) {
        ((List)MODULE$.guessSourcePath((Map<String, Set<VirtualFile>>)sourceMap$1, classFile$1, log$1).map((Function1 & Serializable & scala.Serializable)source -> {
            String binaryClassName = classFile$1.className();
            return new Tuple2(source, (Object)binaryClassName);
        }, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            JavaAnalyze$.$anonfun$apply$12($this, binaryClassNameToLoadedClass$1, newClass$1, analysis$1, sourceToClassFiles$1, classFile$1, loader$1, log$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$8(JavaAnalyze$ $this, Map sourceMap$1, Logger log$1, HashMap binaryClassNameToLoadedClass$1, AnalysisCallback analysis$1, HashMap sourceToClassFiles$1, ClassLoader loader$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Tuple2 x$3) {
        if (x$3 != null) {
            Path newClass = (Path)x$3._1();
            ClassFile classFile = (ClassFile)x$3._2();
            classFile.sourceFile().orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.guessSourceName(((Object)newClass.getFileName()).toString())).foreach((Function1 & Serializable & scala.Serializable)_ -> {
                JavaAnalyze$.$anonfun$apply$10($this, sourceMap$1, classFile, log$1, binaryClassNameToLoadedClass$1, newClass, analysis$1, sourceToClassFiles$1, loader$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, _);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$15(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$apply$18(Class x$4) {
        return x$4.getCanonicalName() != null;
    }

    private static final Option getMappedSource$1(String className, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1) {
        return binaryClassNameToLoadedClass$1.get((Object)className).flatMap((Function1 & Serializable & scala.Serializable)loadedClass -> MODULE$.binaryToSourceName((Class<?>)loadedClass).map((Function1 & Serializable & scala.Serializable)sourceName -> sourceName)).orElse((Function0 & Serializable & scala.Serializable)() -> localClassesToSources$1.get((Object)className));
    }

    private static final Option loadFromClassloader$1(ClassLoader loader$1, String onBinaryName$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1) {
        return Option$.MODULE$.apply((Object)loader$1.getResource(MODULE$.classNameToClassFile(onBinaryName$1))).flatMap((Function1 & Serializable & scala.Serializable)url -> MODULE$.urlAsFile((URL)url, log$1, (Option<Path>)finalJarOutput$1).map((Function1 & Serializable & scala.Serializable)file -> {
            classfilesCache$1.update((Object)onBinaryName$1, file);
            return file;
        }));
    }

    public static final /* synthetic */ void $anonfun$apply$29(JavaAnalyze$ $this, AnalysisCallback analysis$1, String onBinaryName$1, String fromClassName$2, VirtualFile source$2, DependencyContext context$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Logger log$1, Path file) {
        Path binaryFile = $this.remapClassFile$1(file, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, log$1);
        analysis$1.binaryDependency(binaryFile, onBinaryName$1, fromClassName$2, (VirtualFileRef)source$2, context$1);
    }

    private final void processDependency$1(String onBinaryName, DependencyContext context, String fromBinaryName, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, AnalysisCallback analysis$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1) {
        Option option = JavaAnalyze$.getMappedSource$1(onBinaryName, binaryClassNameToLoadedClass$1, localClassesToSources$1);
        Option option2 = JavaAnalyze$.getMappedSource$1(fromBinaryName, binaryClassNameToLoadedClass$1, localClassesToSources$1);
        Tuple2 tuple2 = new Tuple2((Object)option2, (Object)option);
        if (option2 instanceof Some) {
            String fromClassName = (String)((Some)option2).value();
            if (option instanceof Some) {
                String onClassName = (String)((Some)option).value();
                this.trapAndLog(log$1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> analysis$1.classDependency(onClassName, fromClassName, context));
                return;
            }
        }
        if (option2 instanceof Some) {
            String fromClassName = (String)((Some)option2).value();
            if (None$.MODULE$.equals(option)) {
                this.trapAndLog(log$1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> classfilesCache$1.get((Object)onBinaryName).orElse((Function0 & Serializable & scala.Serializable)() -> JavaAnalyze$.loadFromClassloader$1(loader$1, onBinaryName, log$1, finalJarOutput$1, classfilesCache$1)).foreach((Function1 & Serializable & scala.Serializable)file -> {
                    JavaAnalyze$.$anonfun$apply$29(this, analysis$1, onBinaryName, fromClassName, source$2, context, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, log$1, file);
                    return BoxedUnit.UNIT;
                }));
                return;
            }
        }
        if (None$.MODULE$.equals(option2)) {
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final void processDependencies$1(Iterable binaryClassNames, DependencyContext context, String fromBinaryClassName, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, AnalysisCallback analysis$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1) {
        binaryClassNames.foreach((Function1 & Serializable & scala.Serializable)binaryClassName -> {
            this.processDependency$1(binaryClassName, context, fromBinaryClassName, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$32(JavaAnalyze$ $this, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, AnalysisCallback analysis$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String binaryClassName = (String)x0$1._1();
            Set binaryClassNameDeps = (Set)x0$1._2();
            $this.processDependencies$1((Iterable)binaryClassNameDeps, DependencyContext.DependencyByMemberRef, binaryClassName, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1);
            return;
        }
        throw new MatchError(null);
    }

    private static final Iterator readInheritanceDependencies$1(Seq classes, Function2 readAPI$1, VirtualFile source$2) {
        return ((Set)readAPI$1.apply((Object)source$2, (Object)classes)).groupBy((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6._1()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                Set v = (Set)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.map((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7._2(), Set$.MODULE$.canBuildFrom()));
            }
            throw new MatchError(null);
        });
    }

    public static final /* synthetic */ void $anonfun$apply$36(JavaAnalyze$ $this, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, AnalysisCallback analysis$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String className = (String)x0$2._1();
            Set inheritanceDeps = (Set)x0$2._2();
            $this.processDependencies$1((Iterable)inheritanceDeps, DependencyContext.DependencyByInheritance, className, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$apply$38(JavaAnalyze$ $this, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, AnalysisCallback analysis$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String className = (String)x0$3._1();
            Set inheritanceDeps = (Set)x0$3._2();
            $this.processDependencies$1((Iterable)inheritanceDeps, DependencyContext.LocalDependencyByInheritance, className, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1);
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$apply$16(JavaAnalyze$ $this, AnalysisCallback analysis$1, HashMap binaryClassNameToLoadedClass$1, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Function2 readAPI$1, Path directOutputJarOrNull$1, Path singleOutputOrNull$1, Path mappedOutputJarOrNull$1, Tuple2 x$8) {
        if (x$8 != null) {
            void var16_16;
            void var15_15;
            VirtualFile source = (VirtualFile)x$8._1();
            Buffer classFiles = (Buffer)x$8._2();
            analysis$1.startSource(source);
            Tuple2 tuple2 = ((Buffer)classFiles.map((Function1 & Serializable & scala.Serializable)c -> (Class)binaryClassNameToLoadedClass$1.apply((Object)c.className()), Buffer$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JavaAnalyze$.$anonfun$apply$18(x$4)));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Buffer nonLocalClasses = (Buffer)tuple2._1();
            Buffer localClassesOrStale = (Buffer)tuple2._2();
            void nonLocalClasses2 = var15_15;
            void localClassesOrStale2 = var16_16;
            Map localClassesToSources = ((Buffer)localClassesOrStale2.flatMap((Function1 & Serializable & scala.Serializable)cls -> Option$.MODULE$.option2Iterable(MODULE$.loadEnclosingClass((Class<?>)cls).map((Function1 & Serializable & scala.Serializable)sourceOfEnclosing -> new Tuple2((Object)cls.getName(), sourceOfEnclosing))), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            ((TraversableOnce)classFiles.map((Function1 & Serializable & scala.Serializable)cf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cf.className()), cf.types()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                JavaAnalyze$.$anonfun$apply$32($this, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source, binaryClassNameToLoadedClass$1, localClassesToSources, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, x0$1);
                return BoxedUnit.UNIT;
            });
            JavaAnalyze$.readInheritanceDependencies$1(nonLocalClasses2.toSeq(), readAPI$1, source).toMap(Predef$.MODULE$.$conforms()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                JavaAnalyze$.$anonfun$apply$36($this, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source, binaryClassNameToLoadedClass$1, localClassesToSources, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, x0$2);
                return BoxedUnit.UNIT;
            });
            JavaAnalyze$.readInheritanceDependencies$1(((Buffer)localClassesOrStale2.filter((Function1 & Serializable & scala.Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)localClassesToSources.contains((Object)cls.getName())))).toSeq(), readAPI$1, source).toMap(Predef$.MODULE$.$conforms()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                JavaAnalyze$.$anonfun$apply$38($this, loader$1, log$1, finalJarOutput$1, classfilesCache$1, analysis$1, source, binaryClassNameToLoadedClass$1, localClassesToSources, directOutputJarOrNull$1, singleOutputOrNull$1, mappedOutputJarOrNull$1, x0$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    private static final File toFile$1(Path p) {
        if (p == null) {
            return null;
        }
        return p.toFile();
    }

    public static final /* synthetic */ boolean $anonfun$urlAsFile$3(Path p$1, Path x$9) {
        Path path = x$9;
        return !(path != null ? !((Object)path).equals(p$1) : p$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$guessSourcePath$2(char x$10) {
        return x$10 != '$';
    }

    private static final List make$1(List sources$1) {
        return (List)sources$1.map((Function1 & Serializable & scala.Serializable)x$11 -> (VirtualFile)x$11._1(), List$.MODULE$.canBuildFrom());
    }

    private final List refine$1(List sources, List pkgRev) {
        while (true) {
            List xs;
            if (sources.isEmpty() || ((SeqLike)sources.tail()).isEmpty()) {
                return JavaAnalyze$.make$1(sources);
            }
            if (Nil$.MODULE$.equals(pkgRev)) {
                return JavaAnalyze$.shortest$1(JavaAnalyze$.make$1(sources));
            }
            if (!(pkgRev instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)pkgRev;
            String x = (String)colon2.head();
            pkgRev = xs = colon2.tl$access$1();
            sources = (List)sources.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    VirtualFile src = (VirtualFile)x0$1._1();
                    List list = (List)x0$1._2();
                    if (list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        String string = (String)colon2.head();
                        List presRev = colon2.tl$access$1();
                        String string2 = x;
                        if (!(string2 != null ? !string2.equals(string) : string != null)) {
                            Tuple2 tuple2 = new Tuple2((Object)src, (Object)presRev);
                            return Nil$.MODULE$.$colon$colon((Object)tuple2);
                        }
                    }
                }
                return Nil$.MODULE$;
            }, List$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)pkgRev);
    }

    public static final /* synthetic */ int $anonfun$findSource$3(VirtualFile x) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x.names())).size();
    }

    private static final List shortest$1(List files) {
        if (files.isEmpty()) {
            return files;
        }
        Map fs = files.groupBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)JavaAnalyze$.$anonfun$findSource$3(x)));
        return (List)fs.apply(fs.keys().min((Ordering)Ordering.Int$.MODULE$));
    }

    private JavaAnalyze$() {
        MODULE$ = this;
    }
}

