/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import sbt.testing.Event;
import sbt.testing.Fingerprint;
import sbt.testing.OptionalThrowable;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.TestSelector;

final class EventWrapper
implements Event {
    private final org.scalatools.testing.Event oldEvent;
    private final String className;
    private final Fingerprint fingerprint;
    private final OptionalThrowable throwable;

    EventWrapper(org.scalatools.testing.Event oldEvent, String className, Fingerprint fingerprint) {
        this.oldEvent = oldEvent;
        this.className = className;
        this.fingerprint = fingerprint;
        Throwable oldThrowable = oldEvent.error();
        this.throwable = oldThrowable == null ? new OptionalThrowable() : new OptionalThrowable(oldThrowable);
    }

    public String fullyQualifiedName() {
        return this.className;
    }

    public Fingerprint fingerprint() {
        return this.fingerprint;
    }

    public Selector selector() {
        return new TestSelector(this.oldEvent.testName());
    }

    public Status status() {
        switch (this.oldEvent.result()) {
            case Success: {
                return Status.Success;
            }
            case Error: {
                return Status.Error;
            }
            case Failure: {
                return Status.Failure;
            }
            case Skipped: {
                return Status.Skipped;
            }
        }
        throw new IllegalStateException("Invalid status.");
    }

    public OptionalThrowable throwable() {
        return this.throwable;
    }

    public long duration() {
        return -1L;
    }
}

