/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.graph.rendering;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import sbt.internal.graph.GraphModuleId;
import sbt.internal.graph.Module;
import sbt.internal.graph.ModuleGraph;
import sbt.internal.graph.ModuleModel;
import sbt.internal.graph.ModuleModel$;
import sbt.internal.graph.codec.JsonProtocol$;
import sbt.io.IO$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import sjsonnew.JsonWriter;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.CompactPrinter$;
import sjsonnew.support.scalajson.unsafe.Converter$;

public final class TreeView$ {
    public static TreeView$ MODULE$;

    static {
        new TreeView$();
    }

    public String createJson(ModuleGraph graph) {
        Seq moduleModels = (Seq)graph.roots().map((Function1 & Serializable & scala.Serializable)module -> MODULE$.processSubtree(graph, (Module)module, MODULE$.processSubtree$default$3()), Seq$.MODULE$.canBuildFrom());
        Seq js = (Seq)moduleModels.map((Function1 & Serializable & scala.Serializable)x$1 -> (JValue)Converter$.MODULE$.toJsonUnsafe(x$1, (JsonWriter)JsonProtocol$.MODULE$.ModuleModelFormat()), Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)js.map((Function1)CompactPrinter$.MODULE$, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
    }

    public URI createLink(String graphJson, File targetDirectory) {
        targetDirectory.mkdirs();
        File graphHTML = new File(targetDirectory, "tree.html");
        this.saveResource("tree.html", graphHTML);
        IO$.MODULE$.write(new File(targetDirectory, "tree.json"), graphJson, IO$.MODULE$.utf8(), IO$.MODULE$.write$default$4());
        IO$.MODULE$.write(new File(targetDirectory, "tree.data.js"), new StringBuilder(13).append("tree_data = ").append(graphJson).append(";").toString(), IO$.MODULE$.utf8(), IO$.MODULE$.write$default$4());
        return new URI(graphHTML.toURI().toString());
    }

    public ModuleModel processSubtree(ModuleGraph graph, Module module, Set<GraphModuleId> parents) {
        boolean cycle = parents.contains((Object)module.id());
        Nil$ dependencies = cycle ? Nil$.MODULE$ : (Seq)graph.dependencyMap().getOrElse((Object)module.id(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Vector children = ((TraversableOnce)dependencies.map((Function1 & Serializable & scala.Serializable)dependency -> MODULE$.processSubtree(graph, (Module)dependency, (Set<GraphModuleId>)((Set)parents.$plus((Object)module.id()))), Seq$.MODULE$.canBuildFrom())).toVector();
        return this.moduleAsModuleAgain(module, cycle, (Vector<ModuleModel>)children);
    }

    public Set<GraphModuleId> processSubtree$default$3() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    private ModuleModel moduleAsModuleAgain(Module module, boolean isCycle, Vector<ModuleModel> children) {
        String eviction = (String)module.evictedByVersion().map((Function1 & Serializable & scala.Serializable)version -> new StringBuilder(14).append(" (evicted by ").append((String)version).append(")").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String cycle = isCycle ? " (cycle)" : "";
        String error = (String)module.error().map((Function1 & Serializable & scala.Serializable)err -> new StringBuilder(11).append(" (errors: ").append((String)err).append(")").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String text = new StringBuilder(0).append(module.id().idString()).append(eviction).append(error).append(cycle).toString();
        return ModuleModel$.MODULE$.apply(text, children);
    }

    public void saveResource(String resourcePath, File to) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        Predef$.MODULE$.require(is != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Couldn't load '").append(resourcePath).append("' from classpath.").toString());
        FileOutputStream fos = new FileOutputStream(to);
        try {
            this.copy(is, fos);
        }
        finally {
            is.close();
            fos.close();
        }
    }

    public void copy(InputStream from, OutputStream to) {
        byte[] buffer = new byte[65536];
        this.rec$1(from, buffer, to);
    }

    private final void rec$1(InputStream from$1, byte[] buffer$1, OutputStream to$1) {
        int read;
        while ((read = from$1.read(buffer$1)) > 0) {
            to$1.write(buffer$1, 0, read);
        }
        if (read == 0) {
            throw new IllegalStateException("InputStream.read returned 0");
        }
    }

    private TreeView$() {
        MODULE$ = this;
    }
}

