/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import sbt.Command$;
import sbt.Def$;
import sbt.EvaluateTask$;
import sbt.EvaluateTaskConfig;
import sbt.Extracted;
import sbt.Inc;
import sbt.Incomplete;
import sbt.InputTask;
import sbt.Keys$;
import sbt.NodeView;
import sbt.Project$;
import sbt.ProjectRef;
import sbt.Reference;
import sbt.Result;
import sbt.Scope;
import sbt.Scope$;
import sbt.ScopeAxis;
import sbt.ScopeMask;
import sbt.Scoped;
import sbt.Select;
import sbt.SettingKey;
import sbt.SlashSyntax0$;
import sbt.State;
import sbt.State$;
import sbt.Task;
import sbt.Value;
import sbt.Zero$;
import sbt.internal.Aggregation;
import sbt.internal.BuildUtil;
import sbt.internal.Resolve$;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.AttributeKey$;
import sbt.internal.util.Dag$;
import sbt.internal.util.HList;
import sbt.internal.util.Init;
import sbt.internal.util.ManagedLogger;
import sbt.internal.util.Settings;
import sbt.internal.util.Terminal$;
import sbt.internal.util.Util$;
import sbt.internal.util.complete.Parser;
import sbt.internal.util.complete.Parser$;
import sbt.std.Streams;
import sbt.std.TaskExtra$;
import sbt.std.Transform;
import sbt.util.Logger;
import sbt.util.OptJsonWriter;
import sbt.util.OptJsonWriter$;
import sbt.util.Show;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Aggregation$ {
    public static Aggregation$ MODULE$;
    private final AttributeKey<Object> suppressShow;

    static {
        new Aggregation$();
    }

    public Aggregation.ShowConfig defaultShow(State state, boolean showTasks) {
        return new Aggregation.ShowConfig(true, showTasks, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
            Aggregation$.$anonfun$defaultShow$1(state, s);
            return BoxedUnit.UNIT;
        }, true);
    }

    public void printSettings(Seq<Aggregation.KeyValue<?>> xs, Function1<String, BoxedUnit> print, Show<Init.ScopedKey<?>> display) {
        boolean bl = false;
        .colon.colon colon2 = null;
        Seq<Aggregation.KeyValue<?>> seq = xs;
        if (seq instanceof .colon.colon) {
            Object x;
            bl = true;
            colon2 = (.colon.colon)seq;
            Aggregation.KeyValue keyValue = (Aggregation.KeyValue)colon2.head();
            List list = colon2.tl$access$1();
            if (keyValue != null && (x = keyValue.value()) instanceof Seq) {
                Seq seq2 = (Seq)x;
                if (Nil$.MODULE$.equals(list)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)print.apply((Object)seq2.mkString("* ", "\n* ", ""));
                    return;
                }
            }
        }
        if (bl) {
            Aggregation.KeyValue keyValue = (Aggregation.KeyValue)colon2.head();
            List list = colon2.tl$access$1();
            if (keyValue != null) {
                Object x = keyValue.value();
                if (Nil$.MODULE$.equals(list)) {
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)print.apply((Object)x.toString());
                    return;
                }
            }
        }
        xs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            print.apply((Object)new StringBuilder(2).append(display.show(kv.key())).append("\n\t").append(kv.value().toString()).toString());
            return BoxedUnit.UNIT;
        });
    }

    public <T> Parser<Seq<Aggregation.KeyValue<T>>> seqParser(Seq<Aggregation.KeyValue<Parser<T>>> ps) {
        return Parser$.MODULE$.seq((Seq)ps.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Aggregation.KeyValue keyValue = x0$1;
            if (keyValue != null) {
                Init.ScopedKey<?> k = keyValue.key();
                Parser p = (Parser)keyValue.value();
                return Parser$.MODULE$.richParser(p).map((Function1 & Serializable & scala.Serializable)v -> new Aggregation.KeyValue<Object>(k, v));
            }
            throw new MatchError((Object)keyValue);
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public <T> Parser<Function0<State>> applyTasks(State s, Seq<Aggregation.KeyValue<Parser<Task<T>>>> ps, Aggregation.ShowConfig show, Show<Init.ScopedKey<?>> display) {
        return Command$.MODULE$.applyEffect(this.seqParser(ps), (Function1 & Serializable & scala.Serializable)ts -> MODULE$.runTasks(s, (Seq)ts, new Transform.DummyTaskMap((List)Nil$.MODULE$), show, display));
    }

    private <T> void showRun(Aggregation.Complete<T> complete, Aggregation.ShowConfig show, Show<Init.ScopedKey<?>> display) {
        boolean bl;
        ManagedLogger log = State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(complete.state()));
        Extracted extracted = Project$.MODULE$.extract(complete.state());
        Result<Seq<Aggregation.KeyValue<T>>> result = complete.results();
        if (result instanceof Value) {
            bl = true;
        } else if (result instanceof Inc) {
            bl = false;
        } else {
            throw new MatchError(result);
        }
        boolean success = bl;
        complete.results().toEither().right().foreach((Function1 & Serializable & scala.Serializable)r -> {
            Aggregation$.$anonfun$showRun$1(show, display, r);
            return BoxedUnit.UNIT;
        });
        if (show.success() && !BoxesRunTime.unboxToBoolean((Object)State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(complete.state()), this.suppressShow()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
            this.printSuccess(complete.start(), complete.stop(), extracted, success, (Logger)log);
            return;
        }
    }

    public <T> Aggregation.Complete<T> timedRun(State s, Seq<Aggregation.KeyValue<Task<T>>> ts, Transform.DummyTaskMap extra) {
        Extracted extracted = Project$.MODULE$.extract(s);
        Task toRun = TaskExtra$.MODULE$.joinTasks((Seq)ts.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Aggregation.KeyValue keyValue = x0$1;
            if (keyValue != null) {
                Init.ScopedKey<?> k = keyValue.key();
                Task t = (Task)keyValue.value();
                return TaskExtra$.MODULE$.singleInputTask(t).map((Function1 & Serializable & scala.Serializable)v -> new Aggregation.KeyValue<Object>(k, v));
            }
            throw new MatchError((Object)keyValue);
        }, Seq$.MODULE$.canBuildFrom())).join();
        Seq roots = (Seq)ts.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Aggregation.KeyValue keyValue = x0$2;
            if (keyValue != null) {
                Init.ScopedKey<?> k = keyValue.key();
                return k;
            }
            throw new MatchError((Object)keyValue);
        }, Seq$.MODULE$.canBuildFrom());
        EvaluateTaskConfig config = EvaluateTask$.MODULE$.extractedTaskConfig(extracted, extracted.structure(), s);
        long start = System.currentTimeMillis();
        Tuple2 tuple2 = (Tuple2)EvaluateTask$.MODULE$.withStreams(extracted.structure(), s, (Function1 & Serializable & scala.Serializable)str -> {
            NodeView<Task> transform = EvaluateTask$.MODULE$.nodeView(s, (Streams<Init.ScopedKey<?>>)str, (Seq<Init.ScopedKey<?>>)roots, extra);
            return EvaluateTask$.MODULE$.runTask(toRun, s, (Streams<Init.ScopedKey<?>>)str, extracted.structure().index().triggers(), config, transform);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        State newS = (State)tuple2._1();
        Result result = (Result)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)newS, (Object)result);
        State newS2 = (State)tuple22._1();
        Result result2 = (Result)tuple22._2();
        long stop = System.currentTimeMillis();
        return new Aggregation.Complete(start, stop, result2, newS2);
    }

    public <HL extends HList, T> State runTasks(State s, Seq<Aggregation.KeyValue<Task<T>>> ts, Transform.DummyTaskMap extra, Aggregation.ShowConfig show, Show<Init.ScopedKey<?>> display) {
        Aggregation.Complete<T> complete = this.timedRun(s, ts, extra);
        this.showRun(complete, show, display);
        Result<Seq<Aggregation.KeyValue<T>>> result = complete.results();
        if (result instanceof Inc) {
            Inc inc = (Inc)result;
            Incomplete i = inc.cause();
            return State.StateOpsImpl$.MODULE$.handleError$extension(State$.MODULE$.StateOpsImpl(complete.state()), (Throwable)i);
        }
        if (result instanceof Value) {
            return complete.state();
        }
        throw new MatchError(result);
    }

    public void printSuccess(long start, long stop, Extracted extracted, boolean success, Logger log) {
        if (Aggregation$.get$1(Keys$.MODULE$.showSuccess(), extracted)) {
            if (Aggregation$.get$1(Keys$.MODULE$.showTiming(), extracted)) {
                String msg = this.timingString(start, stop, extracted.structure().data(), extracted.currentRef());
                if (success) {
                    log.success((Function0 & Serializable & scala.Serializable)() -> msg);
                    return;
                }
                if (Terminal$.MODULE$.get().isSuccessEnabled()) {
                    log.error((Function0 & Serializable & scala.Serializable)() -> msg);
                    return;
                }
                return;
            }
            if (success) {
                log.success((Function0 & Serializable & scala.Serializable)() -> "");
                return;
            }
            return;
        }
    }

    private String timingString(long startTime, long endTime, Settings<Scope> data, ProjectRef currentRef) {
        DateFormat format = (DateFormat)((Scoped.DefinableSetting)SlashSyntax0$.MODULE$.sbtSlashSyntaxRichReference((Reference)currentRef).$div(Keys$.MODULE$.timingFormat())).get(data).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.defaultFormat());
        return this.timing(format, startTime, endTime);
    }

    public String timing(DateFormat format, long startTime, long endTime) {
        String string;
        String nowString = format.format(new Date(endTime));
        long total = (endTime - startTime + 500L) / 1000L;
        StringBuilder stringBuilder = new StringBuilder(2).append(total).append(" s");
        if (total <= 60L) {
            string = "";
        } else {
            String string2;
            long l = total / 3600L;
            if (0L == l) {
                string2 = "";
            } else {
                long arg$macro$1 = l;
                string2 = new StringOps("%02d:").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)}));
            }
            String maybeHours = string2;
            long arg$macro$2 = total % 3600L / 60L;
            String mins = new StringOps("%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$2)}));
            long arg$macro$3 = total % 60L;
            String secs = new StringOps("%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$3)}));
            string = new StringBuilder(4).append(" (").append(maybeHours).append(mins).append(":").append(secs).append(")").toString();
        }
        String totalString = stringBuilder.append((Object)string).toString();
        return new StringBuilder(24).append("Total time: ").append(totalString).append(", completed ").append(nowString).toString();
    }

    public DateFormat defaultFormat() {
        return DateFormat.getDateTimeInstance(2, 2);
    }

    public <I> Parser<Function0<State>> applyDynamicTasks(State s, Seq<Aggregation.KeyValue<InputTask<I>>> inputs, Aggregation.ShowConfig show, Show<Init.ScopedKey<?>> display) {
        Seq parsers = (Seq)inputs.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Aggregation$.$anonfun$applyDynamicTasks$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            Aggregation.KeyValue keyValue = x$2;
            if (keyValue != null) {
                Init.ScopedKey<?> k = keyValue.key();
                InputTask it = (InputTask)keyValue.value();
                return Parser$.MODULE$.richParser((Parser)it.parser().apply((Object)s)).map((Function1 & Serializable & scala.Serializable)v -> new Aggregation.KeyValue<Task>(k, (Task)v));
            }
            throw new MatchError((Object)keyValue);
        }, Seq$.MODULE$.canBuildFrom());
        return Command$.MODULE$.applyEffect(Parser$.MODULE$.seq(parsers), (Function1 & Serializable & scala.Serializable)roots -> MODULE$.runTasks(s, (Seq)roots, new Transform.DummyTaskMap((List)Nil$.MODULE$), show, display));
    }

    public Parser<Function0<State>> evaluatingParser(State s, Aggregation.ShowConfig show, Seq<Aggregation.KeyValue<?>> keys, Show<Init.ScopedKey<?>> display) {
        List kvs = keys.toList();
        if (kvs.isEmpty()) {
            return Parser$.MODULE$.failure((Function0 & Serializable & scala.Serializable)() -> "No such setting/task", Parser$.MODULE$.failure$default$2());
        }
        Tuple2 tuple2 = Aggregation$.separate$1((Seq)kvs, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Aggregation.KeyValue keyValue = x0$1;
            if (keyValue != null) {
                Init.ScopedKey<?> k = keyValue.key();
                Object v = keyValue.value();
                if (v instanceof InputTask) {
                    InputTask inputTask = (InputTask)v;
                    return package$.MODULE$.Left().apply(new Aggregation.KeyValue<InputTask>(k, inputTask));
                }
            }
            return package$.MODULE$.Right().apply((Object)keyValue);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq inputTasks = (Seq)tuple2._1();
        Seq other = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)inputTasks, (Object)other);
        Seq inputTasks2 = (Seq)tuple22._1();
        Seq other2 = (Seq)tuple22._2();
        Tuple2 tuple23 = Aggregation$.separate$1(other2, (Function1 & Serializable & scala.Serializable)x0$2 -> {
            Aggregation.KeyValue keyValue = x0$2;
            if (keyValue != null) {
                Init.ScopedKey<?> k = keyValue.key();
                Object v = keyValue.value();
                if (v instanceof Task) {
                    Task task = (Task)v;
                    return package$.MODULE$.Left().apply(new Aggregation.KeyValue<Task>(k, task));
                }
            }
            return package$.MODULE$.Right().apply((Object)keyValue);
        });
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Seq tasks = (Seq)tuple23._1();
        Seq settings = (Seq)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)tasks, (Object)settings);
        Seq tasks2 = (Seq)tuple24._1();
        Seq settings2 = (Seq)tuple24._2();
        if (inputTasks2.nonEmpty()) {
            if (other2.nonEmpty()) {
                String inputStrings = ((TraversableOnce)inputTasks2.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.key(), Seq$.MODULE$.canBuildFrom())).mkString("Input task(s):\n\t", "\n\t", "\n");
                String otherStrings = ((TraversableOnce)other2.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.key(), Seq$.MODULE$.canBuildFrom())).mkString("Task(s)/setting(s):\n\t", "\n\t", "\n");
                return Parser$.MODULE$.failure((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Cannot mix input tasks with plain tasks/settings.  ").append(inputStrings).append(" ").append(otherStrings).toString(), Parser$.MODULE$.failure$default$2());
            }
            return this.applyDynamicTasks(s, this.maps(inputTasks2, (Function1 & Serializable & scala.Serializable)t -> MODULE$.castToAny(t)), show, display);
        }
        Parser<Function0<State>> base = tasks2.isEmpty() ? Parser$.MODULE$.success((Function0 & Serializable & scala.Serializable)() -> s) : this.applyTasks(s, this.maps(tasks2, (Function1 & Serializable & scala.Serializable)x -> Parser$.MODULE$.success((Object)MODULE$.castToAny(x))), show, display);
        return Parser$.MODULE$.richParser((Parser)base).map((Function1 & Serializable & scala.Serializable)res -> (Function0 & Serializable & scala.Serializable)() -> {
            State newState;
            block0: {
                newState = (State)res.apply();
                if (!show.settingValues() || !settings2.nonEmpty()) break block0;
                MODULE$.printSettings(settings2, show.print(), display);
            }
            return newState;
        });
    }

    private <T> T castToAny(T t) {
        return t;
    }

    private <T, S> Seq<Aggregation.KeyValue<S>> maps(Seq<Aggregation.KeyValue<T>> vs, Function1<T, S> f) {
        return (Seq)vs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Aggregation.KeyValue keyValue = x0$1;
            if (keyValue != null) {
                Init.ScopedKey<?> k = keyValue.key();
                Object v = keyValue.value();
                return new Aggregation.KeyValue<Object>(k, f.apply(v));
            }
            throw new MatchError((Object)keyValue);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public <Proj> Seq<ProjectRef> projectAggregates(Option<Reference> proj, BuildUtil<Proj> extra, boolean reverse) {
        Option resRef = proj.map((Function1 & Serializable & scala.Serializable)p -> extra.projectRefFor(extra.resolveRef((Reference)p)));
        return (Seq)resRef.toList().flatMap((Function1 & Serializable & scala.Serializable)ref -> {
            if (reverse) {
                return extra.aggregates().reverse(ref);
            }
            return extra.aggregates().forward(ref);
        }, List$.MODULE$.canBuildFrom());
    }

    public <T, Proj> Seq<Init.ScopedKey<T>> aggregate(Init.ScopedKey<T> key, ScopeMask rawMask, BuildUtil<Proj> extra, boolean reverse) {
        ScopeMask mask = rawMask.copy(true, rawMask.copy$default$2(), rawMask.copy$default$3(), rawMask.copy$default$4());
        return Dag$.MODULE$.topologicalSort(key, (Function1 & Serializable & scala.Serializable)k -> {
            if (reverse) {
                return MODULE$.reverseAggregatedKeys((Init.ScopedKey)k, extra, mask);
            }
            if (MODULE$.aggregationEnabled((Init.ScopedKey<?>)k, extra.data())) {
                return MODULE$.aggregatedKeys((Init.ScopedKey)k, extra, mask);
            }
            return Nil$.MODULE$;
        });
    }

    public <T, Proj> boolean aggregate$default$4() {
        return false;
    }

    public <T> Seq<Init.ScopedKey<T>> reverseAggregatedKeys(Init.ScopedKey<T> key, BuildUtil<?> extra, ScopeMask mask) {
        return (Seq)this.projectAggregates((Option<Reference>)((Scope)key.scope()).project().toOption(), extra, true).flatMap((Function1 & Serializable & scala.Serializable)ref -> {
            Scope toResolve = ((Scope)key.scope()).copy((ScopeAxis)new Select(ref), ((Scope)key.scope()).copy$default$2(), ((Scope)key.scope()).copy$default$3(), ((Scope)key.scope()).copy$default$4());
            Scope resolved = (Scope)Resolve$.MODULE$.apply(extra, (ScopeAxis<Reference>)Zero$.MODULE$, key.key(), mask).apply((Object)toResolve);
            Init.ScopedKey skey = new Init.ScopedKey((Init)Def$.MODULE$, (Object)resolved, key.key());
            if (MODULE$.aggregationEnabled(skey, extra.data())) {
                Init.ScopedKey scopedKey = skey;
                return Nil$.MODULE$.$colon$colon((Object)scopedKey);
            }
            return Nil$.MODULE$;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public <T> Seq<Init.ScopedKey<T>> aggregatedKeys(Init.ScopedKey<T> key, BuildUtil<?> extra, ScopeMask mask) {
        return (Seq)this.projectAggregates((Option<Reference>)((Scope)key.scope()).project().toOption(), extra, false).map((Function1 & Serializable & scala.Serializable)ref -> {
            Scope toResolve = ((Scope)key.scope()).copy((ScopeAxis)new Select(ref), ((Scope)key.scope()).copy$default$2(), ((Scope)key.scope()).copy$default$3(), ((Scope)key.scope()).copy$default$4());
            Scope resolved = (Scope)Resolve$.MODULE$.apply(extra, (ScopeAxis<Reference>)Zero$.MODULE$, key.key(), mask).apply((Object)toResolve);
            return new Init.ScopedKey((Init)Def$.MODULE$, (Object)resolved, key.key());
        }, Seq$.MODULE$.canBuildFrom());
    }

    public boolean aggregationEnabled(Init.ScopedKey<?> key, Settings<Scope> data) {
        return BoxesRunTime.unboxToBoolean((Object)Keys$.MODULE$.aggregate().in(Scope$.MODULE$.fillTaskAxis((Scope)key.scope(), key.key())).get(data).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    public AttributeKey<Object> suppressShow() {
        return this.suppressShow;
    }

    public static final /* synthetic */ void $anonfun$defaultShow$1(State state$1, String s) {
        State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(state$1)).info((Function0 & Serializable & scala.Serializable)() -> s);
    }

    public static final /* synthetic */ void $anonfun$showRun$1(Aggregation.ShowConfig show$2, Show display$3, Seq r) {
        if (show$2.taskValues()) {
            MODULE$.printSettings(r, show$2.print(), display$3);
            return;
        }
    }

    private static final boolean get$1(SettingKey key, Extracted extracted$2) {
        return BoxesRunTime.unboxToBoolean((Object)((Scoped.DefinableSetting)SlashSyntax0$.MODULE$.sbtSlashSyntaxRichReference((Reference)extracted$2.currentRef()).$div((Scoped.ScopingSetting)key)).get(extracted$2.structure().data()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    public static final /* synthetic */ boolean $anonfun$applyDynamicTasks$1(Aggregation.KeyValue check$ifrefutable$1) {
        Aggregation.KeyValue keyValue = check$ifrefutable$1;
        return keyValue != null;
    }

    private static final Tuple2 separate$1(Seq in, Function1 f) {
        return Util$.MODULE$.separate(in, f);
    }

    private Aggregation$() {
        MODULE$ = this;
        this.suppressShow = AttributeKey$.MODULE$.apply("suppress-aggregation-show", Integer.MAX_VALUE, (Manifest)ManifestFactory$.MODULE$.Boolean(), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
    }
}

