/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util.logic;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import sbt.internal.util.Dag;
import sbt.internal.util.Dag$;
import sbt.internal.util.Relation;
import sbt.internal.util.Relation$;
import sbt.internal.util.Util$;
import sbt.internal.util.logic.Atom;
import sbt.internal.util.logic.Clause;
import sbt.internal.util.logic.Clauses;
import sbt.internal.util.logic.Formula;
import sbt.internal.util.logic.Formula$True$;
import sbt.internal.util.logic.Literal;
import sbt.internal.util.logic.Logic;
import sbt.internal.util.logic.Logic$Matched$;
import sbt.internal.util.logic.Negated;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;

public final class Logic$ {
    public static Logic$ MODULE$;

    static {
        new Logic$();
    }

    public Either<Logic.LogicException, Logic.Matched> reduceAll(List<Clause> clauses, Set<Literal> initialFacts) {
        return this.reduce(new Clauses(clauses), initialFacts);
    }

    public Either<Logic.LogicException, Logic.Matched> reduce(Clauses clauses, Set<Literal> initialFacts) {
        Tuple2<Seq<Atom>, Seq<Atom>> tuple2 = this.separate((Seq<Literal>)initialFacts.toSeq());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq posSeq = (Seq)tuple2._1();
        Seq negSeq = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)posSeq, (Object)negSeq);
        Seq posSeq2 = (Seq)tuple22._1();
        Seq negSeq2 = (Seq)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)posSeq2.toSet(), (Object)negSeq2.toSet());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Set pos = (Set)tuple23._1();
        Set neg = (Set)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)pos, (Object)neg);
        Set pos2 = (Set)tuple24._1();
        Set neg2 = (Set)tuple24._2();
        Option problem = this.checkContradictions((Set<Atom>)pos2, (Set<Atom>)neg2).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.checkOverlap(clauses, (Set<Atom>)pos2));
        return problem.toLeft((Function0 & Serializable & scala.Serializable)() -> MODULE$.reduce0(clauses, initialFacts, Logic$Matched$.MODULE$.empty()));
    }

    private Option<Logic.InitialOverlap> checkOverlap(Clauses clauses, Set<Atom> initialFacts) {
        Logic.Atoms as = this.atoms(clauses);
        Set initialOverlap = (Set)initialFacts.filter(as.inHead());
        if (initialOverlap.nonEmpty()) {
            return new Some((Object)new Logic.InitialOverlap((Set<Atom>)initialOverlap));
        }
        return None$.MODULE$;
    }

    private Option<Logic.InitialContradictions> checkContradictions(Set<Atom> pos, Set<Atom> neg) {
        Set contradictions = (Set)pos.intersect(neg);
        if (contradictions.nonEmpty()) {
            return new Some((Object)new Logic.InitialContradictions((Set<Atom>)contradictions));
        }
        return None$.MODULE$;
    }

    private Option<Logic.CyclicNegation> checkAcyclic(Clauses clauses) {
        Map<Atom, Set<Literal>> deps = this.dependencyMap(clauses);
        List cycle = Dag$.MODULE$.findNegativeCycle(this.graph(deps));
        if (cycle.nonEmpty()) {
            return new Some((Object)new Logic.CyclicNegation((List<Literal>)cycle));
        }
        return None$.MODULE$;
    }

    private Dag.DirectedSignedGraph<Atom> graph(Map<Atom, Set<Literal>> deps) {
        return new Dag.DirectedSignedGraph<Atom>(deps){
            private final Map deps$1;

            public List<Atom> nodes() {
                return this.deps$1.keys().toList();
            }

            public List<Literal> dependencies(Atom a) {
                return ((TraversableOnce)this.deps$1.getOrElse((Object)a, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).toList();
            }

            public boolean isNegative(Literal b) {
                Literal literal = b;
                if (literal instanceof Negated) {
                    return true;
                }
                if (literal instanceof Atom) {
                    return false;
                }
                throw new MatchError((Object)literal);
            }

            public Atom head(Literal b) {
                return b.atom();
            }

            public String toString() {
                return ((TraversableOnce)this.nodes().flatMap((Function1 & Serializable & scala.Serializable)n -> (List)new .colon.colon(n, (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)this.dependencies((Atom)n).map((Function1 & Serializable & scala.Serializable)d -> new StringBuilder(4).append(n).append(" -> ").append(d).toString(), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).mkString("{\n", "\n", "\n}");
            }
            {
                this.deps$1 = deps$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$dependencies$1(), $anonfun$toString$1(sbt.internal.util.logic.Logic$$anon$1 sbt.internal.util.logic.Atom ), $anonfun$toString$2(sbt.internal.util.logic.Atom sbt.internal.util.logic.Literal )}, serializedLambda);
            }
        };
    }

    private Map<Atom, Set<Literal>> dependencyMap(Clauses clauses) {
        return (Map)clauses.clauses().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Map m = (Map)tuple2._1();
                Clause clause = (Clause)tuple2._2();
                if (clause != null) {
                    Formula formula = clause.body();
                    Set<Atom> heads = clause.head();
                    Set<Literal> deps = MODULE$.literals(formula);
                    return (Map)heads.foldLeft((Object)m, (Function2 & Serializable & scala.Serializable)(n, head) -> n.updated(head, (Object)((SetLike)n.getOrElse(head, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).$plus$plus((GenTraversableOnce)deps)));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Tuple2<Seq<Atom>, Seq<Atom>> separate(Seq<Literal> lits) {
        return Util$.MODULE$.separate(lits, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Literal literal = x0$1;
            if (literal instanceof Atom) {
                Atom atom = (Atom)literal;
                return package$.MODULE$.Left().apply((Object)atom);
            }
            if (literal instanceof Negated) {
                Negated negated = (Negated)literal;
                Atom n = negated.atom();
                return package$.MODULE$.Right().apply((Object)n);
            }
            throw new MatchError((Object)literal);
        });
    }

    private Tuple2<Set<Atom>, List<Clause>> findProven(Clauses c) {
        Tuple2 tuple2 = c.clauses().partition((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Logic$.$anonfun$findProven$1(x$6)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List proven = (List)tuple2._1();
        List unproven = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)proven, (Object)unproven);
        List proven2 = (List)tuple22._1();
        List unproven2 = (List)tuple22._2();
        return new Tuple2((Object)((TraversableOnce)proven2.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.head(), List$.MODULE$.canBuildFrom())).toSet(), (Object)unproven2);
    }

    private Set<Atom> keepPositive(Set<Literal> lits) {
        return ((Set)lits.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Literal, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Atom) {
                    Atom atom = (Atom)A1;
                    return (B1)atom;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Literal x1) {
                Literal literal = x1;
                return literal instanceof Atom;
            }
        }, Set$.MODULE$.canBuildFrom())).toSet();
    }

    private Logic.Matched reduce0(Clauses clauses, Set<Literal> factsToProcess, Logic.Matched state) {
        Option<Clauses> option;
        while (true) {
            if (None$.MODULE$.equals(option = this.applyAll(clauses, factsToProcess))) {
                return state;
            }
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            Clauses applied = (Clauses)some.value();
            Tuple2<Set<Atom>, List<Clause>> tuple2 = this.findProven(applied);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Set proven = (Set)tuple2._1();
            List unprovenClauses = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)proven, (Object)unprovenClauses);
            Set proven2 = (Set)tuple22._1();
            List unprovenClauses2 = (List)tuple22._2();
            Logic.Matched processedFacts = state.add(this.keepPositive(factsToProcess));
            Set newlyProven = (Set)proven2.$minus$minus(processedFacts.provenSet());
            Logic.Matched newState = processedFacts.add((Set<Atom>)newlyProven);
            if (unprovenClauses2.isEmpty()) {
                return newState;
            }
            Clauses unproven = new Clauses((List<Clause>)unprovenClauses2);
            Set<Literal> nextFacts = newlyProven.nonEmpty() ? newlyProven.toSet() : this.inferFailure(unproven);
            state = newState;
            factsToProcess = nextFacts;
            clauses = unproven;
        }
        throw new MatchError(option);
    }

    private Set<Literal> inferFailure(Clauses clauses) {
        Logic.Atoms allAtoms = this.atoms(clauses);
        Set<Literal> newFacts = this.negated(allAtoms.triviallyFalse());
        if (newFacts.nonEmpty()) {
            return newFacts;
        }
        List<Atom> possiblyTrue = this.hasNegatedDependency((Seq<Clause>)clauses.clauses(), (Relation<Atom, Atom>)Relation$.MODULE$.empty(), (Relation<Atom, Atom>)Relation$.MODULE$.empty());
        Set<Literal> newlyFalse = this.negated((Set<Atom>)((Set)allAtoms.inHead().$minus$minus(possiblyTrue)));
        if (newlyFalse.nonEmpty()) {
            return newlyFalse;
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(40).append("No progress:\n\tclauses: ").append(clauses).append("\n\tpossibly true: ").append(possiblyTrue).toString());
    }

    private Set<Literal> negated(Set<Atom> atoms) {
        return (Set)atoms.map((Function1 & Serializable & scala.Serializable)a -> new Negated((Atom)a), Set$.MODULE$.canBuildFrom());
    }

    public List<Atom> hasNegatedDependency(Seq<Clause> clauses, Relation<Atom, Atom> posDeps, Relation<Atom, Atom> negDeps) {
        Seq seq;
        while (true) {
            Relation newNeg;
            Some some;
            if (!(some = Seq$.MODULE$.unapplySeq(seq = clauses)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                return Dag$.MODULE$.topologicalSortUnchecked((Iterable)negDeps._1s(), (Function1 & Serializable & scala.Serializable)_2 -> posDeps.reverse(_2));
            }
            Option option = package$.MODULE$.$plus$colon().unapply(seq);
            if (option.isEmpty()) break;
            Clause clause = (Clause)((Tuple2)option.get())._1();
            Seq tail = (Seq)((Tuple2)option.get())._2();
            if (clause == null) break;
            Formula formula = clause.body();
            Set<Atom> head = clause.head();
            Tuple2<Seq<Atom>, Seq<Atom>> tuple2 = this.directDeps(formula);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq pos = (Seq)tuple2._1();
            Seq neg = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)pos, (Object)neg);
            Seq pos2 = (Seq)tuple22._1();
            Seq neg2 = (Seq)tuple22._2();
            Tuple2 tuple23 = (Tuple2)head.foldLeft((Object)new Tuple2(posDeps, negDeps), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Atom d = (Atom)tuple2._2();
                    if (tuple22 != null) {
                        Relation pdeps = (Relation)tuple22._1();
                        Relation ndeps = (Relation)tuple22._2();
                        return new Tuple2((Object)pdeps.$plus((Object)d, (Traversable)pos2), (Object)ndeps.$plus((Object)d, (Traversable)neg2));
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Relation newPos = (Relation)tuple23._1();
            Relation newNeg2 = (Relation)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)newPos, (Object)newNeg2);
            Relation newPos2 = (Relation)tuple24._1();
            negDeps = newNeg = (Relation)tuple24._2();
            posDeps = newPos2;
            clauses = tail;
        }
        throw new MatchError(seq);
    }

    private Tuple2<Seq<Atom>, Seq<Atom>> directDeps(Formula formula) {
        return Util$.MODULE$.separate(this.literals(formula).toSeq(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Literal literal = x0$1;
            if (literal instanceof Negated) {
                Negated negated = (Negated)literal;
                Atom a = negated.atom();
                return package$.MODULE$.Right().apply((Object)a);
            }
            if (literal instanceof Atom) {
                Atom atom = (Atom)literal;
                return package$.MODULE$.Left().apply((Object)atom);
            }
            throw new MatchError((Object)literal);
        });
    }

    private Set<Literal> literals(Formula formula) {
        Formula formula2 = formula;
        if (formula2 instanceof Formula.And) {
            Formula.And and = (Formula.And)formula2;
            Set<Literal> lits = and.literals();
            return lits;
        }
        if (formula2 instanceof Literal) {
            Literal literal = (Literal)formula2;
            return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{literal}));
        }
        if (Formula$True$.MODULE$.equals(formula2)) {
            return Predef$.MODULE$.Set().empty();
        }
        throw new MatchError((Object)formula2);
    }

    public Logic.Atoms atoms(Clauses cs) {
        return (Logic.Atoms)((TraversableOnce)cs.clauses().map((Function1 & Serializable & scala.Serializable)c -> new Logic.Atoms(c.head(), MODULE$.atoms(c.body())), List$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$12, x$13) -> x$12.$plus$plus((Logic.Atoms)x$13));
    }

    public Set<Atom> atoms(Formula formula) {
        Formula formula2 = formula;
        if (formula2 instanceof Formula.And) {
            Formula.And and = (Formula.And)formula2;
            Set<Literal> lits = and.literals();
            return (Set)lits.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.atom(), Set$.MODULE$.canBuildFrom());
        }
        if (formula2 instanceof Negated) {
            Negated negated = (Negated)formula2;
            Atom lit = negated.atom();
            return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Atom[]{lit}));
        }
        if (formula2 instanceof Atom) {
            Atom atom = (Atom)formula2;
            return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Atom[]{atom}));
        }
        if (Formula$True$.MODULE$.equals(formula2)) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        }
        throw new MatchError((Object)formula2);
    }

    public Option<Clauses> applyAll(Clauses cs, Set<Literal> facts) {
        List newClauses;
        List list = newClauses = facts.isEmpty() ? (List)cs.clauses().filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)Logic$.$anonfun$applyAll$1(x$15))) : (List)((List)cs.clauses().map((Function1 & Serializable & scala.Serializable)c -> MODULE$.applyAll((Clause)c, facts), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.toList(), List$.MODULE$.canBuildFrom());
        if (newClauses.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)new Clauses((List<Clause>)newClauses));
    }

    public Option<Clause> applyAll(Clause c, Set<Literal> facts) {
        Set atoms = (Set)facts.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.atom(), Set$.MODULE$.canBuildFrom());
        Set newHead = (Set)c.head().$minus$minus((GenTraversableOnce)atoms);
        if (newHead.isEmpty()) {
            return None$.MODULE$;
        }
        return this.substitute(c.body(), facts).map((Function1 & Serializable & scala.Serializable)f -> new Clause((Formula)f, (Set<Atom>)newHead));
    }

    public Option<Formula> substitute(Formula formula, Set<Literal> facts) {
        Formula formula2;
        while (true) {
            if ((formula2 = formula) instanceof Formula.And) {
                Formula.And and = (Formula.And)formula2;
                Set<Literal> lits = and.literals();
                if (lits.exists((Function1)Logic$.negated$1(facts))) {
                    return None$.MODULE$;
                }
                Set newLits = (Set)lits.$minus$minus(facts);
                Formula newF = newLits.isEmpty() ? Formula$True$.MODULE$ : new Formula.And((Set<Literal>)newLits);
                return new Some((Object)newF);
            }
            if (Formula$True$.MODULE$.equals(formula2)) {
                return new Some((Object)Formula$True$.MODULE$);
            }
            if (!(formula2 instanceof Literal)) break;
            Literal literal = (Literal)formula2;
            formula = new Formula.And((Set<Literal>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{literal}))));
        }
        throw new MatchError((Object)formula2);
    }

    public static final /* synthetic */ boolean $anonfun$findProven$1(Clause x$6) {
        Formula formula = x$6.body();
        Formula$True$ formula$True$ = Formula$True$.MODULE$;
        return !(formula != null ? !formula.equals(formula$True$) : formula$True$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$applyAll$1(Clause x$15) {
        return x$15.head().nonEmpty();
    }

    private static final Set negated$1(Set lits) {
        return (Set)lits.map((Function1 & Serializable & scala.Serializable)a -> a.unary_$bang(), Set$.MODULE$.canBuildFrom());
    }

    private Logic$() {
        MODULE$ = this;
    }
}

