/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import sbt.internal.nio.Observable;
import sbt.internal.nio.Observer;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001]4QAD\b\u0001'UAQ!\u000e\u0001\u0005\u0002Y2A\u0001\u000f\u0001\u0005s!AQH\u0001B\u0001B\u0003%a\bC\u00036\u0005\u0011\u0005\u0011\tC\u0003F\u0005\u0011\u0005c\t\u0003\u0004>\u0001\u0001\u0006IA\u0013\u0005\u0007)\u0002\u0001\u000b\u0011B+\t\re\u0003\u0001\u0015!\u0003[\u0011\u0019q\u0006\u0001\"\u0001\u0014?\")!\r\u0001C!G\")Q\t\u0001C!\r\")a\r\u0001C!O\")1\u000f\u0001C!i\nIqJY:feZ,'o\u001d\u0006\u0003!E\t1A\\5p\u0015\t\u00112#\u0001\u0005j]R,'O\\1m\u0015\u0005!\u0012aA:ciV\u0011a#J\n\u0005\u0001]y\"\u0007\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005!A.\u00198h\u0015\u0005a\u0012\u0001\u00026bm\u0006L!AH\r\u0003\r=\u0013'.Z2u!\r\u0001\u0013eI\u0007\u0002\u001f%\u0011!e\u0004\u0002\t\u001f\n\u001cXM\u001d<feB\u0011A%\n\u0007\u0001\t\u00151\u0003A1\u0001)\u0005\u0005!6\u0001A\t\u0003S=\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012qAT8uQ&tw\r\u0005\u0002+a%\u0011\u0011g\u000b\u0002\u0004\u0003:L\bc\u0001\u00114G%\u0011Ag\u0004\u0002\u000b\u001f\n\u001cXM\u001d<bE2,\u0017A\u0002\u001fj]&$h\bF\u00018!\r\u0001\u0003a\t\u0002\u0007\u0011\u0006tG\r\\3\u0014\u0007\t9\"\b\u0005\u0002\u0019w%\u0011A(\u0007\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\u0002\u0005%$\u0007C\u0001\u0016@\u0013\t\u00015FA\u0002J]R$\"A\u0011#\u0011\u0005\r\u0013Q\"\u0001\u0001\t\u000bu\"\u0001\u0019\u0001 \u0002\u000b\rdwn]3\u0015\u0003\u001d\u0003\"A\u000b%\n\u0005%[#\u0001B+oSR\u0004\"a\u0013*\u000e\u00031S!!\u0014(\u0002\r\u0005$x.\\5d\u0015\ty\u0005+\u0001\u0006d_:\u001cWO\u001d:f]RT!!U\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003'2\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018!C8cg\u0016\u0014h/\u001a:t!\u00111vKP\u0010\u000e\u00039K!\u0001\u0017(\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007/A\u0006pEN,'O^1cY\u0016\u001c\b\u0003B.]u\u001dk\u0011\u0001U\u0005\u0003;B\u00131bV3bW\"\u000b7\u000f['ba\u0006i\u0011\r\u001a3PEN,'O^1cY\u0016$\"A\u000f1\t\u000b\u0005L\u0001\u0019\u0001\u001a\u0002\u0015=\u00147/\u001a:wC\ndW-A\u0006bI\u0012|%m]3sm\u0016\u0014HC\u0001\u001ee\u0011\u0015)'\u00021\u0001 \u0003!y'm]3sm\u0016\u0014\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003!\u0004\"!\u001b9\u000f\u0005)t\u0007CA6,\u001b\u0005a'BA7(\u0003\u0019a$o\\8u}%\u0011qnK\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002pW\u00051qN\u001c(fqR$\"aR;\t\u000bYl\u0001\u0019A\u0012\u0002\u0003Q\u0004")
public class Observers<T>
implements Observer<T>,
Observable<T> {
    private final AtomicInteger id;
    public final ConcurrentHashMap<Object, Observer<T>> sbt$internal$nio$Observers$$observers;
    private final WeakHashMap<AutoCloseable, BoxedUnit> observables;

    public AutoCloseable addObservable(Observable<T> observable) {
        AutoCloseable autoCloseable;
        WeakHashMap<AutoCloseable, BoxedUnit> weakHashMap = this.observables;
        synchronized (weakHashMap) {
            AutoCloseable handle = observable.addObserver(this);
            this.observables.put(handle, BoxedUnit.UNIT);
            autoCloseable = handle;
        }
        return autoCloseable;
    }

    @Override
    public AutoCloseable addObserver(Observer<T> observer) {
        int observerId = this.id.incrementAndGet();
        this.sbt$internal$nio$Observers$$observers.put(BoxesRunTime.boxToInteger((int)observerId), observer);
        return new Handle(this, observerId);
    }

    @Override
    public void close() {
        this.sbt$internal$nio$Observers$$observers.clear();
        WeakHashMap<AutoCloseable, BoxedUnit> weakHashMap = this.observables;
        synchronized (weakHashMap) {
            this.observables.keySet().forEach(x$1 -> x$1.close());
            this.observables.clear();
        }
    }

    public String toString() {
        return new StringBuilder(39).append("Observers(observers = ").append(this.sbt$internal$nio$Observers$$observers.values()).append(", observables = ").append(this.observables.keySet()).append(")").toString();
    }

    @Override
    public void onNext(T t) {
        this.sbt$internal$nio$Observers$$observers.values().forEach(o -> {
            try {
                o.onNext(t);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        });
    }

    public Observers() {
        Observer.$init$(this);
        this.id = new AtomicInteger(0);
        this.sbt$internal$nio$Observers$$observers = new ConcurrentHashMap();
        this.observables = new WeakHashMap();
    }

    private class Handle
    implements AutoCloseable {
        private final int id;
        public final /* synthetic */ Observers $outer;

        @Override
        public void close() {
            this.sbt$internal$nio$Observers$Handle$$$outer().sbt$internal$nio$Observers$$observers.remove(BoxesRunTime.boxToInteger((int)this.id));
        }

        public /* synthetic */ Observers sbt$internal$nio$Observers$Handle$$$outer() {
            return this.$outer;
        }

        public Handle(Observers $outer, int id) {
            this.id = id;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

