/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.AbstractFile;
import dotty.tools.io.Directory;
import dotty.tools.io.File;
import dotty.tools.io.Path;
import dotty.tools.io.PlainFile$;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;

public class PlainFile
extends AbstractFile {
    private final Path givenPath;
    private final String absolutePath;

    public static PlainFile toPlainFile(java.nio.file.Path path) {
        return PlainFile$.MODULE$.toPlainFile(path);
    }

    public PlainFile(Path givenPath) {
        this.givenPath = givenPath;
        if (this.path() == null) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.absolutePath = givenPath.toAbsolute().toString().intern();
    }

    public Path givenPath() {
        return this.givenPath;
    }

    @Override
    public java.nio.file.Path jpath() {
        return this.givenPath().jpath();
    }

    @Override
    public Option<AbstractFile> underlyingSource() {
        FileSystem fileSystem = this.jpath().getFileSystem();
        String string = fileSystem.provider().getScheme();
        if ("jar".equals(string)) {
            java.util.Iterator<FileStore> fileStores = fileSystem.getFileStores().iterator();
            if (fileStores.hasNext()) {
                None$ none$;
                String jarPath = fileStores.next().name();
                try {
                    none$ = Some$.MODULE$.apply((Object)new PlainFile(new Path(Paths.get(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(jarPath), fileSystem.getSeparator()), new String[0]))));
                }
                catch (InvalidPathException invalidPathException) {
                    none$ = None$.MODULE$;
                }
                return none$;
            }
            return None$.MODULE$;
        }
        if ("jrt".equals(string)) {
            if (this.jpath().getNameCount() > 2 && this.jpath().startsWith("/modules")) {
                java.nio.file.Path moduleName = this.jpath().getName(1);
                return Some$.MODULE$.apply((Object)new PlainFile(new Path(Paths.get(System.getProperty("java.home"), "jmods", new StringBuilder(5).append(moduleName.toString()).append(".jmod").toString()))));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    @Override
    public String name() {
        return this.givenPath().name();
    }

    @Override
    public String path() {
        return this.givenPath().path();
    }

    @Override
    public String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public PlainFile absolute() {
        return new PlainFile(this.givenPath().toAbsolute());
    }

    @Override
    public AbstractFile container() {
        return new PlainFile(this.givenPath().parent());
    }

    @Override
    public InputStream input() {
        return this.givenPath().toFile().inputStream();
    }

    @Override
    public OutputStream output() {
        File file = this.givenPath().toFile();
        return file.outputStream(file.outputStream$default$1());
    }

    @Override
    public Option<Object> sizeOption() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.givenPath().length())));
    }

    public int hashCode() {
        return System.identityHashCode(this.absolutePath());
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof PlainFile) {
            PlainFile x = (PlainFile)object;
            return this.absolutePath() == x.absolutePath();
        }
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.givenPath().isDirectory();
    }

    @Override
    public long lastModified() {
        return this.givenPath().lastModified().toMillis();
    }

    @Override
    public Iterator<AbstractFile> iterator() {
        return this.givenPath().toDirectory().list().filter((Function1 & Serializable)path -> PlainFile.existsFast$1(path)).map((Function1 & Serializable)_$3 -> new PlainFile((Path)_$3));
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        Path child = this.givenPath().$div(name);
        if (child.isDirectory() && directory || child.isFile() && !directory) {
            return new PlainFile(child);
        }
        return null;
    }

    @Override
    public void create() {
        if (!this.exists()) {
            this.givenPath().createFile(this.givenPath().createFile$default$1());
            return;
        }
    }

    @Override
    public void delete() {
        if (this.givenPath().isFile()) {
            this.givenPath().delete();
            return;
        }
        if (this.givenPath().isDirectory()) {
            this.givenPath().toDirectory().deleteRecursively();
            return;
        }
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        return new PlainFile(this.givenPath().$div(name));
    }

    private static final boolean existsFast$1(Path path) {
        Path path2 = path;
        if (path2 instanceof Directory || path2 instanceof File) {
            return true;
        }
        return path.exists();
    }
}

