/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.internal;

import java.io.PrintStream;

public final class Log {
    public static final boolean DEBUG = Boolean.getBoolean(Log.class.getName() + ".debug");
    public static final boolean TRACE = Boolean.getBoolean(Log.class.getName() + ".trace");
    private static PrintStream output = System.err;

    public static PrintStream getOutput() {
        return output;
    }

    public static void setOutput(PrintStream printStream) {
        assert (printStream != null);
        output = printStream;
    }

    private static void print(Object object) {
        if (object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        } else if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                output.print(objectArray[i]);
                if (i + 1 >= objectArray.length) continue;
                output.print(",");
            }
        } else {
            output.print(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(Level level, Object[] objectArray) {
        PrintStream printStream = output;
        synchronized (printStream) {
            output.format("[%s] ", new Object[]{level});
            for (Object object : objectArray) {
                Log.print(object);
            }
            output.println();
            output.flush();
        }
    }

    public static void trace(Object ... objectArray) {
        if (TRACE) {
            Log.log(Level.TRACE, objectArray);
        }
    }

    public static void debug(Object ... objectArray) {
        if (TRACE || DEBUG) {
            Log.log(Level.DEBUG, objectArray);
        }
    }

    public static void warn(Object ... objectArray) {
        Log.log(Level.WARN, objectArray);
    }

    public static void error(Object ... objectArray) {
        Log.log(Level.ERROR, objectArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

