/*
 * Decompiled with CFR 0.152.
 */
package org.savara.switchyard.bpel.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.savara.common.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchyardBPELGenerator {
    private static final Logger logger = Logger.getLogger(SwitchyardBPELGenerator.class.getName());

    public Element createSwitchyardDescriptor(String name, Element descriptor, Map<String, Definition> wsdls) throws Exception {
        return this.createSwitchyardDescriptor(name, descriptor, null, wsdls);
    }

    public Element createSwitchyardDescriptor(String name, Element descriptor, Definition serviceWsdl, Map<String, Definition> wsdls) throws Exception {
        Element ret = null;
        String targetNamespace = null;
        if (serviceWsdl != null) {
            targetNamespace = serviceWsdl.getTargetNamespace();
        }
        StringBuffer composite = new StringBuffer();
        composite.append("<switchyard xmlns=\"urn:switchyard-config:switchyard:1.0\"\r\n");
        NamedNodeMap attrs = descriptor.getAttributes();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().startsWith("xmlns:")) continue;
            namespaces.put(attr.getName().substring(6), attr.getValue());
            composite.append("\t\t" + attr.getName() + "=\"" + attr.getValue() + "\"\r\n");
        }
        if (targetNamespace != null) {
            composite.append("\t\ttargetNamespace=\"" + targetNamespace + "\"\r\n");
        }
        composite.append("\t\tname=\"" + name + "\" >\r\n");
        composite.append("\t<composite xmlns=\"http://docs.oasis-open.org/ns/opencsa/sca/200912\" name=\"" + name + "\"");
        if (targetNamespace != null) {
            composite.append(" targetNamespace=\"" + targetNamespace + "\"");
        }
        composite.append(" >\r\n");
        NodeList nl = descriptor.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element) || !XMLUtils.getLocalname((String)n.getNodeName()).equals("process")) continue;
            Element process = (Element)n;
            composite.append(this.generateServices(name, process, wsdls, namespaces));
            composite.append(this.generateReferences(name, process, wsdls, namespaces));
            composite.append(this.generateComponent(name, process, wsdls, namespaces));
        }
        composite.append("\t</composite>\r\n");
        composite.append("</switchyard>\r\n");
        ret = (Element)XMLUtils.getNode((String)composite.toString());
        return ret;
    }

    protected String generateServices(String compositeName, Element process, Map<String, Definition> wsdls, Map<String, String> namespaces) {
        StringBuffer ret = new StringBuffer();
        NodeList nl = process.getElementsByTagName("provide");
        Vector<String> wsdlPaths = new Vector<String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            NodeList services;
            Node n = nl.item(i);
            if (!(n instanceof Element) || (services = ((Element)n).getElementsByTagName("service")).getLength() != 1 || !(services.item(0) instanceof Element)) continue;
            Element service = (Element)services.item(0);
            String name = this.getComponentName(compositeName);
            String servName = this.getServiceName(service);
            ret.append("\t\t<service name=\"" + servName + "\" promote=\"" + name + "/" + servName + "\">\r\n");
            String wsdlInterface = this.getInterfaceDetails(service, wsdls, namespaces);
            ret.append("\t\t\t<interface.wsdl interface=\"" + wsdlInterface + "\"/>\r\n");
            ret.append("\t\t\t<binding.soap xmlns=\"urn:switchyard-component-soap:config:1.0\" >\r\n");
            String wsdlInterfacePath = this.getInterfacePath(service, wsdls, namespaces);
            if (!wsdlPaths.contains(wsdlInterfacePath)) {
                ret.append("\t\t\t\t<wsdl>" + wsdlInterfacePath + "</wsdl>\r\n");
                wsdlPaths.add(wsdlInterfacePath);
            }
            ret.append("\t\t\t\t<socketAddr>:18001</socketAddr>\r\n");
            ret.append("\t\t\t</binding.soap>\r\n");
            ret.append("\t\t</service>\r\n");
        }
        return ret.toString();
    }

    protected String generateReferences(String compositeName, Element process, Map<String, Definition> wsdls, Map<String, String> namespaces) {
        StringBuffer ret = new StringBuffer();
        NodeList nl = process.getElementsByTagName("invoke");
        for (int i = 0; i < nl.getLength(); ++i) {
            NodeList services;
            Node n = nl.item(i);
            if (!(n instanceof Element) || (services = ((Element)n).getElementsByTagName("service")).getLength() != 1 || !(services.item(0) instanceof Element)) continue;
            Element service = (Element)services.item(0);
            String wsdlInterface = this.getInterfaceDetails(service, wsdls, namespaces);
            String name = this.getComponentName(compositeName);
            String servName = this.getServiceName(service);
            ret.append("\t\t<reference name=\"" + servName + "\" promote=\"" + name + "/" + servName + "\" multiplicity=\"1..1\" >\r\n");
            ret.append("\t\t\t<interface.wsdl interface=\"" + wsdlInterface + "\"/>\r\n");
            ret.append("\t\t\t<binding.soap xmlns=\"urn:switchyard-component-soap:config:1.0\" >\r\n");
            String wsdlInterfacePath = this.getInterfacePath(service, wsdls, namespaces);
            ret.append("\t\t\t\t<wsdl>" + wsdlInterfacePath + "</wsdl>\r\n");
            ret.append("\t\t\t\t<socketAddr>:18001</socketAddr>\r\n");
            ret.append("\t\t\t</binding.soap>\r\n");
            ret.append("\t\t</reference>\r\n");
        }
        return ret.toString();
    }

    protected String generateComponent(String compositeName, Element process, Map<String, Definition> wsdls, Map<String, String> namespaces) {
        String wsdlInterface;
        Element service;
        NodeList services;
        Node n;
        int i;
        StringBuffer ret = new StringBuffer();
        String name = this.getComponentName(compositeName);
        ret.append("\t\t<component name=\"" + name + "\">\r\n");
        ret.append("\t\t\t<implementation.bpel xmlns=\"http://docs.oasis-open.org/ns/opencsa/sca/200903\" process=\"" + process.getAttribute("name") + "\" />\r\n");
        NodeList nl = process.getElementsByTagName("provide");
        for (i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            if (!(n instanceof Element) || (services = ((Element)n).getElementsByTagName("service")).getLength() != 1 || !(services.item(0) instanceof Element)) continue;
            service = (Element)services.item(0);
            wsdlInterface = this.getInterfaceDetails(service, wsdls, namespaces);
            ret.append("\t\t\t<service name=\"" + this.getServiceName(service) + "\" >\r\n");
            ret.append("\t\t\t\t<interface.wsdl interface=\"" + wsdlInterface + "\"/>\r\n");
            ret.append("\t\t\t</service>\r\n");
        }
        nl = process.getElementsByTagName("invoke");
        for (i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            if (!(n instanceof Element) || (services = ((Element)n).getElementsByTagName("service")).getLength() != 1 || !(services.item(0) instanceof Element)) continue;
            service = (Element)services.item(0);
            wsdlInterface = this.getInterfaceDetails(service, wsdls, namespaces);
            ret.append("\t\t\t<reference name=\"" + this.getServiceName(service) + "\" >\r\n");
            ret.append("\t\t\t\t<interface.wsdl interface=\"" + wsdlInterface + "\"/>\r\n");
            ret.append("\t\t\t</reference>\r\n");
        }
        ret.append("\t\t</component>\r\n");
        return ret.toString();
    }

    protected String getInterfaceDetails(Element service, Map<String, Definition> wsdls, Map<String, String> namespaces) {
        String ret = null;
        String namespace = null;
        String localPart = service.getAttribute("name");
        int index = localPart.indexOf(58);
        if (index != -1) {
            namespace = namespaces.get(localPart.substring(0, index));
            localPart = localPart.substring(index + 1);
        }
        QName qname = new QName(namespace, localPart);
        for (String path : wsdls.keySet()) {
            Definition wsdl = wsdls.get(path);
            Service serv = wsdl.getService(qname);
            if (serv == null) continue;
            Port port = (Port)serv.getPorts().values().iterator().next();
            if (port != null) {
                String portType = port.getBinding().getPortType().getQName().getLocalPart();
                ret = path + "#wsdl.porttype(" + portType + ")";
                break;
            }
            logger.severe("Unable to find port type associated with service '" + qname + "'");
            break;
        }
        return ret;
    }

    protected String getInterfacePath(Element service, Map<String, Definition> wsdls, Map<String, String> namespaces) {
        String ret = null;
        String namespace = null;
        String localPart = service.getAttribute("name");
        int index = localPart.indexOf(58);
        if (index != -1) {
            namespace = namespaces.get(localPart.substring(0, index));
            localPart = localPart.substring(index + 1);
        }
        QName qname = new QName(namespace, localPart);
        for (String path : wsdls.keySet()) {
            Definition wsdl = wsdls.get(path);
            Service serv = wsdl.getService(qname);
            if (serv == null) continue;
            ret = path;
            break;
        }
        return ret;
    }

    protected String getComponentName(String name) {
        return name + "Component";
    }

    protected String getServiceName(Element service) {
        String ret = service.getAttribute("name");
        int index = ret.indexOf(58);
        if (index != -1) {
            ret = ret.substring(index + 1);
        }
        return ret;
    }
}

