/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.util;

import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.savara.common.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageUtil {
    private static Logger logger = Logger.getLogger(MessageUtil.class.getName());

    public static boolean isValid(String paramValue, Object mesgValue) {
        boolean ret = false;
        if (mesgValue instanceof String && !(ret = paramValue.equals(mesgValue))) {
            try {
                mesgValue = XMLUtils.getNode((String)((String)mesgValue));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mesgValue instanceof Node) {
            try {
                logger.info("Validating value=" + XMLUtils.toText((Node)((Node)mesgValue)));
                Node paramValueNode = XMLUtils.getNode((String)paramValue);
                if (paramValueNode != null) {
                    ret = MessageUtil.isValid(paramValueNode, (Node)mesgValue);
                } else {
                    logger.severe("Parameter value is not XML");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static boolean isValid(Node paramValue, Node mesgValue) {
        boolean ret = false;
        if (paramValue instanceof Attr && mesgValue instanceof Attr) {
            ret = ((Attr)paramValue).getValue().equals(((Attr)mesgValue).getValue());
            logger.info("isValid Attribute: " + ((Attr)paramValue).getValue() + " = " + ((Attr)mesgValue).getValue() + " ? " + ret);
        } else if (paramValue instanceof Element && mesgValue instanceof Element) {
            Element paramElem = (Element)paramValue;
            Element mesgElem = (Element)mesgValue;
            if (mesgElem.getLocalName().equals("return")) {
                ret = true;
            } else if (paramElem.getLocalName().equals(mesgElem.getLocalName())) {
                ret = true;
            } else {
                logger.info("isValid: element name mismatch, param=" + paramElem.getLocalName() + " mesg=" + mesgElem.getLocalName());
            }
            String instructions = "";
            if (paramElem.getPreviousSibling() instanceof Comment) {
                instructions = ((Comment)paramElem.getPreviousSibling()).getTextContent();
            }
            NamedNodeMap map = paramElem.getAttributes();
            for (int i = 0; ret && i < map.getLength(); ++i) {
                Attr paramAttr = (Attr)map.item(i);
                if (paramAttr.getName().startsWith("xmlns:") || paramAttr.getName().endsWith(":schemaLocation") || instructions.indexOf("@IgnoreAttr(" + paramAttr.getName() + ")") != -1) continue;
                Attr mesgAttr = mesgElem.getAttributeNode(paramAttr.getName());
                if (mesgAttr == null) {
                    logger.info("No attribute for '" + paramAttr.getName() + "'");
                    ret = false;
                    continue;
                }
                if (MessageUtil.isValid(paramAttr, mesgAttr)) continue;
                logger.info("Attribute '" + paramAttr.getName() + "' has different values");
                ret = false;
            }
            List<Element> paramnl = MessageUtil.getChildElements(paramElem);
            List<Element> mesgnl = MessageUtil.getChildElements(mesgElem);
            for (int i = 0; ret && i < paramnl.size(); ++i) {
                Element pn = paramnl.get(i);
                boolean matched = false;
                boolean ignore = instructions.indexOf("@IgnoreElem(" + pn.getNodeName() + ")") != -1;
                for (int j = 0; !matched && j < mesgnl.size(); ++j) {
                    Element mn = mesgnl.get(j);
                    if (!pn.getNodeName().equals(mn.getNodeName())) continue;
                    if (ignore) {
                        mesgnl.remove(j);
                        continue;
                    }
                    if (!MessageUtil.isValid(pn, mn)) continue;
                    matched = true;
                    mesgnl.remove(j);
                    break;
                }
                if (ignore || matched) continue;
                ret = false;
            }
            if (mesgnl.size() > 0) {
                ret = false;
            }
        }
        return ret;
    }

    protected static List<Element> getChildElements(Element elem) {
        Vector<Element> ret = new Vector<Element>();
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            ret.add((Element)nl.item(i));
        }
        return ret;
    }
}

