/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulation;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.savara.common.resources.DefaultResourceLocator;
import org.savara.common.resources.ResourceLocator;
import org.savara.scenario.model.Event;
import org.savara.scenario.model.MessageEvent;
import org.savara.scenario.model.Role;
import org.savara.scenario.model.Scenario;
import org.savara.scenario.simulation.DefaultSimulationContext;
import org.savara.scenario.simulation.RoleSimulator;
import org.savara.scenario.simulation.ScenarioSimulator;
import org.savara.scenario.simulation.ScenarioSimulatorFactory;
import org.savara.scenario.simulation.SimulationContext;
import org.savara.scenario.simulation.SimulationHandler;
import org.savara.scenario.simulation.SimulationModel;
import org.savara.scenario.simulation.model.RoleDetails;
import org.savara.scenario.simulation.model.Simulation;
import org.savara.scenario.simulation.model.SimulatorDetails;
import org.savara.scenario.util.ScenarioModelUtil;
import org.savara.scenario.util.SimulationModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioSimulatorMain {
    private static final Logger logger = Logger.getLogger(ScenarioSimulatorMain.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: ScenarioSimulatorMain simulation");
            System.exit(1);
        }
        Simulation simulation = null;
        try {
            File f;
            InputStream is = ClassLoader.getSystemResourceAsStream(args[0]);
            if (is == null && (f = new File(args[0])).exists()) {
                is = new FileInputStream(f);
            }
            if (is != null) {
                simulation = SimulationModelUtil.deserialize(is);
                is.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to load scenario simulation '" + args[0] + "'", e);
        }
        if (simulation != null) {
            ScenarioSimulatorMain simulator = new ScenarioSimulatorMain();
            int exitCode = simulator.simulate(simulation);
            System.out.flush();
            System.err.flush();
            try {
                ScenarioSimulatorMain scenarioSimulatorMain = simulator;
                synchronized (scenarioSimulatorMain) {
                    simulator.wait(1000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.exit(exitCode);
        } else {
            System.exit(1);
        }
    }

    public int simulate(Simulation simulation) {
        return this.simulate(simulation, null);
    }

    public int simulate(Simulation simulation, SimulationHandler handler) {
        int ret = -1;
        Scenario scenario = this.loadScenario(simulation);
        if (scenario != null) {
            handler = handler == null ? new ConsoleSimulationHandler() : new ProxySimulationHandler(handler);
            Map<Role, RoleSimulator> roleSimulators = this.loadRoleSimulators(scenario, simulation);
            Map<Role, SimulationContext> contexts = this.loadSimulationContexts(scenario, simulation, roleSimulators, handler);
            ScenarioSimulator simulator = this.getSimulator();
            if (simulator != null) {
                try {
                    simulator.simulate(scenario, roleSimulators, contexts, handler);
                    if (!((SimulationHandlerBase)handler).isFailed()) {
                        ret = 0;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to simulate", e);
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Simulation completed with code: " + ret);
        }
        return ret;
    }

    protected ScenarioSimulator getSimulator() {
        return ScenarioSimulatorFactory.getScenarioSimulator();
    }

    protected Map<Role, RoleSimulator> loadRoleSimulators(Scenario scenario, Simulation simulation) {
        HashMap<Role, RoleSimulator> ret = new HashMap<Role, RoleSimulator>();
        for (Role role : scenario.getRole()) {
            block3: for (RoleDetails details : simulation.getRoles()) {
                if (!details.getScenarioRole().equals(role.getName())) continue;
                for (SimulatorDetails simdetails : simulation.getSimulators()) {
                    if (!simdetails.getName().equals(details.getSimulator())) continue;
                    try {
                        Class<?> cls = Class.forName(simdetails.getClassName());
                        Object obj = cls.newInstance();
                        if (!(obj instanceof RoleSimulator)) continue;
                        ret.put(role, (RoleSimulator)obj);
                        continue block3;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to instantiate role simulator '" + details.getSimulator() + "'", e);
                    }
                }
            }
        }
        return ret;
    }

    protected Map<Role, SimulationContext> loadSimulationContexts(Scenario scenario, Simulation simulation, Map<Role, RoleSimulator> roleSimulators, SimulationHandler handler) {
        HashMap<Role, SimulationContext> ret = new HashMap<Role, SimulationContext>();
        for (Role role : scenario.getRole()) {
            for (RoleDetails details : simulation.getRoles()) {
                if (!details.getScenarioRole().equals(role.getName())) continue;
                handler.roleStart(role);
                RoleSimulator rsim = roleSimulators.get(role);
                try {
                    File f;
                    InputStream is = ClassLoader.getSystemResourceAsStream(details.getModel());
                    if (is == null && (f = new File(details.getModel())).exists()) {
                        is = new FileInputStream(f);
                    }
                    if (is != null) {
                        SimulationContext context = this.loadContext(simulation, role, details, rsim);
                        if (context != null) {
                            logger.fine("Adding context for role '" + role.getName() + "'");
                            ret.put(role, context);
                            handler.roleInitialized(role);
                        } else {
                            handler.roleFailed(role, "Failed to load context for role '" + role.getName() + "'");
                        }
                        is.close();
                        continue;
                    }
                    handler.roleFailed(role, "Failed to find model '" + details.getModel() + "'");
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to load simulation model '" + details.getModel() + "'", e);
                    handler.roleFailed(role, "Failed to load simulation model '" + details.getModel() + "': " + e);
                }
            }
        }
        return ret;
    }

    protected Scenario loadScenario(Simulation simulation) {
        Scenario scenario = null;
        try {
            File f;
            InputStream is = ClassLoader.getSystemResourceAsStream(simulation.getScenario());
            if (is == null && (f = new File(simulation.getScenario())).exists()) {
                is = new FileInputStream(f);
            }
            if (is != null) {
                scenario = ScenarioModelUtil.deserialize(is);
                is.close();
            } else {
                logger.severe("Failed to find scenario '" + simulation.getScenario() + "'");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to load scenario '" + simulation.getScenario() + "'", e);
        }
        return scenario;
    }

    protected SimulationContext loadContext(Simulation simulation, Role role, RoleDetails details, RoleSimulator rsim) throws Exception {
        DefaultSimulationContext ret = null;
        URL url = ClassLoader.getSystemResource(simulation.getScenario());
        File f = null;
        if (url != null) {
            f = new File(url.getFile());
        } else {
            f = new File(simulation.getScenario());
            if (!f.exists()) {
                f = null;
            }
        }
        if (f != null) {
            ret = new DefaultSimulationContext(f);
            InputStream is = null;
            File modelFile = null;
            url = ClassLoader.getSystemResource(details.getModel());
            if (url != null) {
                is = url.openStream();
                modelFile = new File(url.getFile());
            } else {
                modelFile = new File(details.getModel());
                if (modelFile.exists()) {
                    is = new FileInputStream(modelFile);
                } else {
                    modelFile = null;
                }
            }
            if (modelFile != null && is != null) {
                DefaultResourceLocator locator = new DefaultResourceLocator(modelFile.getParentFile());
                Object model = rsim.getModel(new SimulationModel(modelFile.getAbsolutePath(), is), (ResourceLocator)locator);
                if (model != null) {
                    if (rsim.getModelRoles(model).size() == 0) {
                        ret.setModel(model);
                    } else {
                        Role localRole = role;
                        if (details.getModelRole() != null) {
                            localRole = new Role();
                            localRole.setName(details.getModelRole());
                        }
                        if ((model = rsim.getModelForRole(model, localRole, (ResourceLocator)locator)) == null) {
                            ret = null;
                        } else {
                            ret.setModel(model);
                        }
                    }
                } else {
                    ret = null;
                }
                is.close();
            } else {
                ret = null;
            }
        } else {
            logger.severe("Failed to locate scenario '" + simulation.getScenario() + "'");
        }
        return ret;
    }

    public class ProxySimulationHandler
    extends SimulationHandlerBase {
        private SimulationHandler m_handler;

        public ProxySimulationHandler(SimulationHandler handler) {
            this.m_handler = null;
            this.m_handler = handler;
        }

        public void roleStart(Role role) {
            super.roleStart(role);
            this.m_handler.roleStart(role);
        }

        public void roleInitialized(Role role) {
            super.roleInitialized(role);
            this.m_handler.roleInitialized(role);
        }

        public void roleFailed(Role role, String mesg) {
            super.roleFailed(role, mesg);
            this.m_handler.roleFailed(role, mesg);
        }

        public void start(Event event) {
            super.start(event);
            this.m_handler.start(event);
        }

        public void end(Event event) {
            super.end(event);
            this.m_handler.end(event);
        }

        public void noSimulator(Event event) {
            super.noSimulator(event);
            this.m_handler.noSimulator(event);
        }

        public void processed(Event event) {
            super.processed(event);
            this.m_handler.processed(event);
        }

        public void unexpected(Event event) {
            super.unexpected(event);
            this.m_handler.unexpected(event);
        }

        public void error(String mesg, Event event, Throwable e) {
            super.error(mesg, event, e);
            this.m_handler.error(mesg, event, e);
        }
    }

    public class ConsoleSimulationHandler
    extends SimulationHandlerBase {
        public void roleStart(Role role) {
            super.roleStart(role);
            System.err.println(">>> ROLE_START [" + role.getName() + "]");
        }

        public void roleInitialized(Role role) {
            super.roleInitialized(role);
            System.err.println(">>> ROLE_INIT [" + role.getName() + "]");
        }

        public void roleFailed(Role role, String mesg) {
            super.roleFailed(role, mesg);
            System.err.println(">>> ROLE_FAIL [" + role.getName() + "] " + mesg);
        }

        public void start(Event event) {
            super.start(event);
            System.err.println(">>> START [ID=" + event.getId() + "]");
        }

        public void end(Event event) {
            super.end(event);
            System.err.println(">>> END [ID=" + event.getId() + "]");
        }

        public void noSimulator(Event event) {
            super.noSimulator(event);
            System.err.println(">>> NO_SIMULATOR [ID=" + event.getId() + "]");
        }

        public void processed(Event event) {
            super.processed(event);
            this.success(event, this.printable(event));
        }

        public void unexpected(Event event) {
            super.unexpected(event);
            this.failure(event, this.printable(event));
        }

        public void error(String mesg, Event event, Throwable e) {
            super.error(mesg, event, e);
            this.failure(event, this.printable(event) + "[" + mesg + "]");
        }

        protected void success(Event event, String mesg) {
            System.err.println(">>> SUCCESS [ID=" + event.getId() + "] " + mesg);
        }

        protected void failure(Event event, String mesg) {
            System.err.println(">>> FAIL [ID=" + event.getId() + "] " + mesg);
        }
    }

    public class SimulationHandlerBase
    implements SimulationHandler {
        private boolean m_failed = false;

        public void roleStart(Role role) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ROLE_START: " + role.getName());
            }
        }

        public void roleInitialized(Role role) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ROLE_INITIALIZED: " + role.getName());
            }
        }

        public void roleFailed(Role role, String mesg) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ROLE_FAILURE: " + role.getName() + " [" + mesg + "]");
            }
        }

        public void start(Event event) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("START: " + this.printable(event));
            }
        }

        public void end(Event event) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("END: " + this.printable(event));
            }
        }

        public void noSimulator(Event event) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("NO SIMULATOR: " + this.printable(event));
            }
        }

        public void processed(Event event) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("PROCESSED: " + this.printable(event));
            }
        }

        public void unexpected(Event event) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("UNEXPECTED: " + this.printable(event));
            }
            this.setFailed(true);
        }

        public void error(String mesg, Event event, Throwable e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ERROR: " + event.getId() + " \"" + mesg + "\"", e);
            }
            this.setFailed(true);
        }

        public boolean isFailed() {
            return this.m_failed;
        }

        protected void setFailed(boolean b) {
            this.m_failed = b;
        }

        protected String printable(Event event) {
            String ret = null;
            if (event instanceof MessageEvent) {
                MessageEvent me = (MessageEvent)event;
                ret = event.getClass().getSimpleName() + "[" + event.getId() + "] " + me.getOperationName() + "(";
                for (int i = 0; i < me.getParameter().size(); ++i) {
                    if (i != 0) {
                        ret = ret + ",";
                    }
                    ret = ret + me.getParameter().get(i).getValue();
                }
                ret = ret + ")";
            }
            if (event.isErrorExpected()) {
                ret = ret + " (Error Expected)";
            }
            return ret;
        }
    }
}

