/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.savara.scenario.simulation;

import org.savara.scenario.model.Role;
import org.savara.scenario.model.Scenario;

/**
 * This interface defines the scenario simulator.
 *
 */
public interface ScenarioSimulator {

	/**
	 * This method simulates the scenario against the pre-configured
	 * monitor. Results from the simulation are notified to the
	 * supplied simulation handler.
	 * 
	 * @param scenario The scenario to be simulated
	 * @param roleSimulators The simulators for the relevant roles in the scenario
	 * @oaram contexts The simulation contexts for each role being simulated
	 * @param handler The callback to notify of the simulation results
	 * @throws Exception Failed to simulate
	 */
	public void simulate(Scenario scenario, java.util.Map<Role,RoleSimulator> roleSimulators,
			java.util.Map<Role,SimulationContext> contexts, SimulationHandler handler) throws Exception;
	
}
