/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulation;

import java.text.MessageFormat;
import java.util.Map;
import java.util.PropertyResourceBundle;
import org.savara.scenario.model.Event;
import org.savara.scenario.model.Role;
import org.savara.scenario.model.RoleEvent;
import org.savara.scenario.model.Scenario;
import org.savara.scenario.simulation.RoleSimulator;
import org.savara.scenario.simulation.ScenarioSimulator;
import org.savara.scenario.simulation.SimulationContext;
import org.savara.scenario.simulation.SimulationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScenarioSimulator
implements ScenarioSimulator {
    @Override
    public void simulate(Scenario scenario, Map<Role, RoleSimulator> roleSimulators, Map<Role, SimulationContext> contexts, SimulationHandler handler) {
        for (Event event : scenario.getEvent()) {
            if (event instanceof RoleEvent) {
                this.simulateAtRole((Role)((RoleEvent)event).getRole(), event, roleSimulators, contexts, handler);
                continue;
            }
            for (Role role : roleSimulators.keySet()) {
                this.simulateAtRole(role, event, roleSimulators, contexts, handler);
            }
        }
    }

    protected void simulateAtRole(Role role, Event event, Map<Role, RoleSimulator> roleSimulators, Map<Role, SimulationContext> contexts, SimulationHandler handler) {
        RoleSimulator sim = roleSimulators.get(role);
        if (sim != null) {
            SimulationContext context = contexts.get(role);
            if (context != null) {
                sim.onEvent(context, event, handler);
            } else {
                handler.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.savara.scenario.Messages").getString("SAVARASCN-00001"), role.getName()), event, null);
            }
        } else {
            handler.noSimulator(event);
        }
    }
}

