/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.parser.rules;

import java.util.List;
import org.savara.bpel.model.TReply;
import org.savara.bpel.model.TVariable;
import org.savara.bpel.parser.rules.ParserContext;
import org.savara.bpel.parser.rules.ProtocolParserRule;
import org.savara.bpel.util.BPELInteractionUtil;
import org.savara.bpel.util.PartnerLinkUtil;
import org.savara.bpel.util.TypeReferenceUtil;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.model.annotation.Annotation;
import org.savara.protocol.model.util.InteractionUtil;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplyParserRule
implements ProtocolParserRule {
    @Override
    public boolean isSupported(Object component) {
        return component instanceof TReply;
    }

    @Override
    public void parse(ParserContext context, Object component, List<Activity> activities, FeedbackHandler handler) {
        Annotation annotation;
        TReply reply = (TReply)component;
        Interaction interaction = new Interaction();
        TVariable var = context.getVariable(reply.getVariable());
        String xmlType = BPELInteractionUtil.getXMLType(context.getProcess(), var.getMessageType(), context.getResourceLocator());
        TypeReference tref = TypeReferenceUtil.createTypeReference(xmlType, context);
        MessageSignature ms = new MessageSignature();
        ms.setOperation(reply.getOperation());
        ms.getTypeReferences().add(tref);
        String toRole = PartnerLinkUtil.getServerPartnerRole(reply.getPartnerLink());
        if (toRole != null) {
            interaction.getToRoles().add(new Role(toRole));
        }
        interaction.setMessageSignature(ms);
        if (reply.getFaultName() != null) {
            ms.setOperation(InteractionUtil.getOperator((String)reply.getOperation(), (String)reply.getFaultName().getLocalPart()));
            annotation = new Annotation("Fault");
            annotation.getProperties().put("name", reply.getFaultName().getLocalPart());
            interaction.getAnnotations().add(annotation);
        }
        annotation = new Annotation("Correlation");
        annotation.getProperties().put("replyTo", reply.getOperation());
        interaction.getAnnotations().add(annotation);
        activities.add((Activity)interaction);
    }
}

