/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.model.change;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.savara.protocol.model.util.InteractionUtil;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Parallel;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolReference;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.util.ActivityUtil;
import org.scribble.protocol.util.RunUtil;

public class InteractionPatterns {
    private static final Logger logger = Logger.getLogger(InteractionPatterns.class.getName());

    public static boolean isFaultHandlerRequired(Interaction interaction) {
        Block block;
        int pos;
        boolean ret = false;
        if (InteractionUtil.isRequest((Interaction)interaction) && InteractionUtil.getRequestLabel((Interaction)interaction) != null && interaction.getParent() instanceof Block && (pos = (block = (Block)interaction.getParent()).getContents().indexOf(interaction)) != -1 && pos < block.getContents().size() - 1) {
            Activity act = (Activity)block.getContents().get(pos + 1);
            ret = InteractionPatterns.isFaultHandlerChoice(act);
        }
        return ret;
    }

    protected static boolean isFaultHandlerChoice(Activity act) {
        boolean ret;
        block3: {
            block4: {
                ret = false;
                if (!(act instanceof Choice)) break block4;
                Choice choice = (Choice)act;
                if (choice.getPaths().size() > 0) {
                    ret = true;
                }
                for (int i = 0; ret && i < choice.getPaths().size(); ++i) {
                    Interaction intn = InteractionPatterns.getFirstInteraction((Block)choice.getPaths().get(0));
                    if (intn == null) continue;
                    ret = !InteractionUtil.isRequest((Interaction)intn);
                }
                break block3;
            }
            if (!(act instanceof Parallel)) break block3;
            Parallel par = (Parallel)act;
            for (Block b : par.getPaths()) {
                if (b.size() <= 0 || !InteractionPatterns.isFaultHandlerChoice(b.get(0))) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static boolean isResponseAndFaultHandler(Choice choice) {
        boolean ret = choice.getPaths().size() > 0;
        String label = null;
        for (int i = 0; ret && i < choice.getPaths().size(); ++i) {
            Block path = (Block)choice.getPaths().get(i);
            Interaction interaction = InteractionPatterns.getFirstInteraction(path);
            if (interaction == null) continue;
            if (i == 0) {
                label = InteractionUtil.getReplyToLabel((Interaction)interaction);
                if (label != null && !InteractionUtil.isRequest((Interaction)interaction) && !InteractionUtil.isSend((Interaction)interaction)) continue;
                ret = false;
                continue;
            }
            String replyTo = InteractionUtil.getReplyToLabel((Interaction)interaction);
            if (replyTo != null && replyTo.equals(label) && !InteractionUtil.isRequest((Interaction)interaction) && !InteractionUtil.isSend((Interaction)interaction)) continue;
            ret = false;
        }
        return ret;
    }

    public static Interaction getPickPathInteraction(Block path) {
        Interaction ret = null;
        if (path.getContents().size() > 0) {
            Activity sub = (Activity)path.getContents().get(0);
            if (sub instanceof Run) {
                Protocol defn = RunUtil.getInnerProtocol((Protocol)((Run)sub).getEnclosingProtocol(), (ProtocolReference)((Run)sub).getProtocolReference());
                Activity b = null;
                for (int j = 0; b == null && j < defn.getBlock().getContents().size(); ++j) {
                    if (ActivityUtil.isDeclaration((Activity)((Activity)defn.getBlock().getContents().get(j)))) continue;
                    b = (Activity)defn.getBlock().getContents().get(j);
                }
                if (b != null) {
                    sub = b;
                }
            }
            if (sub instanceof Interaction) {
                ret = (Interaction)sub;
            }
        }
        return ret;
    }

    public static boolean isInteractionPickPathTrigger(Interaction in) {
        boolean ret = false;
        Block path = (Block)in.getParent();
        if (path.getParent() instanceof Choice && InteractionPatterns.isSwitch((Choice)path.getParent())) {
            ret = true;
        } else if (!InteractionUtil.isSend((Interaction)in) && path.getParent() instanceof Protocol && path.getParent().getParent() instanceof Protocol) {
            ret = true;
        }
        return ret;
    }

    public static boolean isSwitch(Choice choice) {
        boolean ret = false;
        if (choice.getRole() == null || !choice.getRole().equals((Object)choice.getEnclosingProtocol().getLocatedRole())) {
            ret = true;
        }
        return ret;
    }

    public static Interaction getRequestForResponseInFaultHandler(Interaction interaction) {
        Choice choice;
        Interaction ret = null;
        if (!InteractionUtil.isRequest((Interaction)interaction) && InteractionUtil.getReplyToLabel((Interaction)interaction) != null && interaction.getParent() instanceof Block && interaction.getParent().getParent() instanceof Choice && (choice = (Choice)interaction.getParent().getParent()).getParent() instanceof Block) {
            Block block = (Block)choice.getParent();
            int pos = block.getContents().indexOf(choice);
            if (pos != -1 && pos > 0) {
                Activity act = (Activity)block.getContents().get(pos - 1);
                if (act instanceof Interaction && InteractionUtil.isRequest((Interaction)((Interaction)act)) && InteractionUtil.getRequestLabel((Interaction)((Interaction)act)) != null && InteractionUtil.getReplyToLabel((Interaction)interaction).equals(InteractionUtil.getRequestLabel((Interaction)((Interaction)act)))) {
                    ret = (Interaction)act;
                }
            } else if (block.getParent() instanceof Parallel && block.getParent().getParent() instanceof Block) {
                Activity act;
                Parallel par = (Parallel)block.getParent();
                pos = (block = (Block)block.getParent().getParent()).getContents().indexOf(par);
                if (pos != -1 && pos > 0 && (act = (Activity)block.getContents().get(pos - 1)) instanceof Interaction && InteractionUtil.isRequest((Interaction)((Interaction)act)) && InteractionUtil.getRequestLabel((Interaction)((Interaction)act)) != null && InteractionUtil.getReplyToLabel((Interaction)interaction).equals(InteractionUtil.getRequestLabel((Interaction)((Interaction)act)))) {
                    ret = (Interaction)act;
                }
            }
        }
        return ret;
    }

    public static boolean isResponseInFaultHandler(Interaction interaction) {
        return InteractionPatterns.getRequestForResponseInFaultHandler(interaction) != null;
    }

    public static boolean isSyncNormalResponse(Interaction interaction) {
        Block block;
        int pos;
        boolean ret = false;
        if (InteractionUtil.isResponse((Interaction)interaction) && interaction.getParent() instanceof Block && (pos = (block = (Block)interaction.getParent()).getContents().indexOf(interaction)) > 0 && block.getContents().get(pos - 1) instanceof Interaction) {
            Interaction req = (Interaction)block.getContents().get(pos - 1);
            ret = InteractionPatterns.isResponseForRequest(interaction, req);
        }
        return ret;
    }

    public static boolean isResponseForRequest(Interaction resp, Interaction req) {
        boolean ret = false;
        if (InteractionUtil.isRequest((Interaction)req) && InteractionUtil.isResponse((Interaction)resp) && InteractionUtil.getReplyToLabel((Interaction)resp).equals(InteractionUtil.getRequestLabel((Interaction)req))) {
            ret = true;
        }
        return ret;
    }

    public static Interaction getFirstInteraction(Block path) {
        Interaction ret = null;
        List interactions = org.scribble.protocol.util.InteractionUtil.getInitialInteractions((ModelObject)path);
        if (interactions.size() != 1) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Path has " + interactions.size() + " interactions");
            }
        } else if (!(interactions.get(0) instanceof Interaction)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Path 'interaction' is not of type Interaction");
            }
        } else {
            ret = (Interaction)interactions.get(0);
        }
        return ret;
    }
}

