/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.savara.bpel.model.TPartnerLink;
import org.savara.bpel.model.TProcess;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.util.XMLUtils;
import org.savara.contract.model.Contract;
import org.savara.contract.model.Interface;
import org.savara.protocol.contract.generator.ContractGenerator;
import org.savara.protocol.contract.generator.ContractGeneratorFactory;
import org.savara.wsdl.util.WSDLGeneratorUtil;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELGeneratorUtil {
    private static final String USE_PEER2_PEER = "usePeer2Peer";
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final String SERVICE_LABEL = "service";
    private static final String PROVIDE_LABEL = "provide";
    private static final String PARTNER_LINK_LABEL = "partnerLink";
    private static final String INVOKE_LABEL = "invoke";
    private static final String ACTIVE_LABEL = "active";
    private static final String PROCESS_LABEL = "process";
    private static final String DEPLOY_LABEL = "deploy";
    private static final String APACHE_ODE_NAMESPACE = "http://www.apache.org/ode/schemas/dd/2007/03";
    private static final String NAME_LABEL = "name";
    private static final String PROCESS_EVENTS_LABEL = "process-events";
    private static final String PORT_TYPE_LABEL = "portType";
    private static final String PLNK_PREFIX = "plnk";
    private static final String PLNK_ROLE = "plnk:role";
    private static final String PARTNER_LINK_TYPE = "partnerLinkType";
    private static final String PLNK_PARTNER_LINK_TYPE = "plnk:partnerLinkType";
    private static final String WSDL_DEFINITIONS = "wsdl:definitions";
    private static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    private static final String PLNKTYPE_NS = "http://docs.oasis-open.org/wsbpel/2.0/plnktype";
    private static final String XMLNS_WSDL = "xmlns:wsdl";
    private static final String XMLNS_PLNK = "xmlns:plnk";
    private static final String WSDL_IMPORT = "wsdl:import";
    private static final String TARGET_NAMESPACE_LABEL = "targetNamespace";

    public static Document generatePartnerLinkTypes(ProtocolModel model, Role role, ProtocolModel localcm, TProcess bpelProcess, FeedbackHandler journal) throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element defn = doc.createElement(WSDL_DEFINITIONS);
        doc.appendChild(defn);
        defn.setAttribute(XMLNS_PLNK, PLNKTYPE_NS);
        defn.setAttribute(XMLNS_WSDL, WSDL_NS);
        defn.setAttribute(NAME_LABEL, localcm.getProtocol().getName());
        defn.setAttribute(TARGET_NAMESPACE_LABEL, bpelProcess.getTargetNamespace());
        ContractGenerator cg = ContractGeneratorFactory.getContractGenerator();
        String wsdlName = WSDLGeneratorUtil.getWSDLFileName((Role)role, (String)localcm.getProtocol().getName(), (String)"");
        Element imp = doc.createElement(WSDL_IMPORT);
        imp.setAttribute("namespace", bpelProcess.getTargetNamespace());
        imp.setAttribute("location", wsdlName);
        defn.appendChild(imp);
        ListIterator roles = localcm.getProtocol().getRoles().listIterator();
        while (roles.hasNext()) {
            Role r = (Role)roles.next();
            if (localcm.getProtocol().getParameterDefinition(r.getName()) != null) continue;
            Contract contract = null;
            if (cg != null) {
                contract = cg.generate(model.getProtocol(), null, r, journal);
            }
            if (contract == null) continue;
            boolean gen = false;
            Iterator iter = contract.getInterfaces().iterator();
            while (!gen && iter.hasNext()) {
                Interface intf = (Interface)iter.next();
                if (intf.getMessageExchangePatterns().size() <= 0) continue;
                gen = true;
            }
            if (!gen) continue;
            wsdlName = WSDLGeneratorUtil.getWSDLFileName((Role)r, (String)localcm.getProtocol().getName(), (String)"");
            imp = doc.createElement(WSDL_IMPORT);
            imp.setAttribute("namespace", contract.getNamespace());
            imp.setAttribute("location", wsdlName);
            defn.appendChild(imp);
        }
        HashMap nsMap = new HashMap();
        for (TPartnerLink pl : bpelProcess.getPartnerLinks().getPartnerLink()) {
            Element plRole;
            Element plt = doc.createElement(PLNK_PARTNER_LINK_TYPE);
            plt.setAttribute(NAME_LABEL, pl.getPartnerLinkType().getLocalPart());
            if (pl.getPartnerRole() != null && pl.getPartnerRole().trim().length() > 0) {
                plRole = doc.createElement(PLNK_ROLE);
                plt.appendChild(plRole);
                plRole.setAttribute(NAME_LABEL, pl.getPartnerRole());
                Role useRole = null;
                for (int i = 0; useRole == null && i < localcm.getProtocol().getRoles().size(); ++i) {
                    if (!pl.getPartnerRole().startsWith(((Role)localcm.getProtocol().getRoles().get(i)).getName())) continue;
                    useRole = (Role)localcm.getProtocol().getRoles().get(i);
                }
                Contract contract = null;
                if (cg != null && useRole != null) {
                    contract = cg.generate(model.getProtocol(), null, useRole, journal);
                }
                if (contract != null) {
                    Interface intf = null;
                    if (pl.getMyRole() != null) {
                        intf = contract.getInterface(pl.getMyRole());
                    }
                    if (intf == null && contract.getInterfaces().size() > 0) {
                        intf = (Interface)contract.getInterfaces().iterator().next();
                    }
                    if (intf != null) {
                        String prefix = null;
                        String portType = intf.getName();
                        if (intf.getNamespace() != null) {
                            prefix = XMLUtils.getPrefixForNamespace((String)intf.getNamespace(), nsMap);
                            portType = prefix + ":" + portType;
                        }
                        plRole.setAttribute(PORT_TYPE_LABEL, portType);
                    }
                }
            }
            if (pl.getMyRole() != null && pl.getMyRole().trim().length() > 0) {
                plRole = doc.createElement(PLNK_ROLE);
                plt.appendChild(plRole);
                plRole.setAttribute(NAME_LABEL, pl.getMyRole());
                Contract contract = null;
                if (cg != null) {
                    String linkName = pl.getPartnerLinkType().getLocalPart();
                    int pos = linkName.indexOf("To");
                    if (pos != -1) {
                        HashSet<Role> clientRoles = new HashSet<Role>();
                        clientRoles.add(new Role(linkName.substring(0, pos)));
                        contract = cg.generate(model.getProtocol(), clientRoles, role, journal);
                    } else {
                        contract = cg.generate(model.getProtocol(), null, role, journal);
                    }
                }
                if (contract != null) {
                    Interface intf = null;
                    if (pl.getMyRole() != null) {
                        intf = contract.getInterface(pl.getMyRole());
                    }
                    if (intf == null && contract.getInterfaces().size() > 0) {
                        intf = (Interface)contract.getInterfaces().iterator().next();
                    }
                    if (intf != null) {
                        String prefix = null;
                        String portType = intf.getName();
                        if (intf.getNamespace() != null) {
                            prefix = XMLUtils.getPrefixForNamespace((String)intf.getNamespace(), nsMap);
                            portType = prefix + ":" + portType;
                        }
                        plRole.setAttribute(PORT_TYPE_LABEL, portType);
                    }
                }
            }
            defn.appendChild(plt);
        }
        for (String ns : nsMap.keySet()) {
            String prefix = (String)nsMap.get(ns);
            defn.setAttribute(XMLNS_PREFIX + prefix, ns);
        }
        return doc;
    }

    public static Document generateDeploymentDescriptor(ProtocolModel model, Role role, ProtocolModel localcm, TProcess bpelProcess, Collection<Definition> wsdls, Element partnerLinkTypes, FeedbackHandler journal) throws Exception {
        Element service;
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element defn = doc.createElementNS(APACHE_ODE_NAMESPACE, DEPLOY_LABEL);
        doc.appendChild(defn);
        HashMap<String, String> nsMap = new HashMap<String, String>();
        Element proc = doc.createElement(PROCESS_LABEL);
        defn.appendChild(proc);
        String name = bpelProcess.getName();
        if (bpelProcess.getTargetNamespace() != null) {
            String prefix = XMLUtils.getPrefixForNamespace((String)bpelProcess.getTargetNamespace(), nsMap);
            name = prefix + ":" + name;
        }
        proc.setAttribute(NAME_LABEL, name);
        Element active = doc.createElement(ACTIVE_LABEL);
        proc.appendChild(active);
        Text activeText = doc.createTextNode(Boolean.TRUE.toString());
        active.appendChild(activeText);
        Element processEvents = doc.createElement(PROCESS_EVENTS_LABEL);
        processEvents.setAttribute("generate", "all");
        proc.appendChild(processEvents);
        for (TPartnerLink pl : bpelProcess.getPartnerLinks().getPartnerLink()) {
            if (pl.getMyRole() == null || pl.getMyRole().trim().length() <= 0) continue;
            Element provide = doc.createElement(PROVIDE_LABEL);
            provide.setAttribute(PARTNER_LINK_LABEL, XMLUtils.getLocalname((String)pl.getName()));
            service = doc.createElement(SERVICE_LABEL);
            BPELGeneratorUtil.initializeService(service, bpelProcess, pl, wsdls, partnerLinkTypes, nsMap);
            provide.appendChild(service);
            proc.appendChild(provide);
        }
        for (TPartnerLink pl : bpelProcess.getPartnerLinks().getPartnerLink()) {
            if (pl.getPartnerRole() == null || pl.getPartnerRole().trim().length() <= 0) continue;
            Element invoke = doc.createElement(INVOKE_LABEL);
            invoke.setAttribute(PARTNER_LINK_LABEL, XMLUtils.getLocalname((String)pl.getName()));
            invoke.setAttribute(USE_PEER2_PEER, Boolean.FALSE.toString());
            service = doc.createElement(SERVICE_LABEL);
            BPELGeneratorUtil.initializeService(service, bpelProcess, pl, wsdls, partnerLinkTypes, nsMap);
            invoke.appendChild(service);
            proc.appendChild(invoke);
        }
        for (String ns : nsMap.keySet()) {
            String prefix = (String)nsMap.get(ns);
            defn.setAttribute(XMLNS_PREFIX + prefix, ns);
        }
        return doc;
    }

    protected static void initializeService(Element service, TProcess bpelProcess, TPartnerLink pl, Collection<Definition> wsdls, Element partnerLinkTypes, Map<String, String> nsMap) {
        QName serviceName = null;
        String servicePort = null;
        QName partnerLinkType = pl.getPartnerLinkType();
        NodeList nl = partnerLinkTypes.getChildNodes();
        String portType = null;
        for (int i = 0; portType == null && i < nl.getLength(); ++i) {
            Element plt;
            String name;
            Node n = nl.item(i);
            if (!(n instanceof Element) || !XMLUtils.getLocalname((String)n.getNodeName()).equals(PARTNER_LINK_TYPE) || (name = (plt = (Element)nl.item(i)).getAttribute(NAME_LABEL)) == null || !name.equals(partnerLinkType.getLocalPart())) continue;
            NodeList nl2 = plt.getChildNodes();
            for (int j = 0; portType == null && j < nl2.getLength(); ++j) {
                Node n2 = nl2.item(j);
                if (!(n2 instanceof Element) || !XMLUtils.getLocalname((String)n2.getNodeName()).equals("role")) continue;
                Element role = (Element)n2;
                String roleName = role.getAttribute(NAME_LABEL);
                if ((pl.getMyRole() == null || !pl.getMyRole().equals(roleName)) && (pl.getPartnerRole() == null || !pl.getPartnerRole().equals(roleName))) continue;
                portType = role.getAttribute(PORT_TYPE_LABEL);
                String ptprefix = XMLUtils.getPrefix((String)portType);
                String ptns = partnerLinkTypes.getAttribute(XMLNS_PREFIX + ptprefix);
                String newprefix = XMLUtils.getPrefixForNamespace((String)ptns, nsMap);
                portType = newprefix + ":" + XMLUtils.getLocalname((String)portType);
            }
        }
        if (portType != null) {
            String portTypePrefix = XMLUtils.getPrefix(portType);
            String portTypeNS = XMLUtils.getNamespaceForPrefix((String)portTypePrefix, nsMap);
            QName ptQName = new QName(portTypeNS, XMLUtils.getLocalname(portType));
            for (Definition wsdl : wsdls) {
                if (!wsdl.getTargetNamespace().equals(portTypeNS)) continue;
                Collection services = wsdl.getServices().values();
                for (Service s : services) {
                    Collection ports = s.getPorts().values();
                    for (Port p : ports) {
                        if (p.getBinding() == null || p.getBinding().getPortType() == null || !p.getBinding().getPortType().getQName().equals(ptQName)) continue;
                        serviceName = s.getQName();
                        servicePort = p.getName();
                    }
                }
            }
            if (serviceName != null) {
                String prefix = XMLUtils.getPrefixForNamespace((String)serviceName.getNamespaceURI(), nsMap);
                service.setAttribute(NAME_LABEL, prefix + ":" + serviceName.getLocalPart());
            }
            if (servicePort != null) {
                service.setAttribute("port", servicePort);
            }
        }
    }
}

