/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.parser;

import java.io.IOException;
import java.io.InputStream;
import org.savara.bpel.model.TPartnerLink;
import org.savara.bpel.model.TProcess;
import org.savara.bpel.parser.rules.DefaultConversionContext;
import org.savara.bpel.util.BPELModelUtil;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.parser.AnnotationProcessor;
import org.scribble.protocol.parser.ProtocolParser;

public class BPELProtocolParser
implements ProtocolParser {
    public boolean isSupported(String sourceType) {
        return sourceType.equals("bpel");
    }

    public ProtocolModel parse(InputStream is, Journal journal, ProtocolContext context) throws IOException {
        ProtocolModel ret = new ProtocolModel();
        TProcess process = BPELModelUtil.deserialize(is);
        Protocol protocol = new Protocol();
        ret.setProtocol(protocol);
        protocol.setName(process.getName());
        String role = null;
        if (process.getPartnerLinks() != null) {
            for (TPartnerLink pl : process.getPartnerLinks().getPartnerLink()) {
                if (pl.getMyRole() == null || pl.getMyRole().trim().length() <= 0) continue;
                role = pl.getMyRole();
                protocol.setRole(new Role(role));
                break;
            }
        }
        DefaultConversionContext convContext = new DefaultConversionContext(role, process, context);
        convContext.convert(process, protocol.getBlock().getContents(), journal);
        return ret;
    }

    public void setAnnotationProcessor(AnnotationProcessor ap) {
    }
}

