/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.model.change;

import org.savara.protocol.model.util.InteractionUtil;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolReference;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.When;
import org.scribble.protocol.util.ActivityUtil;
import org.scribble.protocol.util.RunUtil;

public class InteractionPatterns {
    public static boolean isFaultHandlerRequired(Interaction interaction) {
        Activity act;
        Block block;
        int pos;
        boolean ret = false;
        if (InteractionUtil.isRequest((Interaction)interaction) && InteractionUtil.getRequestLabel((Interaction)interaction) != null && interaction.getParent() instanceof Block && (pos = (block = (Block)interaction.getParent()).getContents().indexOf(interaction)) != -1 && pos < block.getContents().size() - 1 && (act = (Activity)block.getContents().get(pos + 1)) instanceof Choice) {
            Choice choice = (Choice)act;
            if (choice.getWhens().size() > 0) {
                ret = true;
            }
            for (int i = 0; ret && i < choice.getWhens().size(); ++i) {
                ret = !InteractionUtil.isRequest((When)((When)choice.getWhens().get(i)));
            }
        }
        return ret;
    }

    public static boolean isResponseAndFaultHandler(Choice choice) {
        boolean ret = choice.getWhens().size() > 0;
        String label = null;
        for (int i = 0; ret && i < choice.getWhens().size(); ++i) {
            When path = (When)choice.getWhens().get(i);
            if (i == 0) {
                label = InteractionUtil.getReplyToLabel((When)path);
                if (label != null && !InteractionUtil.isRequest((When)path) && !InteractionUtil.isSend((When)path)) continue;
                ret = false;
                continue;
            }
            String replyTo = InteractionUtil.getReplyToLabel((When)path);
            if (replyTo != null && replyTo.equals(label) && !InteractionUtil.isRequest((When)path) && !InteractionUtil.isSend((When)path)) continue;
            ret = false;
        }
        return ret;
    }

    public static Interaction getPickPathInteraction(Block path) {
        Interaction ret = null;
        if (path.getContents().size() > 0) {
            Activity sub = (Activity)path.getContents().get(0);
            if (sub instanceof Run) {
                Protocol defn = RunUtil.getInnerProtocol((Protocol)((Run)sub).enclosingProtocol(), (ProtocolReference)((Run)sub).getProtocolReference());
                Activity b = null;
                for (int j = 0; b == null && j < defn.getBlock().getContents().size(); ++j) {
                    if (ActivityUtil.isDeclaration((Activity)((Activity)defn.getBlock().getContents().get(j)))) continue;
                    b = (Activity)defn.getBlock().getContents().get(j);
                }
                if (b != null) {
                    sub = b;
                }
            }
            if (sub instanceof Interaction) {
                ret = (Interaction)sub;
            }
        }
        return ret;
    }

    public static boolean isInteractionPickPathTrigger(Interaction in) {
        boolean ret = false;
        Block path = (Block)in.getParent();
        if (path.getParent() instanceof Choice && InteractionPatterns.isSwitch((Choice)path.getParent())) {
            ret = true;
        } else if (!InteractionUtil.isSend((Interaction)in) && path.getParent() instanceof Protocol && path.getParent().getParent() instanceof Block && path.getParent().getParent().getParent() instanceof Protocol) {
            ret = true;
        }
        return ret;
    }

    public static boolean isSwitch(Choice choice) {
        boolean ret = false;
        if (choice.getFromRole() != null && choice.getToRole() == null) {
            ret = true;
        }
        return ret;
    }

    public static Interaction getRequestForResponseInFaultHandler(Interaction interaction) {
        Activity act;
        Block block;
        int pos;
        Choice choice;
        Interaction ret = null;
        if (!InteractionUtil.isRequest((Interaction)interaction) && InteractionUtil.getReplyToLabel((Interaction)interaction) != null && interaction.getParent() instanceof Block && interaction.getParent().getParent() instanceof Choice && (choice = (Choice)interaction.getParent().getParent()).getParent() instanceof Block && (pos = (block = (Block)choice.getParent()).getContents().indexOf(choice)) != -1 && pos > 0 && (act = (Activity)block.getContents().get(pos - 1)) instanceof Interaction && InteractionUtil.isRequest((Interaction)((Interaction)act)) && InteractionUtil.getRequestLabel((Interaction)((Interaction)act)) != null && InteractionUtil.getReplyToLabel((Interaction)interaction).equals(InteractionUtil.getRequestLabel((Interaction)((Interaction)act)))) {
            ret = (Interaction)act;
        }
        return ret;
    }

    public static boolean isResponseInFaultHandler(Interaction interaction) {
        return InteractionPatterns.getRequestForResponseInFaultHandler(interaction) != null;
    }

    public static boolean isSyncNormalResponse(Interaction interaction) {
        Block block;
        int pos;
        boolean ret = false;
        if (InteractionUtil.isResponse((Interaction)interaction) && interaction.getParent() instanceof Block && (pos = (block = (Block)interaction.getParent()).getContents().indexOf(interaction)) > 0 && block.getContents().get(pos - 1) instanceof Interaction) {
            Interaction req = (Interaction)block.getContents().get(pos - 1);
            ret = InteractionPatterns.isResponseForRequest(interaction, req);
        }
        return ret;
    }

    public static boolean isResponseForRequest(Interaction resp, Interaction req) {
        boolean ret = false;
        if (InteractionUtil.isRequest((Interaction)req) && InteractionUtil.isResponse((Interaction)resp) && InteractionUtil.getReplyToLabel((Interaction)resp).equals(InteractionUtil.getRequestLabel((Interaction)req))) {
            ret = true;
        }
        return ret;
    }
}

