/*
 * Decompiled with CFR 0.152.
 */
package org.rypt.f8;

import org.rypt.f8.Utf8;
import org.rypt.f8.Utf8Statistics;

public class Utf8StringBuilder
extends Utf8Statistics
implements CharSequence {
    protected final StringBuilder sb;

    public Utf8StringBuilder(StringBuilder sb) {
        this.sb = sb;
    }

    public Utf8StringBuilder() {
        this(new StringBuilder());
    }

    @Override
    public void handleCodePoint(int codePoint) {
        super.handleCodePoint(codePoint);
        this.sb.appendCodePoint(codePoint);
    }

    @Override
    public void reset() {
        super.reset();
        this.sb.setLength(0);
    }

    @Override
    public void handleError() {
        super.handleError();
        this.sb.append('\ufffd');
    }

    @Override
    public void handle1ByteCodePoint(int ascii) {
        super.handle1ByteCodePoint(ascii);
        this.sb.append((char)ascii);
    }

    @Override
    public void handle2ByteCodePoint(int b1, int b2) {
        super.handle2ByteCodePoint(b1, b2);
        this.sb.append((char)Utf8.codePoint(b1, b2));
    }

    @Override
    public void handle3ByteCodePoint(int b1, int b2, int b3) {
        super.handle3ByteCodePoint(b1, b2, b3);
        this.sb.append((char)Utf8.codePoint(b1, b2, b3));
    }

    @Override
    public void handle4ByteCodePoint(int b1, int b2, int b3, int b4) {
        super.handle4ByteCodePoint(b1, b2, b3, b4);
        int cp = Utf8.codePoint(b1, b2, b3, b4);
        this.sb.append(Character.highSurrogate(cp));
        this.sb.append(Character.lowSurrogate(cp));
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }
}

