/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ViewAnimator;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowViewGroup;

@Implements(value=ViewAnimator.class)
public class ShadowViewAnimator
extends ShadowViewGroup {
    private int currentChild = 0;

    @Implementation
    protected int getDisplayedChild() {
        return this.currentChild;
    }

    @Implementation
    protected void setDisplayedChild(int whichChild) {
        this.currentChild = whichChild;
        for (int i = ((ViewGroup)this.realView).getChildCount() - 1; i >= 0; --i) {
            View child = ((ViewGroup)this.realView).getChildAt(i);
            child.setVisibility(i == whichChild ? 0 : 8);
        }
    }

    @Implementation
    protected View getCurrentView() {
        return ((ViewGroup)this.realView).getChildAt(this.getDisplayedChild());
    }

    @Implementation
    protected void showNext() {
        this.setDisplayedChild((this.getDisplayedChild() + 1) % ((ViewGroup)this.realView).getChildCount());
    }

    @Implementation
    protected void showPrevious() {
        this.setDisplayedChild(this.getDisplayedChild() == 0 ? ((ViewGroup)this.realView).getChildCount() - 1 : this.getDisplayedChild() - 1);
    }
}

