/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SystemApi;
import android.app.Application;
import android.app.UiModeManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.GuardedBy;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=UiModeManager.class)
public class ShadowUIModeManager {
    public int currentModeType = 0;
    public int currentNightMode = 0;
    public int lastFlags;
    public int lastCarModePriority;
    private int currentApplicationNightMode = 0;
    private final Set<Integer> activeProjectionTypes = new HashSet<Integer>();
    private boolean failOnProjectionToggle;
    private static final ImmutableSet<Integer> VALID_NIGHT_MODES = ImmutableSet.of((Object)0, (Object)1, (Object)2);
    private static final int DEFAULT_PRIORITY = 0;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private int nightModeCustomType = -1;
    @GuardedBy(value="lock")
    private boolean isNightModeOn = false;
    @RealObject
    UiModeManager realUiModeManager;
    private static final ImmutableSet<Integer> VALID_NIGHT_MODE_CUSTOM_TYPES = ImmutableSet.of((Object)0, (Object)1);

    @Implementation
    protected int getCurrentModeType() {
        return this.currentModeType;
    }

    public void setCurrentModeType(int modeType) {
        this.currentModeType = modeType;
    }

    @Implementation(maxSdk=29)
    protected void enableCarMode(int flags) {
        this.enableCarMode(0, flags);
    }

    @Implementation(minSdk=30)
    protected void enableCarMode(int priority, int flags) {
        this.currentModeType = 3;
        this.lastCarModePriority = priority;
        this.lastFlags = flags;
    }

    @Implementation
    protected void disableCarMode(int flags) {
        this.currentModeType = 1;
        this.lastFlags = flags;
    }

    @Implementation
    protected int getNightMode() {
        return this.currentNightMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void setNightMode(int mode) {
        Object object = this.lock;
        synchronized (object) {
            ContentResolver resolver = this.getContentResolver();
            switch (mode) {
                case 0: 
                case 1: 
                case 2: {
                    this.currentNightMode = mode;
                    this.nightModeCustomType = -1;
                    if (resolver == null) break;
                    Settings.Secure.putInt((ContentResolver)resolver, (String)"ui_night_mode", (int)mode);
                    Settings.Secure.putInt((ContentResolver)resolver, (String)"ui_night_mode_custom_type", (int)-1);
                    break;
                }
                default: {
                    this.currentNightMode = 0;
                    if (resolver == null) break;
                    Settings.Secure.putInt((ContentResolver)resolver, (String)"ui_night_mode", (int)0);
                }
            }
        }
    }

    public int getApplicationNightMode() {
        return this.currentApplicationNightMode;
    }

    public Set<Integer> getActiveProjectionTypes() {
        return new HashSet<Integer>(this.activeProjectionTypes);
    }

    public void setFailOnProjectionToggle(boolean failOnProjectionToggle) {
        this.failOnProjectionToggle = failOnProjectionToggle;
    }

    @Implementation(minSdk=31)
    @HiddenApi
    protected void setApplicationNightMode(int mode) {
        this.currentApplicationNightMode = mode;
    }

    @Implementation(minSdk=31)
    @SystemApi
    protected boolean requestProjection(int projectionType) {
        if (projectionType == 1) {
            this.assertHasPermission("android.permission.TOGGLE_AUTOMOTIVE_PROJECTION");
        }
        if (this.failOnProjectionToggle) {
            return false;
        }
        this.activeProjectionTypes.add(projectionType);
        return true;
    }

    @Implementation(minSdk=31)
    @SystemApi
    protected boolean releaseProjection(int projectionType) {
        if (projectionType == 1) {
            this.assertHasPermission("android.permission.TOGGLE_AUTOMOTIVE_PROJECTION");
        }
        if (this.failOnProjectionToggle) {
            return false;
        }
        return this.activeProjectionTypes.remove(projectionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=33)
    protected int getNightModeCustomType() {
        Object object = this.lock;
        synchronized (object) {
            return this.nightModeCustomType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNightModeOn() {
        Object object = this.lock;
        synchronized (object) {
            return this.isNightModeOn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=33)
    protected void setNightModeCustomType(int mode) {
        Object object = this.lock;
        synchronized (object) {
            ContentResolver resolver = this.getContentResolver();
            if (VALID_NIGHT_MODE_CUSTOM_TYPES.contains((Object)mode)) {
                this.nightModeCustomType = mode;
                this.currentNightMode = 3;
                if (resolver != null) {
                    Settings.Secure.putInt((ContentResolver)resolver, (String)"ui_night_mode_custom_type", (int)mode);
                }
            } else {
                this.nightModeCustomType = -1;
                if (resolver != null) {
                    Settings.Secure.putInt((ContentResolver)resolver, (String)"ui_night_mode_custom_type", (int)-1);
                }
            }
        }
    }

    private ContentResolver getContentResolver() {
        Context context = this.getContext();
        return context == null ? null : context.getContentResolver();
    }

    private Context getContext() {
        if (Build.VERSION.SDK_INT < 30) {
            return null;
        }
        return ((UiModeManagerReflector)Reflector.reflector(UiModeManagerReflector.class, (Object)this.realUiModeManager)).getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=33)
    protected boolean setNightModeActivatedForCustomMode(int mode, boolean active) {
        Object object = this.lock;
        synchronized (object) {
            if (VALID_NIGHT_MODE_CUSTOM_TYPES.contains((Object)mode) && this.nightModeCustomType == mode) {
                this.isNightModeOn = active;
                return true;
            }
            return false;
        }
    }

    private void assertHasPermission(String ... permissions) {
        Application context = RuntimeEnvironment.getApplication();
        for (String permission2 : permissions) {
            if (context.getPackageManager().checkPermission(permission2, context.getPackageName()) == 0) continue;
            throw new SecurityException("Missing required permission: " + permission2);
        }
    }

    @ForType(value=UiModeManager.class)
    static interface UiModeManagerReflector {
        @Accessor(value="mContext")
        public Context getContext();
    }
}

