/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SmsManager.class, minSdk=18)
public class ShadowSmsManager {
    private String smscAddress;
    private boolean hasSmscAddressPermission = true;
    private static int defaultSmsSubscriptionId = -1;
    protected TextSmsParams lastTextSmsParams;
    protected TextMultipartParams lastTextMultipartParams;
    protected DataMessageParams lastDataParams;
    protected SendMultimediaMessageParams lastSentMultimediaMessageParams;
    protected DownloadMultimediaMessageParams lastDownloadedMultimediaMessageParams;

    @Resetter
    public static void reset() {
        if (RuntimeEnvironment.getApiLevel() >= 22) {
            Map sSubInstances = (Map)ReflectionHelpers.getStaticField(SmsManager.class, (String)"sSubInstances");
            sSubInstances.clear();
            defaultSmsSubscriptionId = -1;
        }
    }

    @Implementation
    protected void sendDataMessage(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty((CharSequence)destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        this.lastDataParams = new DataMessageParams(destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent);
    }

    @Implementation
    protected void sendTextMessage(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty((CharSequence)destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (TextUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("Invalid message body");
        }
        this.lastTextSmsParams = new TextSmsParams(destinationAddress, scAddress, text, sentIntent, deliveryIntent);
    }

    @Implementation(minSdk=30)
    protected void sendTextMessage(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, long messageId) {
        if (TextUtils.isEmpty((CharSequence)destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (TextUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("Invalid message body");
        }
        this.lastTextSmsParams = new TextSmsParams(destinationAddress, scAddress, text, sentIntent, deliveryIntent, messageId);
    }

    @Implementation
    protected void sendMultipartTextMessage(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        if (TextUtils.isEmpty((CharSequence)destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (parts == null) {
            throw new IllegalArgumentException("Invalid message parts");
        }
        this.lastTextMultipartParams = new TextMultipartParams(destinationAddress, scAddress, parts, sentIntents, deliveryIntents);
    }

    public DataMessageParams getLastSentDataMessageParams() {
        return this.lastDataParams;
    }

    public void clearLastSentDataMessageParams() {
        this.lastDataParams = null;
    }

    public TextSmsParams getLastSentTextMessageParams() {
        return this.lastTextSmsParams;
    }

    public void clearLastSentTextMessageParams() {
        this.lastTextSmsParams = null;
    }

    public TextMultipartParams getLastSentMultipartTextMessageParams() {
        return this.lastTextMultipartParams;
    }

    public void clearLastSentMultipartTextMessageParams() {
        this.lastTextMultipartParams = null;
    }

    @Implementation(minSdk=21)
    protected void sendMultimediaMessage(Context context, Uri contentUri, @Nullable String locationUrl, @Nullable Bundle configOverrides, @Nullable PendingIntent sentIntent) {
        if (contentUri == null || TextUtils.isEmpty((CharSequence)contentUri.getHost())) {
            throw new IllegalArgumentException("Invalid contentUri");
        }
        this.lastSentMultimediaMessageParams = new SendMultimediaMessageParams(contentUri, locationUrl, configOverrides, sentIntent, 0L);
    }

    @Implementation(minSdk=31)
    protected void sendMultimediaMessage(Context context, Uri contentUri, @Nullable String locationUrl, @Nullable Bundle configOverrides, @Nullable PendingIntent sentIntent, long messageId) {
        if (contentUri == null || TextUtils.isEmpty((CharSequence)contentUri.getHost())) {
            throw new IllegalArgumentException("Invalid contentUri");
        }
        this.lastSentMultimediaMessageParams = new SendMultimediaMessageParams(contentUri, locationUrl, configOverrides, sentIntent, messageId);
    }

    @Implementation(minSdk=21)
    protected void downloadMultimediaMessage(Context context, String locationUrl, Uri contentUri, @Nullable Bundle configOverrides, @Nullable PendingIntent sentIntent) {
        if (contentUri == null || TextUtils.isEmpty((CharSequence)contentUri.getHost())) {
            throw new IllegalArgumentException("Invalid contentUri");
        }
        if (TextUtils.isEmpty((CharSequence)locationUrl)) {
            throw new IllegalArgumentException("Invalid locationUrl");
        }
        this.lastDownloadedMultimediaMessageParams = new DownloadMultimediaMessageParams(contentUri, locationUrl, configOverrides, sentIntent, 0L);
    }

    @Implementation(minSdk=31)
    protected void downloadMultimediaMessage(Context context, String locationUrl, Uri contentUri, @Nullable Bundle configOverrides, @Nullable PendingIntent sentIntent, long messageId) {
        if (contentUri == null || TextUtils.isEmpty((CharSequence)contentUri.getHost())) {
            throw new IllegalArgumentException("Invalid contentUri");
        }
        if (TextUtils.isEmpty((CharSequence)locationUrl)) {
            throw new IllegalArgumentException("Invalid locationUrl");
        }
        this.lastDownloadedMultimediaMessageParams = new DownloadMultimediaMessageParams(contentUri, locationUrl, configOverrides, sentIntent, messageId);
    }

    public SendMultimediaMessageParams getLastSentMultimediaMessageParams() {
        return this.lastSentMultimediaMessageParams;
    }

    public void clearLastSentMultimediaMessageParams() {
        this.lastSentMultimediaMessageParams = null;
    }

    public DownloadMultimediaMessageParams getLastDownloadedMultimediaMessageParams() {
        return this.lastDownloadedMultimediaMessageParams;
    }

    public void clearLastDownloadedMultimediaMessageParams() {
        this.lastDownloadedMultimediaMessageParams = null;
    }

    @Implementation(minSdk=30)
    protected void sendMultipartTextMessage(String destinationAddress, String scAddress, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents, long messageId) {
        if (TextUtils.isEmpty((CharSequence)destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (parts == null) {
            throw new IllegalArgumentException("Invalid message parts");
        }
        this.lastTextMultipartParams = new TextMultipartParams(destinationAddress, scAddress, parts, sentIntents, deliveryIntents, messageId);
    }

    public void setSmscAddressPermission(boolean smscAddressPermission) {
        this.hasSmscAddressPermission = smscAddressPermission;
    }

    @Implementation(minSdk=30)
    protected String getSmscAddress() {
        if (!this.hasSmscAddressPermission) {
            throw new SecurityException();
        }
        return this.smscAddress;
    }

    public static void setDefaultSmsSubscriptionId(int id2) {
        defaultSmsSubscriptionId = id2;
    }

    @Implementation(minSdk=30)
    protected static int getDefaultSmsSubscriptionId() {
        return defaultSmsSubscriptionId;
    }

    public void setSmscAddress(String smscAddress) {
        this.smscAddress = smscAddress;
    }

    public static class DataMessageParams {
        private final String destinationAddress;
        private final String scAddress;
        private final short destinationPort;
        private final byte[] data;
        private final PendingIntent sentIntent;
        private final PendingIntent deliveryIntent;

        public DataMessageParams(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
            this.destinationAddress = destinationAddress;
            this.scAddress = scAddress;
            this.destinationPort = destinationPort;
            this.data = data;
            this.sentIntent = sentIntent;
            this.deliveryIntent = deliveryIntent;
        }

        public String getDestinationAddress() {
            return this.destinationAddress;
        }

        public String getScAddress() {
            return this.scAddress;
        }

        public short getDestinationPort() {
            return this.destinationPort;
        }

        public byte[] getData() {
            return this.data;
        }

        public PendingIntent getSentIntent() {
            return this.sentIntent;
        }

        public PendingIntent getDeliveryIntent() {
            return this.deliveryIntent;
        }
    }

    public static class TextSmsParams {
        private final String destinationAddress;
        private final String scAddress;
        private final String text;
        private final PendingIntent sentIntent;
        private final PendingIntent deliveryIntent;
        private final long messageId;

        public TextSmsParams(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
            this(destinationAddress, scAddress, text, sentIntent, deliveryIntent, 0L);
        }

        public TextSmsParams(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, long messageId) {
            this.destinationAddress = destinationAddress;
            this.scAddress = scAddress;
            this.text = text;
            this.sentIntent = sentIntent;
            this.deliveryIntent = deliveryIntent;
            this.messageId = messageId;
        }

        public String getDestinationAddress() {
            return this.destinationAddress;
        }

        public String getScAddress() {
            return this.scAddress;
        }

        public String getText() {
            return this.text;
        }

        public PendingIntent getSentIntent() {
            return this.sentIntent;
        }

        public PendingIntent getDeliveryIntent() {
            return this.deliveryIntent;
        }

        public long getMessageId() {
            return this.messageId;
        }
    }

    public static class TextMultipartParams {
        private final String destinationAddress;
        private final String scAddress;
        private final List<String> parts;
        private final List<PendingIntent> sentIntents;
        private final List<PendingIntent> deliveryIntents;
        private final long messageId;

        public TextMultipartParams(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
            this(destinationAddress, scAddress, parts, sentIntents, deliveryIntents, 0L);
        }

        public TextMultipartParams(String destinationAddress, String scAddress, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents, long messageId) {
            this.destinationAddress = destinationAddress;
            this.scAddress = scAddress;
            this.parts = parts;
            this.sentIntents = sentIntents;
            this.deliveryIntents = deliveryIntents;
            this.messageId = messageId;
        }

        public String getDestinationAddress() {
            return this.destinationAddress;
        }

        public String getScAddress() {
            return this.scAddress;
        }

        public List<String> getParts() {
            return this.parts;
        }

        public List<PendingIntent> getSentIntents() {
            return this.sentIntents;
        }

        public List<PendingIntent> getDeliveryIntents() {
            return this.deliveryIntents;
        }

        public long getMessageId() {
            return this.messageId;
        }
    }

    public static final class SendMultimediaMessageParams
    extends MultimediaMessageParams {
        public SendMultimediaMessageParams(Uri contentUri, @Nullable String locationUrl, @Nullable Bundle configOverrides, @Nullable PendingIntent pendingIntent, long messageId) {
            super(contentUri, locationUrl, configOverrides, pendingIntent, messageId);
        }

        @Nullable
        public String getLocationUrl() {
            return this.locationUrl;
        }

        @Nullable
        public PendingIntent getSentIntent() {
            return this.pendingIntent;
        }
    }

    public static final class DownloadMultimediaMessageParams
    extends MultimediaMessageParams {
        public DownloadMultimediaMessageParams(Uri contentUri, String locationUrl, @Nullable Bundle configOverrides, @Nullable PendingIntent pendingIntent, long messageId) {
            super(contentUri, locationUrl, configOverrides, pendingIntent, messageId);
        }

        public String getLocationUrl() {
            return this.locationUrl;
        }

        @Nullable
        public PendingIntent getDownloadedIntent() {
            return this.pendingIntent;
        }
    }

    public static abstract class MultimediaMessageParams {
        private final Uri contentUri;
        protected final String locationUrl;
        @Nullable
        private final Bundle configOverrides;
        @Nullable
        protected final PendingIntent pendingIntent;
        protected final long messageId;

        protected MultimediaMessageParams(Uri contentUri, String locationUrl, @Nullable Bundle configOverrides, @Nullable PendingIntent pendingIntent, long messageId) {
            this.contentUri = contentUri;
            this.locationUrl = locationUrl;
            this.configOverrides = configOverrides;
            this.pendingIntent = pendingIntent;
            this.messageId = messageId;
        }

        public Uri getContentUri() {
            return this.contentUri;
        }

        @Nullable
        public Bundle getConfigOverrides() {
            return this.configOverrides;
        }

        public long getMessageId() {
            return this.messageId;
        }
    }
}

