/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.animation.RenderNodeAnimator;
import android.view.Choreographer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=RenderNodeAnimator.class, minSdk=30, isInAndroidSdk=false)
public class ShadowRenderNodeAnimatorR {
    private static final int STATE_FINISHED = 3;
    @RealObject
    RenderNodeAnimator realObject;
    private boolean scheduled = false;
    private long startTime = -1L;
    private boolean isEnding = false;
    private final Choreographer.FrameCallback frameCallback = new Choreographer.FrameCallback(){

        public void doFrame(long frameTimeNanos) {
            ShadowRenderNodeAnimatorR.this.scheduled = false;
            if (ShadowRenderNodeAnimatorR.this.startTime == -1L) {
                ShadowRenderNodeAnimatorR.this.startTime = frameTimeNanos;
            }
            long duration = ShadowRenderNodeAnimatorR.this.realObject.getDuration();
            long curTime = frameTimeNanos - ShadowRenderNodeAnimatorR.this.startTime;
            if (curTime >= duration) {
                ((RenderNodeAnimatorReflector)Reflector.reflector(RenderNodeAnimatorReflector.class, (Object)ShadowRenderNodeAnimatorR.this.realObject)).onFinished();
            } else {
                ShadowRenderNodeAnimatorR.this.schedule();
            }
        }
    };

    @Resetter
    public static void reset() {
        ((RenderNodeAnimatorReflector)Reflector.reflector(RenderNodeAnimatorReflector.class)).setAnimationHelper(new ThreadLocal());
    }

    @Implementation
    public void moveToRunningState() {
        ((RenderNodeAnimatorReflector)Reflector.reflector(RenderNodeAnimatorReflector.class, (Object)this.realObject)).moveToRunningState();
        if (!this.isEnding) {
            this.schedule();
        }
    }

    @Implementation
    public void doStart() {
        ((RenderNodeAnimatorReflector)Reflector.reflector(RenderNodeAnimatorReflector.class, (Object)this.realObject)).doStart();
        this.schedule();
    }

    @Implementation
    public void cancel() {
        RenderNodeAnimatorReflector renderNodeReflector = (RenderNodeAnimatorReflector)Reflector.reflector(RenderNodeAnimatorReflector.class, (Object)this.realObject);
        renderNodeReflector.cancel();
        int state = renderNodeReflector.getState();
        if (state != 3) {
            renderNodeReflector.onFinished();
        }
    }

    @Implementation
    public void end() {
        RenderNodeAnimatorReflector renderNodeReflector = (RenderNodeAnimatorReflector)Reflector.reflector(RenderNodeAnimatorReflector.class, (Object)this.realObject);
        this.isEnding = true;
        renderNodeReflector.end();
        this.isEnding = false;
        this.unschedule();
        int state = renderNodeReflector.getState();
        if (state != 3) {
            renderNodeReflector.onFinished();
        }
    }

    private void schedule() {
        if (!this.scheduled) {
            this.scheduled = true;
            Choreographer.getInstance().postFrameCallback(this.frameCallback);
        }
    }

    private void unschedule() {
        if (this.scheduled) {
            Choreographer.getInstance().removeFrameCallback(this.frameCallback);
            this.scheduled = false;
        }
    }

    @ForType(value=RenderNodeAnimator.class)
    static interface RenderNodeAnimatorReflector {
        @Accessor(value="mState")
        public int getState();

        @Static
        @Accessor(value="sAnimationHelper")
        public void setAnimationHelper(ThreadLocal<?> var1);

        public void onFinished();

        @Direct
        public void doStart();

        @Direct
        public void cancel();

        @Direct
        public void moveToRunningState();

        @Direct
        public void end();
    }
}

