/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.MacAddress;
import android.net.wifi.rtt.RangingResult;
import android.net.wifi.rtt.ResponderLocation;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=RangingResult.class, minSdk=28)
public class ShadowRangingResult {
    private static RangingResult asRangingResultP(int status, MacAddress mac, int distanceMm, int distanceStdDevMm, int rssi, int numAttemptedMeasurements, int numSuccessfulMeasurements, byte[] lci, byte[] lcr, long timestampMillis) {
        return (RangingResult)ReflectionHelpers.callConstructor(RangingResult.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)status), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)mac), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceStdDevMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)rssi), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numAttemptedMeasurements), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numSuccessfulMeasurements), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lci), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lcr), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)timestampMillis)});
    }

    private static RangingResult asRangingResultQ(int status, MacAddress mac, int distanceMm, int distanceStdDevMm, int rssi, int numAttemptedMeasurements, int numSuccessfulMeasurements, byte[] lci, byte[] lcr, ResponderLocation unverifiedResponderLocation, long timestampMillis) {
        return (RangingResult)ReflectionHelpers.callConstructor(RangingResult.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)status), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)mac), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceStdDevMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)rssi), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numAttemptedMeasurements), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numSuccessfulMeasurements), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lci), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lcr), ReflectionHelpers.ClassParameter.from(ResponderLocation.class, (Object)unverifiedResponderLocation), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)timestampMillis)});
    }

    private static RangingResult asRangingResultS(int status, MacAddress mac, int distanceMm, int distanceStdDevMm, int rssi, int numAttemptedMeasurements, int numSuccessfulMeasurements, byte[] lci, byte[] lcr, ResponderLocation unverifiedResponderLocation, long timestamp, boolean is80211mcMeasurement) {
        return (RangingResult)ReflectionHelpers.callConstructor(RangingResult.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)status), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)mac), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceStdDevMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)rssi), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numAttemptedMeasurements), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numSuccessfulMeasurements), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lci), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lcr), ReflectionHelpers.ClassParameter.from(ResponderLocation.class, (Object)unverifiedResponderLocation), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)timestamp), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)is80211mcMeasurement)});
    }

    public static class Builder {
        private final int status;
        private final MacAddress mac;
        private final int distanceMm;
        private final long timestampMillis;
        private int distanceStdDevMm = 0;
        private int rssi = 0;
        private int numAttemptedMeasurements = 0;
        private int numSuccessfulMeasurements = 0;
        private byte[] lci = new byte[0];
        private byte[] lcr = new byte[0];
        private ResponderLocation unverifiedResponderLocation = null;
        private boolean is80211mcMeasurement = true;

        public Builder(int status, MacAddress mac, long timestampMillis, int distanceMm) {
            this.status = status;
            this.mac = mac;
            this.timestampMillis = timestampMillis;
            this.distanceMm = distanceMm;
        }

        public Builder setDistanceStandardDeviation(int stddev) {
            this.distanceStdDevMm = stddev;
            return this;
        }

        public Builder setRssi(int rssi) {
            this.rssi = rssi;
            return this;
        }

        public Builder setNumAttemptedMeasurements(int num) {
            this.numAttemptedMeasurements = num;
            return this;
        }

        public Builder setNumSuccessfulMeasurements(int num) {
            this.numSuccessfulMeasurements = num;
            return this;
        }

        public Builder setLci(byte[] lci) {
            this.lci = lci;
            return this;
        }

        public Builder setLcr(byte[] lcr) {
            this.lcr = lcr;
            return this;
        }

        public Builder setUnverifiedResponderLocation(ResponderLocation unverifiedResponderLocation) {
            this.unverifiedResponderLocation = unverifiedResponderLocation;
            return this;
        }

        public Builder setIs80211mcMeasurement(boolean is80211mcMeasurement) {
            this.is80211mcMeasurement = is80211mcMeasurement;
            return this;
        }

        public RangingResult build() {
            if (RuntimeEnvironment.getApiLevel() > 30) {
                return ShadowRangingResult.asRangingResultS(this.status, this.mac, this.distanceMm, this.distanceStdDevMm, this.rssi, this.numAttemptedMeasurements, this.numSuccessfulMeasurements, this.lci, this.lcr, this.unverifiedResponderLocation, this.timestampMillis, this.is80211mcMeasurement);
            }
            if (RuntimeEnvironment.getApiLevel() >= 29) {
                return ShadowRangingResult.asRangingResultQ(this.status, this.mac, this.distanceMm, this.distanceStdDevMm, this.rssi, this.numAttemptedMeasurements, this.numSuccessfulMeasurements, this.lci, this.lcr, this.unverifiedResponderLocation, this.timestampMillis);
            }
            return ShadowRangingResult.asRangingResultP(this.status, this.mac, this.distanceMm, this.distanceStdDevMm, this.rssi, this.numAttemptedMeasurements, this.numSuccessfulMeasurements, this.lci, this.lcr, this.timestampMillis);
        }
    }
}

