/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Choreographer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowChoreographer;
import org.robolectric.util.SoftThreadLocal;

@Implements(value=Choreographer.class, shadowPicker=ShadowChoreographer.Picker.class, isInAndroidSdk=false)
public class ShadowLegacyChoreographer
extends ShadowChoreographer {
    private long nanoTime = 0L;
    private static long FRAME_INTERVAL = 10000000L;
    private static final Thread MAIN_THREAD = Thread.currentThread();
    private static SoftThreadLocal<Choreographer> instance = ShadowLegacyChoreographer.makeThreadLocal();
    private Handler handler = new Handler(Looper.myLooper());
    private static volatile int postCallbackDelayMillis = 0;
    private static volatile int postFrameCallbackDelayMillis = 0;

    private static SoftThreadLocal<Choreographer> makeThreadLocal() {
        return new SoftThreadLocal<Choreographer>(){

            protected Choreographer create() {
                Looper looper = Looper.myLooper();
                if (looper == null) {
                    throw new IllegalStateException("The current thread must have a looper!");
                }
                try {
                    Choreographer.class.getDeclaredConstructor(Looper.class);
                    return (Choreographer)Shadow.newInstance(Choreographer.class, (Class[])new Class[]{Looper.class}, (Object[])new Object[]{looper});
                }
                catch (NoSuchMethodException e) {
                    return (Choreographer)Shadow.newInstance(Choreographer.class, (Class[])new Class[]{Looper.class, Integer.TYPE}, (Object[])new Object[]{looper, 0});
                }
            }
        };
    }

    public static void setPostCallbackDelay(int delayMillis) {
        postCallbackDelayMillis = delayMillis;
    }

    public static void setPostFrameCallbackDelay(int delayMillis) {
        postFrameCallbackDelayMillis = delayMillis;
    }

    @Implementation
    protected static Choreographer getInstance() {
        return (Choreographer)instance.get();
    }

    @Implementation
    protected void postCallback(int callbackType, Runnable action, Object token) {
        this.postCallbackDelayed(callbackType, action, token, postCallbackDelayMillis);
    }

    @Implementation
    protected void postCallbackDelayed(int callbackType, Runnable action, Object token, long delayMillis) {
        this.handler.postDelayed(action, delayMillis);
    }

    @Implementation
    protected void removeCallbacks(int callbackType, Runnable action, Object token) {
        this.handler.removeCallbacks(action, token);
    }

    @Implementation
    protected void postFrameCallback(Choreographer.FrameCallback callback) {
        this.postFrameCallbackDelayed(callback, postFrameCallbackDelayMillis);
    }

    @Implementation
    protected void postFrameCallbackDelayed(final Choreographer.FrameCallback callback, long delayMillis) {
        this.handler.postAtTime(new Runnable(){

            @Override
            public void run() {
                callback.doFrame(ShadowLegacyChoreographer.this.getFrameTimeNanos());
            }
        }, (Object)callback, SystemClock.uptimeMillis() + delayMillis);
    }

    @Implementation
    protected void removeFrameCallback(Choreographer.FrameCallback callback) {
        this.handler.removeCallbacksAndMessages((Object)callback);
    }

    @Implementation
    protected long getFrameTimeNanos() {
        long now = this.nanoTime;
        this.nanoTime += FRAME_INTERVAL;
        return now;
    }

    public static long getFrameInterval() {
        return FRAME_INTERVAL;
    }

    public static void setFrameInterval(long frameInterval) {
        FRAME_INTERVAL = frameInterval;
    }

    @Resetter
    public static synchronized void reset() {
        if (Thread.currentThread() != MAIN_THREAD) {
            throw new RuntimeException("You should only call this from the main thread!");
        }
        instance = ShadowLegacyChoreographer.makeThreadLocal();
        FRAME_INTERVAL = 10000000L;
    }
}

