/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.TargetApi;
import android.app.DatePickerDialog;
import android.content.Context;
import androidx.annotation.RequiresApi;
import java.util.Calendar;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAlertDialog;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=DatePickerDialog.class)
public class ShadowDatePickerDialog
extends ShadowAlertDialog {
    @RealObject
    protected DatePickerDialog realDatePickerDialog;
    private Calendar calendar;

    @Implementation(minSdk=24)
    protected void __constructor__(Context context, int theme, DatePickerDialog.OnDateSetListener callBack, Calendar calendar, int year, int monthOfYear, int dayOfMonth) {
        this.calendar = calendar;
        Shadow.invokeConstructor(DatePickerDialog.class, (Object)this.realDatePickerDialog, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)theme), ReflectionHelpers.ClassParameter.from(DatePickerDialog.OnDateSetListener.class, (Object)callBack), ReflectionHelpers.ClassParameter.from(Calendar.class, (Object)calendar), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)year), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)monthOfYear), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)dayOfMonth)});
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public int getYear() {
        return this.realDatePickerDialog.getDatePicker().getYear();
    }

    public int getMonthOfYear() {
        return this.realDatePickerDialog.getDatePicker().getMonth();
    }

    public int getDayOfMonth() {
        return this.realDatePickerDialog.getDatePicker().getDayOfMonth();
    }

    public DatePickerDialog.OnDateSetListener getOnDateSetListenerCallback() {
        if (RuntimeEnvironment.getApiLevel() <= 19) {
            return ((DatePickerDialogReflector)Reflector.reflector(DatePickerDialogReflector.class, (Object)this.realDatePickerDialog)).getCallback();
        }
        return ((DatePickerDialogReflector)Reflector.reflector(DatePickerDialogReflector.class, (Object)this.realDatePickerDialog)).getDateSetListener();
    }

    @ForType(value=DatePickerDialog.class)
    static interface DatePickerDialogReflector {
        @Accessor(value="mDateSetListener")
        @RequiresApi(value=20)
        public DatePickerDialog.OnDateSetListener getDateSetListener();

        @Accessor(value="mCallBack")
        @TargetApi(value=19)
        public DatePickerDialog.OnDateSetListener getCallback();
    }
}

