/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.media.PlaybackParams;
import android.os.Build;
import android.os.Parcel;
import android.util.Log;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;

@Implements(value=AudioTrack.class, looseSignatures=true)
public class ShadowAudioTrack {
    protected static final int DEFAULT_MIN_BUFFER_SIZE = 1024;
    private static final int AUDIOTRACK_ERROR_SETUP_NATIVEINITFAILED = -20;
    private static final String TAG = "ShadowAudioTrack";
    private static final Multimap<AudioFormatInfo, AudioAttributesInfo> directSupportedFormats = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private static final Set<Integer> allowedNonPcmEncodings = Collections.synchronizedSet(new HashSet());
    private static final List<OnAudioDataWrittenListener> audioDataWrittenListeners = new CopyOnWriteArrayList<OnAudioDataWrittenListener>();
    private static int minBufferSize = 1024;
    private int numBytesReceived;
    private PlaybackParams playbackParams;
    @RealObject
    AudioTrack audioTrack;

    public static void setMinBufferSize(int bufferSize) {
        minBufferSize = bufferSize;
    }

    public static void addDirectPlaybackSupport(AudioFormat format, AudioAttributes attr) {
        Preconditions.checkNotNull((Object)format);
        Preconditions.checkNotNull((Object)attr);
        Preconditions.checkArgument((!ShadowAudioTrack.isPcm(format.getEncoding()) ? 1 : 0) != 0);
        directSupportedFormats.put((Object)new AudioFormatInfo(format.getEncoding(), format.getSampleRate(), format.getChannelMask(), format.getChannelIndexMask()), (Object)new AudioAttributesInfo(attr.getContentType(), attr.getUsage(), attr.getFlags()));
    }

    public static void clearDirectPlaybackSupportedFormats() {
        directSupportedFormats.clear();
    }

    public static void addAllowedNonPcmEncoding(int encoding) {
        Preconditions.checkArgument((!ShadowAudioTrack.isPcm(encoding) ? 1 : 0) != 0);
        allowedNonPcmEncodings.add(encoding);
    }

    public static void clearAllowedNonPcmEncodings() {
        allowedNonPcmEncodings.clear();
    }

    @Implementation(minSdk=24, maxSdk=28)
    protected static int native_get_FCC_8() {
        return 8;
    }

    @Implementation(minSdk=29)
    protected static boolean native_is_direct_output_supported(int encoding, int sampleRate, int channelMask, int channelIndexMask, int contentType, int usage, int flags) {
        return directSupportedFormats.containsEntry((Object)new AudioFormatInfo(encoding, sampleRate, channelMask, channelIndexMask), (Object)new AudioAttributesInfo(contentType, usage, flags));
    }

    @Implementation
    protected static int native_get_min_buff_size(int sampleRateInHz, int channelConfig, int audioFormat) {
        return minBufferSize;
    }

    @Implementation(minSdk=28, maxSdk=29)
    protected int native_setup(Object audioTrack, Object attributes, int[] sampleRate, int channelMask, int channelIndexMask, int audioFormat, int buffSizeInBytes, int mode, int[] sessionId, long nativeAudioTrack, boolean offload) {
        if (!(offload || ShadowAudioTrack.isPcm(audioFormat) || allowedNonPcmEncodings.contains(audioFormat))) {
            return -20;
        }
        return 0;
    }

    @Implementation(minSdk=30, maxSdk=30)
    protected int native_setup(Object audioTrack, Object attributes, int[] sampleRate, int channelMask, int channelIndexMask, int audioFormat, int buffSizeInBytes, int mode, int[] sessionId, long nativeAudioTrack, boolean offload, int encapsulationMode, Object tunerConfiguration) {
        if (!(offload || ShadowAudioTrack.isPcm(audioFormat) || allowedNonPcmEncodings.contains(audioFormat))) {
            return -20;
        }
        return 0;
    }

    @Implementation(minSdk=31, maxSdk=33)
    protected int native_setup(Object audioTrack, Object attributes, int[] sampleRate, int channelMask, int channelIndexMask, int audioFormat, int buffSizeInBytes, int mode, int[] sessionId, long nativeAudioTrack, boolean offload, int encapsulationMode, Object tunerConfiguration, String opPackageName) {
        if (!(offload || ShadowAudioTrack.isPcm(audioFormat) || allowedNonPcmEncodings.contains(audioFormat))) {
            return -20;
        }
        return 0;
    }

    @Implementation(minSdk=34)
    protected int native_setup(Object audioTrack, Object attributes, int[] sampleRate, int channelMask, int channelIndexMask, int audioFormat, int buffSizeInBytes, int mode, int[] sessionId, Parcel attributionSource, long nativeAudioTrack, boolean offload, int encapsulationMode, Object tunerConfiguration, String opPackageName) {
        if (!(offload || ShadowAudioTrack.isPcm(audioFormat) || allowedNonPcmEncodings.contains(audioFormat))) {
            return -20;
        }
        return 0;
    }

    @Implementation(minSdk=23)
    protected final int native_write_byte(byte[] audioData, int offsetInBytes, int sizeInBytes, int format, boolean isBlocking) {
        int encoding = this.audioTrack.getAudioFormat();
        if (!(Build.VERSION.SDK_INT >= 29 && this.audioTrack.isOffloadedPlayback() || ShadowAudioTrack.isPcm(encoding) || allowedNonPcmEncodings.contains(encoding))) {
            return -6;
        }
        return sizeInBytes;
    }

    @Implementation(minSdk=23)
    public void setPlaybackParams(PlaybackParams params) {
        this.playbackParams = (PlaybackParams)Preconditions.checkNotNull((Object)params, (Object)"Illegal null params");
    }

    @Implementation(minSdk=23)
    protected final PlaybackParams getPlaybackParams() {
        return this.playbackParams;
    }

    @Implementation(minSdk=21)
    protected int write(ByteBuffer audioData, int sizeInBytes, int writeMode) {
        int encoding = this.audioTrack.getAudioFormat();
        if (!(Build.VERSION.SDK_INT >= 29 && this.audioTrack.isOffloadedPlayback() || ShadowAudioTrack.isPcm(encoding) || allowedNonPcmEncodings.contains(encoding))) {
            return -6;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e((String)TAG, (String)"ShadowAudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (sizeInBytes < 0 || sizeInBytes > audioData.remaining()) {
            Log.e((String)TAG, (String)("ShadowAudioTrack.write() called with invalid size (" + sizeInBytes + ") value"));
            return -2;
        }
        byte[] receivedBytes = new byte[sizeInBytes];
        audioData.get(receivedBytes);
        this.numBytesReceived += sizeInBytes;
        for (OnAudioDataWrittenListener listener : audioDataWrittenListeners) {
            listener.onAudioDataWritten(this, receivedBytes, this.audioTrack.getFormat());
        }
        return sizeInBytes;
    }

    @Implementation
    protected int getPlaybackHeadPosition() {
        return this.numBytesReceived / this.audioTrack.getFormat().getFrameSizeInBytes();
    }

    @Implementation
    protected void flush() {
        this.numBytesReceived = 0;
    }

    public static void addAudioDataListener(OnAudioDataWrittenListener listener) {
        audioDataWrittenListeners.add(listener);
    }

    public static void removeAudioDataListener(OnAudioDataWrittenListener listener) {
        audioDataWrittenListeners.remove(listener);
    }

    @Resetter
    public static void resetTest() {
        audioDataWrittenListeners.clear();
        ShadowAudioTrack.clearDirectPlaybackSupportedFormats();
        ShadowAudioTrack.clearAllowedNonPcmEncodings();
    }

    private static boolean isPcm(int encoding) {
        switch (encoding) {
            case 2: 
            case 3: 
            case 4: 
            case 21: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    private static class AudioFormatInfo {
        private final int encoding;
        private final int sampleRate;
        private final int channelMask;
        private final int channelIndexMask;

        public AudioFormatInfo(int encoding, int sampleRate, int channelMask, int channelIndexMask) {
            this.encoding = encoding;
            this.sampleRate = sampleRate;
            this.channelMask = channelMask;
            this.channelIndexMask = channelIndexMask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AudioFormatInfo)) {
                return false;
            }
            AudioFormatInfo other = (AudioFormatInfo)o;
            return this.encoding == other.encoding && this.sampleRate == other.sampleRate && this.channelMask == other.channelMask && this.channelIndexMask == other.channelIndexMask;
        }

        public int hashCode() {
            int result = this.encoding;
            result = 31 * result + this.sampleRate;
            result = 31 * result + this.channelMask;
            result = 31 * result + this.channelIndexMask;
            return result;
        }
    }

    private static class AudioAttributesInfo {
        private final int contentType;
        private final int usage;
        private final int flags;

        public AudioAttributesInfo(int contentType, int usage, int flags) {
            this.contentType = contentType;
            this.usage = usage;
            this.flags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AudioAttributesInfo)) {
                return false;
            }
            AudioAttributesInfo other = (AudioAttributesInfo)o;
            return this.contentType == other.contentType && this.usage == other.usage && this.flags == other.flags;
        }

        public int hashCode() {
            int result = this.contentType;
            result = 31 * result + this.usage;
            result = 31 * result + this.flags;
            return result;
        }
    }

    public static interface OnAudioDataWrittenListener {
        public void onAudioDataWritten(ShadowAudioTrack var1, byte[] var2, AudioFormat var3);
    }
}

