/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.res.android.ApkAssetsCache;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.CppApkAssets;
import org.robolectric.res.android.Registries;
import org.robolectric.res.android.ResXMLTree;
import org.robolectric.res.android.Util;
import org.robolectric.shadows.ShadowApkAssets;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=ApkAssets.class, minSdk=28, shadowPicker=ShadowApkAssets.Picker.class, isInAndroidSdk=false, looseSignatures=true)
public class ShadowArscApkAssets9
extends ShadowApkAssets {
    private static final int PROPERTY_SYSTEM = 1;
    private static final int PROPERTY_DYNAMIC = 2;
    private static final int PROPERTY_OVERLAY = 8;
    protected static final String FRAMEWORK_APK_PATH = (String)ReflectionHelpers.getStaticField(AssetManager.class, (String)"FRAMEWORK_APK_PATH");
    @RealObject
    private ApkAssets realApkAssets;

    long getNativePtr() {
        return ((_ApkAssets_)Reflector.reflector(_ApkAssets_.class, (Object)this.realApkAssets)).getNativePtr();
    }

    @Implementation(maxSdk=29)
    protected static ApkAssets loadFromPath(String path, boolean system) throws IOException {
        if (FRAMEWORK_APK_PATH.equals(path)) {
            path = RuntimeEnvironment.getAndroidFrameworkJarPath().toString();
        }
        return ((_ApkAssets_)Reflector.reflector(_ApkAssets_.class)).loadFromPath(path, system);
    }

    @Implementation(minSdk=30)
    protected static ApkAssets loadFromPath(String path, int flags) throws IOException {
        if (FRAMEWORK_APK_PATH.equals(path)) {
            path = RuntimeEnvironment.getAndroidFrameworkJarPath().toString();
        }
        return ((_ApkAssets_)Reflector.reflector(_ApkAssets_.class)).loadFromPath(path, flags);
    }

    @Implementation(maxSdk=29)
    protected static long nativeLoad(String path, boolean system, boolean forceSharedLib, boolean overlay) throws IOException {
        CppApkAssets apk_assets;
        if (path == null) {
            return 0L;
        }
        long cachedApkAssetsPtr = ApkAssetsCache.get((String)path, (boolean)system, (int)RuntimeEnvironment.getApiLevel());
        if (cachedApkAssetsPtr != -1L) {
            return cachedApkAssetsPtr;
        }
        Util.ATRACE_NAME((String)String.format("LoadApkAssets(%s)", path));
        try {
            apk_assets = overlay ? CppApkAssets.LoadOverlay((String)path, (boolean)system) : (forceSharedLib ? CppApkAssets.LoadAsSharedLibrary((String)path, (boolean)system) : CppApkAssets.Load((String)path, (boolean)system));
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryError outOfMemoryError = new OutOfMemoryError("Failed to load " + path);
            outOfMemoryError.initCause(e);
            throw outOfMemoryError;
        }
        if (apk_assets == null) {
            String error_msg = String.format("Failed to load asset path %s", path);
            throw new IOException(error_msg);
        }
        long ptr = Registries.NATIVE_APK_ASSETS_REGISTRY.register((Object)apk_assets);
        ApkAssetsCache.put((String)path, (boolean)system, (int)RuntimeEnvironment.getApiLevel(), (long)ptr);
        return ptr;
    }

    @Implementation(minSdk=30)
    protected static Object nativeLoad(Object format, Object javaPath, Object flags, Object assetsProvider) throws IOException {
        boolean system = ((Integer)flags & 1) == 1;
        boolean overlay = ((Integer)flags & 8) == 8;
        boolean forceSharedLib = ((Integer)flags & 2) == 2;
        return ShadowArscApkAssets9.nativeLoad((String)javaPath, system, forceSharedLib, overlay);
    }

    @Implementation(maxSdk=29)
    protected static long nativeLoadFromFd(FileDescriptor file_descriptor, String friendly_name, boolean system, boolean force_shared_lib) {
        String friendly_name_utf8 = friendly_name;
        if (friendly_name_utf8 == null) {
            return 0L;
        }
        throw new UnsupportedOperationException();
    }

    @Implementation
    protected static String nativeGetAssetPath(long ptr) {
        CppApkAssets apk_assets = (CppApkAssets)Registries.NATIVE_APK_ASSETS_REGISTRY.getNativeObject(ptr);
        return apk_assets.GetPath();
    }

    @Implementation
    protected static long nativeGetStringBlock(long ptr) {
        CppApkAssets apk_assets = (CppApkAssets)Registries.NATIVE_APK_ASSETS_REGISTRY.getNativeObject(ptr);
        return apk_assets.GetLoadedArsc().GetStringPool().getNativePtr();
    }

    @Implementation
    protected static boolean nativeIsUpToDate(long ptr) {
        return true;
    }

    @Implementation
    protected static long nativeOpenXml(long ptr, String file_name) throws FileNotFoundException {
        String path_utf8 = file_name;
        if (path_utf8 == null) {
            return 0L;
        }
        CppApkAssets apk_assets = (CppApkAssets)Registries.NATIVE_APK_ASSETS_REGISTRY.getNativeObject(ptr);
        Asset asset = apk_assets.Open(path_utf8, Asset.AccessMode.ACCESS_RANDOM);
        if (asset == null) {
            throw new FileNotFoundException(path_utf8);
        }
        ResXMLTree xml_tree = new ResXMLTree(null);
        int err = xml_tree.setTo(asset.getBuffer(true), (int)asset.getLength(), true);
        if (err != 0) {
            throw new FileNotFoundException("Corrupt XML binary file");
        }
        return Registries.NATIVE_RES_XML_TREES.register((Object)xml_tree);
    }

    @ForType(value=ApkAssets.class)
    static interface _ApkAssets_ {
        @Static
        @Direct
        public ApkAssets loadFromPath(String var1, boolean var2);

        @Static
        @Direct
        public ApkAssets loadFromPath(String var1, int var2);

        @Accessor(value="mNativePtr")
        public long getNativePtr();
    }
}

