/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.location.GnssStatus;
import android.os.Build;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.robolectric.shadows.AutoValue_GnssStatusBuilder_GnssSatelliteInfo;
import org.robolectric.util.ReflectionHelpers;

@Deprecated
public final class GnssStatusBuilder {
    private final List<GnssSatelliteInfo> satelliteInfos = new ArrayList<GnssSatelliteInfo>();
    private static final int GNSS_SV_FLAGS_HAS_EPHEMERIS_DATA = Build.VERSION.SDK_INT <= 29 ? (Integer)ReflectionHelpers.getStaticField(GnssStatus.class, (String)"GNSS_SV_FLAGS_HAS_EPHEMERIS_DATA") : 0;
    private static final int GNSS_SV_FLAGS_HAS_ALMANAC_DATA = Build.VERSION.SDK_INT <= 29 ? (Integer)ReflectionHelpers.getStaticField(GnssStatus.class, (String)"GNSS_SV_FLAGS_HAS_ALMANAC_DATA") : 0;
    private static final int GNSS_SV_FLAGS_USED_IN_FIX = Build.VERSION.SDK_INT <= 29 ? (Integer)ReflectionHelpers.getStaticField(GnssStatus.class, (String)"GNSS_SV_FLAGS_USED_IN_FIX") : 0;
    private static final int GNSS_SV_FLAGS_HAS_CARRIER_FREQUENCY = Build.VERSION.SDK_INT >= 26 && Build.VERSION.SDK_INT <= 29 ? (Integer)ReflectionHelpers.getStaticField(GnssStatus.class, (String)"GNSS_SV_FLAGS_HAS_CARRIER_FREQUENCY") : 0;
    private static final boolean SUPPORTS_CARRIER_FREQUENCY = GNSS_SV_FLAGS_HAS_CARRIER_FREQUENCY != 0;
    private static final int SVID_SHIFT_WIDTH = (Integer)ReflectionHelpers.getStaticField(GnssStatus.class, (String)"SVID_SHIFT_WIDTH");
    private static final int CONSTELLATION_TYPE_SHIFT_WIDTH = (Integer)ReflectionHelpers.getStaticField(GnssStatus.class, (String)"CONSTELLATION_TYPE_SHIFT_WIDTH");
    private static final int CONSTELLATION_TYPE_MASK = (Integer)ReflectionHelpers.getStaticField(GnssStatus.class, (String)"CONSTELLATION_TYPE_MASK");

    private GnssStatusBuilder() {
    }

    public static GnssStatusBuilder create() {
        return new GnssStatusBuilder();
    }

    public GnssStatusBuilder addSatellite(GnssSatelliteInfo satelliteInfo) {
        this.satelliteInfos.add(satelliteInfo);
        return this;
    }

    public GnssStatusBuilder addAllSatellites(Collection<GnssSatelliteInfo> satelliteInfos) {
        this.satelliteInfos.addAll(satelliteInfos);
        return this;
    }

    public GnssStatus build() {
        return GnssStatusBuilder.createFrom(this.satelliteInfos);
    }

    public static GnssStatus buildFrom(GnssSatelliteInfo ... satelliteInfos) {
        return GnssStatusBuilder.createFrom(Arrays.asList(satelliteInfos));
    }

    private static GnssStatus createFrom(List<GnssSatelliteInfo> satelliteInfos) {
        int svCount = satelliteInfos.size();
        int[] svidWithFlags = new int[svCount];
        float[] cn0DbHz = new float[svCount];
        float[] elevations = new float[svCount];
        float[] azimuths = new float[svCount];
        float[] carrierFrequencies = new float[svCount];
        for (int i = 0; i < svCount; ++i) {
            GnssSatelliteInfo info = satelliteInfos.get(i);
            int packedSvid = info.getSvid() << SVID_SHIFT_WIDTH | (info.getConstellation() & CONSTELLATION_TYPE_MASK) << CONSTELLATION_TYPE_SHIFT_WIDTH;
            if (info.getHasEphemeris()) {
                packedSvid |= GNSS_SV_FLAGS_HAS_EPHEMERIS_DATA;
            }
            if (info.getHasAlmanac()) {
                packedSvid |= GNSS_SV_FLAGS_HAS_ALMANAC_DATA;
            }
            if (info.isUsedInFix()) {
                packedSvid |= GNSS_SV_FLAGS_USED_IN_FIX;
            }
            if (SUPPORTS_CARRIER_FREQUENCY && info.getCarrierFrequencyHz() != null) {
                packedSvid |= GNSS_SV_FLAGS_HAS_CARRIER_FREQUENCY;
                carrierFrequencies[i] = info.getCarrierFrequencyHz().floatValue();
            }
            svidWithFlags[i] = packedSvid;
            cn0DbHz[i] = info.getCn0DbHz();
            elevations[i] = info.getElevation();
            azimuths[i] = info.getAzimuth();
        }
        ArrayList<ReflectionHelpers.ClassParameter> classParameters = new ArrayList<ReflectionHelpers.ClassParameter>();
        classParameters.add(ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)svCount));
        classParameters.add(ReflectionHelpers.ClassParameter.from(int[].class, (Object)svidWithFlags));
        classParameters.add(ReflectionHelpers.ClassParameter.from(float[].class, (Object)cn0DbHz));
        classParameters.add(ReflectionHelpers.ClassParameter.from(float[].class, (Object)elevations));
        classParameters.add(ReflectionHelpers.ClassParameter.from(float[].class, (Object)azimuths));
        if (SUPPORTS_CARRIER_FREQUENCY) {
            classParameters.add(ReflectionHelpers.ClassParameter.from(float[].class, (Object)carrierFrequencies));
        }
        return (GnssStatus)ReflectionHelpers.callConstructor(GnssStatus.class, (ReflectionHelpers.ClassParameter[])classParameters.toArray(new ReflectionHelpers.ClassParameter[0]));
    }

    @AutoValue
    public static abstract class GnssSatelliteInfo {
        public abstract int getConstellation();

        public abstract int getSvid();

        public abstract float getCn0DbHz();

        public abstract float getElevation();

        public abstract float getAzimuth();

        public abstract boolean getHasEphemeris();

        public abstract boolean getHasAlmanac();

        public abstract boolean isUsedInFix();

        @Nullable
        public abstract Float getCarrierFrequencyHz();

        public static Builder builder() {
            return new AutoValue_GnssStatusBuilder_GnssSatelliteInfo.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setConstellation(int var1);

            public abstract Builder setSvid(int var1);

            public abstract Builder setCn0DbHz(float var1);

            public abstract Builder setElevation(float var1);

            public abstract Builder setAzimuth(float var1);

            public abstract Builder setHasEphemeris(boolean var1);

            public abstract Builder setHasAlmanac(boolean var1);

            public abstract Builder setUsedInFix(boolean var1);

            public abstract Builder setCarrierFrequencyHz(@Nullable Float var1);

            public abstract GnssSatelliteInfo build();
        }
    }
}

