/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telephony.CellIdentityLte;
import android.telephony.ClosedSubscriberGroupInfo;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@RequiresApi(value=17)
public class CellIdentityLteBuilder {
    @Nullable
    private String mcc = null;
    @Nullable
    private String mnc = null;
    private int ci = Integer.MAX_VALUE;
    private int pci = Integer.MAX_VALUE;
    private int tac = Integer.MAX_VALUE;
    private int earfcn = Integer.MAX_VALUE;
    private int[] bands = new int[0];
    private int bandwidth = Integer.MAX_VALUE;
    @Nullable
    private String alphal = null;
    @Nullable
    private String alphas = null;
    private List<String> additionalPlmns = new ArrayList<String>();

    private CellIdentityLteBuilder() {
    }

    public static CellIdentityLteBuilder newBuilder() {
        return new CellIdentityLteBuilder();
    }

    protected static CellIdentityLte getDefaultInstance() {
        return ((CellIdentityLteReflector)Reflector.reflector(CellIdentityLteReflector.class)).newCellIdentityLte();
    }

    public CellIdentityLteBuilder setMcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    public CellIdentityLteBuilder setMnc(String mnc) {
        this.mnc = mnc;
        return this;
    }

    public CellIdentityLteBuilder setCi(int ci) {
        this.ci = ci;
        return this;
    }

    public CellIdentityLteBuilder setPci(int pci) {
        this.pci = pci;
        return this;
    }

    public CellIdentityLteBuilder setTac(int tac) {
        this.tac = tac;
        return this;
    }

    public CellIdentityLteBuilder setEarfcn(int earfcn) {
        this.earfcn = earfcn;
        return this;
    }

    public CellIdentityLteBuilder setBands(int[] bands) {
        this.bands = bands;
        return this;
    }

    public CellIdentityLteBuilder setBandwidth(int bandwidth) {
        this.bandwidth = bandwidth;
        return this;
    }

    public CellIdentityLteBuilder setLongOperatorName(String longOperatorName) {
        this.alphal = longOperatorName;
        return this;
    }

    public CellIdentityLteBuilder setShortOperatorName(String shortOperatorName) {
        this.alphas = shortOperatorName;
        return this;
    }

    public CellIdentityLteBuilder setAdditionalPlmns(List<String> additionalPlmns) {
        this.additionalPlmns = additionalPlmns;
        return this;
    }

    public CellIdentityLte build() {
        CellIdentityLteReflector cellIdentityLteReflector = (CellIdentityLteReflector)Reflector.reflector(CellIdentityLteReflector.class);
        int apiLevel = RuntimeEnvironment.getApiLevel();
        if (apiLevel < 24) {
            return cellIdentityLteReflector.newCellIdentityLte(CellIdentityLteBuilder.mccOrMncToInt(this.mcc), CellIdentityLteBuilder.mccOrMncToInt(this.mnc), this.ci, this.pci, this.tac);
        }
        if (apiLevel < 28) {
            return cellIdentityLteReflector.newCellIdentityLte(CellIdentityLteBuilder.mccOrMncToInt(this.mcc), CellIdentityLteBuilder.mccOrMncToInt(this.mnc), this.ci, this.pci, this.tac, this.earfcn);
        }
        if (apiLevel < 30) {
            return cellIdentityLteReflector.newCellIdentityLte(this.ci, this.pci, this.tac, this.earfcn, this.bandwidth, this.mcc, this.mnc, this.alphal, this.alphas);
        }
        return cellIdentityLteReflector.newCellIdentityLte(this.ci, this.pci, this.tac, this.earfcn, this.bands, this.bandwidth, this.mcc, this.mnc, this.alphal, this.alphas, this.additionalPlmns, null);
    }

    private static int mccOrMncToInt(@Nullable String mccOrMnc) {
        return mccOrMnc == null ? Integer.MAX_VALUE : Integer.parseInt(mccOrMnc);
    }

    @ForType(value=CellIdentityLte.class)
    private static interface CellIdentityLteReflector {
        @Constructor
        public CellIdentityLte newCellIdentityLte();

        @Constructor
        public CellIdentityLte newCellIdentityLte(int var1, int var2, int var3, int var4, int var5);

        @Constructor
        public CellIdentityLte newCellIdentityLte(int var1, int var2, int var3, int var4, int var5, int var6);

        @Constructor
        public CellIdentityLte newCellIdentityLte(int var1, int var2, int var3, int var4, int var5, String var6, String var7, String var8, String var9);

        @Constructor
        public CellIdentityLte newCellIdentityLte(int var1, int var2, int var3, int var4, int[] var5, int var6, String var7, String var8, String var9, String var10, Collection<String> var11, ClosedSubscriberGroupInfo var12);
    }
}

