/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.FileMap;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.Util;
import org.robolectric.res.android.ZipArchiveHandle;

public class ZipFileRO {
    static final int kCompressStored = 0;
    static final int kCompressDeflated = 8;
    final ZipArchiveHandle mHandle;
    final String mFileName;

    ZipFileRO(ZipArchiveHandle handle, String fileName) {
        this.mHandle = handle;
        this.mFileName = fileName;
    }

    protected void finalize() {
        ZipFileRO.CloseArchive();
    }

    static int OpenArchive(String zipFileName, Ref<ZipArchiveHandle> mHandle) {
        try {
            File file = new File(zipFileName);
            ZipFile zipFile = new ZipFile(file);
            mHandle.set(new ZipArchiveHandle(zipFile, FileMap.guessDataOffsets(file, (int)file.length())));
            return 0;
        }
        catch (IOException e) {
            return -2147483643;
        }
    }

    private static void CloseArchive() {
        throw new UnsupportedOperationException();
    }

    private static String ErrorCodeString(int error) {
        return "error " + error;
    }

    static int FindEntry(ZipArchiveHandle mHandle, String name, Ref<ZipEntry> zipEntryRef) {
        ZipEntry entry = mHandle.zipFile.getEntry(name);
        zipEntryRef.set(entry);
        if (entry == null) {
            return -2147483643;
        }
        return 0;
    }

    static ZipFileRO open(String zipFileName) {
        Ref<Object> handle = new Ref<Object>(null);
        int error = ZipFileRO.OpenArchive(zipFileName, handle);
        if (Util.isTruthy(error)) {
            Util.ALOGW("Error opening archive %s: %s", zipFileName, ZipFileRO.ErrorCodeString(error));
            ZipFileRO.CloseArchive();
            return null;
        }
        return new ZipFileRO(handle.get(), zipFileName);
    }

    ZipEntryRO findEntryByName(String entryName) {
        ZipEntryRO data = new ZipEntryRO();
        data.name = ZipFileRO.String(entryName);
        if (this.mHandle.dataOffsets.get((Object)entryName) == null) {
            return null;
        }
        data.dataOffset = (Long)this.mHandle.dataOffsets.get((Object)entryName);
        Ref<ZipEntry> zipEntryRef = new Ref<ZipEntry>(data.entry);
        int error = ZipFileRO.FindEntry(this.mHandle, data.name, zipEntryRef);
        if (Util.isTruthy(error)) {
            return null;
        }
        data.entry = zipEntryRef.get();
        return data;
    }

    boolean getEntryInfo(ZipEntryRO entry, Ref<Short> pMethod, Ref<Long> pUncompLen, Ref<Long> pCompLen, Ref<Long> pOffset, Ref<Long> pModWhen, Ref<Long> pCrc32) {
        ZipEntryRO zipEntry = entry;
        ZipEntry ze = zipEntry.entry;
        if (pMethod != null) {
            pMethod.set((short)ze.getMethod());
        }
        if (pUncompLen != null) {
            pUncompLen.set(ze.getSize());
        }
        if (pCompLen != null) {
            pCompLen.set(ze.getCompressedSize());
        }
        if (pOffset != null) {
            throw new UnsupportedOperationException("Figure out offset");
        }
        if (pModWhen != null) {
            // empty if block
        }
        if (pCrc32 != null) {
            pCrc32.set(ze.getCrc());
        }
        return true;
    }

    boolean startIteration(Ref<Enumeration<? extends ZipEntry>> cookie) {
        return this.startIteration(cookie, null, null);
    }

    boolean startIteration(Ref<Enumeration<? extends ZipEntry>> cookie, String prefix, String suffix) {
        cookie.set(this.mHandle.zipFile.entries());
        return true;
    }

    ZipEntryRO nextEntry(Enumeration<? extends ZipEntry> cookie) {
        if (!cookie.hasMoreElements()) {
            return null;
        }
        ZipEntryRO zipEntryRO = new ZipEntryRO();
        zipEntryRO.entry = cookie.nextElement();
        return zipEntryRO;
    }

    void endIteration(Object cookie) {
    }

    void releaseEntry(ZipEntryRO entry) {
    }

    int getEntryFileName(ZipEntryRO entry, Ref<String> buffer) {
        buffer.set(entry.entry.getName());
        return 0;
    }

    ZipFileRO(ZipEntryRO entry) {
        throw new UnsupportedOperationException("Implememnt me");
    }

    FileMap createEntryFileMap(ZipEntryRO entry) {
        FileMap newMap = new FileMap();
        if (!newMap.createFromZip(this.mFileName, this.mHandle.zipFile, entry.entry, entry.dataOffset, Asset.toIntExact(entry.entry.getCompressedSize()), true)) {
            return null;
        }
        return newMap;
    }

    boolean uncompressEntry(ZipEntryRO entry, Object buffer, int size) {
        throw new UnsupportedOperationException("Implememnt me");
    }

    boolean uncompressEntry(ZipEntryRO entry, int fd) {
        throw new UnsupportedOperationException("Implememnt me");
    }

    static String String(String string) {
        return string;
    }

    static class ZipEntryRO {
        ZipEntry entry;
        String name;
        long dataOffset;
        Object cookie;

        ZipEntryRO() {
        }

        protected void finalize() {
        }
    }
}

