/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.Registries;
import org.robolectric.res.android.ResourceString;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.res.android.Util;

public class ResStringPool {
    private static boolean kDebugStringPoolNoisy = false;
    private final long myNativePtr = Registries.NATIVE_STRING_POOLS.register(new WeakReference<ResStringPool>(this));
    private int mError = -2147483642;
    byte[] mOwnedData;
    private ResourceTypes.ResStringPool_header mHeader;
    private int mSize;
    private IntArray mEntries;
    private IntArray mEntryStyles;
    private int mStrings;
    private int mStringPoolSize;
    private int mStyles;
    private int mStylePoolSize;

    protected void finalize() throws Throwable {
        Registries.NATIVE_STRING_POOLS.unregister(this.myNativePtr);
    }

    public long getNativePtr() {
        return this.myNativePtr;
    }

    public static ResStringPool getNativeObject(long nativeId) {
        return (ResStringPool)Registries.NATIVE_STRING_POOLS.getNativeObject(nativeId).get();
    }

    void setToEmpty() {
        this.uninit();
        ByteBuffer buf = ByteBuffer.allocate(16384).order(ByteOrder.LITTLE_ENDIAN);
        ResourceTypes.ResStringPool_header.Writer resStringPoolWriter = new ResourceTypes.ResStringPool_header.Writer();
        resStringPoolWriter.write(buf);
        this.mOwnedData = new byte[buf.position()];
        buf.position();
        buf.get(this.mOwnedData);
        ResourceTypes.ResStringPool_header header = new ResourceTypes.ResStringPool_header(buf, 0);
        this.mSize = 0;
        this.mEntries = null;
        this.mStrings = 0;
        this.mStringPoolSize = 0;
        this.mEntryStyles = null;
        this.mStyles = 0;
        this.mStylePoolSize = 0;
        this.mHeader = header;
    }

    public int setTo(ByteBuffer buf, int offset, int size, boolean copyData) {
        if (!Util.isTruthy(buf) || !Util.isTruthy(size)) {
            this.mError = -2147483646;
            return -2147483646;
        }
        this.uninit();
        if (size < ResourceTypes.ResStringPool_header.SIZEOF) {
            Util.ALOGW("Bad string block: data size %d is too small to be a string block", size);
            this.mError = -2147483646;
            return -2147483646;
        }
        if (ResourceTypes.validate_chunk(new ResourceTypes.ResChunk_header(buf, offset), ResourceTypes.ResStringPool_header.SIZEOF, size, "ResStringPool_header") != 0) {
            Util.ALOGW("Bad string block: malformed block dimensions", new Object[0]);
            this.mError = -2147483646;
            return -2147483646;
        }
        this.mHeader = new ResourceTypes.ResStringPool_header(buf, offset);
        if (this.mHeader.header.headerSize > this.mHeader.header.size || this.mHeader.header.size > size) {
            Util.ALOGW("Bad string block: header size %d or total size %d is larger than data size %d\n", this.mHeader.header.headerSize, this.mHeader.header.size, size);
            this.mError = -2147483646;
            return -2147483646;
        }
        this.mSize = this.mHeader.header.size;
        this.mEntries = new IntArray(this.mHeader.myBuf(), this.mHeader.myOffset() + this.mHeader.header.headerSize);
        if (this.mHeader.stringCount > 0) {
            if (this.mHeader.stringCount * 4 < this.mHeader.stringCount || this.mHeader.header.headerSize + this.mHeader.stringCount * 4 > size) {
                Util.ALOGW("Bad string block: entry of %d items extends past data size %d\n", this.mHeader.header.headerSize + this.mHeader.stringCount * 4, size);
                this.mError = -2147483646;
                return -2147483646;
            }
            int charSize = Util.isTruthy(this.mHeader.flags & 0x100) ? 1 : 2;
            if (this.mHeader.stringsStart >= this.mSize - 2) {
                Util.ALOGW("Bad string block: string pool starts at %d, after total size %d\n", this.mHeader.stringsStart, this.mHeader.header.size);
                this.mError = -2147483646;
                return -2147483646;
            }
            this.mStrings = this.mHeader.stringsStart;
            if (this.mHeader.styleCount == 0) {
                this.mStringPoolSize = (this.mSize - this.mHeader.stringsStart) / charSize;
            } else {
                if (this.mHeader.stylesStart >= this.mSize - 2) {
                    Util.ALOGW("Bad style block: style block starts at %d past data size of %d\n", this.mHeader.stylesStart, this.mHeader.header.size);
                    this.mError = -2147483646;
                    return -2147483646;
                }
                if (this.mHeader.stylesStart <= this.mHeader.stringsStart) {
                    Util.ALOGW("Bad style block: style block starts at %d, before strings at %d\n", this.mHeader.stylesStart, this.mHeader.stringsStart);
                    this.mError = -2147483646;
                    return -2147483646;
                }
                this.mStringPoolSize = (this.mHeader.stylesStart - this.mHeader.stringsStart) / charSize;
            }
            if (this.mStringPoolSize == 0) {
                Util.ALOGW("Bad string block: stringCount is %d but pool size is 0\n", this.mHeader.stringCount);
                this.mError = -2147483646;
                return -2147483646;
            }
            if (Util.isTruthy(this.mHeader.flags & 0x100) && this.mHeader.getByte(this.mStrings + this.mStringPoolSize - 1) != 0 || !Util.isTruthy(this.mHeader.flags & 0x100) && this.mHeader.getShort(this.mStrings + this.mStringPoolSize * 2 - 2) != 0) {
                Util.ALOGW("Bad string block: last string is not 0-terminated\n", new Object[0]);
                this.mError = -2147483646;
                return -2147483646;
            }
        } else {
            this.mStrings = -1;
            this.mStringPoolSize = 0;
        }
        if (this.mHeader.styleCount > 0) {
            this.mEntryStyles = new IntArray(this.mEntries.myBuf(), this.mEntries.myOffset() + this.mHeader.stringCount * 4);
            if (this.mEntryStyles.myOffset() < this.mEntries.myOffset()) {
                Util.ALOGW("Bad string block: integer overflow finding styles\n", new Object[0]);
                this.mError = -2147483646;
                return -2147483646;
            }
            if (this.mEntryStyles.myOffset() - this.mHeader.myOffset() > size) {
                Util.ALOGW("Bad string block: entry of %d styles extends past data size %d\n", this.mEntryStyles.myOffset(), size);
                this.mError = -2147483646;
                return -2147483646;
            }
            this.mStyles = this.mHeader.stylesStart;
            if (this.mHeader.stylesStart >= this.mHeader.header.size) {
                Util.ALOGW("Bad string block: style pool starts %d, after total size %d\n", this.mHeader.stylesStart, this.mHeader.header.size);
                this.mError = -2147483646;
                return -2147483646;
            }
            this.mStylePoolSize = this.mHeader.header.size - this.mHeader.stylesStart;
            ResourceTypes.ResStringPool_span endSpan = new ResourceTypes.ResStringPool_span(buf, this.mHeader.myOffset() + this.mStyles + (this.mStylePoolSize - 12));
            if (!endSpan.isEnd()) {
                Util.ALOGW("Bad string block: last style is not 0xFFFFFFFF-terminated\n", new Object[0]);
                this.mError = -2147483646;
                return -2147483646;
            }
        } else {
            this.mEntryStyles = null;
            this.mStyles = 0;
            this.mStylePoolSize = 0;
        }
        this.mError = 0;
        return 0;
    }

    private int setError(int error) {
        this.mError = error;
        return this.mError;
    }

    void uninit() {
        this.setError(-2147483642);
        this.mHeader = null;
    }

    public String stringAt(int idx) {
        if (this.mError == 0 && idx < this.mHeader.stringCount) {
            boolean isUTF8 = (this.mHeader.flags & 0x100) != 0;
            ByteBuffer buf = this.mHeader.myBuf();
            int bufOffset = this.mHeader.myOffset();
            int off = this.mEntries.get(idx) / (isUTF8 ? 1 : 2);
            if (off < this.mStringPoolSize - 1) {
                if (!isUTF8) {
                    int strings = this.mStrings;
                    int str = strings + off * 2;
                    return ResourceString.decodeString(buf, bufOffset + str, ResourceString.Type.UTF16);
                }
                int strings = this.mStrings;
                int u8str = strings + off;
                return ResourceString.decodeString(buf, bufOffset + u8str, ResourceString.Type.UTF8);
            }
            Util.ALOGW("Bad string block: string #%d entry is at %d, past end at %d\n", idx, off * 2, this.mStringPoolSize * 2);
        }
        return null;
    }

    String stringAt(int idx, Ref<Integer> outLen) {
        String s = this.stringAt(idx);
        if (s != null && outLen != null) {
            outLen.set(s.length());
        }
        return s;
    }

    public String string8At(int id, Ref<Integer> outLen) {
        return this.stringAt(id, outLen);
    }

    final ResourceTypes.ResStringPool_span styleAt(ResourceTypes.ResStringPool_ref ref) {
        return this.styleAt(ref.index);
    }

    public final ResourceTypes.ResStringPool_span styleAt(int idx) {
        if (this.mError == 0 && idx < this.mHeader.styleCount) {
            int off = this.mEntryStyles.get(idx) / 4;
            if (off < this.mStylePoolSize) {
                return new ResourceTypes.ResStringPool_span(this.mHeader.myBuf(), this.mHeader.myOffset() + this.mStyles + off * 4);
            }
            Util.ALOGW("Bad string block: style #%d entry is at %d, past end at %d\n", idx, off * 4, this.mStylePoolSize * 4);
        }
        return null;
    }

    public int indexOfString(String str) {
        if (this.mError != 0) {
            return this.mError;
        }
        if (kDebugStringPoolNoisy) {
            Util.ALOGI("indexOfString : %s", str);
        }
        if ((this.mHeader.flags & 1) != 0) {
            int l = 0;
            int h = this.mHeader.stringCount - 1;
            while (l <= h) {
                int c;
                int mid = l + (h - l) / 2;
                String s = this.stringAt(mid);
                int n = c = s != null ? s.compareTo(str) : -1;
                if (kDebugStringPoolNoisy) {
                    Util.ALOGI("Looking at %s, cmp=%d, l/mid/h=%d/%d/%d\n", s, c, l, mid, h);
                }
                if (c == 0) {
                    if (kDebugStringPoolNoisy) {
                        Util.ALOGI("MATCH!", new Object[0]);
                    }
                    return mid;
                }
                if (c < 0) {
                    l = mid + 1;
                    continue;
                }
                h = mid - 1;
            }
        } else {
            for (int i = this.mHeader.stringCount; i >= 0; --i) {
                String s = this.stringAt(i);
                if (kDebugStringPoolNoisy) {
                    Util.ALOGI("Looking at %s, i=%d\n", s, i);
                }
                if (!Objects.equals(s, str)) continue;
                if (kDebugStringPoolNoisy) {
                    Util.ALOGI("MATCH!", new Object[0]);
                }
                return i;
            }
        }
        return -2147483643;
    }

    public int size() {
        return this.mError == 0 ? this.mHeader.stringCount : 0;
    }

    int styleCount() {
        return this.mError == 0 ? this.mHeader.styleCount : 0;
    }

    int bytes() {
        return this.mError == 0 ? this.mHeader.header.size : 0;
    }

    public boolean isUTF8() {
        return true;
    }

    public int getError() {
        return this.mError;
    }

    static class IntArray
    extends ResourceTypes.WithOffset {
        IntArray(ByteBuffer buf, int offset) {
            super(buf, offset);
        }

        int get(int idx) {
            return this.myBuf().getInt(this.myOffset() + idx * 4);
        }
    }
}

